/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.expressions.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001dB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\n\u001a\u00028\u0000X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "kind", "Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;", "value", "<init>", "(IILorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;Ljava/lang/Object;)V", "getStartOffset", "()I", "getEndOffset", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "setType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getKind", "()Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;", "setKind", "(Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;)V", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "Companion", "ir.tree"})
public final class IrConstImpl<T>
extends IrConst<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private IrType type;
    @NotNull
    private IrConstKind<T> kind;
    private T value;

    public IrConstImpl(int startOffset, int endOffset, @NotNull IrType type2, @NotNull IrConstKind<T> kind, T value2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.type = type2;
        this.kind = kind;
        this.value = value2;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    @NotNull
    public IrType getType() {
        return this.type;
    }

    @Override
    public void setType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"<set-?>");
        this.type = irType;
    }

    @Override
    @NotNull
    public IrConstKind<T> getKind() {
        return this.kind;
    }

    @Override
    public void setKind(@NotNull IrConstKind<T> irConstKind) {
        Intrinsics.checkNotNullParameter(irConstKind, (String)"<set-?>");
        this.kind = irConstKind;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T t) {
        this.value = t;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ&\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0017J,\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0019J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001bJ,\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001dJ,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001fJ\"\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl$Companion;", "", "<init>", "()V", "string", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "value", "int", "constNull", "", "boolean", "", "constTrue", "constFalse", "long", "", "float", "", "double", "", "char", "", "byte", "", "short", "", "defaultValueForType", "ir.tree"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrConstImpl<String> string(int startOffset, int endOffset, @NotNull IrType type2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new IrConstImpl<String>(startOffset, endOffset, type2, IrConstKind.String.INSTANCE, value2);
        }

        @NotNull
        public final IrConstImpl<Integer> int(int startOffset, int endOffset, @NotNull IrType type2, int value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Integer>(startOffset, endOffset, type2, IrConstKind.Int.INSTANCE, value2);
        }

        @NotNull
        public final IrConstImpl constNull(int startOffset, int endOffset, @NotNull IrType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Object>(startOffset, endOffset, type2, IrConstKind.Null.INSTANCE, null);
        }

        @NotNull
        public final IrConstImpl<Boolean> boolean(int startOffset, int endOffset, @NotNull IrType type2, boolean value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Boolean>(startOffset, endOffset, type2, IrConstKind.Boolean.INSTANCE, value2);
        }

        @NotNull
        public final IrConstImpl<Boolean> constTrue(int startOffset, int endOffset, @NotNull IrType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return this.boolean(startOffset, endOffset, type2, true);
        }

        @NotNull
        public final IrConstImpl<Boolean> constFalse(int startOffset, int endOffset, @NotNull IrType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return this.boolean(startOffset, endOffset, type2, false);
        }

        @NotNull
        public final IrConstImpl<Long> long(int startOffset, int endOffset, @NotNull IrType type2, long value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Long>(startOffset, endOffset, type2, IrConstKind.Long.INSTANCE, value2);
        }

        @NotNull
        public final IrConstImpl<Float> float(int startOffset, int endOffset, @NotNull IrType type2, float value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Float>(startOffset, endOffset, type2, IrConstKind.Float.INSTANCE, Float.valueOf(value2));
        }

        @NotNull
        public final IrConstImpl<Double> double(int startOffset, int endOffset, @NotNull IrType type2, double value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Double>(startOffset, endOffset, type2, IrConstKind.Double.INSTANCE, value2);
        }

        @NotNull
        public final IrConstImpl<Character> char(int startOffset, int endOffset, @NotNull IrType type2, char value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Character>(startOffset, endOffset, type2, IrConstKind.Char.INSTANCE, Character.valueOf(value2));
        }

        @NotNull
        public final IrConstImpl<Byte> byte(int startOffset, int endOffset, @NotNull IrType type2, byte value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Byte>(startOffset, endOffset, type2, IrConstKind.Byte.INSTANCE, value2);
        }

        @NotNull
        public final IrConstImpl<Short> short(int startOffset, int endOffset, @NotNull IrType type2, short value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Short>(startOffset, endOffset, type2, IrConstKind.Short.INSTANCE, value2);
        }

        @NotNull
        public final IrConstImpl<?> defaultValueForType(int startOffset, int endOffset, @NotNull IrType type2) {
            IrConstImpl<Comparable<Boolean>> irConstImpl;
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            if (IrTypePredicatesKt.isMarkedNullable(type2)) {
                return this.constNull(startOffset, endOffset, type2);
            }
            PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(type2);
            switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
                case 1: {
                    irConstImpl = this.boolean(startOffset, endOffset, type2, false);
                    break;
                }
                case 2: {
                    irConstImpl = this.char(startOffset, endOffset, type2, '\u0000');
                    break;
                }
                case 3: {
                    irConstImpl = this.byte(startOffset, endOffset, type2, (byte)0);
                    break;
                }
                case 4: {
                    irConstImpl = this.short(startOffset, endOffset, type2, (short)0);
                    break;
                }
                case 5: {
                    irConstImpl = this.int(startOffset, endOffset, type2, 0);
                    break;
                }
                case 6: {
                    irConstImpl = this.float(startOffset, endOffset, type2, 0.0f);
                    break;
                }
                case 7: {
                    irConstImpl = this.long(startOffset, endOffset, type2, 0L);
                    break;
                }
                case 8: {
                    irConstImpl = this.double(startOffset, endOffset, type2, 0.0);
                    break;
                }
                default: {
                    irConstImpl = this.constNull(startOffset, endOffset, IrTypesKt.makeNullable(type2));
                }
            }
            return irConstImpl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=50)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PrimitiveType.values().length];
                try {
                    nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.CHAR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.BYTE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.SHORT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.INT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.FLOAT.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.LONG.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

