/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameScope;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B9\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u001b\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "T", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameScope;", "parent", "reserved", "", "", "mappedNames", "", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/NameScope;Ljava/util/Set;Ljava/util/Map;)V", "getParent", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameScope;", "getReserved", "()Ljava/util/Set;", "getMappedNames", "()Ljava/util/Map;", "names", "getNames", "suggestedNameLastIdx", "", "isReserved", "", "name", "declareStableName", "", "declaration", "(Ljava/lang/Object;Ljava/lang/String;)V", "declareFreshName", "suggestedName", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/String;", "findFreshName", "backend.js"})
public final class NameTable<T>
extends NameScope {
    @NotNull
    private final NameScope parent;
    @NotNull
    private final Set<String> reserved;
    @Nullable
    private final Map<String, String> mappedNames;
    @NotNull
    private final Map<T, String> names;
    @NotNull
    private final Map<String, Integer> suggestedNameLastIdx;

    public NameTable(@NotNull NameScope parent2, @NotNull Set<String> reserved, @Nullable Map<String, String> mappedNames) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(reserved, (String)"reserved");
        this.parent = parent2;
        this.reserved = reserved;
        this.mappedNames = mappedNames;
        this.names = new LinkedHashMap();
        this.suggestedNameLastIdx = new LinkedHashMap();
    }

    public /* synthetic */ NameTable(NameScope nameScope, Set set, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            nameScope = NameScope.EmptyScope.INSTANCE;
        }
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        if ((n & 4) != 0) {
            map = null;
        }
        this(nameScope, set, map);
    }

    @NotNull
    public final NameScope getParent() {
        return this.parent;
    }

    @NotNull
    public final Set<String> getReserved() {
        return this.reserved;
    }

    @Nullable
    public final Map<String, String> getMappedNames() {
        return this.mappedNames;
    }

    @NotNull
    public final Map<T, String> getNames() {
        return this.names;
    }

    @Override
    public boolean isReserved(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.parent.isReserved(name2) || this.reserved.contains(name2);
    }

    public final void declareStableName(T declaration, @NotNull String name2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.names.put(declaration, name2);
            this.reserved.add(name2);
            Map<String, String> map = this.mappedNames;
            if (map == null) break block0;
            map.put(NameTablesKt.access$mapToKey(declaration), name2);
        }
    }

    @NotNull
    public final String declareFreshName(T declaration, @NotNull String suggestedName) {
        Intrinsics.checkNotNullParameter((Object)suggestedName, (String)"suggestedName");
        String freshName = this.findFreshName(NameTablesKt.sanitizeName$default(suggestedName, false, 2, null));
        this.declareStableName(declaration, freshName);
        return freshName;
    }

    private final String findFreshName(String suggestedName) {
        if (!this.isReserved(suggestedName)) {
            return suggestedName;
        }
        Ref.IntRef i = new Ref.IntRef();
        Integer n = this.suggestedNameLastIdx.get(suggestedName);
        int n2 = i.element = n != null ? n : 0;
        while (this.isReserved(NameTable.findFreshName$freshName(suggestedName, i))) {
            int n3 = i.element;
            i.element = n3 + 1;
        }
        this.suggestedNameLastIdx.put(suggestedName, i.element);
        return NameTable.findFreshName$freshName(suggestedName, i);
    }

    private static final String findFreshName$freshName(String $suggestedName, Ref.IntRef i) {
        return $suggestedName + '_' + i.element;
    }

    public NameTable() {
        this(null, null, null, 7, null);
    }
}

