/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.EnumeratorStringDescriptor;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.AppendableBasicStringMap;
import org.jetbrains.kotlin.incremental.storage.AppendablePersistentStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0010\u001a\u00020\u0005H\u0086\u0002J\u001f\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003H\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u001c\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/SourceToJsOutputMap;", "Lorg/jetbrains/kotlin/incremental/storage/AppendableBasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "dumpValue", "value", "add", "", "key", "get", "sourceFile", "set", "values", "remove", "removeValues", "removed", "", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nSourceToJsOutputMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceToJsOutputMap.kt\norg/jetbrains/kotlin/incremental/storage/SourceToJsOutputMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1620#2,3:49\n1549#2:52\n1620#2,3:53\n766#2:56\n857#2,2:57\n*S KotlinDebug\n*F\n+ 1 SourceToJsOutputMap.kt\norg/jetbrains/kotlin/incremental/storage/SourceToJsOutputMap\n*L\n25#1:49,3\n35#1:52\n35#1:53,3\n45#1:56\n45#1:57,2\n*E\n"})
public final class SourceToJsOutputMap
extends AppendableBasicStringMap<String, Collection<? extends String>> {
    public SourceToJsOutputMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"INSTANCE");
        super(storageFile, enumeratorStringDescriptor, icContext);
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull Collection<String> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value2);
    }

    public final synchronized void add(@NotNull File key, @NotNull File value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.getStorage().append(this.getPathConverter().toPath(key), this.getPathConverter().toPath(value2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final Collection<File> get(@NotNull File sourceFile) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Collection collection2 = (Collection)this.getStorage().get(this.getPathConverter().toPath(sourceFile));
        if (collection2 != null) {
            void var3_3;
            void $this$mapTo$iv;
            Iterable iterable = collection2;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string2 = (String)item$iv;
                Collection collection3 = destination$iv;
                boolean bl = false;
                collection3.add(this.getPathConverter().toFile((String)it));
            }
            collection = (Set)var3_3;
        } else {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void set(@NotNull File key, @NotNull Collection<? extends File> values2) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        if (values2.isEmpty()) {
            this.remove(key);
            return;
        }
        Iterable iterable = CollectionsKt.toSet((Iterable)values2);
        String string2 = this.getPathConverter().toPath(key);
        AppendablePersistentStorage appendablePersistentStorage = this.getStorage();
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getPathConverter().toPath((File)it));
        }
        collection = (List)destination$iv$iv;
        appendablePersistentStorage.set(string2, (List)collection);
    }

    @Override
    public final synchronized void remove(@NotNull File key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.getStorage().remove(this.getPathConverter().toPath(key));
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void removeValues(@NotNull File key, @NotNull Set<? extends File> removed2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(removed2, (String)"removed");
        Iterable $this$filter$iv = this.get(key);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(!removed2.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notRemoved = (List)destination$iv$iv;
        this.set(key, notRemoved);
    }
}

