/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.EnumeratorStringDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.AppendableBasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverterKt;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003H\u0086\u0002J\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\f\u001a\u00020\u0005H\u0086\u0002J\u0016\u0010\u000f\u001a\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0012\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ComplementarySourceFilesMap;", "Lorg/jetbrains/kotlin/incremental/storage/AppendableBasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "set", "", "sourceFile", "complementaryFiles", "get", "dumpValue", "value", "remove", "file", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nComplementarySourceFilesMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComplementarySourceFilesMap.kt\norg/jetbrains/kotlin/incremental/storage/ComplementarySourceFilesMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class ComplementarySourceFilesMap
extends AppendableBasicStringMap<String, Collection<? extends String>> {
    public ComplementarySourceFilesMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        KeyDescriptor keyDescriptor = PathStringDescriptor.INSTANCE;
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"INSTANCE");
        super(storageFile, keyDescriptor, (DataExternalizer)enumeratorStringDescriptor, icContext);
    }

    @Override
    public final void set(@NotNull File sourceFile, @NotNull Collection<? extends File> complementaryFiles) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter(complementaryFiles, (String)"complementaryFiles");
        this.getStorage().set(this.getPathConverter().toPath(sourceFile), FileToPathConverterKt.toPaths(this.getPathConverter(), complementaryFiles));
    }

    @Override
    @NotNull
    public final Collection<File> get(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Collection collection = (Collection)this.getStorage().get(this.getPathConverter().toPath(sourceFile));
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection paths = collection;
        return CollectionsKt.toSet((Iterable)FileToPathConverterKt.toFiles(this.getPathConverter(), paths));
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull Collection<String> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value2);
    }

    @NotNull
    public final Collection<File> remove(@NotNull File file2) {
        Collection<File> collection;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Collection<File> it = collection = this.get(file2);
        boolean bl = false;
        this.getStorage().remove(this.getPathConverter().toPath(file2));
        return collection;
    }
}

