/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.name.WasmStandardClassIds;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"hasValidJsCodeBody", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isValidJsCodeBody", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "isJsCodeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers.wasm"})
public final class FirWasmJsCodeHelpersKt {
    public static final boolean hasValidJsCodeBody(@NotNull FirSimpleFunction $this$hasValidJsCodeBody) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidJsCodeBody, (String)"<this>");
        FirBlock firBlock = $this$hasValidJsCodeBody.getBody();
        return firBlock != null ? FirWasmJsCodeHelpersKt.isValidJsCodeBody(firBlock) : false;
    }

    public static final boolean hasValidJsCodeBody(@NotNull FirProperty $this$hasValidJsCodeBody) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidJsCodeBody, (String)"<this>");
        FirExpression firExpression2 = $this$hasValidJsCodeBody.getInitializer();
        return firExpression2 != null ? FirWasmJsCodeHelpersKt.isJsCodeCall(firExpression2) : false;
    }

    private static final boolean isValidJsCodeBody(FirBlock $this$isValidJsCodeBody) {
        FirStatement firStatement = (FirStatement)CollectionsKt.singleOrNull($this$isValidJsCodeBody.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement singleStatement = firStatement;
        return singleStatement instanceof FirFunctionCall ? FirWasmJsCodeHelpersKt.isJsCodeCall((FirExpression)singleStatement) : (singleStatement instanceof FirReturnExpression && $this$isValidJsCodeBody instanceof FirSingleExpressionBlock ? FirWasmJsCodeHelpersKt.isJsCodeCall(((FirReturnExpression)singleStatement).getResult()) : false);
    }

    private static final boolean isJsCodeCall(FirExpression $this$isJsCodeCall) {
        if (!($this$isJsCodeCall instanceof FirFunctionCall)) {
            return false;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirFunctionCall)$this$isJsCodeCall).getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return false;
        }
        FirCallableSymbol symbol2 = firCallableSymbol;
        return Intrinsics.areEqual((Object)symbol2.getCallableId(), (Object)WasmStandardClassIds.Callables.Js);
    }
}

