/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirMemberPropertiesCheckerKt;
import org.jetbrains.kotlin.fir.declarations.FirControlFlowGraphOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.NormalPath;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelPropertiesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "collectionInitializationInfo", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfo;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTopLevelPropertiesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTopLevelPropertiesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelPropertiesChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,271:1\n800#2,11:272\n800#2,11:283\n1611#2:294\n1855#2:295\n1856#2:298\n1612#2:299\n1#3:296\n1#3:297\n*S KotlinDebug\n*F\n+ 1 FirTopLevelPropertiesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelPropertiesChecker\n*L\n56#1:272,11\n57#1:283,11\n60#1:294\n60#1:295\n60#1:298\n60#1:299\n60#1:297\n*E\n"})
public final class FirTopLevelPropertiesChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirTopLevelPropertiesChecker INSTANCE = new FirTopLevelPropertiesChecker();

    private FirTopLevelPropertiesChecker() {
    }

    @Override
    public void check(@NotNull FirFile declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        PropertyInitializationInfo info = this.collectionInitializationInfo(declaration, context2, reporter);
        for (FirDeclaration innerDeclaration : declaration.getDeclarations()) {
            if (!(innerDeclaration instanceof FirProperty)) continue;
            FirPropertySymbol symbol2 = ((FirProperty)innerDeclaration).getSymbol();
            Object object = info;
            boolean isDefinitelyAssigned = object != null && (object = (EventOccurrencesRange)((Object)object.get(symbol2))) != null ? EventOccurrencesRangeKt.isDefinitelyVisited((EventOccurrencesRange)((Object)object)) : false;
            FirMemberPropertiesCheckerKt.checkProperty(null, (FirProperty)innerDeclaration, isDefinitelyAssigned, context2, reporter, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PropertyInitializationInfo collectionInitializationInfo(FirFile $this$collectionInitializationInfo, CheckerContext context2, DiagnosticReporter reporter) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        List list2;
        Iterable $this$filterIsInstanceTo$iv$iv;
        boolean $i$f$filterIsInstanceTo;
        Collection destination$iv$iv;
        boolean $i$f$filterIsInstance2;
        Iterable $this$filterIsInstance$iv;
        Object object = $this$collectionInitializationInfo instanceof FirControlFlowGraphOwner ? (FirControlFlowGraphOwner)$this$collectionInitializationInfo : null;
        if (object == null || (object = object.getControlFlowGraphReference()) == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return null;
        }
        Object graph = object;
        FirDeclaration script = (FirDeclaration)CollectionsKt.singleOrNull($this$collectionInitializationInfo.getDeclarations());
        if (script instanceof FirScript) {
            $this$filterIsInstance$iv = ((FirScript)script).getStatements();
            $i$f$filterIsInstance2 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            $this$filterIsInstance$iv = $this$collectionInitializationInfo.getDeclarations();
            $i$f$filterIsInstance2 = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        List topLevelProperties = list2;
        $this$filterIsInstance$iv = topLevelProperties;
        Collection $i$f$filterIsInstance2 = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirPropertySymbol it$iv;
            FirPropertySymbol firPropertySymbol;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            FirProperty declaration = (FirProperty)element$iv;
            boolean bl2 = false;
            FirPropertySymbol it = firPropertySymbol = declaration.getSymbol();
            boolean bl3 = false;
            if ((FirPropertyInitializationAnalyzerKt.requiresInitialization(it, true) ? firPropertySymbol : null) == null) continue;
            it$iv = it$iv;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        Set propertySymbols = (Set)destination$iv;
        if (propertySymbols.isEmpty()) {
            return null;
        }
        PropertyInitializationInfoData data2 = new PropertyInitializationInfoData(propertySymbols, null, (ControlFlowGraph)graph);
        FirPropertyInitializationAnalyzerKt.checkPropertyAccesses(data2, true, context2, reporter);
        return (PropertyInitializationInfo)data2.getValue(((ControlFlowGraph)graph).getExitNode()).get(NormalPath.INSTANCE);
    }
}

