/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContext;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContextFactory;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContextKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirExpectActualDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.mpp.CallableSymbolMarker;
import org.jetbrains.kotlin.mpp.ClassLikeSymbolMarker;
import org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import org.jetbrains.kotlin.mpp.RegularClassSymbolMarker;
import org.jetbrains.kotlin.mpp.SourceElementMarker;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualAnnotationMatchChecker;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualChecker;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualAnnotationsIncompatibilityType;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCheckingCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualMatchingCompatibility;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0019\u001a\u00020\u000eH\u0002JF\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001c2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\t\u001a\u00020\"H\u0002JN\u0010#\u001a\u00020\u00072\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u001c2\u001c\u0010%\u001a\u0018\u0012\u0004\u0012\u00020'\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0(0&2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010*\u001a\u00020\u00072\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010+\u001a\u00020\u000e2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010,\u001a\u00020-H\u0002J,\u0010.\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "containsExpectOrActualModifier", "", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkExpectDeclarationModifiers", "checkExpectPropertyAccessorsModifiers", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkExpectPropertyAccessorModifiers", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "checkExpectDeclarationHasNoExternalModifier", "checkActualDeclarationHasExpected", "checkActual", "getCheckingCompatibility", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "actualSymbol", "expectSymbol", "actualContainingClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "expectContainingClass", "Lorg/jetbrains/kotlin/fir/FirExpectActualMatchingContext;", "checkAmbiguousExpects", "actualDeclaration", "compatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualMatchingCompatibility;", "", "symbol", "checkAnnotationsMatch", "requireActualModifier", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkOptInAnnotation", "expectDeclarationSymbol", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectActualDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n37#2:322\n36#2:323\n37#2:324\n36#2:325\n44#2:326\n45#2:327\n36#2:328\n819#3:329\n847#3,2:330\n1549#3:332\n1620#3,3:333\n1045#3:336\n*S KotlinDebug\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n*L\n43#1:322\n43#1:323\n53#1:324\n57#1:325\n78#1:326\n112#1:327\n147#1:328\n174#1:329\n174#1:330,2\n254#1:332\n254#1:333,3\n255#1:336\n*E\n"})
public final class FirExpectActualDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectActualDeclarationChecker INSTANCE = new FirExpectActualDeclarationChecker();

    private FirExpectActualDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block7: {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    if (!(declaration instanceof FirMemberDeclaration)) {
                        return;
                    }
                    if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.MultiPlatformProjects)) break block7;
                    FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
                    boolean $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) break block8;
                    FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration;
                    boolean $i$f$isActual = false;
                    if (!$this$isActual$iv.getStatus().isActual()) break block9;
                }
                if (this.containsExpectOrActualModifier((FirMemberDeclaration)declaration)) {
                    KtDiagnosticReportHelpersKt.reportOn(reporter, (AbstractKtSourceElement)((FirMemberDeclaration)declaration).getSource(), FirErrors.INSTANCE.getNOT_A_MULTIPLATFORM_COMPILATION(), (DiagnosticContext)context2, (AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getEXPECT_ACTUAL_MODIFIER());
                }
            }
            return;
        }
        FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            this.checkExpectDeclarationModifiers((FirMemberDeclaration)declaration, context2, reporter);
            this.checkOptInAnnotation((FirMemberDeclaration)declaration, ((FirMemberDeclaration)declaration).getSymbol(), context2, reporter);
        }
        FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isActual = false;
        if ($this$isActual$iv.getStatus().isActual()) {
            FirExpectActualDeclarationChecker.checkActualDeclarationHasExpected$default(this, (FirMemberDeclaration)declaration, context2, reporter, false, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsExpectOrActualModifier(FirMemberDeclaration declaration) {
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(declaration.getSource());
        if (firModifierList == null) return false;
        FirModifierList modifiers = firModifierList;
        boolean bl = false;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.EXPECT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"EXPECT_KEYWORD");
        if (modifiers.contains(ktModifierKeywordToken)) return true;
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.ACTUAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"ACTUAL_KEYWORD");
        if (!modifiers.contains(ktModifierKeywordToken2)) return false;
        return true;
    }

    private final void checkExpectDeclarationModifiers(FirMemberDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter) {
        this.checkExpectDeclarationHasNoExternalModifier(declaration, context2, reporter);
        if (declaration instanceof FirProperty) {
            this.checkExpectPropertyAccessorsModifiers((FirProperty)declaration, context2, reporter);
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions) && declaration instanceof FirFunction) {
            FirMemberDeclaration $this$isTailRec$iv = declaration;
            boolean $i$f$isTailRec = false;
            if ($this$isTailRec$iv.getStatus().isTailRec()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirErrors.INSTANCE.getEXPECTED_TAILREC_FUNCTION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkExpectPropertyAccessorsModifiers(FirProperty property, CheckerContext context2, DiagnosticReporter reporter) {
        Object[] objectArray = new FirPropertyAccessor[]{property.getGetter(), property.getSetter()};
        for (FirPropertyAccessor accessor : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            this.checkExpectPropertyAccessorModifiers(accessor, context2, reporter);
        }
    }

    private final void checkExpectPropertyAccessorModifiers(FirPropertyAccessor accessor, CheckerContext context2, DiagnosticReporter reporter) {
        if (!FirExpectActualDeclarationChecker.checkExpectPropertyAccessorModifiers$isDefault(accessor)) {
            this.checkExpectDeclarationHasNoExternalModifier(accessor, context2, reporter);
        }
    }

    private final void checkExpectDeclarationHasNoExternalModifier(FirMemberDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter) {
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            FirMemberDeclaration $this$isExternal$iv = declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPECTED_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActualDeclarationHasExpected(FirMemberDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter, boolean checkActual) {
        ExpectActualCompatibility<FirBasedSymbol<?>> expectActualCompatibility;
        FirBasedSymbol expectedSingleCandidate;
        FirBasedSymbol<? extends FirDeclaration> symbol2 = declaration.getSymbol();
        Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> map = ExpectActualAttributesKt.getExpectForActual(symbol2);
        if (map == null) {
            return;
        }
        Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> matchingCompatibilityToMembersMap = map;
        List<FirBasedSymbol<?>> list2 = matchingCompatibilityToMembersMap.get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE);
        FirBasedSymbol firBasedSymbol = expectedSingleCandidate = list2 != null ? (FirBasedSymbol)CollectionsKt.singleOrNull(list2) : null;
        if (expectedSingleCandidate != null) {
            FirRegularClassSymbol actualContainingClass;
            FirExpectActualMatchingContext expectActualMatchingContext = FirExpectActualMatchingContextKt.getExpectActualMatchingContextFactory(context2.getSession()).create(context2.getSession(), context2.getScopeSession(), true);
            FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            FirBasedSymbol<? extends FirDeclaration> firBasedSymbol2 = firDeclaration != null ? firDeclaration.getSymbol() : null;
            FirRegularClassSymbol firRegularClassSymbol = actualContainingClass = firBasedSymbol2 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol2 : null;
            FirBasedSymbol<?> firBasedSymbol3 = firRegularClassSymbol != null ? ExpectActualAttributesKt.getSingleExpectForActualOrNull(firRegularClassSymbol) : null;
            FirRegularClassSymbol expectContainingClass = firBasedSymbol3 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol3 : null;
            expectActualCompatibility = this.getCheckingCompatibility(symbol2, expectedSingleCandidate, actualContainingClass, expectContainingClass, expectActualMatchingContext);
        } else {
            expectActualCompatibility = null;
        }
        ExpectActualCompatibility<FirBasedSymbol<?>> checkingCompatibility = expectActualCompatibility;
        this.checkAmbiguousExpects(symbol2, matchingCompatibilityToMembersMap, symbol2, context2, reporter);
        KtSourceElement source = declaration.getSource();
        FirMemberDeclaration $this$isActual$iv = declaration;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            if (checkActual && matchingCompatibilityToMembersMap.containsKey(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_MISSING(), (DiagnosticContext)context2, null, 8, null);
            }
            return;
        }
        if (checkingCompatibility instanceof ExpectActualCheckingCompatibility.ClassScopes) {
            void $this$filterNotTo$iv$iv;
            if (!(symbol2 instanceof FirRegularClassSymbol || symbol2 instanceof FirTypeAliasSymbol)) {
                boolean $i$a$-require-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22 = false;
                String $i$a$-require-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22 = "Incompatible.ClassScopes is only possible for a class or a typealias: " + declaration;
                throw new IllegalArgumentException($i$a$-require-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22.toString());
            }
            Iterable $this$filterNot$iv = ((ExpectActualCheckingCompatibility.ClassScopes)checkingCompatibility).getIncompatibleMembers();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Pair p0 = (Pair)element$iv$iv;
                boolean bl = false;
                if (FirExpectActualDeclarationChecker.checkActualDeclarationHasExpected$hasSingleActualSuspect(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonTrivialIncompatibleMembers = (List)destination$iv$iv;
            if (!((Collection)nonTrivialIncompatibleMembers).isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS(), symbol2, (Object)nonTrivialIncompatibleMembers, (DiagnosticContext)context2, null, 32, null);
            } else if (!((Collection)((ExpectActualCheckingCompatibility.ClassScopes)checkingCompatibility).getMismatchedMembers()).isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS(), symbol2, ((ExpectActualCheckingCompatibility.ClassScopes)checkingCompatibility).getMismatchedMembers(), (DiagnosticContext)context2, null, 32, null);
            }
        } else if (!matchingCompatibilityToMembersMap.containsKey(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE) && this.requireActualModifier(declaration.getSymbol(), context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_WITHOUT_EXPECT(), symbol2, matchingCompatibilityToMembersMap, (DiagnosticContext)context2, null, 32, null);
        } else if (checkingCompatibility != null && !Intrinsics.areEqual(checkingCompatibility, (Object)ExpectActualCheckingCompatibility.Compatible.INSTANCE)) {
            if (!(expectedSingleCandidate != null)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            if (declaration instanceof FirFunction && Intrinsics.areEqual(checkingCompatibility, (Object)ExpectActualCheckingCompatibility.ActualFunctionWithDefaultParameters.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirErrors.INSTANCE.getACTUAL_FUNCTION_WITH_DEFAULT_ARGUMENTS(), (DiagnosticContext)context2, null, 8, null);
            } else if (this.requireActualModifier(declaration.getSymbol(), context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_WITHOUT_EXPECT(), symbol2, (Object)MapsKt.mapOf((Pair)TuplesKt.to(checkingCompatibility, (Object)CollectionsKt.listOf((Object)expectedSingleCandidate))), (DiagnosticContext)context2, null, 32, null);
            }
        }
        if (expectedSingleCandidate != null) {
            this.checkOptInAnnotation(declaration, expectedSingleCandidate, context2, reporter);
            this.checkAnnotationsMatch(expectedSingleCandidate, symbol2, context2, reporter);
        }
    }

    static /* synthetic */ void checkActualDeclarationHasExpected$default(FirExpectActualDeclarationChecker firExpectActualDeclarationChecker, FirMemberDeclaration firMemberDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        firExpectActualDeclarationChecker.checkActualDeclarationHasExpected(firMemberDeclaration, checkerContext, diagnosticReporter, bl);
    }

    private final ExpectActualCompatibility<FirBasedSymbol<?>> getCheckingCompatibility(FirBasedSymbol<?> actualSymbol, FirBasedSymbol<?> expectSymbol, FirRegularClassSymbol actualContainingClass, FirRegularClassSymbol expectContainingClass, FirExpectActualMatchingContext context2) {
        ExpectActualCheckingCompatibility expectActualCheckingCompatibility;
        if (actualSymbol instanceof FirCallableSymbol && expectSymbol instanceof FirCallableSymbol) {
            expectActualCheckingCompatibility = AbstractExpectActualChecker.INSTANCE.getCallablesCompatibility((CallableSymbolMarker)((Object)expectSymbol), (CallableSymbolMarker)((Object)actualSymbol), expectContainingClass, actualContainingClass, context2);
        } else if (actualSymbol instanceof FirClassLikeSymbol && expectSymbol instanceof RegularClassSymbolMarker) {
            expectActualCheckingCompatibility = AbstractExpectActualChecker.INSTANCE.getClassifiersCompatibility((RegularClassSymbolMarker)((Object)expectSymbol), (ClassLikeSymbolMarker)((Object)actualSymbol), context2);
        } else {
            throw new IllegalStateException("These expect/actual shouldn't have been matched by FirExpectActualResolver".toString());
        }
        return expectActualCheckingCompatibility;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(FirBasedSymbol<?> actualDeclaration, Map<ExpectActualMatchingCompatibility, ? extends List<? extends FirBasedSymbol<?>>> compatibility, FirBasedSymbol<?> symbol2, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List list2 = compatibility.get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable iterable = list2;
        boolean $i$f$map = false;
        void var9_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirBasedSymbol firBasedSymbol = (FirBasedSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getModuleData());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List filesWithAtLeastWeaklyCompatibleExpects2 = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FirModuleData it = (FirModuleData)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (FirModuleData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName().asString())));
            }
        }));
        if (filesWithAtLeastWeaklyCompatibleExpects2.size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)actualDeclaration.getSource(), FirErrors.INSTANCE.getAMBIGUOUS_EXPECTS(), symbol2, (Object)filesWithAtLeastWeaklyCompatibleExpects2, (DiagnosticContext)context2, null, 32, null);
        }
    }

    private final void checkAnnotationsMatch(FirBasedSymbol<?> expectSymbol, FirBasedSymbol<?> actualSymbol, CheckerContext context2, DiagnosticReporter reporter) {
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            return;
        }
        FirExpectActualMatchingContext matchingContext2 = FirExpectActualMatchingContextFactory.create$default(FirExpectActualMatchingContextKt.getExpectActualMatchingContextFactory(context2.getSession()), context2.getSession(), context2.getScopeSession(), false, 4, null);
        AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility = AbstractExpectActualAnnotationMatchChecker.INSTANCE.areAnnotationsCompatible(expectSymbol, (DeclarationSymbolMarker)actualSymbol, matchingContext2);
        if (incompatibility == null) {
            return;
        }
        AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility2 = incompatibility;
        SourceElementMarker sourceElementMarker = incompatibility2.getActualAnnotationTargetElement();
        Intrinsics.checkNotNull((Object)sourceElementMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirSourceElement");
        KtSourceElement actualAnnotationTargetSourceElement = ((FirSourceElement)sourceElementMarker).getElement();
        KtDiagnosticFactory4<FirBasedSymbol<?>, FirBasedSymbol<?>, KtSourceElement, ExpectActualAnnotationsIncompatibilityType<FirAnnotation>> ktDiagnosticFactory4 = FirErrors.INSTANCE.getACTUAL_ANNOTATIONS_NOT_MATCH_EXPECT();
        AbstractKtSourceElement abstractKtSourceElement = KtDiagnosticReportHelpersKt.requireNotNull(actualSymbol.getSource());
        DeclarationSymbolMarker declarationSymbolMarker = incompatibility2.getExpectSymbol();
        Intrinsics.checkNotNull((Object)declarationSymbolMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>");
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)declarationSymbolMarker;
        DeclarationSymbolMarker declarationSymbolMarker2 = incompatibility2.getActualSymbol();
        Intrinsics.checkNotNull((Object)declarationSymbolMarker2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>");
        reporter.report(ktDiagnosticFactory4.on(abstractKtSourceElement, firBasedSymbol, (FirBasedSymbol)declarationSymbolMarker2, actualAnnotationTargetSourceElement, incompatibility2.getType().mapAnnotationType(checkAnnotationsMatch.1.INSTANCE), null), context2);
    }

    private final boolean requireActualModifier(FirBasedSymbol<?> declaration, FirSession session2) {
        return !DeclarationUtilsKt.isAnnotationConstructor(declaration, session2) && !DeclarationUtilsKt.isPrimaryConstructorOfInlineOrValueClass(declaration, session2);
    }

    private final void checkOptInAnnotation(FirMemberDeclaration declaration, FirBasedSymbol<?> expectDeclarationSymbol, CheckerContext context2, DiagnosticReporter reporter) {
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions) && declaration instanceof FirClass && ((FirClass)declaration).getClassKind() == ClassKind.ANNOTATION_CLASS && !FirAnnotationUtilsKt.hasAnnotation(expectDeclarationSymbol, StandardClassIds.Annotations.INSTANCE.getOptionalExpectation(), context2.getSession()) && FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)declaration, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirClass)declaration).getSource(), FirErrors.INSTANCE.getEXPECT_ACTUAL_OPT_IN_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private static final boolean checkExpectPropertyAccessorModifiers$isDefault(FirPropertyAccessor $this$checkExpectPropertyAccessorModifiers_u24isDefault) {
        KtSourceElement ktSourceElement = $this$checkExpectPropertyAccessorModifiers_u24isDefault.getSource();
        return Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DefaultAccessor.INSTANCE);
    }

    private static final boolean checkActualDeclarationHasExpected$hasSingleActualSuspect(Pair<? extends FirBasedSymbol<?>, ? extends Map<? extends ExpectActualCheckingCompatibility.Incompatible<? extends FirBasedSymbol<?>>, ? extends Collection<? extends FirBasedSymbol<?>>>> expectedWithIncompatibility) {
        Object object;
        FirBasedSymbol actualMember;
        FirBasedSymbol expectedMember = (FirBasedSymbol)expectedWithIncompatibility.component1();
        Map incompatibility = (Map)expectedWithIncompatibility.component2();
        Collection collection = (Collection)CollectionsKt.singleOrNull((Iterable)incompatibility.values());
        FirBasedSymbol firBasedSymbol = actualMember = collection != null ? (FirBasedSymbol)CollectionsKt.singleOrNull((Iterable)collection) : null;
        return actualMember != null && Intrinsics.areEqual((object = ExpectActualAttributesKt.getExpectForActual(actualMember.getFir())) != null && (object = object.values()) != null && (object = (List)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) != null ? (FirBasedSymbol)CollectionsKt.singleOrNull((List)object) : null, (Object)expectedMember);
    }
}

