/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSessionKey;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016JB\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2 \u0010\u000e\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J*\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u001a2\u0006\u0010\t\u001a\u00020\nH\u0002R\u001c\u0010\u0013\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportConflicts", "declarationConflictingSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/utils/SmartSet;", "container", "isPrimaryConstructor", "", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "checkFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "inspector", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ScopeSession.kt\norg/jetbrains/kotlin/fir/resolve/ScopeSession\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,128:1\n215#2:129\n216#2:136\n1726#3,3:130\n1747#3,3:133\n18#4:137\n19#4:141\n20#4,2:146\n372#5,3:138\n375#5,4:142\n*S KotlinDebug\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n*L\n58#1:129\n58#1:136\n73#1:130,3\n81#1:133,3\n96#1:137\n96#1:141\n96#1:146,2\n96#1:138,3\n96#1:142,4\n*E\n"})
public final class FirConflictsDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictsDeclarationChecker INSTANCE = new FirConflictsDeclarationChecker();

    private FirConflictsDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirFile) {
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            this.checkFile((FirFile)declaration, inspector, context2);
            this.reportConflicts(reporter, context2, (Map)inspector.getDeclarationConflictingSymbols(), declaration);
        } else if (firDeclaration instanceof FirRegularClass) {
            KtSourceElement ktSourceElement = ((FirRegularClass)declaration).getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirRegularClass)declaration).getTypeParameters(), context2, reporter);
            }
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            FirConflictsHelpersKt.collectClassMembers(inspector, ((FirRegularClass)declaration).getSymbol());
            this.reportConflicts(reporter, context2, (Map)inspector.getDeclarationConflictingSymbols(), declaration);
        } else {
            KtSourceElement ktSourceElement = declaration.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && declaration instanceof FirTypeParameterRefsOwner) {
                if (declaration instanceof FirFunction) {
                    FirConflictsHelpersKt.checkForLocalRedeclarations(((FirFunction)declaration).getValueParameters(), context2, reporter);
                }
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirTypeParameterRefsOwner)((Object)declaration)).getTypeParameters(), context2, reporter);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void reportConflicts(DiagnosticReporter reporter, CheckerContext context, Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> declarationConflictingSymbols, FirDeclaration container) {
        $this$forEach$iv = declarationConflictingSymbols;
        $i$f$forEach = false;
        var7_7 = $this$forEach$iv.entrySet().iterator();
        while (var7_7.hasNext()) {
            block17: {
                block15: {
                    block16: {
                        var9_9 = element$iv = var7_7.next();
                        $i$a$-forEach-FirConflictsDeclarationChecker$reportConflicts$1 = false;
                        conflictingDeclaration = var9_9.getKey();
                        symbols = var9_9.getValue();
                        v0 = conflictingDeclaration instanceof FirConstructorSymbol != false ? (FirConstructorSymbol)conflictingDeclaration : null;
                        typeAliasForConstructorSource = v0 != null && (v0 = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirConstructorSymbol)v0)) != null ? v0.getSource() : null;
                        origin = conflictingDeclaration.getOrigin();
                        if (!(conflictingDeclaration instanceof FirCallableSymbol)) {
                            v1 = conflictingDeclaration.getSource();
                        } else if (Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Source.INSTANCE)) {
                            v1 = ((FirCallableSymbol)conflictingDeclaration).getSource();
                        } else {
                            if (Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Library.INSTANCE)) continue;
                            v1 = source = Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE) != false ? typeAliasForConstructorSource : container.getSource();
                        }
                        if (symbols.isEmpty()) continue;
                        if (FirConflictsDeclarationChecker.INSTANCE.isPrimaryConstructor(conflictingDeclaration)) {
                            block14: {
                                $this$all$iv = (Iterable)symbols;
                                $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    v2 = true;
                                } else {
                                    for (T element$iv : $this$all$iv) {
                                        it = (FirBasedSymbol)element$iv;
                                        $i$a$-all-FirConflictsDeclarationChecker$reportConflicts$1$1 = false;
                                        if (FirConflictsDeclarationChecker.INSTANCE.isPrimaryConstructor(it)) continue;
                                        v2 = false;
                                        break block14;
                                    }
                                    v2 = true;
                                }
                            }
                            if (v2) continue;
                        }
                        if (!(conflictingDeclaration instanceof FirNamedFunctionSymbol) && !(conflictingDeclaration instanceof FirConstructorSymbol)) break block16;
                        v3 = FirErrors.INSTANCE.getCONFLICTING_OVERLOADS();
                        break block17;
                    }
                    if (!(conflictingDeclaration instanceof FirClassLikeSymbol) || FirHelpersKt.getContainingClassSymbol(conflictingDeclaration, context.getSession()) != null) ** GOTO lbl-1000
                    $this$any$iv = (Iterable)symbols;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v4 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (FirBasedSymbol)element$iv;
                            $i$a$-any-FirConflictsDeclarationChecker$reportConflicts$1$factory$1 = false;
                            if (!(it instanceof FirClassLikeSymbol)) continue;
                            v4 = true;
                            break block15;
                        }
                        v4 = false;
                    }
                }
                if (v4) {
                    v3 = FirErrors.INSTANCE.getPACKAGE_OR_CLASSIFIER_REDECLARATION();
                } else lbl-1000:
                // 2 sources

                {
                    v3 = FirErrors.INSTANCE.getREDECLARATION();
                }
            }
            factory = v3;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory, symbols, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final boolean isPrimaryConstructor(FirBasedSymbol<?> $this$isPrimaryConstructor) {
        return $this$isPrimaryConstructor instanceof FirConstructorSymbol && ((FirConstructorSymbol)$this$isPrimaryConstructor).isPrimary() || Intrinsics.areEqual((Object)$this$isPrimaryConstructor.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFile(FirFile file2, FirDeclarationCollector<FirBasedSymbol<?>> inspector, CheckerContext context2) {
        Object object;
        Object object2;
        Object answer$iv$iv;
        void id$iv;
        void this_$iv;
        ScopeSession scopeSession = context2.getSessionHolder().getScopeSession();
        FqName fqName2 = UtilsKt.getPackageFqName(file2);
        ScopeSessionKey<FqName, FirPackageMemberScope> key$iv = FirPackageMemberScopeKt.getPACKAGE_MEMBER();
        boolean $i$f$getOrBuild = false;
        Map $this$getOrPut$iv$iv = this_$iv.scopes();
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(id$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            answer$iv$iv = new HashMap();
            $this$getOrPut$iv$iv.put(id$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        $this$getOrPut$iv$iv = (Map)object2;
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            answer$iv$iv = new FirPackageMemberScope(UtilsKt.getPackageFqName(file2), context2.getSessionHolder().getSession(), null, null, 12, null);
            $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        FirPackageMemberScope packageMemberScope = (FirPackageMemberScope)object;
        FirConflictsHelpersKt.collectTopLevel(inspector, file2, packageMemberScope);
        for (FirDeclaration topLevelDeclaration : file2.getDeclarations()) {
            if (topLevelDeclaration instanceof FirErrorProperty || !(topLevelDeclaration instanceof FirErrorFunction)) continue;
        }
    }
}

