/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentMap;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u0016j\u0002`\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a2\u0006\u0002\u0010\u001fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010RA\u0010\u0011\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u0016j\b\u0012\u0004\u0012\u00020\u0015`\u00140\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "receiver", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "<init>", "(Ljava/util/Set;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;)V", "getProperties", "()Ljava/util/Set;", "getReceiver", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getGraph", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfo;", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "getData", "()Ljava/util/Map;", "data$delegate", "Lkotlin/Lazy;", "getValue", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwarePropertyInitializationInfo;", "node", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)Lkotlinx/collections/immutable/PersistentMap;", "checkers"})
public final class PropertyInitializationInfoData {
    @NotNull
    private final Set<FirPropertySymbol> properties;
    @Nullable
    private final FirBasedSymbol<?> receiver;
    @NotNull
    private final ControlFlowGraph graph;
    @NotNull
    private final Lazy data$delegate;

    public PropertyInitializationInfoData(@NotNull Set<? extends FirPropertySymbol> properties2, @Nullable FirBasedSymbol<?> receiver, @NotNull ControlFlowGraph graph) {
        Intrinsics.checkNotNullParameter(properties2, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.properties = properties2;
        this.receiver = receiver;
        this.graph = graph;
        this.data$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)new Function0<Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PropertyInitializationInfo>>>(this){
            final /* synthetic */ PropertyInitializationInfoData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Map<CFGNode<?>, PersistentMap<EdgeLabel, PropertyInitializationInfo>> invoke() {
                return CfgTraverserKt.collectDataForNode(this.this$0.getGraph(), TraverseDirection.Forward, new PropertyInitializationInfoCollector(this.this$0.getProperties(), this.this$0.getReceiver(), null, 4, null));
            }
        });
    }

    @NotNull
    public final Set<FirPropertySymbol> getProperties() {
        return this.properties;
    }

    @Nullable
    public final FirBasedSymbol<?> getReceiver() {
        return this.receiver;
    }

    @NotNull
    public final ControlFlowGraph getGraph() {
        return this.graph;
    }

    private final Map<CFGNode<?>, PersistentMap<EdgeLabel, PropertyInitializationInfo>> getData() {
        Lazy lazy = this.data$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final PersistentMap<EdgeLabel, PropertyInitializationInfo> getValue(@NotNull CFGNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        return (PersistentMap)MapsKt.getValue(this.getData(), node);
    }
}

