/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.diagnostics.rendering.AnnotationsWhitelistDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.AnnotationsWhitelistDescriptorRendererKt;
import org.jetbrains.kotlin.diagnostics.rendering.CommonRenderers;
import org.jetbrains.kotlin.diagnostics.rendering.ContextIndependentParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRendererKt;
import org.jetbrains.kotlin.diagnostics.rendering.MultiplatformDiagnosticRenderingMode;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderersKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.CannotCapture;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.ParameterConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ValidityConstraintForConstituentType;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.AbstractTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.utils.IDEAPlatforms;
import org.jetbrains.kotlin.utils.IDEAPluginsCompatibilityAPI;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001~B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020(0%H\u0002J(\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H/0%0.\"\u0004\b\u0000\u0010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/0.H\u0007J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u0002022\u0006\u0010:\u001a\u000208H\u0007J\u0018\u0010;\u001a\u0002082\u0006\u00109\u001a\u0002022\u0006\u0010<\u001a\u000208H\u0007J\u0018\u0010=\u001a\u0002082\u0006\u00109\u001a\u0002022\u0006\u0010:\u001a\u000208H\u0007J\u0018\u0010>\u001a\u0002082\u0006\u00109\u001a\u0002022\u0006\u0010:\u001a\u000208H\u0007J\"\u0010?\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u0002022\u0006\u0010:\u001a\u0002082\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010B\u001a\u0002082\u0006\u00109\u001a\u0002022\u0006\u0010:\u001a\u000208H\u0007J,\u0010E\u001a\u00020+2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0%2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020G0.2\u0006\u0010I\u001a\u00020JH\u0002J\u0016\u0010L\u001a\u00020+2\u0006\u0010M\u001a\u00020A2\u0006\u0010N\u001a\u00020OJ\u0018\u0010P\u001a\u00020+2\u0006\u0010Q\u001a\u00020R2\u0006\u0010N\u001a\u00020OH\u0002J\u0018\u0010S\u001a\u00020+2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0002J\u0018\u0010X\u001a\u00020+2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010[\u001a\u00020+2\u0006\u0010\\\u001a\u00020]H\u0002J\"\u0010^\u001a\u00020+2\u0006\u0010_\u001a\u00020+2\u0006\u00109\u001a\u0002022\b\b\u0002\u0010N\u001a\u00020OH\u0002J\f\u0010`\u001a\u00020+*\u00020+H\u0002J\f\u0010`\u001a\u00020+*\u00020aH\u0002J \u0010v\u001a\u00020+2\b\u0010w\u001a\u0004\u0018\u00010G2\u000e\u0010x\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010yJ\u0018\u0010z\u001a\u00020+2\b\u0010{\u001a\u0004\u0018\u00010|2\u0006\u0010}\u001a\u00020+R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0%0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0%0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\b\u0012\u0004\u0012\u0002020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\b\u0012\u0004\u0012\u0002020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\b\u0012\u0004\u0012\u0002020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0%0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020G0%0.8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010b\u001a\u00020cX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010d\u001a\u00020W*\b\u0012\u0004\u0012\u00020f0e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bg\u0010hR\u001c\u0010i\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020f0e0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010j\u001a\u00020k8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010l\u001a\u00020m8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010n\u001a\u00020k8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010o\u001a\u00020k8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010p\u001a\u00020k8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010q\u001a\u00020k8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010r\u001a\u00020k8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010s\u001a\u00020k8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010t\u001a\u00020k8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010u\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140%0.8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u007f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers;", "", "<init>", "()V", "LOG", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TO_STRING", "Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "NOT_RENDERED", "NAME", "Lorg/jetbrains/kotlin/descriptors/Named;", "FQ_NAME", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "MODULE_WITH_PLATFORM", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "MODULE", "VISIBILITY", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "DECLARATION_NAME_WITH_KIND", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM", "NAME_OF_CONTAINING_DECLARATION_OR_FILE", "ELEMENT_TEXT", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "RENDER_CLASS_OR_OBJECT", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "RENDER_CLASS_OR_OBJECT_NAME", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "RENDER_TYPE", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartTypeRenderer;", "RENDER_TYPE_WITH_ANNOTATIONS", "TYPE_PROJECTION", "Lorg/jetbrains/kotlin/types/TypeProjection;", "AMBIGUOUS_CALLS", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "COMPATIBILITY_CANDIDATE", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "AMBIGUOUS_CALLABLE_REFERENCES", "renderAmbiguousDescriptors", "", "descriptors", "commaSeparated", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "T", "itemRenderer", "TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER", "TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER", "TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER", "TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER", "renderConflictingSubstitutionsInferenceError", "Lorg/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer;", "inferenceErrorData", "result", "renderParameterConstraintError", "renderer", "renderNoInformationForParameterError", "renderUpperBoundViolatedInferenceError", "renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor", "systemWithoutWeakConstraints", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "renderCannotCaptureTypeParameterError", "CLASSES_OR_SEPARATED", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "renderTypes", "types", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeRenderer", "context", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "RENDER_COLLECTION_OF_TYPES", "renderConstraintSystem", "constraintSystem", "verbosity", "Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers$ConstraintSystemRenderingVerbosity;", "renderTypeBounds", "typeBounds", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "renderTypeVariable", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "includeTypeConstructor", "", "renderTypeBound", "bound", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "renderTypeConstructor", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "debugMessage", "message", "wrapIntoQuotes", "Lorg/jetbrains/kotlin/name/Name;", "WHEN_MISSING_LIMIT", "", "assumesElseBranchOnly", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "getAssumesElseBranchOnly", "(Ljava/util/List;)Z", "RENDER_WHEN_MISSING_CASES", "FQ_NAMES_IN_TYPES", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartDescriptorRenderer;", "FQ_NAMES_IN_TYPES_ANNOTATIONS_WHITELIST", "Lorg/jetbrains/kotlin/diagnostics/rendering/AnnotationsWhitelistDescriptorRenderer;", "FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS", "COMPACT", "COMPACT_WITHOUT_SUPERTYPES", "WITHOUT_MODIFIERS", "SHORT_NAMES_IN_TYPES", "COMPACT_WITH_MODIFIERS", "DEPRECATION_RENDERER", "DESCRIPTORS_ON_NEWLINE_WITH_INDENT", "renderExpressionType", "type", "dataFlowTypes", "", "renderCallInfo", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "typeCall", "ConstraintSystemRenderingVerbosity", "frontend"})
@SourceDebugExtension(value={"SMAP\nRenderers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Renderers.kt\norg/jetbrains/kotlin/diagnostics/rendering/Renderers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,758:1\n766#2:759\n857#2,2:760\n1549#2:762\n1620#2,3:763\n288#2,2:766\n288#2,2:768\n1549#2:770\n1620#2,3:771\n288#2,2:776\n1747#2,3:778\n1549#2:781\n1620#2,3:782\n20#3,2:774\n1#4:785\n*S KotlinDebug\n*F\n+ 1 Renderers.kt\norg/jetbrains/kotlin/diagnostics/rendering/Renderers\n*L\n307#1:759\n307#1:760,2\n307#1:762\n307#1:763,3\n324#1:766,2\n355#1:768,2\n449#1:770\n449#1:771,3\n500#1:776,2\n685#1:778,3\n745#1:781\n745#1:782,3\n493#1:774,2\n*E\n"})
public final class Renderers {
    @NotNull
    public static final Renderers INSTANCE = new Renderers();
    @NotNull
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Object> TO_STRING;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Object> NOT_RENDERED;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Named> NAME;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<MemberDescriptor> FQ_NAME;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<ModuleDescriptor> MODULE_WITH_PLATFORM;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<ModuleDescriptor> MODULE;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<DescriptorVisibility> VISIBILITY;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<DeclarationDescriptor> DECLARATION_NAME_WITH_KIND;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<DeclarationDescriptor> CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<DeclarationDescriptor> NAME_OF_CONTAINING_DECLARATION_OR_FILE;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<PsiElement> ELEMENT_TEXT;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<KtClassOrObject> RENDER_CLASS_OR_OBJECT;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<ClassifierDescriptorWithTypeParameters> RENDER_CLASS_OR_OBJECT_NAME;
    @JvmField
    @NotNull
    public static final SmartTypeRenderer RENDER_TYPE;
    @JvmField
    @NotNull
    public static final SmartTypeRenderer RENDER_TYPE_WITH_ANNOTATIONS;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<TypeProjection> TYPE_PROJECTION;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Collection<? extends ResolvedCall<?>>> AMBIGUOUS_CALLS;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<CallableDescriptor> COMPATIBILITY_CANDIDATE;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Collection<? extends CallableDescriptor>> AMBIGUOUS_CALLABLE_REFERENCES;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Collection<? extends ClassDescriptor>> CLASSES_OR_SEPARATED;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Collection<? extends KotlinType>> RENDER_COLLECTION_OF_TYPES;
    private static final int WHEN_MISSING_LIMIT;
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<List<? extends WhenMissingCase>> RENDER_WHEN_MISSING_CASES;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer FQ_NAMES_IN_TYPES;
    @JvmField
    @NotNull
    public static final AnnotationsWhitelistDescriptorRenderer FQ_NAMES_IN_TYPES_ANNOTATIONS_WHITELIST;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer COMPACT;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer COMPACT_WITHOUT_SUPERTYPES;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer WITHOUT_MODIFIERS;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer SHORT_NAMES_IN_TYPES;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer COMPACT_WITH_MODIFIERS;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer DEPRECATION_RENDERER;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Collection<? extends DeclarationDescriptor>> DESCRIPTORS_ON_NEWLINE_WITH_INDENT;

    private Renderers() {
    }

    private final String renderAmbiguousDescriptors(Collection<? extends CallableDescriptor> descriptors) {
        RenderingContext.Impl context2 = new RenderingContext.Impl(descriptors);
        Iterable iterable = descriptors;
        MemberComparator memberComparator = MemberComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)memberComparator, (String)"INSTANCE");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)memberComparator), (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, (Function1)((Function1)new Function1<CallableDescriptor, CharSequence>(context2){
            final /* synthetic */ RenderingContext.Impl $context;
            {
                this.$context = $context;
                super(1);
            }

            public final CharSequence invoke(CallableDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Renderers.FQ_NAMES_IN_TYPES.render(it, (RenderingContext)this.$context);
            }
        }), (int)28, null);
    }

    @JvmStatic
    @IDEAPluginsCompatibilityAPI(usedIn={IDEAPlatforms._213}, message="Please use the CommonRenderers.commaSeparated instead", plugins="Android plugin in IDEA")
    @NotNull
    public static final <T> DiagnosticParameterRenderer<Collection<? extends T>> commaSeparated(@NotNull DiagnosticParameterRenderer<? super T> itemRenderer) {
        Intrinsics.checkNotNullParameter(itemRenderer, (String)"itemRenderer");
        return CommonRenderers.commaSeparated(itemRenderer);
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderConflictingSubstitutionsInferenceError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Intrinsics.checkNotNullParameter((Object)inferenceErrorData, (String)"inferenceErrorData");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        LOG.assertTrue(inferenceErrorData.constraintSystem.getStatus().hasConflictingConstraints(), Renderers.debugMessage$default(INSTANCE, "Conflicting substitutions inference error renderer is applied for incorrect status", inferenceErrorData, null, 4, null));
        ArrayList<CallableDescriptor> substitutedDescriptors = Lists.newArrayList();
        Collection<TypeSubstitutor> collection = ConstraintsUtil.getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSubstitutorsForConflictingParameters(...)");
        Collection<TypeSubstitutor> substitutors = collection;
        for (TypeSubstitutor substitutor2 : substitutors) {
            CallableDescriptor callableDescriptor = inferenceErrorData.descriptor;
            Intrinsics.checkNotNull((Object)substitutor2);
            CallableDescriptor substitutedDescriptor = (CallableDescriptor)callableDescriptor.substitute(substitutor2);
            substitutedDescriptors.add(substitutedDescriptor);
        }
        TypeVariable firstConflictingVariable = ConstraintsUtil.getFirstConflictingVariable(inferenceErrorData.constraintSystem);
        if (firstConflictingVariable == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "There is no conflicting parameter for 'conflicting constraints' error.", inferenceErrorData, null, 4, null));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Cannot infer type parameter ").strong(firstConflictingVariable.getName()).normal(" in "));
        TabledDescriptorRenderer.TableRenderer table = TabledDescriptorRenderer.newTable();
        result2.table(table);
        table.descriptor(inferenceErrorData.descriptor).text("None of the following substitutions");
        Iterator iterator2 = substitutedDescriptors.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            CallableDescriptor substitutedDescriptor = (CallableDescriptor)iterator3.next();
            KotlinType receiverType = DescriptorUtils.getReceiverParameterType(substitutedDescriptor.getExtensionReceiverParameter());
            HashSet<ConstraintPosition> errorPositions = new HashSet<ConstraintPosition>();
            ArrayList<KotlinType> parameterTypes2 = Lists.newArrayList();
            for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
                KotlinType actualType;
                parameterTypes2.add(valueParameterDescriptor.getType());
                if (valueParameterDescriptor.getIndex() >= inferenceErrorData.valueArgumentsTypes.size() || KotlinTypeChecker.DEFAULT.isSubtypeOf(actualType = inferenceErrorData.valueArgumentsTypes.get(valueParameterDescriptor.getIndex()), valueParameterDescriptor.getType())) continue;
                errorPositions.add(ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex()));
            }
            if (receiverType != null && inferenceErrorData.receiverArgumentType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(inferenceErrorData.receiverArgumentType, receiverType)) {
                errorPositions.add(ConstraintPositionKind.RECEIVER_POSITION.position());
            }
            table.functionArgumentTypeList(receiverType, (List<KotlinType>)parameterTypes2, arg_0 -> Renderers.renderConflictingSubstitutionsInferenceError$lambda$0(errorPositions, arg_0));
        }
        table.text("can be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderParameterConstraintError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer renderer2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ConstraintError it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)inferenceErrorData, (String)"inferenceErrorData");
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        List<ConstraintError> constraintErrors = inferenceErrorData.constraintSystem.getStatus().getConstraintErrors();
        Iterable $this$filter$iv = constraintErrors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConstraintError)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof ParameterConstraintError)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ConstraintError)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getConstraintPosition());
        }
        List errorPositions = (List)destination$iv$iv;
        TabledDescriptorRenderer tabledDescriptorRenderer = renderer2.table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("cannot be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes, arg_0 -> Renderers.renderParameterConstraintError$lambda$3(errorPositions, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)tabledDescriptorRenderer, (String)"table(...)");
        return tabledDescriptorRenderer;
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderNoInformationForParameterError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)inferenceErrorData, (String)"inferenceErrorData");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Iterable $this$firstOrNull$iv = inferenceErrorData.constraintSystem.getTypeVariables();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TypeVariable variable2 = (TypeVariable)element$iv;
                boolean bl = false;
                if (!inferenceErrorData.constraintSystem.getTypeBounds(variable2).getValues().isEmpty()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        TypeVariable typeVariable = v0;
        if (typeVariable == null) {
            TabledDescriptorRenderer tabledDescriptorRenderer;
            TabledDescriptorRenderer $this$renderNoInformationForParameterError_u24lambda_u245 = tabledDescriptorRenderer = result2;
            boolean bl = false;
            LOG.error(Renderers.debugMessage$default(INSTANCE, "There is no unknown parameter for 'no information for parameter error'.", inferenceErrorData, null, 4, null));
            return tabledDescriptorRenderer;
        }
        TypeVariable firstUnknownVariable = typeVariable;
        TabledDescriptorRenderer tabledDescriptorRenderer = result2.text(TabledDescriptorRenderer.newText().normal("Not enough information to infer parameter ").strong(firstUnknownVariable.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("Please specify it explicitly."));
        Intrinsics.checkNotNullExpressionValue((Object)tabledDescriptorRenderer, (String)"table(...)");
        return tabledDescriptorRenderer;
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderUpperBoundViolatedInferenceError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Object v2;
        Object $this$firstOrNull$iv;
        ConstraintSystem systemWithoutWeakConstraints;
        ConstraintSystemStatus status2;
        block8: {
            Intrinsics.checkNotNullParameter((Object)inferenceErrorData, (String)"inferenceErrorData");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
            Intrinsics.checkNotNullExpressionValue((Object)constraintSystem, (String)"constraintSystem");
            ConstraintSystem constraintSystem2 = constraintSystem;
            status2 = constraintSystem2.getStatus();
            LOG.assertTrue(status2.hasViolatedUpperBound(), Renderers.debugMessage$default(INSTANCE, "Upper bound violated renderer is applied for incorrect status", inferenceErrorData, null, 4, null));
            systemWithoutWeakConstraints = ConstraintSystemUtilsKt.filterConstraintsOut(constraintSystem2, ConstraintPositionKind.TYPE_BOUND_POSITION);
            List<TypeParameterDescriptor> list2 = inferenceErrorData.descriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeParameters(...)");
            $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)element$iv;
                boolean bl = false;
                if (!(!ConstraintsUtil.checkUpperBoundIsSatisfied(systemWithoutWeakConstraints, typeParameterDescriptor, inferenceErrorData.call, true))) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = v2;
        if (typeParameterDescriptor == null) {
            TabledDescriptorRenderer tabledDescriptorRenderer;
            if (inferenceErrorData.descriptor instanceof TypeAliasConstructorDescriptor && ($this$firstOrNull$iv = INSTANCE.renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor(inferenceErrorData, result2, systemWithoutWeakConstraints)) != null) {
                Object it = $this$firstOrNull$iv;
                boolean bl = false;
                return it;
            }
            if (status2.hasConflictingConstraints()) {
                tabledDescriptorRenderer = Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, result2);
            } else {
                LOG.error(INSTANCE.debugMessage("There is no type parameter with violated upper bound for 'upper bound violated' error", inferenceErrorData, ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE));
                tabledDescriptorRenderer = result2;
            }
            return tabledDescriptorRenderer;
        }
        Call call2 = inferenceErrorData.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
        TypeVariable typeVariable = ConstraintSystemUtilsKt.descriptorToVariable(systemWithoutWeakConstraints, TypeVariableKt.toHandle(call2), typeParameterDescriptor);
        KotlinType inferredValueForTypeParameter = systemWithoutWeakConstraints.getTypeBounds(typeVariable).getValue();
        if (inferredValueForTypeParameter == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "System without weak constraints is not successful, there is no value for type parameter " + typeParameterDescriptor.getName() + "\n: " + systemWithoutWeakConstraints, inferenceErrorData, null, 4, null));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
        KotlinType violatedUpperBound = null;
        for (KotlinType kotlinType : typeParameterDescriptor.getUpperBounds()) {
            KotlinType upperBoundWithSubstitutedInferredTypes = systemWithoutWeakConstraints.getResultingSubstitutor().substitute(kotlinType, Variance.INVARIANT);
            if (upperBoundWithSubstitutedInferredTypes == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(inferredValueForTypeParameter, upperBoundWithSubstitutedInferredTypes)) continue;
            violatedUpperBound = upperBoundWithSubstitutedInferredTypes;
            break;
        }
        if (violatedUpperBound == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "Type parameter (chosen as violating its upper bound)" + typeParameterDescriptor.getName() + " violates no bounds after substitution", inferenceErrorData, null, 4, null));
            return result2;
        }
        Object[] objectArray = new Object[]{inferredValueForTypeParameter, violatedUpperBound};
        RenderingContext context2 = RenderingContext.Companion.of(objectArray);
        DiagnosticParameterRenderer<KotlinType> diagnosticParameterRenderer = result2.getTypeRenderer();
        Intrinsics.checkNotNullExpressionValue(diagnosticParameterRenderer, (String)"getTypeRenderer(...)");
        DiagnosticParameterRenderer<KotlinType> diagnosticParameterRenderer2 = diagnosticParameterRenderer;
        result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(diagnosticParameterRenderer2.render(inferredValueForTypeParameter, context2)).normal(" is not a subtype of ").strong(diagnosticParameterRenderer2.render(violatedUpperBound, context2)));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final TabledDescriptorRenderer renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer result2, ConstraintSystem systemWithoutWeakConstraints) {
        Object[] it;
        void $this$mapTo$iv$iv;
        CallableDescriptor callableDescriptor = inferenceErrorData.descriptor;
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"descriptor");
        CallableDescriptor descriptor2 = callableDescriptor;
        if (!(descriptor2 instanceof TypeAliasConstructorDescriptor)) {
            LOG.error("Type alias constructor descriptor expected: " + descriptor2);
            return result2;
        }
        List<TypeParameterDescriptor> list2 = ((TypeAliasConstructorDescriptor)descriptor2).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeParameters(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Call call2 = inferenceErrorData.call;
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
            CallHandle callHandle = TypeVariableKt.toHandle(call2);
            Intrinsics.checkNotNull((Object)it);
            TypeVariable typeVariable = ConstraintSystemUtilsKt.descriptorToVariable(systemWithoutWeakConstraints, callHandle, (TypeParameterDescriptor)it);
            collection.add(systemWithoutWeakConstraints.getTypeBounds(typeVariable).getValue());
        }
        List inferredTypesForTypeParameters = (List)destination$iv$iv;
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(descriptor2, inferredTypesForTypeParameters){
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ List<KotlinType> $inferredTypesForTypeParameters;
            {
                this.$descriptor = $descriptor;
                this.$inferredTypesForTypeParameters = $inferredTypesForTypeParameters;
            }

            public TypeProjection get(TypeConstructor key) {
                TypeProjectionImpl typeProjectionImpl;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                ClassifierDescriptor classifierDescriptor = key.getDeclarationDescriptor();
                TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
                if (typeParameterDescriptor == null) {
                    return null;
                }
                TypeParameterDescriptor typeDescriptor = typeParameterDescriptor;
                if (!Intrinsics.areEqual((Object)typeDescriptor.getContainingDeclaration(), (Object)((TypeAliasConstructorDescriptor)this.$descriptor).getTypeAliasDescriptor())) {
                    return null;
                }
                KotlinType kotlinType = this.$inferredTypesForTypeParameters.get(typeDescriptor.getIndex());
                if (kotlinType != null) {
                    KotlinType p0 = kotlinType;
                    boolean bl = false;
                    typeProjectionImpl = new TypeProjectionImpl(p0);
                } else {
                    typeProjectionImpl = null;
                }
                return typeProjectionImpl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(...)");
        TypeSubstitutor inferredTypeSubstitutor2 = typeSubstitutor2;
        for (ConstraintError constraintError : inferenceErrorData.constraintSystem.getStatus().getConstraintErrors()) {
            ValidityConstraintForConstituentType validityConstraintForConstituentType = ConstraintPositionKt.getValidityConstraintForConstituentType(constraintError.getConstraintPosition());
            if (validityConstraintForConstituentType == null) continue;
            ValidityConstraintForConstituentType constraintInfo = validityConstraintForConstituentType;
            KotlinType kotlinType = inferredTypeSubstitutor2.safeSubstitute(constraintInfo.getBound(), Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"safeSubstitute(...)");
            KotlinType violatedUpperBound = kotlinType;
            KotlinType kotlinType2 = inferredTypeSubstitutor2.safeSubstitute(constraintInfo.getTypeArgument(), Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"safeSubstitute(...)");
            KotlinType violatingInferredType = kotlinType2;
            it = new Object[]{violatingInferredType, violatedUpperBound};
            RenderingContext context2 = RenderingContext.Companion.of(it);
            DiagnosticParameterRenderer<KotlinType> diagnosticParameterRenderer = result2.getTypeRenderer();
            Intrinsics.checkNotNullExpressionValue(diagnosticParameterRenderer, (String)"getTypeRenderer(...)");
            DiagnosticParameterRenderer<KotlinType> typeRenderer = diagnosticParameterRenderer;
            result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(constraintInfo.getTypeParameter().getName()).normal(" in type inferred from type alias expansion for ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
            result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render(violatingInferredType, context2)).normal(" is not a subtype of ").strong(typeRenderer.render(violatedUpperBound, context2)));
            return result2;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderCannotCaptureTypeParameterError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        boolean element$iv3;
        CapturedTypeConstructor capturedTypeConstructor;
        TypeBounds.Bound boundWithCapturedType;
        Object object;
        Object v4;
        TypeVariable typeVariableWithCapturedConstraint;
        block6: {
            Object v1;
            ConstraintSystem system2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)inferenceErrorData, (String)"inferenceErrorData");
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
                Intrinsics.checkNotNullExpressionValue((Object)constraintSystem, (String)"constraintSystem");
                system2 = constraintSystem;
                List<ConstraintError> errors2 = system2.getStatus().getConstraintErrors();
                Iterable $this$firstIsInstanceOrNull$iv = errors2;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv2 : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv2 instanceof CannotCapture)) continue;
                    v1 = element$iv2;
                    break block5;
                }
                v1 = null;
            }
            CannotCapture cannotCapture = v1;
            TypeVariable typeVariable = typeVariableWithCapturedConstraint = cannotCapture != null ? cannotCapture.getTypeVariable() : null;
            if (typeVariableWithCapturedConstraint == null) {
                LOG.error(Renderers.debugMessage$default(INSTANCE, "An error 'cannot capture type parameter' is not found in errors", inferenceErrorData, null, 4, null));
                return result2;
            }
            TypeBounds typeBounds = system2.getTypeBounds(typeVariableWithCapturedConstraint);
            Iterable $this$firstOrNull$iv = typeBounds.getBounds();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv3 : $this$firstOrNull$iv) {
                TypeBounds.Bound it = (TypeBounds.Bound)element$iv3;
                boolean bl = false;
                if (!CapturedTypeConstructorKt.isCaptured(it.getConstrainingType())) continue;
                v4 = element$iv3;
                break block6;
            }
            v4 = null;
        }
        TypeConstructor $i$f$firstOrNull = (object = (boundWithCapturedType = (TypeBounds.Bound)v4)) != null && (object = ((TypeBounds.Bound)object).getConstrainingType()) != null ? ((KotlinType)object).getConstructor() : null;
        CapturedTypeConstructor capturedTypeConstructor2 = capturedTypeConstructor = $i$f$firstOrNull instanceof CapturedTypeConstructor ? (CapturedTypeConstructor)$i$f$firstOrNull : null;
        if (capturedTypeConstructor == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "There is no captured type in bounds, but there is an error 'cannot capture type parameter'", inferenceErrorData, null, 4, null));
            return result2;
        }
        TypeParameterDescriptor typeParameter2 = typeVariableWithCapturedConstraint.getOriginalTypeParameter();
        KotlinType kotlinType = TypeIntersector.getUpperBoundsAsType(typeParameter2);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getUpperBoundsAsType(...)");
        KotlinType upperBound = kotlinType;
        boolean bl = element$iv3 = !KotlinBuiltIns.isNullableAny(upperBound) && capturedTypeConstructor.getProjection().getProjectionKind() == Variance.IN_VARIANCE;
        if (_Assertions.ENABLED && !element$iv3) {
            boolean bl2 = false;
            String string2 = "There is the only reason to report TYPE_INFERENCE_CANNOT_CAPTURE_TYPES";
            throw new AssertionError((Object)string2);
        }
        Object[] objectArray = new Object[]{upperBound};
        String explanation = "Type parameter has an upper bound " + INSTANCE.wrapIntoQuotes(result2.getTypeRenderer().render(upperBound, RenderingContext.Companion.of(objectArray))) + " that cannot be satisfied capturing 'in' projection";
        TabledDescriptorRenderer.TextRenderer textRenderer = TabledDescriptorRenderer.newText();
        StringBuilder stringBuilder2 = new StringBuilder();
        Name name2 = typeParameter2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        objectArray = new Object[]{capturedTypeConstructor.getProjection()};
        result2.text(textRenderer.normal(stringBuilder2.append(INSTANCE.wrapIntoQuotes(name2)).append(" cannot capture ").append(INSTANCE.wrapIntoQuotes(result2.getTypeProjectionRenderer().render(capturedTypeConstructor.getProjection(), RenderingContext.Companion.of(objectArray)))).append(". ").append(explanation).toString()));
        return result2;
    }

    private final String renderTypes(Collection<? extends KotlinType> types2, DiagnosticParameterRenderer<? super KotlinType> typeRenderer, RenderingContext context2) {
        String string2 = StringUtil.join(types2, arg_0 -> Renderers.renderTypes$lambda$11((Function1)new Function1<KotlinType, String>(typeRenderer, context2){
            final /* synthetic */ DiagnosticParameterRenderer<KotlinType> $typeRenderer;
            final /* synthetic */ RenderingContext $context;
            {
                this.$typeRenderer = $typeRenderer;
                this.$context = $context;
                super(1);
            }

            public final String invoke(KotlinType it) {
                Intrinsics.checkNotNull((Object)it);
                return this.$typeRenderer.render(it, this.$context);
            }
        }, arg_0), ", ");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
        return string2;
    }

    @NotNull
    public final String renderConstraintSystem(@NotNull ConstraintSystem constraintSystem, @NotNull ConstraintSystemRenderingVerbosity verbosity) {
        Intrinsics.checkNotNullParameter((Object)constraintSystem, (String)"constraintSystem");
        Intrinsics.checkNotNullParameter((Object)((Object)verbosity), (String)"verbosity");
        LinkedHashSet<TypeBounds> typeBounds = new LinkedHashSet<TypeBounds>();
        for (TypeVariable variable2 : constraintSystem.getTypeVariables()) {
            typeBounds.add(constraintSystem.getTypeBounds(variable2));
        }
        String separator = verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE ? "\n\n" : "\n";
        return "type parameter bounds:\n" + CollectionsKt.joinToString$default((Iterable)typeBounds, (CharSequence)separator, null, null, (int)0, null, (Function1)((Function1)new Function1<TypeBounds, CharSequence>(verbosity){
            final /* synthetic */ ConstraintSystemRenderingVerbosity $verbosity;
            {
                this.$verbosity = $verbosity;
                super(1);
            }

            public final CharSequence invoke(TypeBounds it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Renderers.access$renderTypeBounds(Renderers.INSTANCE, it, this.$verbosity);
            }
        }), (int)30, null) + "\n\nstatus:\n" + ConstraintsUtil.getDebugMessageForStatus(constraintSystem.getStatus());
    }

    private final String renderTypeBounds(TypeBounds typeBounds, ConstraintSystemRenderingVerbosity verbosity) {
        String string2;
        String renderedTypeVariable = this.renderTypeVariable(typeBounds.getTypeVariable(), verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE);
        if (typeBounds.getBounds().isEmpty()) {
            string2 = renderedTypeVariable;
        } else {
            String boundsPrefix = verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE ? "\n" : " ";
            String boundsSeparator = verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE ? "\n" : ", ";
            String renderedBounds2 = CollectionsKt.joinToString$default((Iterable)typeBounds.getBounds(), (CharSequence)boundsSeparator, null, null, (int)0, null, (Function1)((Function1)new Function1<TypeBounds.Bound, CharSequence>(verbosity){
                final /* synthetic */ ConstraintSystemRenderingVerbosity $verbosity;
                {
                    this.$verbosity = $verbosity;
                    super(1);
                }

                public final CharSequence invoke(TypeBounds.Bound it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Renderers.access$renderTypeBound(Renderers.INSTANCE, it, this.$verbosity);
                }
            }), (int)30, null);
            string2 = renderedTypeVariable + boundsPrefix + renderedBounds2;
        }
        return string2;
    }

    private final String renderTypeVariable(TypeVariable typeVariable, boolean includeTypeConstructor) {
        String string2 = typeVariable.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String typeVariableName = string2;
        if (!includeTypeConstructor) {
            return typeVariableName;
        }
        StringBuilder stringBuilder2 = new StringBuilder().append("TypeVariable ").append(typeVariableName).append(", descriptor = ").append(typeVariable.getFreshTypeParameter$frontend()).append(", typeConstructor = ");
        TypeConstructor typeConstructor2 = typeVariable.getFreshTypeParameter$frontend().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"getTypeConstructor(...)");
        return stringBuilder2.append(this.renderTypeConstructor(typeConstructor2)).toString();
    }

    private final String renderTypeBound(TypeBounds.Bound bound2, ConstraintSystemRenderingVerbosity verbosity) {
        String string2;
        String string3;
        DescriptorRenderer typeRendered = verbosity == ConstraintSystemRenderingVerbosity.COMPACT ? DescriptorRenderer.SHORT_NAMES_IN_TYPES : DescriptorRenderer.FQ_NAMES_IN_TYPES;
        switch (WhenMappings.$EnumSwitchMapping$0[bound2.getKind().ordinal()]) {
            case 1: {
                string3 = ">: ";
                break;
            }
            case 2: {
                string3 = "<: ";
                break;
            }
            default: {
                string3 = ":= ";
            }
        }
        String arrow = string3;
        String initialBoundRender = arrow + typeRendered.renderType(bound2.getConstrainingType()) + (!bound2.isProper() ? "*" : "");
        switch (WhenMappings.$EnumSwitchMapping$1[verbosity.ordinal()]) {
            case 1: {
                string2 = initialBoundRender;
                break;
            }
            case 2: {
                string2 = initialBoundRender + " (" + bound2.getPosition() + ") ";
                break;
            }
            case 3: {
                StringBuilder stringBuilder2 = new StringBuilder().append(initialBoundRender).append(" (").append(bound2.getPosition()).append(")\nConstraining type additional info: ").append(this.renderTypeConstructor(bound2.getConstrainingType().getConstructor())).append("\nSupertypes of constraining type:\n");
                Set<KotlinType> set = TypeUtils.getAllSupertypes(bound2.getConstrainingType());
                Intrinsics.checkNotNullExpressionValue(set, (String)"getAllSupertypes(...)");
                string2 = stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<KotlinType, CharSequence>(typeRendered){
                    final /* synthetic */ DescriptorRenderer $typeRendered;
                    {
                        this.$typeRendered = $typeRendered;
                        super(1);
                    }

                    public final CharSequence invoke(KotlinType it) {
                        StringBuilder stringBuilder2 = new StringBuilder().append("- ");
                        Intrinsics.checkNotNull((Object)it);
                        return stringBuilder2.append(this.$typeRendered.renderType(it)).append(", TypeConstructor info: ").append(Renderers.access$renderTypeConstructor(Renderers.INSTANCE, it.getConstructor())).toString();
                    }
                }), (int)30, null)).append('\n').toString();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final String renderTypeConstructor(TypeConstructor typeConstructor2) {
        AbstractTypeConstructor abstractTypeConstructor = typeConstructor2 instanceof AbstractTypeConstructor ? (AbstractTypeConstructor)typeConstructor2 : null;
        return typeConstructor2 + '[' + typeConstructor2.getClass().getName() + "], " + (abstractTypeConstructor != null ? abstractTypeConstructor.renderAdditionalDebugInformation() : null);
    }

    private final String debugMessage(String message2, InferenceErrorData inferenceErrorData, ConstraintSystemRenderingVerbosity verbosity) {
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3;
        StringBuilder $this$debugMessage_u24lambda_u2412 = stringBuilder3 = new StringBuilder();
        boolean bl = false;
        $this$debugMessage_u24lambda_u2412.append(message2);
        $this$debugMessage_u24lambda_u2412.append("\nConstraint system: \n");
        ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
        Intrinsics.checkNotNullExpressionValue((Object)constraintSystem, (String)"constraintSystem");
        $this$debugMessage_u24lambda_u2412.append(INSTANCE.renderConstraintSystem(constraintSystem, verbosity));
        $this$debugMessage_u24lambda_u2412.append("\nDescriptor:\n");
        $this$debugMessage_u24lambda_u2412.append(inferenceErrorData.descriptor);
        $this$debugMessage_u24lambda_u2412.append("\nExpected type:\n");
        RenderingContext.Empty context2 = RenderingContext.Empty.INSTANCE;
        if (TypeUtils.noExpectedType(inferenceErrorData.expectedType)) {
            stringBuilder2 = $this$debugMessage_u24lambda_u2412.append(inferenceErrorData.expectedType);
        } else {
            KotlinType kotlinType = inferenceErrorData.expectedType;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
            stringBuilder2 = $this$debugMessage_u24lambda_u2412.append(RENDER_TYPE_WITH_ANNOTATIONS.render(kotlinType, (RenderingContext)context2));
        }
        $this$debugMessage_u24lambda_u2412.append("\nArgument types:\n");
        if (inferenceErrorData.receiverArgumentType != null) {
            $this$debugMessage_u24lambda_u2412.append(RENDER_TYPE_WITH_ANNOTATIONS.render(inferenceErrorData.receiverArgumentType, (RenderingContext)context2)).append(".");
        }
        StringBuilder stringBuilder4 = $this$debugMessage_u24lambda_u2412.append("(");
        List<KotlinType> list2 = inferenceErrorData.valueArgumentsTypes;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"valueArgumentsTypes");
        stringBuilder4.append(INSTANCE.renderTypes((Collection<? extends KotlinType>)list2, RENDER_TYPE_WITH_ANNOTATIONS, context2)).append(")");
        String string2 = stringBuilder3.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    static /* synthetic */ String debugMessage$default(Renderers renderers, String string2, InferenceErrorData inferenceErrorData, ConstraintSystemRenderingVerbosity constraintSystemRenderingVerbosity, int n, Object object) {
        if ((n & 4) != 0) {
            constraintSystemRenderingVerbosity = ConstraintSystemRenderingVerbosity.DEBUG;
        }
        return renderers.debugMessage(string2, inferenceErrorData, constraintSystemRenderingVerbosity);
    }

    private final String wrapIntoQuotes(String $this$wrapIntoQuotes) {
        return '\'' + $this$wrapIntoQuotes + '\'';
    }

    private final String wrapIntoQuotes(Name $this$wrapIntoQuotes) {
        return '\'' + $this$wrapIntoQuotes.asString() + '\'';
    }

    private final boolean getAssumesElseBranchOnly(List<? extends WhenMissingCase> $this$assumesElseBranchOnly) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$assumesElseBranchOnly;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WhenMissingCase it = (WhenMissingCase)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)WhenMissingCase.Unknown.INSTANCE) || it instanceof WhenMissingCase.ConditionTypeIsExpect)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderExpressionType(@Nullable KotlinType type2, @Nullable Set<? extends KotlinType> dataFlowTypes) {
        Set set;
        void $this$mapTo$iv$iv;
        if (type2 == null) {
            return "Type is unknown";
        }
        if (dataFlowTypes == null) {
            return DescriptorRenderer.DEBUG_TEXT.renderType(type2);
        }
        Iterable $this$map$iv = dataFlowTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DescriptorRenderer.DEBUG_TEXT.renderType((KotlinType)it));
        }
        Set $this$renderExpressionType_u24lambda_u2415 = set = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        $this$renderExpressionType_u24lambda_u2415.add(DescriptorRenderer.DEBUG_TEXT.renderType(type2));
        Set typesAsString = set;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)typesAsString), (CharSequence)" & ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String renderCallInfo(@Nullable FqNameUnsafe fqName2, @NotNull String typeCall) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)typeCall, (String)"typeCall");
        StringBuilder $this$renderCallInfo_u24lambda_u2416 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder3 = new StringBuilder().append("fqName: ");
        Object object = fqName2;
        if (object == null || (object = ((FqNameUnsafe)object).asString()) == null) {
            object = "fqName is unknown";
        }
        $this$renderCallInfo_u24lambda_u2416.append(stringBuilder3.append((String)object).append("; ").toString());
        $this$renderCallInfo_u24lambda_u2416.append("typeCall: " + typeCall);
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final boolean renderConflictingSubstitutionsInferenceError$lambda$0(HashSet $errorPositions, ConstraintPosition it) {
        Intrinsics.checkNotNullParameter((Object)$errorPositions, (String)"$errorPositions");
        return $errorPositions.contains(it);
    }

    private static final boolean renderParameterConstraintError$lambda$3(List $errorPositions, ConstraintPosition it) {
        Intrinsics.checkNotNullParameter((Object)$errorPositions, (String)"$errorPositions");
        return $errorPositions.contains(it);
    }

    private static final String renderTypes$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$renderTypeBounds(Renderers $this, TypeBounds typeBounds, ConstraintSystemRenderingVerbosity verbosity) {
        return $this.renderTypeBounds(typeBounds, verbosity);
    }

    public static final /* synthetic */ String access$renderTypeBound(Renderers $this, TypeBounds.Bound bound2, ConstraintSystemRenderingVerbosity verbosity) {
        return $this.renderTypeBound(bound2, verbosity);
    }

    public static final /* synthetic */ String access$renderTypeConstructor(Renderers $this, TypeConstructor typeConstructor2) {
        return $this.renderTypeConstructor(typeConstructor2);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$wrapIntoQuotes(Renderers $this, String $receiver) {
        return $this.wrapIntoQuotes($receiver);
    }

    public static final /* synthetic */ String access$renderAmbiguousDescriptors(Renderers $this, Collection descriptors) {
        return $this.renderAmbiguousDescriptors(descriptors);
    }

    public static final /* synthetic */ String access$renderTypes(Renderers $this, Collection types2, DiagnosticParameterRenderer typeRenderer, RenderingContext context2) {
        return $this.renderTypes(types2, typeRenderer, context2);
    }

    public static final /* synthetic */ boolean access$getAssumesElseBranchOnly(Renderers $this, List $receiver) {
        return $this.getAssumesElseBranchOnly($receiver);
    }

    public static final /* synthetic */ int access$getWHEN_MISSING_LIMIT$p() {
        return WHEN_MISSING_LIMIT;
    }

    static {
        Logger logger = Logger.getInstance(Renderers.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        TO_STRING = DiagnosticParameterRendererKt.Renderer(TO_STRING.1.INSTANCE);
        NOT_RENDERED = DiagnosticParameterRendererKt.Renderer(NOT_RENDERED.1.INSTANCE);
        NAME = DiagnosticParameterRendererKt.Renderer(NAME.1.INSTANCE);
        FQ_NAME = DiagnosticParameterRendererKt.Renderer(FQ_NAME.1.INSTANCE);
        MODULE_WITH_PLATFORM = DiagnosticParameterRendererKt.Renderer(MODULE_WITH_PLATFORM.1.INSTANCE);
        MODULE = DiagnosticParameterRendererKt.Renderer(MODULE.1.INSTANCE);
        VISIBILITY = DiagnosticParameterRendererKt.Renderer(VISIBILITY.1.INSTANCE);
        DECLARATION_NAME_WITH_KIND = DiagnosticParameterRendererKt.Renderer(DECLARATION_NAME_WITH_KIND.1.INSTANCE);
        CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM = DiagnosticParameterRendererKt.Renderer(CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM.1.INSTANCE);
        NAME_OF_CONTAINING_DECLARATION_OR_FILE = DiagnosticParameterRendererKt.Renderer(NAME_OF_CONTAINING_DECLARATION_OR_FILE.1.INSTANCE);
        ELEMENT_TEXT = DiagnosticParameterRendererKt.Renderer(ELEMENT_TEXT.1.INSTANCE);
        DECLARATION_NAME = DiagnosticParameterRendererKt.Renderer(DECLARATION_NAME.1.INSTANCE);
        RENDER_CLASS_OR_OBJECT = DiagnosticParameterRendererKt.Renderer(RENDER_CLASS_OR_OBJECT.1.INSTANCE);
        RENDER_CLASS_OR_OBJECT_NAME = DiagnosticParameterRendererKt.Renderer(RENDER_CLASS_OR_OBJECT_NAME.1.INSTANCE);
        RENDER_TYPE = new SmartTypeRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)RENDER_TYPE.1.INSTANCE)));
        RENDER_TYPE_WITH_ANNOTATIONS = new SmartTypeRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)RENDER_TYPE_WITH_ANNOTATIONS.1.INSTANCE)));
        TYPE_PROJECTION = DiagnosticParameterRendererKt.Renderer(TYPE_PROJECTION.1.INSTANCE);
        AMBIGUOUS_CALLS = DiagnosticParameterRendererKt.Renderer(AMBIGUOUS_CALLS.1.INSTANCE);
        COMPATIBILITY_CANDIDATE = DiagnosticParameterRendererKt.Renderer(COMPATIBILITY_CANDIDATE.1.INSTANCE);
        AMBIGUOUS_CALLABLE_REFERENCES = DiagnosticParameterRendererKt.Renderer(AMBIGUOUS_CALLABLE_REFERENCES.1.INSTANCE);
        TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER.1.INSTANCE);
        CLASSES_OR_SEPARATED = DiagnosticParameterRendererKt.Renderer(CLASSES_OR_SEPARATED.1.INSTANCE);
        RENDER_COLLECTION_OF_TYPES = DiagnosticParameterRendererKt.ContextDependentRenderer(RENDER_COLLECTION_OF_TYPES.1.INSTANCE);
        WHEN_MISSING_LIMIT = 7;
        RENDER_WHEN_MISSING_CASES = DiagnosticParameterRendererKt.Renderer(RENDER_WHEN_MISSING_CASES.1.INSTANCE);
        FQ_NAMES_IN_TYPES = RenderersKt.asRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES);
        FQ_NAMES_IN_TYPES_ANNOTATIONS_WHITELIST = AnnotationsWhitelistDescriptorRendererKt.withAnnotationsWhitelist$default(DescriptorRenderer.FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS, null, 1, null);
        FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS = RenderersKt.asRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS);
        COMPACT = RenderersKt.asRenderer(DescriptorRenderer.COMPACT);
        COMPACT_WITHOUT_SUPERTYPES = RenderersKt.asRenderer(DescriptorRenderer.COMPACT_WITHOUT_SUPERTYPES);
        WITHOUT_MODIFIERS = RenderersKt.asRenderer(DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)WITHOUT_MODIFIERS.1.INSTANCE)));
        SHORT_NAMES_IN_TYPES = RenderersKt.asRenderer(DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        COMPACT_WITH_MODIFIERS = RenderersKt.asRenderer(DescriptorRenderer.COMPACT_WITH_MODIFIERS);
        DEPRECATION_RENDERER = RenderersKt.asRenderer(DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)DEPRECATION_RENDERER.1.INSTANCE)));
        DESCRIPTORS_ON_NEWLINE_WITH_INDENT = new DiagnosticParameterRenderer<Collection<? extends DeclarationDescriptor>>(){
            private final MultiplatformDiagnosticRenderingMode mode;
            {
                this.mode = new MultiplatformDiagnosticRenderingMode();
            }

            public String render(Collection<? extends DeclarationDescriptor> obj, RenderingContext renderingContext) {
                StringBuilder stringBuilder2;
                Intrinsics.checkNotNullParameter(obj, (String)"obj");
                Intrinsics.checkNotNullParameter((Object)renderingContext, (String)"renderingContext");
                StringBuilder $this$render_u24lambda_u240 = stringBuilder2 = new StringBuilder();
                boolean bl = false;
                for (DeclarationDescriptor declarationDescriptor : obj) {
                    this.mode.newLine($this$render_u24lambda_u240);
                    this.mode.renderDescriptor($this$render_u24lambda_u240, declarationDescriptor, renderingContext, "");
                }
                String string2 = stringBuilder2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                return string2;
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers$ConstraintSystemRenderingVerbosity;", "", "<init>", "(Ljava/lang/String;I)V", "COMPACT", "DEBUG", "EXTRA_VERBOSE", "frontend"})
    public static final class ConstraintSystemRenderingVerbosity
    extends Enum<ConstraintSystemRenderingVerbosity> {
        public static final /* enum */ ConstraintSystemRenderingVerbosity COMPACT = new ConstraintSystemRenderingVerbosity();
        public static final /* enum */ ConstraintSystemRenderingVerbosity DEBUG = new ConstraintSystemRenderingVerbosity();
        public static final /* enum */ ConstraintSystemRenderingVerbosity EXTRA_VERBOSE = new ConstraintSystemRenderingVerbosity();
        private static final /* synthetic */ ConstraintSystemRenderingVerbosity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConstraintSystemRenderingVerbosity[] values() {
            return (ConstraintSystemRenderingVerbosity[])$VALUES.clone();
        }

        public static ConstraintSystemRenderingVerbosity valueOf(String value2) {
            return Enum.valueOf(ConstraintSystemRenderingVerbosity.class, value2);
        }

        @NotNull
        public static EnumEntries<ConstraintSystemRenderingVerbosity> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = constraintSystemRenderingVerbosityArray = new ConstraintSystemRenderingVerbosity[]{ConstraintSystemRenderingVerbosity.COMPACT, ConstraintSystemRenderingVerbosity.DEBUG, ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TypeBounds.BoundKind.values().length];
            try {
                nArray[TypeBounds.BoundKind.LOWER_BOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeBounds.BoundKind.UPPER_BOUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ConstraintSystemRenderingVerbosity.values().length];
            try {
                nArray[ConstraintSystemRenderingVerbosity.COMPACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemRenderingVerbosity.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

