/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.description;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0005j\u0002`\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010!J\u001d\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010%J\u001d\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010)J\u001d\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010-J\u001d\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u0002002\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u00101J\f\u00102\u001a\u000203*\u000204H\u0002J\u0018\u00105\u001a\u0002032\u0006\u00106\u001a\u0002042\u0006\u00107\u001a\u000204H\u0002J&\u00108\u001a\u00020\u00022\u0006\u00106\u001a\u0002042\u0006\u00107\u001a\u0002042\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020:H\u0002R\u0014\u0010\u0003\u001a\u00060\u0005j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionRenderer;", "Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionVisitor;", "", "builder", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "<init>", "(Ljava/lang/StringBuilder;)V", "Ljava/lang/StringBuilder;", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/ConditionalEffectDeclaration;", "data", "(Lorg/jetbrains/kotlin/contracts/description/ConditionalEffectDeclaration;Lkotlin/Unit;)V", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/contracts/description/ReturnsEffectDeclaration;", "(Lorg/jetbrains/kotlin/contracts/description/ReturnsEffectDeclaration;Lkotlin/Unit;)V", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/contracts/description/CallsEffectDeclaration;", "(Lorg/jetbrains/kotlin/contracts/description/CallsEffectDeclaration;Lkotlin/Unit;)V", "visitLogicalOr", "logicalOr", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;Lkotlin/Unit;)V", "visitLogicalAnd", "logicalAnd", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;Lkotlin/Unit;)V", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;Lkotlin/Unit;)V", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;Lkotlin/Unit;)V", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;Lkotlin/Unit;)V", "visitConstantDescriptor", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;Lkotlin/Unit;)V", "visitVariableReference", "variableReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;Lkotlin/Unit;)V", "isAtom", "", "Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionElement;", "needsBrackets", "parent", "child", "inBracketsIfNecessary", "block", "Lkotlin/Function0;", "resolution"})
public final class ContractDescriptionRenderer
implements ContractDescriptionVisitor<Unit, Unit> {
    @NotNull
    private final StringBuilder builder;

    public ContractDescriptionRenderer(@NotNull StringBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        this.builder = builder2;
    }

    @Override
    public void visitConditionalEffectDeclaration(@NotNull ConditionalEffectDeclaration conditionalEffect, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)conditionalEffect, (String)"conditionalEffect");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        conditionalEffect.getEffect().accept(this, data2);
        this.builder.append(" -> ");
        conditionalEffect.getCondition().accept(this, data2);
    }

    @Override
    public void visitReturnsEffectDeclaration(@NotNull ReturnsEffectDeclaration returnsEffect, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)returnsEffect, (String)"returnsEffect");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.builder.append("Returns(");
        returnsEffect.getValue().accept(this, data2);
        this.builder.append(")");
    }

    @Override
    public void visitCallsEffectDeclaration(@NotNull CallsEffectDeclaration callsEffect, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)callsEffect, (String)"callsEffect");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.builder.append("CallsInPlace(");
        callsEffect.getVariableReference().accept(this, data2);
        this.builder.append(", " + (Object)((Object)callsEffect.getKind()) + ')');
    }

    @Override
    public void visitLogicalOr(@NotNull LogicalOr logicalOr, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)logicalOr, (String)"logicalOr");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.inBracketsIfNecessary(logicalOr, logicalOr.getLeft(), (Function0<Unit>)((Function0)new Function0<Unit>(logicalOr, this, data2){
            final /* synthetic */ LogicalOr $logicalOr;
            final /* synthetic */ ContractDescriptionRenderer this$0;
            final /* synthetic */ Unit $data;
            {
                this.$logicalOr = $logicalOr;
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                this.$logicalOr.getLeft().accept(this.this$0, this.$data);
            }
        }));
        this.builder.append(" || ");
        this.inBracketsIfNecessary(logicalOr, logicalOr.getRight(), (Function0<Unit>)((Function0)new Function0<Unit>(logicalOr, this, data2){
            final /* synthetic */ LogicalOr $logicalOr;
            final /* synthetic */ ContractDescriptionRenderer this$0;
            final /* synthetic */ Unit $data;
            {
                this.$logicalOr = $logicalOr;
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                this.$logicalOr.getRight().accept(this.this$0, this.$data);
            }
        }));
    }

    @Override
    public void visitLogicalAnd(@NotNull LogicalAnd logicalAnd, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)logicalAnd, (String)"logicalAnd");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.inBracketsIfNecessary(logicalAnd, logicalAnd.getLeft(), (Function0<Unit>)((Function0)new Function0<Unit>(logicalAnd, this, data2){
            final /* synthetic */ LogicalAnd $logicalAnd;
            final /* synthetic */ ContractDescriptionRenderer this$0;
            final /* synthetic */ Unit $data;
            {
                this.$logicalAnd = $logicalAnd;
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                this.$logicalAnd.getLeft().accept(this.this$0, this.$data);
            }
        }));
        this.builder.append(" && ");
        this.inBracketsIfNecessary(logicalAnd, logicalAnd.getRight(), (Function0<Unit>)((Function0)new Function0<Unit>(logicalAnd, this, data2){
            final /* synthetic */ LogicalAnd $logicalAnd;
            final /* synthetic */ ContractDescriptionRenderer this$0;
            final /* synthetic */ Unit $data;
            {
                this.$logicalAnd = $logicalAnd;
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                this.$logicalAnd.getRight().accept(this.this$0, this.$data);
            }
        }));
    }

    @Override
    public void visitLogicalNot(@NotNull LogicalNot logicalNot, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)logicalNot, (String)"logicalNot");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.inBracketsIfNecessary(logicalNot, logicalNot.getArg(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ContractDescriptionRenderer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ContractDescriptionRenderer.access$getBuilder$p(this.this$0).append("!");
            }
        }));
        logicalNot.getArg().accept(this, data2);
    }

    @Override
    public void visitIsInstancePredicate(@NotNull IsInstancePredicate isInstancePredicate, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)isInstancePredicate, (String)"isInstancePredicate");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        isInstancePredicate.getArg().accept(this, data2);
        this.builder.append(' ' + (isInstancePredicate.isNegated() ? "!" : "") + "is " + isInstancePredicate.getType());
    }

    @Override
    public void visitIsNullPredicate(@NotNull IsNullPredicate isNullPredicate, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)isNullPredicate, (String)"isNullPredicate");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        isNullPredicate.getArg().accept(this, data2);
        this.builder.append(' ' + (isNullPredicate.isNegated() ? "!=" : "==") + " null");
    }

    @Override
    public void visitConstantDescriptor(@NotNull ConstantReference constantReference, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)constantReference, (String)"constantReference");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.builder.append(constantReference.getName());
    }

    @Override
    public void visitVariableReference(@NotNull VariableReference variableReference, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)variableReference, (String)"variableReference");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.builder.append(variableReference.getDescriptor().getName());
    }

    private final boolean isAtom(ContractDescriptionElement $this$isAtom) {
        return $this$isAtom instanceof VariableReference || $this$isAtom instanceof ConstantReference || $this$isAtom instanceof IsNullPredicate || $this$isAtom instanceof IsInstancePredicate;
    }

    private final boolean needsBrackets(ContractDescriptionElement parent2, ContractDescriptionElement child) {
        if (this.isAtom(child)) {
            return false;
        }
        if (parent2 instanceof LogicalNot) {
            return true;
        }
        return parent2.getClass() != child.getClass();
    }

    private final void inBracketsIfNecessary(ContractDescriptionElement parent2, ContractDescriptionElement child, Function0<Unit> block) {
        if (this.needsBrackets(parent2, child)) {
            this.builder.append("(");
            block.invoke();
            this.builder.append(")");
        } else {
            block.invoke();
        }
    }

    public static final /* synthetic */ StringBuilder access$getBuilder$p(ContractDescriptionRenderer $this) {
        return $this.builder;
    }
}

