/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins.functions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0004 !\"#B+\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\fJ\b\u0010\u0018\u001a\u00020\u0000H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "classNamePrefix", "", "isReflectType", "", "annotationOnInvokeClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;ZLorg/jetbrains/kotlin/name/ClassId;)V", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;Lorg/jetbrains/kotlin/name/ClassId;Z)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getClassNamePrefix", "()Ljava/lang/String;", "()Z", "getAnnotationOnInvokeClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "prefixForTypeRender", "getPrefixForTypeRender", "serializeAsFunctionWithAnnotationUntil", "getSerializeAsFunctionWithAnnotationUntil", "nonReflectKind", "reflectKind", "numberedClassName", "Lorg/jetbrains/kotlin/name/Name;", "arity", "", "numberedClassId", "toString", "Function", "SuspendFunction", "KFunction", "KSuspendFunction", "compiler.common"})
public abstract class FunctionTypeKind {
    @NotNull
    private final FqName packageFqName;
    @NotNull
    private final String classNamePrefix;
    private final boolean isReflectType;
    @Nullable
    private final ClassId annotationOnInvokeClassId;

    public FunctionTypeKind(@NotNull FqName packageFqName, @NotNull String classNamePrefix, boolean isReflectType, @Nullable ClassId annotationOnInvokeClassId) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)classNamePrefix, (String)"classNamePrefix");
        this.packageFqName = packageFqName;
        this.classNamePrefix = classNamePrefix;
        this.isReflectType = isReflectType;
        this.annotationOnInvokeClassId = annotationOnInvokeClassId;
    }

    @NotNull
    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    public final boolean isReflectType() {
        return this.isReflectType;
    }

    @Nullable
    public final ClassId getAnnotationOnInvokeClassId() {
        return this.annotationOnInvokeClassId;
    }

    public FunctionTypeKind(@NotNull FqName packageFqName, @NotNull String classNamePrefix, @NotNull ClassId annotationOnInvokeClassId, boolean isReflectType) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)classNamePrefix, (String)"classNamePrefix");
        Intrinsics.checkNotNullParameter((Object)annotationOnInvokeClassId, (String)"annotationOnInvokeClassId");
        this(packageFqName, classNamePrefix, isReflectType, annotationOnInvokeClassId);
    }

    @Nullable
    public String getPrefixForTypeRender() {
        return null;
    }

    @Nullable
    public String getSerializeAsFunctionWithAnnotationUntil() {
        return null;
    }

    @NotNull
    public FunctionTypeKind nonReflectKind() {
        if (this.isReflectType) {
            throw new IllegalStateException("Should be overridden explicitly".toString());
        }
        return this;
    }

    @NotNull
    public FunctionTypeKind reflectKind() {
        if (!this.isReflectType) {
            throw new IllegalStateException("Should be overridden explicitly".toString());
        }
        return this;
    }

    @NotNull
    public final Name numberedClassName(int arity) {
        Name name2 = Name.identifier(this.classNamePrefix + arity);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        return name2;
    }

    @NotNull
    public final ClassId numberedClassId(int arity) {
        return new ClassId(this.packageFqName, this.numberedClassName(arity));
    }

    @NotNull
    public String toString() {
        return this.packageFqName + '.' + this.classNamePrefix + 'N';
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0001H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind$Function;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "<init>", "()V", "reflectKind", "compiler.common"})
    public static final class Function
    extends FunctionTypeKind {
        @NotNull
        public static final Function INSTANCE = new Function();

        private Function() {
            super(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, "Function", false, null);
        }

        @Override
        @NotNull
        public FunctionTypeKind reflectKind() {
            return KFunction.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0001H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind$KFunction;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "<init>", "()V", "nonReflectKind", "compiler.common"})
    public static final class KFunction
    extends FunctionTypeKind {
        @NotNull
        public static final KFunction INSTANCE = new KFunction();

        private KFunction() {
            super(StandardNames.KOTLIN_REFLECT_FQ_NAME, "KFunction", true, null);
        }

        @Override
        @NotNull
        public FunctionTypeKind nonReflectKind() {
            return Function.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0001H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind$KSuspendFunction;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "<init>", "()V", "nonReflectKind", "compiler.common"})
    public static final class KSuspendFunction
    extends FunctionTypeKind {
        @NotNull
        public static final KSuspendFunction INSTANCE = new KSuspendFunction();

        private KSuspendFunction() {
            super(StandardNames.KOTLIN_REFLECT_FQ_NAME, "KSuspendFunction", true, null);
        }

        @Override
        @NotNull
        public FunctionTypeKind nonReflectKind() {
            return SuspendFunction.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0001H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind$SuspendFunction;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "<init>", "()V", "prefixForTypeRender", "", "getPrefixForTypeRender", "()Ljava/lang/String;", "reflectKind", "compiler.common"})
    public static final class SuspendFunction
    extends FunctionTypeKind {
        @NotNull
        public static final SuspendFunction INSTANCE = new SuspendFunction();

        private SuspendFunction() {
            super(StandardNames.COROUTINES_PACKAGE_FQ_NAME, "SuspendFunction", false, null);
        }

        @Override
        @NotNull
        public String getPrefixForTypeRender() {
            return "suspend";
        }

        @Override
        @NotNull
        public FunctionTypeKind reflectKind() {
            return KSuspendFunction.INSTANCE;
        }
    }
}

