/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.ir.declarations.DescriptorMetadataSource;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u0007*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ProcessOptionalAnnotations;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "registerOptionalAnnotations", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nProcessOptionalAnnotations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessOptionalAnnotations.kt\norg/jetbrains/kotlin/backend/jvm/lower/ProcessOptionalAnnotations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1855#2,2:43\n*S KotlinDebug\n*F\n+ 1 ProcessOptionalAnnotations.kt\norg/jetbrains/kotlin/backend/jvm/lower/ProcessOptionalAnnotations\n*L\n37#1:43,2\n*E\n"})
public final class ProcessOptionalAnnotations
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public ProcessOptionalAnnotations(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        for (IrDeclaration declaration : irFile.getDeclarations()) {
            if (!(declaration instanceof IrClass) || !JvmIrUtilsKt.isOptionalAnnotationClass((IrClass)declaration)) continue;
            this.registerOptionalAnnotations((IrClass)declaration);
        }
    }

    private final void registerOptionalAnnotations(IrClass $this$registerOptionalAnnotations) {
        MetadataSource metadataSource = $this$registerOptionalAnnotations.getMetadata();
        Object object = metadataSource instanceof DescriptorMetadataSource.Class ? (DescriptorMetadataSource.Class)metadataSource : null;
        if (object == null || (object = ((DescriptorMetadataSource.Class)object).getDescriptor()) == null) {
            return;
        }
        Object metadataSource2 = object;
        if (!OptionalAnnotationUtil.shouldGenerateExpectClass((ClassDescriptor)metadataSource2)) {
            return;
        }
        ((Collection)this.context.getState().getFactory().getPackagePartRegistry().getOptionalAnnotations()).add(metadataSource2);
        Iterable $this$forEach$iv = $this$registerOptionalAnnotations.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof IrClass) || !JvmIrUtilsKt.isOptionalAnnotationClass((IrClass)it)) continue;
            this.registerOptionalAnnotations((IrClass)it);
        }
    }
}

