/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureFactory;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0016\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\bH\u0014J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010 \u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J$\u0010!\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\u0018J\u0018\u0010#\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0016\u0010$\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010%\u001a\u00020\tR \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "", "globalTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;)V", "table", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getTable", "()Ljava/util/HashMap;", "globalDeclarationTable", "getGlobalDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "signaturer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;", "getSignaturer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;", "inFile", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "block", "Lkotlin/Function0;", "isLocalDeclaration", "", "compatibleMode", "isExportedDeclaration", "declaration", "tryComputeBackendSpecificSignature", "allocateIndexedSignature", "computeSignatureByDeclaration", "privateDeclarationSignature", "builder", "signatureByDeclaration", "assumeDeclarationSignature", "signature", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nDeclarationTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/DeclarationTable\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n372#2,7:105\n372#2,7:113\n1#3:112\n*S KotlinDebug\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/DeclarationTable\n*L\n76#1:105,7\n88#1:113,7\n*E\n"})
public class DeclarationTable {
    @NotNull
    private final HashMap<IrDeclaration, IdSignature> table;
    @NotNull
    private final GlobalDeclarationTable globalDeclarationTable;
    @NotNull
    private final IdSignatureFactory signaturer;

    public DeclarationTable(@NotNull GlobalDeclarationTable globalTable) {
        Intrinsics.checkNotNullParameter((Object)globalTable, (String)"globalTable");
        this.table = new HashMap();
        this.globalDeclarationTable = globalTable;
        this.signaturer = new IdSignatureFactory(globalTable.getPublicIdSignatureComputer(), this);
    }

    @NotNull
    protected final HashMap<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    @NotNull
    protected GlobalDeclarationTable getGlobalDeclarationTable() {
        return this.globalDeclarationTable;
    }

    @NotNull
    public IdSignatureFactory getSignaturer() {
        return this.signaturer;
    }

    public final void inFile(@Nullable IrFile file2, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        IrFile irFile = file2;
        this.getSignaturer().inFile(irFile != null ? irFile.getSymbol() : null, block);
    }

    private final boolean isLocalDeclaration(IrDeclaration $this$isLocalDeclaration, boolean compatibleMode) {
        return !this.isExportedDeclaration($this$isLocalDeclaration, compatibleMode);
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.getGlobalDeclarationTable().isExportedDeclaration(declaration, compatibleMode);
    }

    @Nullable
    protected IdSignature tryComputeBackendSpecificSignature(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return null;
    }

    private final IdSignature allocateIndexedSignature(IrDeclaration declaration, boolean compatibleMode) {
        Object object;
        Map $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature answer$iv = this.getSignaturer().composeFileLocalIdSignature(declaration, compatibleMode);
            $this$getOrPut$iv.put(declaration, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IdSignature)object;
    }

    private final IdSignature computeSignatureByDeclaration(IrDeclaration declaration, boolean compatibleMode) {
        IdSignature idSignature = this.tryComputeBackendSpecificSignature(declaration);
        if (idSignature != null) {
            IdSignature it = idSignature;
            boolean bl = false;
            return it;
        }
        return this.isLocalDeclaration(declaration, compatibleMode) ? this.allocateIndexedSignature(declaration, compatibleMode) : this.getGlobalDeclarationTable().computeSignatureByDeclaration(declaration, compatibleMode);
    }

    @NotNull
    public final IdSignature privateDeclarationSignature(@NotNull IrDeclaration declaration, boolean compatibleMode, @NotNull Function0<? extends IdSignature> builder2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(builder2, (String)"builder");
        boolean bl = this.isLocalDeclaration(declaration, compatibleMode);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Map $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            boolean bl2 = false;
            IdSignature answer$iv = (IdSignature)builder2.invoke();
            $this$getOrPut$iv.put(declaration, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IdSignature)object;
    }

    @NotNull
    public IdSignature signatureByDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.computeSignatureByDeclaration(declaration, compatibleMode);
    }

    public final void assumeDeclarationSignature(@NotNull IrDeclaration declaration, @NotNull IdSignature signature2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        boolean bl2 = bl = this.table.get(declaration) == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Declaration table already has signature for " + RenderIrElementKt.render$default(declaration, null, 1, null);
            throw new AssertionError((Object)string2);
        }
        this.table.put(declaration, signature2);
    }
}

