/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.phaser.AbstractNamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfigurationService;
import org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import org.jetbrains.kotlin.backend.common.phaser.SameTypeCompilerPhase;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u0003*\u0004\b\u0002\u0010\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005B+\u0012\"\u0010\u0006\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00050\u0007\u00a2\u0006\u0004\b\t\u0010\nJ3\u0010\r\u001a\u00028\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0014J0\u0010\u0015\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0017\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00180\u00160\u00072\u0006\u0010\u0019\u001a\u00020\u0017H\u0016R-\u0010\u0006\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR4\u0010\u001a\u001a\"\u0012\u001e\u0012\u001c\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u001e0\u001dj\n\u0012\u0006\u0012\u0004\u0018\u00010\b`\u001c0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/common/phaser/CompositePhase;", "Context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Input", "Output", "Lorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;", "phases", "", "", "<init>", "(Ljava/util/List;)V", "getPhases", "()Ljava/util/List;", "invoke", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;", "phaserState", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;", "context", "input", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Ljava/lang/Object;)Ljava/lang/Object;", "getNamedSubphases", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/backend/common/phaser/AbstractNamedCompilerPhase;", "startDepth", "stickyPostconditions", "", "Lorg/jetbrains/kotlin/backend/common/phaser/Checker;", "Lkotlin/Function1;", "", "getStickyPostconditions", "()Ljava/util/Set;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nPhaseBuilders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhaseBuilders.kt\norg/jetbrains/kotlin/backend/common/phaser/CompositePhase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1360#2:162\n1446#2,5:163\n*S KotlinDebug\n*F\n+ 1 PhaseBuilders.kt\norg/jetbrains/kotlin/backend/common/phaser/CompositePhase\n*L\n37#1:162\n37#1:163,5\n*E\n"})
final class CompositePhase<Context extends CommonBackendContext, Input, Output>
implements CompilerPhase<Context, Input, Output> {
    @NotNull
    private final List<CompilerPhase<Context, Object, Object>> phases;

    public CompositePhase(@NotNull List<? extends CompilerPhase<? super Context, Object, Object>> phases) {
        Intrinsics.checkNotNullParameter(phases, (String)"phases");
        this.phases = phases;
    }

    @NotNull
    public final List<CompilerPhase<Context, Object, Object>> getPhases() {
        return this.phases;
    }

    @Override
    public Output invoke(@NotNull PhaseConfigurationService phaseConfig, @NotNull PhaserState<Input> phaserState, @NotNull Context context2, Input input) {
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter(phaserState, (String)"phaserState");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        PhaserState<Object> currentState = phaserState;
        Object result2 = ((CompilerPhase)CollectionsKt.first(this.phases)).invoke(phaseConfig, currentState, (LoggingContext)context2, input);
        for (Pair pair : CollectionsKt.zip((Iterable)this.phases, (Iterable)CollectionsKt.drop((Iterable)this.phases, (int)1))) {
            CompilerPhase previous = (CompilerPhase)pair.component1();
            CompilerPhase next = (CompilerPhase)pair.component2();
            if (!(next instanceof SameTypeCompilerPhase)) {
                currentState = CompilerPhaseKt.changePhaserStateType(currentState);
            }
            currentState.getStickyPostconditions().addAll(previous.getStickyPostconditions());
            result2 = next.invoke(phaseConfig, currentState, (LoggingContext)context2, result2);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<Integer, AbstractNamedCompilerPhase<Context, ?, ?>>> getNamedSubphases(int startDepth) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.phases;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CompilerPhase it = (CompilerPhase)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getNamedSubphases(startDepth);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Set<Function1<Object, Unit>> getStickyPostconditions() {
        return ((CompilerPhase)CollectionsKt.last(this.phases)).getStickyPostconditions();
    }
}

