/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.reader;

import java.io.IOException;
import java.time.Instant;
import java.util.ListIterator;
import org.jetbrains.kotlin.org.jline.reader.LineReader;

public interface History
extends Iterable<Entry> {
    public void attach(LineReader var1);

    public void load() throws IOException;

    public void save() throws IOException;

    public void purge() throws IOException;

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public int index();

    public int first();

    public int last();

    public String get(int var1);

    default public void add(String line) {
        this.add(Instant.now(), line);
    }

    public void add(Instant var1, String var2);

    public ListIterator<Entry> iterator(int var1);

    @Override
    default public ListIterator<Entry> iterator() {
        return this.iterator(this.first());
    }

    public String current();

    public boolean previous();

    public boolean next();

    public boolean moveToFirst();

    public boolean moveToLast();

    public boolean moveTo(int var1);

    public void moveToEnd();

    public static interface Entry {
        public int index();

        public Instant time();

        public String line();
    }
}

