/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.metrics;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;
import org.jetbrains.kotlin.build.report.metrics.ValueType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Ljava/io/Serializable;", "()V", "myBuildAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttributes;", "myBuildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetrics;", "myBuildTimeStartNs", "Ljava/util/EnumMap;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;", "", "myBuildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimes;", "addAttribute", "", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "addMetric", "metric", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "value", "addMetrics", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addTimeMetric", "addTimeMetricNs", "time", "durationNs", "endMeasure", "getMetrics", "startMeasure", "kotlin-build-common"})
public final class BuildMetricsReporterImpl
implements Serializable,
BuildMetricsReporter {
    @NotNull
    private final EnumMap<BuildTime, Long> myBuildTimeStartNs = new EnumMap(BuildTime.class);
    @NotNull
    private final BuildTimes myBuildTimes = new BuildTimes();
    @NotNull
    private final BuildPerformanceMetrics myBuildMetrics = new BuildPerformanceMetrics();
    @NotNull
    private final BuildAttributes myBuildAttributes = new BuildAttributes();

    @Override
    public void startMeasure(@NotNull BuildTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        if (((Map)this.myBuildTimeStartNs).containsKey(time)) {
            throw new IllegalStateException((time + " was restarted before it finished").toString());
        }
        ((Map)this.myBuildTimeStartNs).put(time, System.nanoTime());
    }

    @Override
    public void endMeasure(@NotNull BuildTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Long l = this.myBuildTimeStartNs.remove(time);
        if (l == null) {
            throw new IllegalStateException((time + " finished before it started").toString());
        }
        long startNs = ((Number)l).longValue();
        long durationNs = System.nanoTime() - startNs;
        this.myBuildTimes.addTimeNs(time, durationNs);
    }

    @Override
    public void addTimeMetricNs(@NotNull BuildTime time, long durationNs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.myBuildTimes.addTimeNs(time, durationNs);
    }

    @Override
    public void addMetric(@NotNull BuildPerformanceMetric metric, long value2) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.myBuildMetrics.add(metric, value2);
    }

    @Override
    public void addTimeMetric(@NotNull BuildPerformanceMetric metric) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        switch (WhenMappings.$EnumSwitchMapping$0[metric.getType().ordinal()]) {
            case 1: {
                this.myBuildMetrics.add(metric, System.nanoTime());
                break;
            }
            case 2: {
                this.myBuildMetrics.add(metric, System.currentTimeMillis());
                break;
            }
            default: {
                throw new IllegalStateException(("Unable to add time metric for '" + (Object)((Object)metric.getType()) + "' type").toString());
            }
        }
    }

    @Override
    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        BuildAttributes.add$default(this.myBuildAttributes, attribute, 0, 2, null);
    }

    @Override
    @NotNull
    public BuildMetrics getMetrics() {
        return new BuildMetrics(this.myBuildTimes, this.myBuildMetrics, this.myBuildAttributes);
    }

    @Override
    public void addMetrics(@NotNull BuildMetrics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this.myBuildAttributes.addAll(metrics.getBuildAttributes());
        this.myBuildTimes.addAll(metrics.getBuildTimes());
        this.myBuildMetrics.addAll(metrics.getBuildPerformanceMetrics());
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.NANOSECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.MILLISECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

