/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.concurrency;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;

public final class AtomicFieldUpdater<ContainingClass, FieldType> {
    private static final Object unsafe;
    private static final MethodHandle compareAndSwapIntHandle;
    private static final MethodHandle compareAndSwapLongHandle;
    private static final MethodHandle compareAndSwapObjectHandle;
    private static final MethodHandle putObjectVolatileHandle;
    private static final MethodHandle getObjectVolatileHandle;
    private final long offset;

    @NotNull
    public static Object getUnsafe() {
        Object object = unsafe;
        if (object == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(0);
        }
        return object;
    }

    @NotNull
    public static <T, V> AtomicFieldUpdater<T, V> forFieldOfType(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(1);
        }
        if (fieldType == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(2);
        }
        return new AtomicFieldUpdater<T, V>(ownerClass, fieldType);
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Long> forLongFieldIn(@NotNull Class<T> ownerClass) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(3);
        }
        return new AtomicFieldUpdater<T, Long>(ownerClass, Long.TYPE);
    }

    private AtomicFieldUpdater(@NotNull Class<ContainingClass> ownerClass, @NotNull Class<FieldType> fieldType) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(6);
        }
        if (fieldType == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(7);
        }
        this(ReflectionUtil.getTheOnlyVolatileInstanceFieldOfClass(ownerClass, fieldType));
    }

    private AtomicFieldUpdater(@NotNull Field field2) {
        if (field2 == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(8);
        }
        field2.setAccessible(true);
        if (!Modifier.isVolatile(field2.getModifiers()) || Modifier.isStatic(field2.getModifiers())) {
            throw new IllegalArgumentException(field2 + " must be volatile instance");
        }
        try {
            MethodHandle objectFieldOffset = MethodHandles.publicLookup().findVirtual(unsafe.getClass(), "objectFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
            this.offset = objectFieldOffset.invoke(unsafe, field2);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public boolean compareAndSet(@NotNull ContainingClass owner, FieldType expected, FieldType newValue2) {
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(9);
        }
        try {
            return compareAndSwapObjectHandle.invokeExact(owner, this.offset, expected, newValue2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean compareAndSetLong(@NotNull ContainingClass owner, long expected, long l) {
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(10);
        }
        try {
            void newValue2;
            return compareAndSwapLongHandle.invokeExact(owner, this.offset, expected, (long)newValue2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static {
        Class<?> unsafeClass;
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        unsafe = ReflectionUtil.getStaticFieldValue(unsafeClass, unsafeClass, "theUnsafe");
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the Unsafe class");
        }
        MethodHandles.Lookup lookup2 = MethodHandles.publicLookup();
        try {
            compareAndSwapIntHandle = lookup2.findVirtual(unsafeClass, "compareAndSwapInt", MethodType.methodType(Boolean.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE)).bindTo(unsafe);
            compareAndSwapLongHandle = lookup2.findVirtual(unsafeClass, "compareAndSwapLong", MethodType.methodType(Boolean.TYPE, Object.class, Long.TYPE, Long.TYPE, Long.TYPE)).bindTo(unsafe);
            compareAndSwapObjectHandle = lookup2.findVirtual(unsafeClass, "compareAndSwapObject", MethodType.methodType(Boolean.TYPE, Object.class, Long.TYPE, Object.class, Object.class)).bindTo(unsafe);
            putObjectVolatileHandle = lookup2.findVirtual(unsafeClass, "putObjectVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Object.class)).bindTo(unsafe);
            getObjectVolatileHandle = lookup2.findVirtual(unsafeClass, "getObjectVolatile", MethodType.methodType(Object.class, Object.class, Long.TYPE)).bindTo(unsafe);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/concurrency/AtomicFieldUpdater";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsafe";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/concurrency/AtomicFieldUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forFieldOfType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forLongFieldIn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forIntFieldIn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forField";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSet";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetLong";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetInt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

