/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JdkClassesKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.JvmRecordApplicabilityCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmRecordApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class JvmRecordApplicabilityChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    public JvmRecordApplicabilityChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        this.jvmTarget = jvmTarget;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Object parameters2;
        Iterator<Object> modifierOrName;
        KtElementImplStub reportOn;
        Object element$iv2;
        block27: {
            PsiElement psiElement;
            block29: {
                block28: {
                    Object v2;
                    block26: {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        if (!(descriptor2 instanceof ClassDescriptor) || !(declaration instanceof KtClassOrObject)) {
                            return;
                        }
                        for (KtSuperTypeListEntry supertypeEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
                            KotlinType supertype2 = (KotlinType)context.getTrace().get(BindingContext.TYPE, supertypeEntry.getTypeReference());
                            Object object = supertype2;
                            if (!Intrinsics.areEqual(object != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object) : null, (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
                            context.getTrace().report(ErrorsJvm.ILLEGAL_JAVA_LANG_RECORD_SUPERTYPE.on(supertypeEntry));
                            return;
                        }
                        if (!JvmAnnotationUtilKt.isJvmRecord((ClassDescriptor)descriptor2)) {
                            return;
                        }
                        List<KtAnnotationEntry> list2 = ((KtClassOrObject)declaration).getAnnotationEntries();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"declaration.annotationEntries");
                        Iterable $this$firstOrNull$iv = list2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv2 : $this$firstOrNull$iv) {
                            KtAnnotationEntry it = (KtAnnotationEntry)element$iv2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getShortName(), (Object)JvmNames.JVM_RECORD_ANNOTATION_FQ_NAME.shortName())) continue;
                            v2 = element$iv2;
                            break block26;
                        }
                        v2 = null;
                    }
                    KtAnnotationEntry ktAnnotationEntry = v2;
                    KtElementImplStub ktElementImplStub = reportOn = ktAnnotationEntry != null ? (KtElementImplStub)ktAnnotationEntry : (KtElementImplStub)((Object)declaration);
                    if (DescriptorUtilsKt.resolveTopLevelClass(context.getModuleDescriptor(), JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME(), NoLookupLocation.FOR_DEFAULT_IMPORTS) == null) {
                        context.getTrace().report(ErrorsJvm.JVM_RECORD_REQUIRES_JDK15.on(reportOn));
                        return;
                    }
                    if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmRecordSupport)) {
                        context.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.JvmRecordSupport), (Object)context.getLanguageVersionSettings())));
                        return;
                    }
                    if (!JvmRecordApplicabilityCheckerKt.access$areRecordsAllowed(this.jvmTarget, context.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getEnableJvmPreview()))) {
                        context.getTrace().report(ErrorsJvm.JVM_RECORDS_ILLEGAL_BYTECODE_TARGET.on(reportOn));
                        return;
                    }
                    if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_CLASS) {
                        PsiElement psiElement2 = ((KtClassOrObject)declaration).getModifierList();
                        if ((psiElement2 == null || (psiElement2 = psiElement2.getModifier(KtTokens.ENUM_KEYWORD)) == null) && (psiElement2 = ((KtClassOrObject)declaration).getNameIdentifier()) == null) {
                            psiElement2 = declaration;
                        }
                        modifierOrName = psiElement2;
                        context.getTrace().report(ErrorsJvm.ENUM_JVM_RECORD.on((PsiElement)((Object)modifierOrName)));
                        return;
                    }
                    if (ModalityUtilsKt.isFinalClass((ClassDescriptor)descriptor2)) break block27;
                    psiElement = ((KtClassOrObject)declaration).getModifierList();
                    if (psiElement == null) break block28;
                    KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[3];
                    Intrinsics.checkNotNullExpressionValue((Object)KtTokens.ABSTRACT_KEYWORD, (String)"ABSTRACT_KEYWORD");
                    Intrinsics.checkNotNullExpressionValue((Object)KtTokens.OPEN_KEYWORD, (String)"OPEN_KEYWORD");
                    Intrinsics.checkNotNullExpressionValue((Object)KtTokens.SEALED_KEYWORD, (String)"SEALED_KEYWORD");
                    if ((psiElement = JvmRecordApplicabilityCheckerKt.access$findOneOfModifiers(psiElement, ktModifierKeywordTokenArray)) != null) break block29;
                }
                if ((psiElement = ((KtClassOrObject)declaration).getNameIdentifier()) == null) {
                    psiElement = declaration;
                }
            }
            modifierOrName = psiElement;
            context.getTrace().report(ErrorsJvm.NON_FINAL_JVM_RECORD.on((PsiElement)((Object)modifierOrName)));
            return;
        }
        if (((ClassDescriptor)descriptor2).isInner()) {
            PsiElement psiElement = ((KtClassOrObject)declaration).getModifierList();
            if ((psiElement == null || (psiElement = psiElement.getModifier(KtTokens.INNER_KEYWORD)) == null) && (psiElement = ((KtClassOrObject)declaration).getNameIdentifier()) == null) {
                psiElement = declaration;
            }
            modifierOrName = psiElement;
            context.getTrace().report(ErrorsJvm.INNER_JVM_RECORD.on((PsiElement)((Object)modifierOrName)));
            return;
        }
        if (DescriptorUtils.isLocal(descriptor2)) {
            context.getTrace().report(ErrorsJvm.LOCAL_JVM_RECORD.on(reportOn));
            return;
        }
        for (KtDeclaration member2 : ((KtClassOrObject)declaration).getDeclarations()) {
            PropertyDescriptor propertyDescriptor;
            if (!(member2 instanceof KtProperty) || ((element$iv2 = context.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, member2)) instanceof PropertyDescriptor ? (PropertyDescriptor)element$iv2 : null) == null) continue;
            propertyDescriptor = propertyDescriptor;
            if (!Intrinsics.areEqual(context.getTrace().getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor), (Object)true) && ((KtProperty)member2).getDelegate() == null) continue;
            context.getTrace().report(ErrorsJvm.FIELD_IN_JVM_RECORD.on(member2));
            return;
        }
        for (KtSuperTypeListEntry superTypeEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            if (!(superTypeEntry instanceof KtDelegatedSuperTypeEntry)) continue;
            context.getTrace().report(ErrorsJvm.DELEGATION_BY_IN_JVM_RECORD.on(superTypeEntry));
            return;
        }
        for (KotlinType supertype2 : ((ClassDescriptor)descriptor2).getTypeConstructor().getSupertypes()) {
            ClassDescriptor classDescriptor2;
            element$iv2 = supertype2.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor3 = element$iv2 instanceof ClassDescriptor ? (ClassDescriptor)element$iv2 : null;
            if (classDescriptor3 == null || (classDescriptor2 = classDescriptor3).getKind() == ClassKind.INTERFACE || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor2), (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
            PsiElement psiElement = ((KtClassOrObject)declaration).getNameIdentifier();
            if (psiElement == null) {
                psiElement = declaration;
            }
            PsiElement reportSupertypeOn = psiElement;
            context.getTrace().report(ErrorsJvm.JVM_RECORD_EXTENDS_CLASS.on(reportSupertypeOn, supertype2));
            return;
        }
        if (!((ClassDescriptor)descriptor2).isData()) {
            context.getTrace().report(ErrorsJvm.NON_DATA_CLASS_JVM_RECORD.on(reportOn));
            return;
        }
        KtPrimaryConstructor primaryConstructor2 = ((KtClassOrObject)declaration).getPrimaryConstructor();
        Object object = primaryConstructor2;
        if (object == null || (object = ((KtConstructor)object).getValueParameters()) == null) {
            object = CollectionsKt.emptyList();
        }
        if ((parameters2 = object).isEmpty()) {
            PsiElement psiElement;
            KtElementImplStub ktElementImplStub = primaryConstructor2;
            PsiElement psiElement3 = ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getValueParameterList()) != null ? (PsiElement)ktElementImplStub : (psiElement = ((KtClassOrObject)declaration).getNameIdentifier());
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                context.getTrace().report(ErrorsJvm.JVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS.on(it));
                return;
            }
        }
        Iterator iterator2 = parameters2.iterator();
        while (iterator2.hasNext()) {
            KtParameter parameter = (KtParameter)iterator2.next();
            if (parameter.hasValOrVar() && !parameter.isMutable()) continue;
            context.getTrace().report(ErrorsJvm.JVM_RECORD_NOT_VAL_PARAMETER.on(parameter));
            return;
        }
        for (KtParameter parameter : CollectionsKt.dropLast((List)parameters2, (int)1)) {
            if (!parameter.isVarArg()) continue;
            context.getTrace().report(ErrorsJvm.JVM_RECORD_NOT_LAST_VARARG_PARAMETER.on(parameter));
            return;
        }
    }
}

