/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.builder.FirErrorImportBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirResolvedImportBuilder;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeImportFromSingleton;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirImportResolveTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ)\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u001cH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "currentFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "isAcceptable", "", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "file", "transformImport", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "import", "transformImportForFqName", "fqName", "delegate", "resolve"})
public class FirImportResolveTransformer
extends FirAbstractTreeTransformer<Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @Nullable
    private FirFile currentFile;

    protected FirImportResolveTransformer(@NotNull FirSession session2, @NotNull FirResolvePhase phase) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        super(phase);
        this.session = session2;
        this.symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.session);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    public FirImportResolveTransformer(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this(session2, FirResolvePhase.IMPORTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.checkSessionConsistency(file2);
        FirFile it = firFile = file2;
        boolean bl = false;
        FirFile prevValue = this.currentFile;
        this.currentFile = file2;
        try {
            it.transformChildren(this, null);
        }
        finally {
            this.currentFile = prevValue;
        }
        return firFile;
    }

    @Override
    @NotNull
    public FirImport transformImport(@NotNull FirImport firImport, @Nullable Object data) {
        FqName parentFqName;
        block9: {
            Object it;
            FqName fqName2;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)firImport, (String)"import");
                    fqName2 = firImport.getImportedFqName();
                    if (fqName2 == null) break block7;
                    FqName fqName3 = fqName2;
                    it = fqName3;
                    boolean bl = false;
                    fqName2 = !((FqName)it).isRoot() ? fqName3 : null;
                    if (fqName2 != null) break block8;
                }
                return firImport;
            }
            FqName fqName4 = fqName2;
            if (!this.isAcceptable(fqName4)) {
                return firImport;
            }
            if (firImport.isAllUnder()) {
                return this.transformImportForFqName(fqName4, firImport);
            }
            FqName fqName5 = fqName4.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName5, (String)"fqName.parent()");
            parentFqName = fqName5;
            FirFile firFile = this.currentFile;
            if (firFile == null) break block9;
            it = firFile;
            boolean bl = false;
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
            if (firLookupTrackerComponent != null) {
                Name name = fqName4.shortName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"fqName.shortName()");
                String string2 = parentFqName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parentFqName.asString()");
                firLookupTrackerComponent.recordLookup(name, string2, firImport.getSource(), ((FirFile)it).getSource());
            }
        }
        return this.transformImportForFqName(parentFqName, firImport);
    }

    protected boolean isAcceptable(@NotNull FqName $this$isAcceptable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAcceptable, (String)"<this>");
        return true;
    }

    private final FirImport transformImportForFqName(FqName fqName2, FirImport delegate2) {
        FirResolvedImportBuilder firResolvedImportBuilder;
        FirRegularClass firClass;
        FirClassLikeSymbol<?> classSymbol;
        PackageResolutionResult result2 = FirImportResolveTransformerKt.resolveToPackageOrClass(this.symbolProvider, fqName2);
        if (result2 instanceof PackageResolutionResult.Error) {
            FirErrorImportBuilder firErrorImportBuilder;
            boolean $i$f$buildErrorImport = false;
            FirErrorImportBuilder $this$transformImportForFqName_u24lambda_u243 = firErrorImportBuilder = new FirErrorImportBuilder();
            boolean bl = false;
            $this$transformImportForFqName_u24lambda_u243.setDelegate(delegate2);
            $this$transformImportForFqName_u24lambda_u243.setDiagnostic(((PackageResolutionResult.Error)result2).getDiagnostic());
            return firErrorImportBuilder.build();
        }
        if (!(result2 instanceof PackageResolutionResult.PackageOrClass)) {
            throw new NoWhenBranchMatchedException();
        }
        PackageResolutionResult.PackageOrClass packageOrClass = (PackageResolutionResult.PackageOrClass)result2;
        FqName packageFqName = packageOrClass.component1();
        FqName relativeClassFqName = packageOrClass.component2();
        FirClassLikeSymbol<?> firClassLikeSymbol = classSymbol = packageOrClass.component3();
        FirClassLikeDeclaration bl = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirRegularClass firRegularClass = firClass = bl instanceof FirRegularClass ? (FirRegularClass)bl : null;
        if (delegate2.isAllUnder()) {
            Object object = firClass;
            boolean bl2 = object != null && (object = ((FirRegularClass)object).getClassKind()) != null ? ((ClassKind)((Object)object)).isSingleton() : false;
            if (bl2) {
                FirErrorImportBuilder firErrorImportBuilder;
                boolean $i$f$buildErrorImport = false;
                FirErrorImportBuilder $this$transformImportForFqName_u24lambda_u244 = firErrorImportBuilder = new FirErrorImportBuilder();
                boolean bl3 = false;
                $this$transformImportForFqName_u24lambda_u244.setDelegate(delegate2);
                $this$transformImportForFqName_u24lambda_u244.setDiagnostic(new ConeImportFromSingleton(firClass.getName()));
                return firErrorImportBuilder.build();
            }
        }
        boolean $i$f$buildResolvedImport = false;
        FirResolvedImportBuilder $this$transformImportForFqName_u24lambda_u245 = firResolvedImportBuilder = new FirResolvedImportBuilder();
        boolean bl4 = false;
        $this$transformImportForFqName_u24lambda_u245.setDelegate(delegate2);
        $this$transformImportForFqName_u24lambda_u245.setPackageFqName(packageFqName);
        $this$transformImportForFqName_u24lambda_u245.setRelativeParentClassName(relativeClassFqName);
        return firResolvedImportBuilder.build();
    }
}

