/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration.FirJvmInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J6\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00102\u0014\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e0\u000bH\u0014J \u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0010H\u0014R\u0089\u0001\u0010\u0003\u001aw\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmInlineDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker;", "()V", "inlineVisitor", "Lkotlin/reflect/KFunction5;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lkotlin/ParameterName;", "name", "inlineFunction", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "inlineFunEffectiveVisibility", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "inalienableParameters", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmInlineDeclarationChecker$InlineVisitor;", "getInlineVisitor", "()Lkotlin/reflect/KFunction;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkFunctionalParametersWithInheritedDefaultValues", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "overriddenSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkSuspendFunctionalParameterWithDefaultValue", "param", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "InlineVisitor", "checkers.jvm"})
public final class FirJvmInlineDeclarationChecker
extends FirInlineDeclarationChecker {
    @NotNull
    public static final FirJvmInlineDeclarationChecker INSTANCE = new FirJvmInlineDeclarationChecker();

    private FirJvmInlineDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        CheckerContext ctx;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isInline$iv = declaration;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getStatus().isInline()) {
            this.checkParametersInNotInline(declaration, context, reporter);
            return;
        }
        if (DeclarationUtilsKt.isLocalMember(declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Local inline functions", (DiagnosticContext)context, null, 16, null);
            return;
        }
        if (!(declaration instanceof FirPropertyAccessor) && !(declaration instanceof FirSimpleFunction)) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        Object effectiveVisibility = object;
        boolean $i$f$withSuppressedDiagnostics = false;
        List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(declaration);
        if (arguments$iv != null) {
            DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            if (diagnosticContext == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
            }
            ctx = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
            boolean bl = false;
            INSTANCE.checkInlineFunctionBody(declaration, (EffectiveVisibility)effectiveVisibility, ctx, reporter);
            INSTANCE.checkCallableDeclaration(declaration, ctx, reporter);
        } else {
            ctx = (CheckerContext)((MutableDiagnosticContext)context);
            boolean bl = false;
            INSTANCE.checkInlineFunctionBody(declaration, (EffectiveVisibility)effectiveVisibility, ctx, reporter);
            INSTANCE.checkCallableDeclaration(declaration, ctx, reporter);
        }
    }

    @NotNull
    public KFunction<InlineVisitor> getInlineVisitor() {
        return (KFunction)inlineVisitor.1.INSTANCE;
    }

    @Override
    protected void checkSuspendFunctionalParameterWithDefaultValue(@NotNull FirValueParameter param, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Suspend functional parameters with default values", (DiagnosticContext)context, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void checkFunctionalParametersWithInheritedDefaultValues(@NotNull FirSimpleFunction function2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull List<? extends FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(overriddenSymbols2, (String)"overriddenSymbols");
        Iterable $this$flatMap$iv = overriddenSymbols2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof FirFunctionSymbol)) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$mapIndexedNotNullTo$iv$iv;
                Iterable $this$mapIndexedNotNull$iv = ((FirFunctionSymbol)it).getValueParameterSymbols();
                boolean $i$f$mapIndexedNotNull = false;
                Iterable iterable2 = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    Integer it$iv$iv;
                    void param;
                    void element$iv$iv2;
                    int n;
                    if ((n = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl2 = false;
                    FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)element$iv$iv2;
                    int idx = index$iv$iv;
                    boolean bl3 = false;
                    Integer n2 = idx;
                    int it2 = ((Number)n2).intValue();
                    boolean bl4 = false;
                    if ((param.getHasDefaultValue() ? n2 : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set paramsWithDefaults = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEachIndexed$iv = function2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (FirValueParameter)item$iv;
            int idx = n;
            boolean bl = false;
            if (param.getDefaultValue() != null || !paramsWithDefaults.contains(idx)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Functional parameters with inherited default values", (DiagnosticContext)context, null, 16, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmInlineDeclarationChecker$InlineVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$BasicInlineVisitor;", "inlineFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "inalienableParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "visitRegularClass", "", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers.jvm"})
    public static final class InlineVisitor
    extends FirInlineDeclarationChecker.BasicInlineVisitor {
        public InlineVisitor(@NotNull FirFunction inlineFunction2, @NotNull EffectiveVisibility inlineFunEffectiveVisibility, @NotNull List<FirValueParameterSymbol> inalienableParameters, @NotNull FirSession session2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)inlineFunction2, (String)"inlineFunction");
            Intrinsics.checkNotNullParameter((Object)inlineFunEffectiveVisibility, (String)"inlineFunEffectiveVisibility");
            Intrinsics.checkNotNullParameter(inalienableParameters, (String)"inalienableParameters");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            super(inlineFunction2, inlineFunEffectiveVisibility, inalienableParameters, session2, reporter);
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull CheckerContext data) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!regularClass.getClassKind().isSingleton() && CollectionsKt.lastOrNull(data.getContainingDeclarations()) == this.getInlineFunction()) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.getReporter(), (AbstractKtSourceElement)regularClass.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Local classes", (DiagnosticContext)data, null, 16, null);
            } else {
                super.visitRegularClass(regularClass, data);
            }
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull CheckerContext data) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (CollectionsKt.lastOrNull(data.getContainingDeclarations()) == this.getInlineFunction()) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.getReporter(), (AbstractKtSourceElement)simpleFunction.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Local functions", (DiagnosticContext)data, null, 16, null);
            } else {
                super.visitSimpleFunction(simpleFunction, data);
            }
        }
    }
}

