/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAssignmentOperatorStatement;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\nR\u001e\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer;", "", "assignedLocalVariablesByFunction", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$AssignedLocalVariables;", "(Ljava/util/Map;)V", "concurrentLambdaArgsStack", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "concurrentlyAssignedLocalVariablesStack", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "ephemeralConcurrentlyAssignedLocalVariables", "enterFunctionCallWithMultipleLambdaArgs", "", "lambdaArgs", "", "enterLocalFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "exitFunctionCallWithMultipleLambdaArgs", "exitLocalFunction", "finishPostponedAnonymousFunction", "isAccessToUnstableLocalVariable", "", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitPostponedAnonymousFunction", "anonymousFunction", "Companion", "resolve"})
public final class FirLocalVariableAssignmentAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<FirFunctionSymbol<?>, Companion.AssignedLocalVariables> assignedLocalVariablesByFunction;
    @NotNull
    private final List<Set<FirAnonymousFunction>> concurrentLambdaArgsStack;
    @NotNull
    private final List<Set<FirProperty>> concurrentlyAssignedLocalVariablesStack;
    @NotNull
    private final Set<FirProperty> ephemeralConcurrentlyAssignedLocalVariables;

    public FirLocalVariableAssignmentAnalyzer(@NotNull Map<FirFunctionSymbol<?>, Companion.AssignedLocalVariables> assignedLocalVariablesByFunction) {
        Intrinsics.checkNotNullParameter(assignedLocalVariablesByFunction, (String)"assignedLocalVariablesByFunction");
        this.assignedLocalVariablesByFunction = assignedLocalVariablesByFunction;
        this.concurrentLambdaArgsStack = new ArrayList();
        Object[] objectArray = new Set[]{new LinkedHashSet()};
        this.concurrentlyAssignedLocalVariablesStack = CollectionsKt.mutableListOf((Object[])objectArray);
        this.ephemeralConcurrentlyAssignedLocalVariables = new LinkedHashSet();
    }

    public final boolean isAccessToUnstableLocalVariable(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression) {
        Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
        Object object = FirDeclarationUtilKt.getReferredPropertySymbol(qualifiedAccessExpression);
        if (object == null || (object = (FirProperty)((FirBasedSymbol)object).getFir()) == null) {
            return false;
        }
        Object property2 = object;
        return this.ephemeralConcurrentlyAssignedLocalVariables.contains(property2) || ((Set)CollectionsKt.last(this.concurrentlyAssignedLocalVariablesStack)).contains(property2);
    }

    public final void visitPostponedAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)anonymousFunction2, (String)"anonymousFunction");
            Object object = this.assignedLocalVariablesByFunction.get(anonymousFunction2.getSymbol());
            if (object == null || (object = ((Companion.AssignedLocalVariables)object).getInsideLocalFunction()) == null) break block0;
            Object it = object;
            boolean bl = false;
            this.ephemeralConcurrentlyAssignedLocalVariables.addAll((Collection)it);
        }
    }

    public final void finishPostponedAnonymousFunction() {
        this.ephemeralConcurrentlyAssignedLocalVariables.clear();
    }

    public final void enterLocalFunction(@NotNull FirFunction function2) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Set concurrentlyAssignedLocalVariables = CollectionsKt.toMutableSet((Iterable)((Iterable)CollectionsKt.last(this.concurrentlyAssignedLocalVariablesStack)));
        this.concurrentlyAssignedLocalVariablesStack.add(concurrentlyAssignedLocalVariables);
        Set concurrentLambdasInCurrentCall = (Set)CollectionsKt.lastOrNull(this.concurrentLambdaArgsStack);
        if (concurrentLambdasInCurrentCall != null && CollectionsKt.contains((Iterable)concurrentLambdasInCurrentCall, (Object)function2)) {
            for (FirAnonymousFunction otherLambda : concurrentLambdasInCurrentCall) {
                if (Intrinsics.areEqual((Object)otherLambda, (Object)function2) || otherLambda.getInvocationKind() == EventOccurrencesRange.ZERO) continue;
                Object object = this.assignedLocalVariablesByFunction.get(otherLambda.getSymbol());
                if (object != null && (object = ((Companion.AssignedLocalVariables)object).getInsideLocalFunction()) != null) {
                    it = object;
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)concurrentlyAssignedLocalVariables, (Iterable)((Iterable)it));
                }
            }
        }
        FirAnonymousFunction firAnonymousFunction = function2 instanceof FirAnonymousFunction ? (FirAnonymousFunction)function2 : null;
        EventOccurrencesRange eventOccurrencesRange = firAnonymousFunction != null ? firAnonymousFunction.getInvocationKind() : null;
        switch (eventOccurrencesRange == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eventOccurrencesRange.ordinal()]) {
            case 1: 
            case 2: {
                Object object = this.assignedLocalVariablesByFunction.get(((FirAnonymousFunction)function2).getSymbol());
                if (object != null && (object = ((Companion.AssignedLocalVariables)object).getInsideLocalFunction()) != null) {
                    it = object;
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)concurrentlyAssignedLocalVariables, (Iterable)((Iterable)it));
                }
                break;
            }
            case -1: 
            case 3: {
                Object object = this.assignedLocalVariablesByFunction.get(function2.getSymbol());
                if (object != null && (object = ((Companion.AssignedLocalVariables)object).getAll()) != null) {
                    it = object;
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)concurrentlyAssignedLocalVariables, (Iterable)((Iterable)it));
                }
                break;
            }
        }
    }

    public final void exitLocalFunction(@NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        CollectionsKt.removeLast(this.concurrentlyAssignedLocalVariablesStack);
        FirAnonymousFunction firAnonymousFunction = function2 instanceof FirAnonymousFunction ? (FirAnonymousFunction)function2 : null;
        EventOccurrencesRange eventOccurrencesRange = firAnonymousFunction != null ? firAnonymousFunction.getInvocationKind() : null;
        switch (eventOccurrencesRange == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eventOccurrencesRange.ordinal()]) {
            case -1: 
            case 3: {
                Object object = this.assignedLocalVariablesByFunction.get(function2.getSymbol());
                if (object != null && (object = ((Companion.AssignedLocalVariables)object).getInsideLocalFunction()) != null) {
                    Object it = object;
                    boolean bl = false;
                    for (Set<FirProperty> outerScope : this.concurrentlyAssignedLocalVariablesStack) {
                        CollectionsKt.addAll((Collection)outerScope, (Iterable)((Iterable)it));
                    }
                }
                break;
            }
        }
    }

    public final void enterFunctionCallWithMultipleLambdaArgs(@NotNull List<? extends FirAnonymousFunction> lambdaArgs) {
        Intrinsics.checkNotNullParameter(lambdaArgs, (String)"lambdaArgs");
        this.concurrentLambdaArgsStack.add(CollectionsKt.toSet((Iterable)lambdaArgs));
    }

    public final void exitFunctionCallWithMultipleLambdaArgs() {
        CollectionsKt.removeLast(this.concurrentLambdaArgsStack);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion;", "", "()V", "analyzeFunction", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer;", "rootFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "computeAssignedLocalVariables", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$AssignedLocalVariables;", "firFunction", "AssignedLocalVariables", "MiniCfgBuilder", "MiniFlow", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirLocalVariableAssignmentAnalyzer analyzeFunction(@NotNull FirFunction rootFunction) {
            Intrinsics.checkNotNullParameter((Object)rootFunction, (String)"rootFunction");
            return new FirLocalVariableAssignmentAnalyzer(this.computeAssignedLocalVariables(rootFunction));
        }

        private final Map<FirFunctionSymbol<?>, AssignedLocalVariables> computeAssignedLocalVariables(FirFunction firFunction) {
            MiniFlow startFlow = MiniFlow.Companion.start();
            MiniCfgBuilder.MiniCfgData data = new MiniCfgBuilder.MiniCfgData(startFlow);
            new MiniCfgBuilder().visitElement((FirElement)firFunction, data);
            return data.getLocalFunctionToAssignedLocalVariables();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$AssignedLocalVariables;", "", "outsideLocalFunction", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "insideLocalFunction", "(Ljava/util/Set;Ljava/util/Set;)V", "all", "getAll", "()Ljava/util/Set;", "getInsideLocalFunction", "getOutsideLocalFunction", "resolve"})
        public static final class AssignedLocalVariables {
            @NotNull
            private final Set<FirProperty> outsideLocalFunction;
            @NotNull
            private final Set<FirProperty> insideLocalFunction;

            public AssignedLocalVariables(@NotNull Set<? extends FirProperty> outsideLocalFunction, @NotNull Set<? extends FirProperty> insideLocalFunction) {
                Intrinsics.checkNotNullParameter(outsideLocalFunction, (String)"outsideLocalFunction");
                Intrinsics.checkNotNullParameter(insideLocalFunction, (String)"insideLocalFunction");
                this.outsideLocalFunction = outsideLocalFunction;
                this.insideLocalFunction = insideLocalFunction;
            }

            @NotNull
            public final Set<FirProperty> getOutsideLocalFunction() {
                return this.outsideLocalFunction;
            }

            @NotNull
            public final Set<FirProperty> getInsideLocalFunction() {
                return this.insideLocalFunction;
            }

            @NotNull
            public final Set<FirProperty> getAll() {
                return SetsKt.plus(this.outsideLocalFunction, (Iterable)this.insideLocalFunction);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "", "parents", "", "(Ljava/util/Set;)V", "assignedLocalVariables", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getAssignedLocalVariables", "()Ljava/util/Set;", "getParents", "fork", "Companion", "resolve"})
        private static final class MiniFlow {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Set<MiniFlow> parents;
            @NotNull
            private final Set<FirProperty> assignedLocalVariables;

            public MiniFlow(@NotNull Set<MiniFlow> parents2) {
                Intrinsics.checkNotNullParameter(parents2, (String)"parents");
                this.parents = parents2;
                this.assignedLocalVariables = new LinkedHashSet();
            }

            @NotNull
            public final Set<MiniFlow> getParents() {
                return this.parents;
            }

            @NotNull
            public final Set<FirProperty> getAssignedLocalVariables() {
                return this.assignedLocalVariables;
            }

            @NotNull
            public final MiniFlow fork() {
                return new MiniFlow(SetsKt.setOf((Object)this));
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0005\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow$Companion;", "", "()V", "start", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "join", "", "resolve"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final MiniFlow start() {
                    return new MiniFlow(SetsKt.emptySet());
                }

                @NotNull
                public final MiniFlow join(@NotNull Set<MiniFlow> $this$join) {
                    Intrinsics.checkNotNullParameter($this$join, (String)"<this>");
                    return new MiniFlow($this$join);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\"\u0010'\u001a\u00020\u0002*\u00020(2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0*H\u0002J\u001a\u0010'\u001a\u00020\u0002*\u00020(2\u0006\u0010+\u001a\u00020,2\u0006\u0010\b\u001a\u00020\u0003\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "()V", "handleFunctionFork", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "data", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "visitAssignmentOperatorStatement", "assignmentOperatorStatement", "Lorg/jetbrains/kotlin/fir/expressions/FirAssignmentOperatorStatement;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitReturnExpression", "returnExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "visitWhenExpression", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "recordAssignment", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "visited", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "MiniCfgData", "resolve"})
        private static final class MiniCfgBuilder
        extends FirVisitor<Unit, MiniCfgData> {
            @Override
            public void visitElement(@NotNull FirElement element, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                element.acceptChildren(this, data);
            }

            @Override
            public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction2, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)anonymousFunction2, (String)"anonymousFunction");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.handleFunctionFork(anonymousFunction2, data);
            }

            @Override
            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.handleFunctionFork(simpleFunction, data);
            }

            /*
             * WARNING - void declaration
             */
            private final void handleFunctionFork(FirFunction function2, MiniCfgData data) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                MiniFlow miniFlow = data.getFlow();
                if (miniFlow == null) {
                    return;
                }
                MiniFlow currentFlow = miniFlow;
                MiniFlow functionFork = currentFlow.fork();
                data.setFlow(functionFork);
                function2.acceptChildren(this, data);
                Iterable iterable = (Iterable)data.getVariableDeclarations();
                Set<FirProperty> set = functionFork.getAssignedLocalVariables();
                boolean $i$f$flatMap = false;
                void var7_8 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Map it = (Map)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.values();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                set.retainAll((List)destination$iv$iv);
                MiniFlow normalExecution = currentFlow.fork();
                data.getLocalFunctionToAssignedLocalVariables().put(function2.getSymbol(), new AssignedLocalVariables(normalExecution.getAssignedLocalVariables(), functionFork.getAssignedLocalVariables()));
                data.setFlow(normalExecution);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitWhenExpression(@NotNull FirWhenExpression whenExpression, @NotNull MiniCfgData data) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                MiniFlow miniFlow = data.getFlow();
                if (miniFlow == null) {
                    return;
                }
                MiniFlow flow = miniFlow;
                MiniCfgBuilder visitor2 = this;
                FirWhenExpression $this$visitWhenExpression_u24lambda_u242 = whenExpression;
                boolean bl = false;
                $this$visitWhenExpression_u24lambda_u242.getCalleeReference().accept(visitor2, data);
                FirVariable subjectVariable = $this$visitWhenExpression_u24lambda_u242.getSubjectVariable();
                if (subjectVariable != null) {
                    subjectVariable.accept(visitor2, data);
                } else {
                    FirExpression firExpression2 = $this$visitWhenExpression_u24lambda_u242.getSubject();
                    if (firExpression2 != null) {
                        firExpression2.accept(visitor2, data);
                    }
                }
                Iterable $this$mapNotNull$iv = $this$visitWhenExpression_u24lambda_u242.getBranches();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    MiniFlow it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    FirWhenBranch it = (FirWhenBranch)element$iv$iv;
                    boolean bl3 = false;
                    data.setFlow(flow.fork());
                    it.accept(visitor2, data);
                    if (data.getFlow() == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List childFlows = (List)destination$iv$iv;
                data.setFlow(MiniFlow.Companion.join(CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)childFlows, (Object)flow))));
            }

            @Override
            public void visitReturnExpression(@NotNull FirReturnExpression returnExpression, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)returnExpression, (String)"returnExpression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super.visitReturnExpression(returnExpression, data);
                data.setFlow(null);
            }

            @Override
            public void visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull MiniCfgData data) {
                FirExpression it;
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                MiniCfgBuilder visitor2 = this;
                FirFunctionCall $this$visitFunctionCall_u24lambda_u247 = functionCall;
                boolean bl = false;
                FirExpression[] firExpressionArray = new FirExpression[]{$this$visitFunctionCall_u24lambda_u247.getExplicitReceiver(), $this$visitFunctionCall_u24lambda_u247.getDispatchReceiver(), $this$visitFunctionCall_u24lambda_u247.getExtensionReceiver()};
                Iterable $this$forEach$iv = SetsKt.setOfNotNull((Object[])firExpressionArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirExpression it2 = (FirExpression)element$iv;
                    boolean bl2 = false;
                    it2.accept(visitor2, data);
                }
                Iterable $this$partition$iv = $this$visitFunctionCall_u24lambda_u247.getArgumentList().getArguments();
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    it = (FirExpression)element$iv;
                    boolean bl3 = false;
                    if (it instanceof FirAnonymousFunctionExpression) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                firExpressionArray = new Pair(first$iv, second$iv);
                List postponedFunctionArgs = (List)firExpressionArray.component1();
                List normalArgs = (List)firExpressionArray.component2();
                Iterable $this$forEach$iv2 = normalArgs;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl4 = false;
                    it.accept(visitor2, data);
                }
                $this$forEach$iv2 = postponedFunctionArgs;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl5 = false;
                    it.accept(visitor2, data);
                }
                $this$visitFunctionCall_u24lambda_u247.getCalleeReference().accept(visitor2, data);
            }

            @Override
            public void visitBlock(@NotNull FirBlock block, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                data.getVariableDeclarations().addLast((Object)new LinkedHashMap());
                super.visitBlock(block, data);
                data.getVariableDeclarations().removeLast();
            }

            @Override
            public void visitProperty(@NotNull FirProperty property2, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super.visitProperty(property2, data);
                if (property2.isLocal()) {
                    ((Map)data.getVariableDeclarations().last()).put(property2.getName(), property2);
                }
            }

            @Override
            public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super.visitVariableAssignment(variableAssignment, data);
                MiniFlow miniFlow = data.getFlow();
                if (miniFlow == null) {
                    return;
                }
                MiniFlow flow = miniFlow;
                FirReference firReference = variableAssignment.getLValue();
                Object object = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
                if (object == null || (object = ((FirNamedReference)object).getName()) == null) {
                    return;
                }
                Object name = object;
                this.recordAssignment(flow, (Name)name, data);
            }

            @Override
            public void visitAssignmentOperatorStatement(@NotNull FirAssignmentOperatorStatement assignmentOperatorStatement, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)assignmentOperatorStatement, (String)"assignmentOperatorStatement");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super.visitAssignmentOperatorStatement(assignmentOperatorStatement, data);
                MiniFlow miniFlow = data.getFlow();
                if (miniFlow == null) {
                    return;
                }
                MiniFlow flow = miniFlow;
                FirExpression firExpression2 = assignmentOperatorStatement.getLeftArgument();
                FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
                if (firQualifiedAccessExpression == null) {
                    return;
                }
                FirQualifiedAccessExpression lhs = firQualifiedAccessExpression;
                if (lhs.getExplicitReceiver() != null) {
                    return;
                }
                FirReference firReference = lhs.getCalleeReference();
                Object object = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
                if (object == null || (object = ((FirNamedReference)object).getName()) == null) {
                    return;
                }
                Object name = object;
                this.recordAssignment(flow, (Name)name, data);
            }

            public final void recordAssignment(@NotNull MiniFlow $this$recordAssignment, @NotNull Name name, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)$this$recordAssignment, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                FirProperty firProperty = data.resolveLocalVariable(name);
                if (firProperty == null) {
                    return;
                }
                FirProperty property2 = firProperty;
                this.recordAssignment($this$recordAssignment, property2, new LinkedHashSet());
            }

            private final void recordAssignment(MiniFlow $this$recordAssignment, FirProperty property2, Set<MiniFlow> visited2) {
                if (visited2.contains($this$recordAssignment)) {
                    return;
                }
                ((Collection)visited2).add($this$recordAssignment);
                ((Collection)$this$recordAssignment.getAssignedLocalVariables()).add(property2);
                Iterable $this$forEach$iv = $this$recordAssignment.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignment(it, property2, visited2);
                }
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0010R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R!\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;)V", "getFlow", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "setFlow", "localFunctionToAssignedLocalVariables", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$AssignedLocalVariables;", "getLocalFunctionToAssignedLocalVariables", "()Ljava/util/Map;", "variableDeclarations", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getVariableDeclarations", "()Lkotlin/collections/ArrayDeque;", "resolveLocalVariable", "name", "resolve"})
            public static final class MiniCfgData {
                @Nullable
                private MiniFlow flow;
                @NotNull
                private final ArrayDeque<Map<Name, FirProperty>> variableDeclarations;
                @NotNull
                private final Map<FirFunctionSymbol<?>, AssignedLocalVariables> localFunctionToAssignedLocalVariables;

                public MiniCfgData(@Nullable MiniFlow flow) {
                    this.flow = flow;
                    this.variableDeclarations = new ArrayDeque((Collection)CollectionsKt.listOf((Object)new LinkedHashMap()));
                    this.localFunctionToAssignedLocalVariables = new LinkedHashMap();
                }

                @Nullable
                public final MiniFlow getFlow() {
                    return this.flow;
                }

                public final void setFlow(@Nullable MiniFlow miniFlow) {
                    this.flow = miniFlow;
                }

                @NotNull
                public final ArrayDeque<Map<Name, FirProperty>> getVariableDeclarations() {
                    return this.variableDeclarations;
                }

                @NotNull
                public final Map<FirFunctionSymbol<?>, AssignedLocalVariables> getLocalFunctionToAssignedLocalVariables() {
                    return this.localFunctionToAssignedLocalVariables;
                }

                @Nullable
                public final FirProperty resolveLocalVariable(@NotNull Name name) {
                    Object v0;
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        List $this$lastOrNull$iv = (List)this.variableDeclarations;
                        boolean $i$f$lastOrNull = false;
                        ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            Object element$iv = iterator$iv.previous();
                            Map it = (Map)element$iv;
                            boolean bl = false;
                            if (!it.containsKey(name)) continue;
                            v0 = element$iv;
                            break block1;
                        }
                        v0 = null;
                    }
                    Map map = v0;
                    return map != null ? (FirProperty)MapsKt.getValue((Map)map, (Object)name) : null;
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventOccurrencesRange.values().length];
            try {
                nArray[EventOccurrencesRange.AT_LEAST_ONCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventOccurrencesRange.MORE_THAN_ONCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventOccurrencesRange.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

