/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.infos.ClassCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.FactoryMap;

public class MethodReferenceResolver
implements ResolveCache.PolyVariantContextResolver<PsiMethodReferenceExpressionImpl> {
    public JavaResolveResult @NotNull [] resolve(final @NotNull PsiMethodReferenceExpressionImpl reference, @NotNull PsiFile containingFile, boolean incompleteCode) {
        if (reference == null) {
            MethodReferenceResolver.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            MethodReferenceResolver.$$$reportNull$$$0(1);
        }
        final PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference);
        final PsiClass containingClass = qualifierResolveResult.getContainingClass();
        PsiSubstitutor substitutor2 = qualifierResolveResult.getSubstitutor();
        if (containingClass != null) {
            PsiElement element = reference.getReferenceNameElement();
            boolean isConstructor = reference.isConstructor();
            if (element instanceof PsiIdentifier || isConstructor) {
                if (isConstructor && !MethodReferenceResolver.canBeConstructed(containingClass)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        MethodReferenceResolver.$$$reportNull$$$0(2);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                final PsiType functionalInterfaceType = reference.getFunctionalInterfaceType();
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                final PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                PsiSubstitutor functionalInterfaceSubstitutor = interfaceMethod != null ? LambdaUtil.getSubstitutor(interfaceMethod, resolveResult) : null;
                final MethodSignature signature2 = interfaceMethod != null ? interfaceMethod.getSignature(functionalInterfaceSubstitutor) : null;
                final PsiType interfaceMethodReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
                if (isConstructor && containingClass.getConstructors().length == 0) {
                    JavaResolveResult[] javaResolveResultArray;
                    if (interfaceMethodReturnType != null) {
                        PsiClassType returnType2 = MethodReferenceResolver.composeReturnType(containingClass, substitutor2);
                        InferenceSession session2 = new InferenceSession(containingClass.getTypeParameters(), substitutor2, reference.getManager(), null);
                        if (!session2.isProperType(session2.substituteWithInferenceVariables(returnType2)) || !session2.isProperType(interfaceMethodReturnType)) {
                            session2.registerReturnTypeConstraints(returnType2, interfaceMethodReturnType, reference);
                            substitutor2 = session2.infer();
                        }
                    }
                    ClassCandidateInfo candidateInfo = null;
                    boolean isArray = PsiUtil.isArrayClass(containingClass);
                    if (signature2 == null || !isArray && (containingClass.getContainingClass() == null || !MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference)) && signature2.getParameterTypes().length == 0 || isArray && MethodReferenceResolver.arrayCreationSignature(signature2)) {
                        candidateInfo = new ClassCandidateInfo(containingClass, substitutor2);
                    }
                    if (candidateInfo == null) {
                        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
                    } else {
                        JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                        javaResolveResultArray = javaResolveResultArray2;
                        javaResolveResultArray2[0] = candidateInfo;
                    }
                    if (javaResolveResultArray == null) {
                        MethodReferenceResolver.$$$reportNull$$$0(3);
                    }
                    return javaResolveResultArray;
                }
                PsiConflictResolver conflictResolver = this.createResolver(reference, qualifierResolveResult, interfaceMethod, signature2);
                MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor(reference, containingFile, new PsiConflictResolver[]{conflictResolver}, new SmartList()){

                    @Override
                    protected boolean acceptVarargs() {
                        return true;
                    }

                    @Override
                    @NotNull
                    protected MethodCandidateInfo createCandidateInfo(final @NotNull PsiMethod method, final @NotNull PsiSubstitutor substitutor2, boolean staticProblem, boolean accessible, final boolean varargs) {
                        if (method == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (substitutor2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        PsiExpressionList argumentList2 = this.getArgumentList();
                        PsiType[] typeParameters2 = reference.getTypeParameters();
                        return new MethodCandidateInfo(method, substitutor2, !accessible, staticProblem, argumentList2, this.myCurrentFileContext, argumentList2 != null ? argumentList2.getExpressionTypes() : null, method.hasTypeParameters() && typeParameters2.length > 0 ? typeParameters2 : null, this.getLanguageLevel()){

                            @Override
                            public boolean isVarargs() {
                                return varargs;
                            }

                            @Override
                            @NotNull
                            public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
                                if (policy == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                PsiSubstitutor psiSubstitutor = includeReturnConstraint ? this.inferTypeArguments(true) : Objects.requireNonNull(MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(reference, false, () -> this.inferTypeArguments(false)));
                                if (psiSubstitutor == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return psiSubstitutor;
                            }

                            private PsiSubstitutor inferTypeArguments(boolean includeReturnConstraint) {
                                if (interfaceMethod == null) {
                                    return substitutor2;
                                }
                                InferenceSession session2 = new InferenceSession(method.getTypeParameters(), substitutor2, reference.getManager(), reference);
                                session2.initThrowsConstraints(method);
                                PsiSubstitutor psiSubstitutor = session2.collectApplicabilityConstraints(reference, this, functionalInterfaceType);
                                if (psiSubstitutor != null) {
                                    return psiSubstitutor;
                                }
                                if (!session2.repeatInferencePhases()) {
                                    List<String> errorMessages2 = session2.getIncompatibleErrorMessages();
                                    if (errorMessages2 != null) {
                                        this.setApplicabilityError(StringUtil.join(errorMessages2, "\n"));
                                    }
                                    return substitutor2;
                                }
                                if (includeReturnConstraint && !PsiType.VOID.equals(interfaceMethodReturnType) && interfaceMethodReturnType != null) {
                                    PsiClassType returnType2;
                                    PsiType psiType2 = returnType2 = method.isConstructor() ? MethodReferenceResolver.composeReturnType(containingClass, substitutor2) : PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature2, qualifierResolveResult, method, containingClass, reference).substitute(method.getReturnType());
                                    if (returnType2 != null) {
                                        session2.registerReturnTypeConstraints(returnType2, interfaceMethodReturnType, reference);
                                    }
                                }
                                return session2.infer(method.getParameterList().getParameters(), null, null, null);
                            }

                            @Override
                            public boolean isApplicable() {
                                boolean hasReceiver;
                                if (signature2 == null) {
                                    return false;
                                }
                                if (this.getInferenceErrorMessageAssumeAlreadyComputed() != null) {
                                    return false;
                                }
                                PsiType[] argTypes = signature2.getParameterTypes();
                                return MethodReferenceConflictResolver.isApplicableByFirstSearch(this, argTypes, hasReceiver = PsiMethodReferenceUtil.isSecondSearchPossible(argTypes, qualifierResolveResult, reference), reference, interfaceMethod.isVarArgs(), interfaceMethod) != null;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string2;
                                switch (n) {
                                    default: {
                                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                    case 1: {
                                        string2 = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 3;
                                        break;
                                    }
                                    case 1: {
                                        n2 = 2;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "policy";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "inferTypeArguments";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray;
                                        objectArray[2] = "inferTypeArguments";
                                        break;
                                    }
                                    case 1: {
                                        break;
                                    }
                                }
                                String string3 = String.format(string2, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalArgumentException(string3);
                                        break;
                                    }
                                    case 1: {
                                        runtimeException = new IllegalStateException(string3);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        };
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "method";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "substitutor";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1";
                        objectArray[2] = "createCandidateInfo";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                processor2.setIsConstructor(isConstructor);
                processor2.setName(isConstructor ? containingClass.getName() : element.getText());
                PsiExpression expression2 = reference.getQualifierExpression();
                if (expression2 == null || !(expression2.getType() instanceof PsiArrayType) && !(expression2 instanceof PsiSuperExpression)) {
                    processor2.setAccessClass(containingClass);
                }
                if (qualifierResolveResult.isReferenceTypeQualified() && MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference)) {
                    processor2.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                }
                ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2);
                containingClass.processDeclarations(processor2, state, reference, reference);
                JavaResolveResult[] javaResolveResultArray = processor2.getResult();
                if (javaResolveResultArray == null) {
                    MethodReferenceResolver.$$$reportNull$$$0(4);
                }
                return javaResolveResultArray;
            }
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            MethodReferenceResolver.$$$reportNull$$$0(5);
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public static boolean canBeConstructed(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MethodReferenceResolver.$$$reportNull$$$0(6);
        }
        return !psiClass.isEnum() && !psiClass.hasModifierProperty("abstract") && !(psiClass instanceof PsiTypeParameter);
    }

    private static boolean isLocatedInStaticContext(@NotNull PsiClass containingClass, @NotNull PsiMethodReferenceExpression reference) {
        PsiClass gContainingClass;
        if (containingClass == null) {
            MethodReferenceResolver.$$$reportNull$$$0(7);
        }
        if (reference == null) {
            MethodReferenceResolver.$$$reportNull$$$0(8);
        }
        if ((gContainingClass = containingClass.getContainingClass()) == null || !containingClass.hasModifierProperty("static")) {
            PsiClass aClass = null;
            if (PsiTreeUtil.isAncestor(gContainingClass != null ? gContainingClass : containingClass, reference, false)) {
                aClass = gContainingClass != null ? gContainingClass : containingClass;
            }
            return PsiUtil.getEnclosingStaticElement(reference, aClass) != null;
        }
        return false;
    }

    protected PsiConflictResolver createResolver(@NotNull PsiMethodReferenceExpressionImpl referenceExpression, @NotNull PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable PsiMethod interfaceMethod, @Nullable MethodSignature signature2) {
        if (referenceExpression == null) {
            MethodReferenceResolver.$$$reportNull$$$0(9);
        }
        if (qualifierResolveResult == null) {
            MethodReferenceResolver.$$$reportNull$$$0(10);
        }
        return new MethodReferenceConflictResolver(referenceExpression, qualifierResolveResult, signature2, interfaceMethod);
    }

    @NotNull
    private static PsiClassType composeReturnType(@NotNull PsiClass containingClass, @NotNull PsiSubstitutor substitutor2) {
        if (containingClass == null) {
            MethodReferenceResolver.$$$reportNull$$$0(11);
        }
        if (substitutor2 == null) {
            MethodReferenceResolver.$$$reportNull$$$0(12);
        }
        boolean isRawSubst = PsiUtil.isRawSubstitutor(containingClass, substitutor2);
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : substitutor2);
        if (psiClassType == null) {
            MethodReferenceResolver.$$$reportNull$$$0(13);
        }
        return psiClassType;
    }

    private static boolean arrayCreationSignature(@NotNull MethodSignature signature2) {
        PsiType[] parameterTypes;
        if (signature2 == null) {
            MethodReferenceResolver.$$$reportNull$$$0(14);
        }
        return (parameterTypes = signature2.getParameterTypes()).length == 1 && parameterTypes[0] != null && TypeConversionUtil.isAssignable(PsiType.INT, parameterTypes[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/MethodReferenceResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierResolveResult";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/MethodReferenceResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "composeReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBeConstructed";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isLocatedInStaticContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createResolver";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "composeReturnType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "arrayCreationSignature";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MethodReferenceConflictResolver
    extends JavaMethodsConflictResolver {
        private final MethodSignature mySignature;
        private final PsiMethod myInterfaceMethod;
        private final PsiMethodReferenceExpressionImpl myReferenceExpression;
        private final PsiMethodReferenceUtil.QualifierResolveResult myQualifierResolveResult;
        private final boolean myFunctionalMethodVarArgs;

        private MethodReferenceConflictResolver(@NotNull PsiMethodReferenceExpressionImpl referenceExpression, @NotNull PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable MethodSignature signature2, @Nullable PsiMethod interfaceMethod) {
            if (referenceExpression == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(0);
            }
            if (qualifierResolveResult == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(1);
            }
            super(referenceExpression, signature2 != null ? signature2.getParameterTypes() : PsiType.EMPTY_ARRAY, PsiUtil.getLanguageLevel(referenceExpression), referenceExpression.getContainingFile());
            this.myReferenceExpression = referenceExpression;
            this.myQualifierResolveResult = qualifierResolveResult;
            this.myFunctionalMethodVarArgs = interfaceMethod != null && interfaceMethod.isVarArgs();
            this.mySignature = signature2;
            this.myInterfaceMethod = interfaceMethod;
        }

        @Override
        protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict, Map<MethodCandidateInfo, PsiSubstitutor> map) {
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(2);
            }
            return conflict.isVarargs() ? 2 : 3;
        }

        @Override
        @Nullable
        protected CandidateInfo guardedOverloadResolution(@NotNull List<CandidateInfo> conflicts) {
            CandidateInfo candidateInfo;
            if (conflicts == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(3);
            }
            if (this.mySignature == null) {
                return null;
            }
            if (conflicts.isEmpty()) {
                return null;
            }
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            Map<MethodCandidateInfo, PsiSubstitutor> map = FactoryMap.create(key -> key.getSubstitutor(false));
            this.checkSameSignatures(conflicts, map);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            MethodReferenceConflictResolver.checkAccessStaticLevels(conflicts, true);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            PsiType[] argTypes = this.mySignature.getParameterTypes();
            boolean hasReceiver = PsiMethodReferenceUtil.isSecondSearchPossible(argTypes, this.myQualifierResolveResult, this.myReferenceExpression);
            ArrayList<CandidateInfo> firstCandidates = new ArrayList<CandidateInfo>();
            ArrayList<CandidateInfo> secondCandidates = new ArrayList<CandidateInfo>();
            for (CandidateInfo conflict : conflicts) {
                Boolean applicableByFirstSearch;
                if (!(conflict instanceof MethodCandidateInfo) || (applicableByFirstSearch = MethodReferenceConflictResolver.isApplicableByFirstSearch(conflict, argTypes, hasReceiver, this.myReferenceExpression, this.myFunctionalMethodVarArgs, this.myInterfaceMethod)) == null) continue;
                (applicableByFirstSearch != false ? firstCandidates : secondCandidates).add(conflict);
            }
            if (this.myQualifierResolveResult.isReferenceTypeQualified() && this.myReferenceExpression.getReferenceNameElement() instanceof PsiIdentifier) {
                candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(firstCandidates, secondCandidates, true);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
                candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(secondCandidates, firstCandidates, false);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
            }
            if ((candidateInfo = this.resolveConflicts(firstCandidates, secondCandidates, map, 3)) != null) {
                return candidateInfo;
            }
            candidateInfo = this.resolveConflicts(firstCandidates, secondCandidates, map, 2);
            if (candidateInfo != null) {
                return candidateInfo;
            }
            if (firstCandidates.isEmpty() && secondCandidates.isEmpty()) {
                return null;
            }
            conflicts.clear();
            firstCandidates.addAll(secondCandidates);
            conflicts.addAll(firstCandidates);
            return null;
        }

        private static Boolean isApplicableByFirstSearch(@NotNull CandidateInfo conflict, PsiType @NotNull [] functionalInterfaceParamTypes, boolean hasReceiver, @NotNull PsiMethodReferenceExpression referenceExpression, boolean functionalMethodVarArgs, PsiMethod interfaceMethod) {
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(4);
            }
            if (referenceExpression == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(5);
            }
            if (functionalInterfaceParamTypes == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(6);
            }
            PsiMethod psiMethod = ((MethodCandidateInfo)conflict).getElement();
            PsiSubstitutor substitutor2 = ((MethodCandidateInfo)conflict).getSubstitutor(false);
            if (((MethodCandidateInfo)conflict).getInferenceErrorMessage() != null) {
                return null;
            }
            PsiType[] parameterTypes = psiMethod.getSignature(substitutor2).getParameterTypes();
            boolean varargs = ((MethodCandidateInfo)conflict).isVarargs();
            if (varargs && (!psiMethod.isVarArgs() || functionalMethodVarArgs)) {
                return null;
            }
            if ((varargs || functionalInterfaceParamTypes.length == parameterTypes.length) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes, functionalInterfaceParamTypes, interfaceMethod, varargs, conflict, 0)) {
                PsiClass containingClass;
                if (psiMethod.hasModifierProperty("static") && (containingClass = psiMethod.getContainingClass()) != null && containingClass.isInterface()) {
                    PsiClass qualifierClass = PsiMethodReferenceUtil.getQualifierResolveResult(referenceExpression).getContainingClass();
                    if (!containingClass.getManager().areElementsEquivalent(qualifierClass, containingClass)) {
                        return null;
                    }
                }
                return true;
            }
            if (hasReceiver && (varargs || functionalInterfaceParamTypes.length == parameterTypes.length + 1) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes, functionalInterfaceParamTypes, interfaceMethod, varargs, conflict, 1)) {
                return false;
            }
            return null;
        }

        private static boolean isCorrectAssignment(PsiType @NotNull [] parameterTypes, PsiType @NotNull [] functionalInterfaceParamTypes, PsiMethod interfaceMethod, boolean varargs, @NotNull CandidateInfo conflict, int offset2) {
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(7);
            }
            if (parameterTypes == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(8);
            }
            if (functionalInterfaceParamTypes == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(9);
            }
            int min = Math.min(parameterTypes.length, functionalInterfaceParamTypes.length - offset2);
            for (int i = 0; i < min; ++i) {
                PsiType argType = PsiUtil.captureToplevelWildcards(functionalInterfaceParamTypes[i + offset2], interfaceMethod.getParameterList().getParameters()[i]);
                PsiType parameterType = parameterTypes[i];
                if (varargs && i == parameterTypes.length - 1) {
                    if (TypeConversionUtil.isAssignable(parameterType, argType) || TypeConversionUtil.isAssignable(((PsiArrayType)parameterType).getComponentType(), argType)) continue;
                    MethodReferenceConflictResolver.markNotApplicable(conflict);
                    return false;
                }
                if (TypeConversionUtil.isAssignable(parameterType, argType)) continue;
                MethodReferenceConflictResolver.markNotApplicable(conflict);
                return false;
            }
            return !varargs || parameterTypes.length - 1 <= functionalInterfaceParamTypes.length - offset2;
        }

        private static void markNotApplicable(@NotNull CandidateInfo conflict) {
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(10);
            }
            if (conflict instanceof MethodCandidateInfo) {
                ((MethodCandidateInfo)conflict).markNotApplicable();
            }
        }

        private CandidateInfo resolveConflicts(@NotNull List<CandidateInfo> firstCandidates, @NotNull List<CandidateInfo> secondCandidates, Map<MethodCandidateInfo, PsiSubstitutor> map, int applicabilityLevel) {
            if (firstCandidates == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(11);
            }
            if (secondCandidates == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(12);
            }
            int firstApplicability = this.checkApplicability(firstCandidates);
            this.checkSpecifics(firstCandidates, applicabilityLevel, map, 0);
            int secondApplicability = this.checkApplicability(secondCandidates);
            this.checkSpecifics(secondCandidates, applicabilityLevel, map, 1);
            if (firstApplicability < secondApplicability) {
                return secondCandidates.size() == 1 ? secondCandidates.get(0) : null;
            }
            if (secondApplicability < firstApplicability) {
                return firstCandidates.size() == 1 ? firstCandidates.get(0) : null;
            }
            return firstCandidates.size() + secondCandidates.size() == 1 ? (firstCandidates.isEmpty() ? secondCandidates.get(0) : firstCandidates.get(0)) : null;
        }

        @Override
        protected boolean nonComparable(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, boolean fixedArity) {
            if (method == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(13);
            }
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(14);
            }
            if (method == conflict) {
                return true;
            }
            PsiElement psiElement = method.getElement();
            PsiElement conflictElement = conflict.getElement();
            if (psiElement instanceof PsiMethod && conflictElement instanceof PsiMethod) {
                return fixedArity && ((PsiMethod)psiElement).getParameterList().getParametersCount() != ((PsiMethod)conflictElement).getParameterList().getParametersCount();
            }
            return false;
        }

        private static CandidateInfo filterStaticCorrectCandidates(@NotNull List<CandidateInfo> firstCandidates, @NotNull List<CandidateInfo> secondCandidates, boolean shouldBeStatic) {
            boolean isStatic;
            CandidateInfo candidateInfo;
            PsiElement element;
            if (firstCandidates == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(15);
            }
            if (secondCandidates == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(16);
            }
            if (firstCandidates.size() == 1 && (element = (candidateInfo = firstCandidates.get(0)).getElement()) instanceof PsiMethod && shouldBeStatic == (isStatic = ((PsiMethod)element).hasModifierProperty("static"))) {
                for (CandidateInfo secondCandidate : secondCandidates) {
                    boolean oppositeStatic;
                    PsiElement psiElement = secondCandidate.getElement();
                    if (!(psiElement instanceof PsiMethod) || shouldBeStatic == (oppositeStatic = ((PsiMethod)psiElement).hasModifierProperty("static"))) continue;
                    return null;
                }
                return candidateInfo;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifierResolveResult";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflict";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflicts";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionalInterfaceParamTypes";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterTypes";
                    break;
                }
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstCandidates";
                    break;
                }
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondCandidates";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$MethodReferenceConflictResolver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPertinentApplicabilityLevel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "guardedOverloadResolution";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicableByFirstSearch";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCorrectAssignment";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markNotApplicable";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveConflicts";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nonComparable";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "filterStaticCorrectCandidates";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

