/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLowering;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u0015\u001a\u00020\u000e*\u00020\nH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "buildInitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "createInitFunction", "", "lower", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "openInitializerBox", "addInternalValueParameters", "hasStrictSignature", "", "CallSiteTransformer", "ES6_INIT_BOX_PARAMETER", "ES6_RESULT_TYPE_PARAMETER", "ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION", "backend.js"})
public final class ES6AddInternalParametersToConstructorPhase
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public ES6AddInternalParametersToConstructorPhase(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!this.context.getEs6mode()) {
            return;
        }
        container.transform(new CallSiteTransformer(), null);
        if (!(container instanceof IrConstructor)) {
            return;
        }
        if (!this.hasStrictSignature((IrConstructor)container)) {
            this.addInternalValueParameters((IrConstructor)container);
        }
        if (container.getOrigin() == PrimaryConstructorLowering.SYNTHETIC_PRIMARY_CONSTRUCTOR.INSTANCE) {
            this.createInitFunction((IrConstructor)container);
            this.openInitializerBox((IrConstructor)container);
        }
    }

    private final void addInternalValueParameters(IrConstructor $this$addInternalValueParameters) {
        DeclarationBuildersKt.addValueParameter((IrFunction)$this$addInternalValueParameters, "box", (IrType)this.context.getDynamicType(), (IrDeclarationOrigin)ES6_INIT_BOX_PARAMETER.INSTANCE);
        if (!$this$addInternalValueParameters.isPrimary()) {
            DeclarationBuildersKt.addValueParameter((IrFunction)$this$addInternalValueParameters, "resultType", (IrType)this.context.getDynamicType(), (IrDeclarationOrigin)ES6_RESULT_TYPE_PARAMETER.INSTANCE);
        }
    }

    private final void createInitFunction(IrConstructor constructor2) {
        IrClass irClass2 = IrUtilsKt.getParentAsClass(constructor2);
        IrSimpleFunction initFunction = this.buildInitFunction(constructor2, irClass2);
        ((Collection)irClass2.getDeclarations()).add(initFunction);
        this.context.getMapping().getConstructorToInitFunction().set((IrConstructor)((IrDeclaration)constructor2), initFunction);
        initFunction.transformChildren(new IrElementTransformerVoid(initFunction){
            final /* synthetic */ IrSimpleFunction $initFunction;
            {
                this.$initFunction = $initFunction;
            }

            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                declaration.setParent(this.$initFunction);
                return declaration;
            }
        }, null);
    }

    private final void openInitializerBox(IrConstructor constructor2) {
        IrCall irCall;
        IrBody irBody = constructor2.getBody();
        Intrinsics.checkNotNull((Object)irBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        IrBlockBody $this$openInitializerBox_u24lambda_u241 = (IrBlockBody)irBody;
        boolean bl = false;
        $this$openInitializerBox_u24lambda_u241.getStatements().clear();
        Collection collection = $this$openInitializerBox_u24lambda_u241.getStatements();
        IrCall it = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIntrinsics().getJsOpenInitializerBox(), null, null, null, 14, null);
        boolean bl2 = false;
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(constructor2).getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        it.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irValueParameter.getSymbol()));
        it.putValueArgument(1, JsIrBuilder.INSTANCE.buildGetValue(((IrValueParameter)CollectionsKt.last(constructor2.getValueParameters())).getSymbol()));
        collection.add(irCall);
    }

    private final IrSimpleFunction buildInitFunction(IrConstructor constructor2, IrClass irClass2) {
        IrSimpleFunction irSimpleFunction;
        String functionName = irClass2.getName() + "_init";
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$buildInitFunction_u24lambda_u242 = $this$buildFun_u24lambda_u2418$iv;
        boolean bl2 = false;
        Name name = Name.identifier(functionName);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(functionName)");
        $this$buildInitFunction_u24lambda_u242.setName(name);
        $this$buildInitFunction_u24lambda_u242.setReturnType(this.context.getIrBuiltIns().getUnitType());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PROTECTED");
        $this$buildInitFunction_u24lambda_u242.setVisibility(descriptorVisibility);
        $this$buildInitFunction_u24lambda_u242.setModality(Modality.FINAL);
        $this$buildInitFunction_u24lambda_u242.setInline(constructor2.isInline());
        $this$buildInitFunction_u24lambda_u242.setExternal(constructor2.isExternal());
        $this$buildInitFunction_u24lambda_u242.setOrigin(ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION.INSTANCE);
        IrSimpleFunction $this$buildInitFunction_u24lambda_u243 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2418$iv);
        boolean bl3 = false;
        $this$buildInitFunction_u24lambda_u243.setParent(irClass2);
        DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$buildInitFunction_u24lambda_u243, "$this$", (IrType)this.context.getDynamicType(), null, 4, null);
        IrFactory irFactory = this.context.getIrFactory();
        IrBody irBody = constructor2.getBody();
        List list2 = irBody != null ? IrUtilsKt.getStatements(irBody) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        $this$buildInitFunction_u24lambda_u243.setBody(irFactory.createBlockBody(-1, -1, list2));
        $this$buildInitFunction_u24lambda_u243.transformChildren(new IrElementTransformerVoid(constructor2, $this$buildInitFunction_u24lambda_u243){
            final /* synthetic */ IrConstructor $constructor;
            final /* synthetic */ IrSimpleFunction $this_apply;
            {
                this.$constructor = $constructor;
                this.$this_apply = $receiver;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(this.$constructor).getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter);
                if (irValueDeclaration == irValueParameter) {
                    IrSimpleFunction irSimpleFunction = this.$this_apply;
                    IrGetValue $this$visitGetValue_u24lambda_u240 = expression2;
                    boolean bl = false;
                    irExpression = new IrGetValueImpl($this$visitGetValue_u24lambda_u240.getStartOffset(), $this$visitGetValue_u24lambda_u240.getEndOffset(), $this$visitGetValue_u24lambda_u240.getType(), ((IrValueParameter)CollectionsKt.single(irSimpleFunction.getValueParameters())).getSymbol(), null, 16, null);
                } else {
                    irExpression = expression2;
                }
                return irExpression;
            }
        }, null);
        return irSimpleFunction;
    }

    private final boolean hasStrictSignature(IrConstructor $this$hasStrictSignature) {
        IrBuiltIns $this$hasStrictSignature_u24lambda_u244 = this.context.getIrBuiltIns();
        boolean bl = false;
        List primitives = CollectionsKt.plus($this$hasStrictSignature_u24lambda_u244.getPrimitiveTypesToPrimitiveArrays().values(), (Object)$this$hasStrictSignature_u24lambda_u244.getStringClass());
        IrClass $this$hasStrictSignature_u24lambda_u245 = IrUtilsKt.getParentAsClass($this$hasStrictSignature);
        boolean bl2 = false;
        return $this$hasStrictSignature_u24lambda_u245.isExternal() || this.context.getInlineClassesUtils().isClassInlineLike($this$hasStrictSignature_u24lambda_u245) || primitives.contains($this$hasStrictSignature_u24lambda_u245.getSymbol());
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
    public static final class ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION
    extends IrDeclarationOriginImpl {
        @NotNull
        public static final ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION INSTANCE = new ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION();

        private ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION() {
            super("ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION", false, 2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$ES6_INIT_BOX_PARAMETER;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
    public static final class ES6_INIT_BOX_PARAMETER
    extends IrDeclarationOriginImpl {
        @NotNull
        public static final ES6_INIT_BOX_PARAMETER INSTANCE = new ES6_INIT_BOX_PARAMETER();

        private ES6_INIT_BOX_PARAMETER() {
            super("ES6_INIT_BOX_PARAMETER", false, 2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$ES6_RESULT_TYPE_PARAMETER;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
    public static final class ES6_RESULT_TYPE_PARAMETER
    extends IrDeclarationOriginImpl {
        @NotNull
        public static final ES6_RESULT_TYPE_PARAMETER INSTANCE = new ES6_RESULT_TYPE_PARAMETER();

        private ES6_RESULT_TYPE_PARAMETER() {
            super("ES6_RESULT_TYPE_PARAMETER", false, 2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$CallSiteTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase;)V", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "backend.js"})
    public final class CallSiteTransformer
    extends IrElementTransformerVoid {
        @Override
        @NotNull
        public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
            IrConstructorCallImpl irConstructorCallImpl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrConstructor constructor2 = (IrConstructor)expression2.getSymbol().getOwner();
            IrClass parent2 = IrUtilsKt.getParentAsClass(constructor2);
            if (ES6AddInternalParametersToConstructorPhase.this.hasStrictSignature(constructor2) || IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(parent2))) {
                return expression2;
            }
            int newArgsCount = constructor2.isPrimary() ? 1 : 2;
            IrConstructorCall irConstructorCall = expression2;
            ES6AddInternalParametersToConstructorPhase eS6AddInternalParametersToConstructorPhase = ES6AddInternalParametersToConstructorPhase.this;
            IrConstructorCall $this$visitConstructorCall_u24lambda_u241 = irConstructorCall;
            boolean bl = false;
            IrConstructorCallImpl it = irConstructorCallImpl = new IrConstructorCallImpl($this$visitConstructorCall_u24lambda_u241.getStartOffset(), $this$visitConstructorCall_u24lambda_u241.getEndOffset(), $this$visitConstructorCall_u24lambda_u241.getType(), $this$visitConstructorCall_u24lambda_u241.getSymbol(), $this$visitConstructorCall_u24lambda_u241.getTypeArgumentsCount(), $this$visitConstructorCall_u24lambda_u241.getConstructorTypeArgumentsCount(), $this$visitConstructorCall_u24lambda_u241.getValueArgumentsCount() + newArgsCount, null, null, 384, null);
            boolean bl2 = false;
            int n = $this$visitConstructorCall_u24lambda_u241.getValueArgumentsCount();
            for (int i = 0; i < n; ++i) {
                it.putValueArgument(i, $this$visitConstructorCall_u24lambda_u241.getValueArgument(i));
            }
            it.putValueArgument($this$visitConstructorCall_u24lambda_u241.getValueArgumentsCount(), JsIrBuilder.INSTANCE.buildNull(eS6AddInternalParametersToConstructorPhase.getContext().getDynamicType()));
            if (!constructor2.isPrimary()) {
                it.putValueArgument($this$visitConstructorCall_u24lambda_u241.getValueArgumentsCount() + 1, JsIrBuilder.INSTANCE.buildNull(eS6AddInternalParametersToConstructorPhase.getContext().getDynamicType()));
            }
            return irConstructorCallImpl;
        }

        @Override
        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrConstructor constructor2 = (IrConstructor)expression2.getSymbol().getOwner();
            IrClass parent2 = IrUtilsKt.getParentAsClass(constructor2);
            if (ES6AddInternalParametersToConstructorPhase.this.hasStrictSignature(constructor2) || IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(parent2))) {
                return expression2;
            }
            int newArgsCount = constructor2.isPrimary() ? 1 : 2;
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = expression2;
            ES6AddInternalParametersToConstructorPhase eS6AddInternalParametersToConstructorPhase = ES6AddInternalParametersToConstructorPhase.this;
            IrDelegatingConstructorCall $this$visitDelegatingConstructorCall_u24lambda_u243 = irDelegatingConstructorCall2;
            boolean bl = false;
            IrDelegatingConstructorCallImpl it = irDelegatingConstructorCallImpl = new IrDelegatingConstructorCallImpl($this$visitDelegatingConstructorCall_u24lambda_u243.getStartOffset(), $this$visitDelegatingConstructorCall_u24lambda_u243.getEndOffset(), $this$visitDelegatingConstructorCall_u24lambda_u243.getType(), $this$visitDelegatingConstructorCall_u24lambda_u243.getSymbol(), $this$visitDelegatingConstructorCall_u24lambda_u243.getTypeArgumentsCount(), $this$visitDelegatingConstructorCall_u24lambda_u243.getValueArgumentsCount() + newArgsCount);
            boolean bl2 = false;
            int n = $this$visitDelegatingConstructorCall_u24lambda_u243.getValueArgumentsCount();
            for (int i = 0; i < n; ++i) {
                it.putValueArgument(i, $this$visitDelegatingConstructorCall_u24lambda_u243.getValueArgument(i));
            }
            it.putValueArgument($this$visitDelegatingConstructorCall_u24lambda_u243.getValueArgumentsCount(), JsIrBuilder.INSTANCE.buildNull(eS6AddInternalParametersToConstructorPhase.getContext().getDynamicType()));
            if (!constructor2.isPrimary()) {
                it.putValueArgument($this$visitDelegatingConstructorCall_u24lambda_u243.getValueArgumentsCount() + 1, JsIrBuilder.INSTANCE.buildNull(eS6AddInternalParametersToConstructorPhase.getContext().getDynamicType()));
            }
            return irDelegatingConstructorCallImpl;
        }
    }
}

