/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.FirJvmAnnotationHelperKt;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.FirJvmHelperKt;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration.FirJvmDefaultChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.java.JvmDefaultModeContainerKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.name.JvmNames;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012*\u0006\u0012\u0002\b\u00030\u0013J\u0016\u0010\u0014\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmDefaultChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkNonJvmDefaultOverridesJavaDefault", "defaultAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "getOverriddenDeclarations", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "isCompiledToJvmDefaultWithProperMode", "", "checkers.jvm"})
public final class FirJvmDefaultChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmDefaultChecker INSTANCE = new FirJvmDefaultChecker();

    private FirJvmDefaultChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirAnnotation defaultAnnotation;
        JvmDefaultMode jvmDefaultMode2;
        block22: {
            KtSourceElement source;
            block23: {
                FirAnnotation annotationWithCompatibility;
                block19: {
                    KtSourceElement source2;
                    block21: {
                        block20: {
                            FirElement firElement;
                            block18: {
                                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                                jvmDefaultMode2 = JvmDefaultModeContainerKt.getJvmDefaultModeState(context.getSession());
                                defaultAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmNames.INSTANCE.getJVM_DEFAULT_CLASS_ID());
                                if (defaultAnnotation == null) break block19;
                                CheckerContext $this$findClosest_u24default$iv = context;
                                boolean $i$f$findClosest = false;
                                for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                                    FirElement firElement2;
                                    FirDeclaration firDeclaration = it$iv;
                                    if (!(firDeclaration instanceof FirClassLikeDeclaration)) {
                                        firDeclaration = null;
                                    }
                                    if ((firElement = (FirElement)((FirClassLikeDeclaration)firDeclaration)) == null) continue;
                                    FirElement firElement3 = firElement2 = firElement;
                                    boolean bl = false;
                                    FirElement it = firElement3;
                                    firElement = true ? firElement2 : null;
                                    if (firElement == null) {
                                        continue;
                                    }
                                    break block18;
                                }
                                firElement = null;
                            }
                            FirClassLikeDeclaration containingDeclaration = (FirClassLikeDeclaration)firElement;
                            source2 = defaultAnnotation.getSource();
                            if (!(containingDeclaration instanceof FirClass)) break block20;
                            FirClass $this$isInterface$iv = (FirClass)containingDeclaration;
                            boolean $i$f$isInterface = false;
                            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                            boolean $i$f$isInterface2 = false;
                            if ($this$isInterface$iv$iv == ClassKind.INTERFACE) break block21;
                        }
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirJvmErrors.INSTANCE.getJVM_DEFAULT_NOT_IN_INTERFACE(), (DiagnosticContext)context, null, 8, null);
                        return;
                    }
                    if (FirJvmHelperKt.isJvm6(context)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_JVM6_TARGET(), (Object)"JvmDefault", (DiagnosticContext)context, null, 16, null);
                        return;
                    }
                    if (!jvmDefaultMode2.isEnabled()) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_DECLARATION(), (Object)"JvmDefault", (DiagnosticContext)context, null, 16, null);
                        return;
                    }
                    break block22;
                }
                FirAnnotation annotationNoCompatibility = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmNames.INSTANCE.getJVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID());
                if (annotationNoCompatibility != null) {
                    KtSourceElement source3 = annotationNoCompatibility.getSource();
                    if (FirJvmHelperKt.isJvm6(context)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source3, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_JVM6_TARGET(), (Object)"JvmDefaultWithoutCompatibility", (DiagnosticContext)context, null, 16, null);
                        return;
                    }
                    if (!jvmDefaultMode2.isEnabled()) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source3, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_DECLARATION(), (Object)"JvmDefaultWithoutCompatibility", (DiagnosticContext)context, null, 16, null);
                        return;
                    }
                }
                if ((annotationWithCompatibility = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmNames.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID())) == null) break block22;
                source = annotationWithCompatibility.getSource();
                if (FirJvmHelperKt.isJvm6(context)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_JVM6_TARGET(), (Object)"JvmDefaultWithCompatibility", (DiagnosticContext)context, null, 16, null);
                    return;
                }
                if (jvmDefaultMode2 != JvmDefaultMode.ALL_INCOMPATIBLE) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_IN_DECLARATION(), (DiagnosticContext)context, null, 8, null);
                    return;
                }
                if (!(declaration instanceof FirRegularClass)) break block23;
                FirClass $this$isInterface$iv = (FirClass)declaration;
                boolean $i$f$isInterface = false;
                ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                boolean $i$f$isInterface3 = false;
                if ($this$isInterface$iv$iv == ClassKind.INTERFACE) break block22;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_NOT_ON_INTERFACE(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        this.checkNonJvmDefaultOverridesJavaDefault(defaultAnnotation, jvmDefaultMode2, declaration, context, reporter);
    }

    private final void checkNonJvmDefaultOverridesJavaDefault(FirAnnotation defaultAnnotation, JvmDefaultMode jvmDefaultMode2, FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter) {
        FirClassLikeDeclaration containingDeclaration;
        Object object;
        FirSimpleFunction member2;
        block16: {
            if (defaultAnnotation != null || jvmDefaultMode2.getForAllMethodsWithBody()) {
                return;
            }
            FirSimpleFunction firSimpleFunction = declaration instanceof FirSimpleFunction ? (FirSimpleFunction)declaration : null;
            if (firSimpleFunction == null) {
                return;
            }
            member2 = firSimpleFunction;
            if (declaration instanceof FirPropertyAccessor) {
                return;
            }
            CheckerContext $this$findClosest_u24default$iv = context;
            boolean $i$f$findClosest = false;
            for (Object it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                Object object2 = it$iv;
                if (!(object2 instanceof FirClassLikeDeclaration)) {
                    object2 = null;
                }
                if ((object = (FirElement)((FirClassLikeDeclaration)object2)) == null) continue;
                Object object3 = object;
                FirElement firElement = object3;
                boolean bl = false;
                FirElement firElement2 = firElement;
                object = true ? object3 : null;
                if (object == null) {
                    continue;
                }
                break block16;
            }
            object = null;
        }
        if ((containingDeclaration = (FirClassLikeDeclaration)object) instanceof FirClass) {
            FirClass $this$isInterface$iv = (FirClass)containingDeclaration;
            boolean $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            boolean $i$f$isInterface2 = false;
            boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            if (bl) {
                boolean bl2;
                List overriddenFunctions2;
                block17: {
                    FirTypeScope unsubstitutedScope = FirHelpersKt.unsubstitutedScope((FirClass)containingDeclaration, context);
                    unsubstitutedScope.processFunctionsByName(member2.getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)checkNonJvmDefaultOverridesJavaDefault.1.INSTANCE));
                    overriddenFunctions2 = FirTypeScopeKt.getDirectOverriddenFunctions$default(unsubstitutedScope, member2.getSymbol(), false, 2, null);
                    Iterable $this$any$iv = overriddenFunctions2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirNamedFunctionSymbol firNamedFunctionSymbol = (FirNamedFunctionSymbol)element$iv;
                            boolean bl3 = false;
                            if (!(FirAnnotationUtilsKt.getAnnotationByClassId(firNamedFunctionSymbol, JvmNames.INSTANCE.getJVM_DEFAULT_CLASS_ID()) != null)) continue;
                            bl2 = true;
                            break block17;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getJVM_DEFAULT_REQUIRED_FOR_OVERRIDE(), (DiagnosticContext)context, null, 8, null);
                } else if (jvmDefaultMode2.isEnabled()) {
                    for (FirNamedFunctionSymbol overriddenFunction : overriddenFunctions2) {
                        List<FirCallableSymbol<?>> overriddenDeclarations = this.getOverriddenDeclarations(overriddenFunction);
                        for (FirCallableSymbol firCallableSymbol : overriddenDeclarations) {
                            FirClassLikeSymbol<?> containingClassSymbol;
                            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(firCallableSymbol);
                            FirClassLikeSymbol<?> firClassLikeSymbol = containingClassSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context.getSession()) : null;
                            if (!((firClassLikeSymbol != null ? firClassLikeSymbol.getOrigin() : null) instanceof FirDeclarationOrigin.Java)) continue;
                            FirCallableSymbol $this$modality$iv = firCallableSymbol;
                            boolean $i$f$getModality = false;
                            if ($this$modality$iv.getResolvedStatus().getModality() == Modality.ABSTRACT) continue;
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getNON_JVM_DEFAULT_OVERRIDES_JAVA_DEFAULT(), (DiagnosticContext)context, null, 8, null);
                            return;
                        }
                    }
                }
            }
        }
    }

    @NotNull
    public final List<FirCallableSymbol<?>> getOverriddenDeclarations(@NotNull FirCallableSymbol<?> $this$getOverriddenDeclarations) {
        List list2;
        Intrinsics.checkNotNullParameter($this$getOverriddenDeclarations, (String)"<this>");
        if ($this$getOverriddenDeclarations instanceof FirIntersectionCallableSymbol) {
            list2 = new ArrayList(((FirIntersectionCallableSymbol)((Object)$this$getOverriddenDeclarations)).getIntersections());
        } else {
            ArrayList arrayList;
            ArrayList it = arrayList = new ArrayList(1);
            boolean bl = false;
            it.add($this$getOverriddenDeclarations);
            list2 = arrayList;
        }
        return list2;
    }

    public final boolean isCompiledToJvmDefaultWithProperMode(@NotNull FirCallableSymbol<?> $this$isCompiledToJvmDefaultWithProperMode, @NotNull JvmDefaultMode jvmDefaultMode2) {
        Intrinsics.checkNotNullParameter($this$isCompiledToJvmDefaultWithProperMode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)jvmDefaultMode2), (String)"jvmDefaultMode");
        return FirJvmAnnotationHelperKt.isCompiledToJvmDefault((FirBasedSymbol)$this$isCompiledToJvmDefaultWithProperMode, jvmDefaultMode2);
    }
}

