/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LogUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.openapi.util.StaticGetter;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementTypeBase;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.ImmutableCharSequence;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance(LazyParseableElement.class);
    private static final StaticGetter<CharSequence> NO_TEXT = new StaticGetter<Object>(null);
    private final ReentrantLock myLock;
    @NotNull
    private volatile Getter<CharSequence> myText;
    private volatile boolean myParsed;
    private static boolean ourParsingAllowed = true;

    public LazyParseableElement(@NotNull IElementType type2, @Nullable CharSequence text2) {
        if (type2 == null) {
            LazyParseableElement.$$$reportNull$$$0(0);
        }
        super(type2);
        this.myLock = new ReentrantLock();
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (text2 == null) {
                this.myParsed = true;
                this.myText = NO_TEXT;
            } else {
                this.myText = new StaticGetter<CharSequence>(ImmutableCharSequence.asImmutable(text2));
                this.setCachedLength(text2.length());
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (this.myParsed) {
                this.myText = NO_TEXT;
            } else {
                this.setCachedLength(this.myText.get().length());
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    @Override
    @NotNull
    public String getText() {
        CharSequence text2 = this.myText();
        if (text2 != null) {
            String string2 = text2.toString();
            if (string2 == null) {
                LazyParseableElement.$$$reportNull$$$0(1);
            }
            return string2;
        }
        String s = super.getText();
        this.myText = new SoftReference<String>(s);
        String string3 = s;
        if (string3 == null) {
            LazyParseableElement.$$$reportNull$$$0(2);
        }
        return string3;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text2 = this.myText();
        if (text2 == null) {
            text2 = super.getText();
            this.myText = new SoftReference<CharSequence>(text2);
        }
        CharSequence charSequence2 = text2;
        if (charSequence2 == null) {
            LazyParseableElement.$$$reportNull$$$0(3);
        }
        return charSequence2;
    }

    @Override
    public int getTextLength() {
        CharSequence text2 = this.myText();
        if (text2 != null) {
            return text2.length();
        }
        return super.getTextLength();
    }

    @Override
    public int hc() {
        CharSequence text2 = this.myText();
        return text2 == null ? super.hc() : LeafElement.leafHC(text2);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        CharSequence text2;
        if (buffer == null) {
            LazyParseableElement.$$$reportNull$$$0(4);
        }
        if ((text2 = this.myText()) != null) {
            return LeafElement.leafTextMatches(text2, buffer, start);
        }
        return super.textMatches(buffer, start);
    }

    public boolean isParsed() {
        return this.myParsed;
    }

    private CharSequence myText() {
        return this.myText.get();
    }

    @Override
    final void setFirstChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child);
    }

    @Override
    final void setLastChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child);
    }

    private void ensureParsed() {
        if (!ourParsingAllowed) {
            LOG.error("Parsing not allowed!!!");
        }
        if (this.myParsed) {
            return;
        }
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (this.myParsed) {
                return;
            }
            CharSequence text2 = this.myText.get();
            assert (text2 != null);
            FileElement fileElement = TreeUtil.getFileElement(this);
            if (fileElement == null) {
                LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
            } else {
                fileElement.assertReadAccessAllowed();
            }
            if (this.rawFirstChild() != null) {
                LOG.error("Reentrant parsing?");
            }
            DebugUtil.performPsiModification("lazy-parsing", () -> {
                TreeElement parsedNode = (TreeElement)((ILazyParseableElementTypeBase)((Object)this.getElementType())).parseContents(this);
                this.assertTextLengthIntact(text2, parsedNode);
                if (parsedNode != null) {
                    this.setChildren(parsedNode);
                }
                this.myParsed = true;
                this.myText = new SoftReference<CharSequence>(text2);
            });
        }
        finally {
            this.myLock.unlock();
        }
    }

    private void assertTextLengthIntact(CharSequence text2, TreeElement child) {
        int length = 0;
        while (child != null) {
            length += child.getTextLength();
            child = child.getTreeNext();
        }
        if (length != text2.length()) {
            LOG.error("Text mismatch in " + LogUtil.objectAndClass(this.getElementType()), (Throwable)PluginException.createByClass("Text mismatch", null, this.getElementType().getClass()), new Attachment("code.txt", text2.toString()));
        }
    }

    private void setChildren(@NotNull TreeElement parsedNode) {
        if (parsedNode == null) {
            LazyParseableElement.$$$reportNull$$$0(5);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                TreeElement last = LazyParseableElement.rawSetParents(parsedNode, this);
                super.setFirstChildNode(parsedNode);
                super.setLastChildNode(last);
            }
            catch (Throwable e) {
                LOG.error("Chameleon expansion may not be interrupted by exceptions", e);
            }
        });
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (first == null) {
            LazyParseableElement.$$$reportNull$$$0(6);
        }
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon " + this.getClass());
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(char @Nullable [] buffer, int start) {
        CharSequence text2 = this.myText();
        if (text2 == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars(text2, buffer, start);
        }
        return start + text2.length();
    }

    @TestOnly
    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    private static void waitForLock(@NotNull ReentrantLock ml) {
        if (ml == null) {
            LazyParseableElement.$$$reportNull$$$0(7);
        }
        while (true) {
            try {
                if (ml.tryLock(10L, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ProgressManager.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildrenWithoutNotifications";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "waitForLock";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

