/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarations;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceSuperCallsLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "postprocessMovedThis", "irCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "backend.jvm.lower"})
final class InterfaceSuperCallsLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public InterfaceSuperCallsLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrClass superQualifierClass;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClassSymbol irClassSymbol = expression2.getSuperQualifierSymbol();
        IrClass irClass2 = superQualifierClass = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
        if (superQualifierClass == null || !IrUtilsKt.isInterface(superQualifierClass) || IrUtilsKt.isSuperToAny(expression2)) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction superCallee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (InheritedDefaultMethodsOnClassesLoweringKt.isDefinitelyNotDefaultImplsMethod$default(superCallee, this.context.getState().getJvmDefaultMode(), null, 2, null)) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction redirectTarget = JvmCachedDeclarations.getDefaultImplsFunction$default(this.context.getCachedDeclarations(), superCallee, false, 2, null);
        IrCall newCall = JvmIrUtilsKt.createDelegatingCallWithPlaceholderTypeArguments(expression2, redirectTarget, this.context.getIrBuiltIns());
        this.postprocessMovedThis(newCall);
        return super.visitCall(newCall);
    }

    private final void postprocessMovedThis(IrCall irCall) {
        Object v0;
        block2: {
            Iterable iterable = ((IrSimpleFunction)irCall.getSymbol().getOwner()).getValueParameters();
            for (Object t : iterable) {
                IrValueParameter it = (IrValueParameter)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.MOVED_DISPATCH_RECEIVER.INSTANCE)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        IrValueParameter irValueParameter = v0;
        if (irValueParameter == null) {
            return;
        }
        IrValueParameter movedThisParameter = irValueParameter;
        int movedThisParameterIndex = movedThisParameter.getIndex();
        IrExpression irExpression = irCall.getValueArgument(movedThisParameterIndex);
        irCall.putValueArgument(movedThisParameterIndex, irExpression != null ? InheritedDefaultMethodsOnClassesLoweringKt.reinterpretAsDispatchReceiverOfType(irExpression, movedThisParameter.getType()) : null);
    }
}

