/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;
import org.jetbrains.kotlin.resolve.AnnotationTargetLists;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.PlatformAnnotationFeaturesSupport;
import org.jetbrains.kotlin.resolve.UseSiteTargetsList;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J$\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J6\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J6\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020'2\b\b\u0002\u0010)\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u0004\u0018\u00010-*\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020.H\u0002J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020-0\u001a*\u0004\u0018\u00010\rH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "", "additionalCheckers", "", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "platformAnnotationFeaturesSupport", "Lorg/jetbrains/kotlin/resolve/PlatformAnnotationFeaturesSupport;", "(Ljava/lang/Iterable;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/PlatformAnnotationFeaturesSupport;)V", "check", "", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkAnnotationEntry", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/resolve/AnnotationTargetList;", "Lorg/jetbrains/kotlin/resolve/TargetList;", "checkEntries", "entries", "", "checkExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkPropertyUseSiteTargetAnnotations", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkSuperTypeAnnotations", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkTypeReference", "reference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isSuperType", "", "shouldCheckReferenceItself", "checkWithoutLanguageFeature", "isRepeatableAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getDefaultUseSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getImplicitUseSiteTargetList", "Companion", "frontend"})
public final class AnnotationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Iterable<AdditionalAnnotationChecker> additionalCheckers;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final PlatformAnnotationFeaturesSupport platformAnnotationFeaturesSupport;
    @NotNull
    private static final Name TARGET_ALLOWED_TARGETS;

    public AnnotationChecker(@NotNull Iterable<? extends AdditionalAnnotationChecker> additionalCheckers, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull PlatformAnnotationFeaturesSupport platformAnnotationFeaturesSupport) {
        Intrinsics.checkNotNullParameter(additionalCheckers, (String)"additionalCheckers");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)platformAnnotationFeaturesSupport, (String)"platformAnnotationFeaturesSupport");
        this.additionalCheckers = additionalCheckers;
        this.languageVersionSettings = languageVersionSettings;
        this.platformAnnotationFeaturesSupport = platformAnnotationFeaturesSupport;
    }

    public final void check(@NotNull KtAnnotated annotated, @NotNull BindingTrace trace, @Nullable DeclarationDescriptor descriptor2) {
        KtModifierListOwnerStub it;
        KtTypeReference it2;
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        KtElement ktElement = annotated;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        AnnotationTargetList actualTargets = Companion.getActualTargetList(ktElement, descriptor2, bindingContext);
        List<KtAnnotationEntry> list2 = annotated.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"annotated.annotationEntries");
        this.checkEntries(list2, actualTargets, trace, annotated);
        if (annotated instanceof KtProperty) {
            this.checkPropertyUseSiteTargetAnnotations((KtProperty)annotated, trace);
        }
        if (annotated instanceof KtClassOrObject) {
            this.checkSuperTypeAnnotations((KtClassOrObject)annotated, trace);
        }
        if (annotated instanceof KtCallableDeclaration) {
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)annotated).getTypeReference();
            if (ktTypeReference != null) {
                it2 = ktTypeReference;
                boolean bl = false;
                AnnotationChecker.check$default(this, it2, trace, null, 4, null);
            }
            KtTypeReference ktTypeReference2 = ((KtCallableDeclaration)annotated).getReceiverTypeReference();
            if (ktTypeReference2 != null) {
                it2 = ktTypeReference2;
                boolean bl = false;
                AnnotationChecker.check$default(this, it2, trace, null, 4, null);
            }
        }
        if (annotated instanceof KtTypeAlias) {
            KtTypeReference ktTypeReference = ((KtTypeAlias)annotated).getTypeReference();
            if (ktTypeReference != null) {
                it2 = ktTypeReference;
                boolean bl = false;
                AnnotationChecker.check$default(this, it2, trace, null, 4, null);
            }
        }
        if (annotated instanceof KtTypeParameterListOwner && (annotated instanceof KtCallableDeclaration || this.languageVersionSettings.supportsFeature(LanguageFeature.ProperCheckAnnotationsTargetInTypeUsePositions) || annotated instanceof KtClass && this.languageVersionSettings.supportsFeature(LanguageFeature.ClassTypeParameterAnnotations))) {
            if (annotated instanceof KtClass && this.languageVersionSettings.supportsFeature(LanguageFeature.ClassTypeParameterAnnotations)) {
                Object object = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
                if (object != null && (object = object.getDeclaredTypeParameters()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        TypeParameterDescriptor it3 = (TypeParameterDescriptor)element$iv;
                        boolean bl = false;
                        ForceResolveUtil.forceResolveAllContents(it3.getAnnotations());
                    }
                }
            }
            List<KtTypeParameter> list3 = ((KtTypeParameterListOwner)annotated).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"annotated.typeParameters");
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtTypeParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                AnnotationChecker.check$default(this, it, trace, null, 4, null);
            }
            for (KtTypeParameter typeParameter : ((KtTypeParameterListOwner)annotated).getTypeParameters()) {
                if (typeParameter.getExtendsBound() == null) continue;
                boolean bl = false;
                AnnotationChecker.checkTypeReference$default(this, (KtTypeReference)it, trace, false, true, annotated instanceof KtCallableDeclaration, 4, null);
            }
            for (KtTypeConstraint typeConstraint : ((KtTypeParameterListOwner)annotated).getTypeConstraints()) {
                if (typeConstraint.getBoundTypeReference() == null) continue;
                boolean bl = false;
                AnnotationChecker.checkTypeReference$default(this, (KtTypeReference)it, trace, false, true, false, 20, null);
            }
        }
        if (annotated instanceof KtTypeReference) {
            if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProperCheckAnnotationsTargetInTypeUsePositions)) {
                AnnotationChecker.checkTypeReference$default(this, (KtTypeReference)annotated, trace, false, false, false, 28, null);
            } else {
                Object object = ((KtTypeReference)annotated).getTypeElement();
                if (object != null && (object = object.getTypeArgumentsAsTypes()) != null && (object = CollectionsKt.filterNotNull((Iterable)((Iterable)object))) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KtTypeReference it4 = (KtTypeReference)element$iv;
                        boolean bl = false;
                        AnnotationChecker.check$default(this, it4, trace, null, 4, null);
                    }
                }
            }
        }
        if (annotated instanceof KtDeclarationWithBody) {
            for (KtParameter parameter : ((KtDeclarationWithBody)annotated).getValueParameters()) {
                if (parameter.hasValOrVar()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                AnnotationChecker.check$default(this, parameter, trace, null, 4, null);
                if (!(annotated instanceof KtFunctionLiteral)) continue;
                if (parameter.getTypeReference() != null) {
                    boolean bl = false;
                    AnnotationChecker.check$default(this, it, trace, null, 4, null);
                }
            }
        }
    }

    public static /* synthetic */ void check$default(AnnotationChecker annotationChecker, KtAnnotated ktAnnotated, BindingTrace bindingTrace, DeclarationDescriptor declarationDescriptor, int n, Object object) {
        if ((n & 4) != 0) {
            declarationDescriptor = null;
        }
        annotationChecker.check(ktAnnotated, bindingTrace, declarationDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    public final void checkExpression(@NotNull KtExpression expression2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        List<KtAnnotationEntry> list2 = KtPsiUtilKt.getAnnotationEntries(expression2);
        KtElement ktElement = expression2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        PsiElement psiElement = expression2.getParent();
        this.checkEntries(list2, Companion.getActualTargetList(ktElement, null, bindingContext), trace, psiElement instanceof KtAnnotated ? (KtAnnotated)psiElement : null);
        if (expression2 instanceof KtCallElement && this.languageVersionSettings.supportsFeature(LanguageFeature.ProperCheckAnnotationsTargetInTypeUsePositions)) {
            void $this$mapNotNullTo$iv$iv;
            List<KtTypeProjection> list3 = ((KtCallElement)((Object)expression2)).getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"expression.typeArguments");
            Iterable $this$mapNotNull$iv = list3;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KtTypeReference it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtTypeProjection it = (KtTypeProjection)element$iv$iv;
                boolean bl2 = false;
                if (it.getTypeReference() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List typeArguments2 = (List)destination$iv$iv;
            for (KtTypeReference typeArgument : typeArguments2) {
                List<KtAnnotationEntry> list4 = typeArgument.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue((Object)typeArgument, (String)"typeArgument");
                KtElement ktElement2 = typeArgument;
                BindingContext bindingContext2 = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"trace.bindingContext");
                AnnotationChecker.checkEntries$default(this, list4, Companion.getActualTargetList(ktElement2, null, bindingContext2), trace, null, 8, null);
            }
        }
        if (expression2 instanceof KtLambdaExpression) {
            for (KtParameter parameter : ((KtLambdaExpression)expression2).getValueParameters()) {
                if (parameter.getTypeReference() != null) {
                    KtTypeReference it;
                    boolean bl = false;
                    AnnotationChecker.check$default(this, it, trace, null, 4, null);
                }
            }
        }
    }

    private final void checkPropertyUseSiteTargetAnnotations(KtProperty property2, BindingTrace trace) {
        boolean reportError2 = this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitRepeatedUseSiteTargetAnnotations);
        Pair[] pairArray = new Pair[3];
        KtPropertyAccessor ktPropertyAccessor = property2.getGetter();
        pairArray[0] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.PROPERTY_GETTER), AnnotationChecker.checkPropertyUseSiteTargetAnnotations$getDescriptors(ktPropertyAccessor != null ? ktPropertyAccessor.getAnnotationEntries() : null, trace));
        KtPropertyAccessor ktPropertyAccessor2 = property2.getSetter();
        pairArray[1] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.PROPERTY_SETTER), AnnotationChecker.checkPropertyUseSiteTargetAnnotations$getDescriptors(ktPropertyAccessor2 != null ? ktPropertyAccessor2.getAnnotationEntries() : null, trace));
        KtDeclarationStub ktDeclarationStub = property2.getSetter();
        pairArray[2] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.SETTER_PARAMETER), AnnotationChecker.checkPropertyUseSiteTargetAnnotations$getDescriptors(ktDeclarationStub != null && (ktDeclarationStub = ((KtPropertyAccessor)ktDeclarationStub).getParameter()) != null ? ktDeclarationStub.getAnnotationEntries() : null, trace));
        Map propertyAnnotations = MapsKt.mapOf((Pair[])pairArray);
        for (KtAnnotationEntry entry : property2.getAnnotationEntries()) {
            ClassDescriptor classDescriptor;
            List existingAnnotations;
            Object useSiteTarget;
            AnnotationDescriptor descriptor2;
            if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry) == null || DescriptorUtilsKt.getAnnotationClass(descriptor2) == null) continue;
            Object object = entry.getUseSiteTarget();
            if (object == null || (object = object.getAnnotationUseSiteTarget()) == null) {
                object = this.getDefaultUseSiteTarget(property2, descriptor2);
            }
            if ((List)propertyAnnotations.get(useSiteTarget = object) == null || !existingAnnotations.contains(classDescriptor) || this.isRepeatableAnnotation(classDescriptor)) continue;
            if (reportError2) {
                SimpleDiagnostic<KtAnnotationEntry> simpleDiagnostic = Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)entry));
                Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"REPEATED_ANNOTATION.on(entry)");
                DiagnosticUtilsKt.reportDiagnosticOnce(trace, simpleDiagnostic);
                continue;
            }
            trace.report(Errors.REPEATED_ANNOTATION_WARNING.on((KtAnnotationEntry)((PsiElement)entry)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSuperTypeAnnotations(KtClassOrObject annotated, BindingTrace trace) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = annotated.getSuperTypeListEntries();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtTypeReference it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv$iv;
            boolean bl2 = false;
            if (it.getTypeReference() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (KtTypeReference superType2 : (List)destination$iv$iv) {
            Intrinsics.checkNotNullExpressionValue((Object)superType2, (String)"superType");
            AnnotationChecker.checkTypeReference$default(this, superType2, trace, true, false, false, 24, null);
        }
    }

    private final void checkTypeReference(KtTypeReference reference, BindingTrace trace, boolean isSuperType, boolean shouldCheckReferenceItself, boolean checkWithoutLanguageFeature) {
        Object object;
        boolean shouldRunCheck;
        boolean bl = shouldRunCheck = isSuperType || shouldCheckReferenceItself;
        if (shouldRunCheck) {
            for (KtAnnotationEntry entry : reference.getAnnotationEntries()) {
                AnnotationDescriptor descriptor2 = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
                if (descriptor2 instanceof LazyAnnotationDescriptor) {
                    ((LazyAnnotationDescriptor)descriptor2).forceResolveAllContents();
                }
                KtElement ktElement = reference;
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                AnnotationTargetList actualTargets = Companion.getActualTargetList(ktElement, null, bindingContext);
                if (entry.getUseSiteTarget() != null && isSuperType) {
                    trace.report(Errors.ANNOTATION_ON_SUPERCLASS.on(this.languageVersionSettings, (KtAnnotationEntry)((PsiElement)entry)));
                    continue;
                }
                if (!shouldRunCheck || !this.languageVersionSettings.supportsFeature(LanguageFeature.ProperCheckAnnotationsTargetInTypeUsePositions) && !checkWithoutLanguageFeature) continue;
                this.checkAnnotationEntry(entry, actualTargets, trace);
            }
        }
        if ((object = reference.getTypeElement()) == null || (object = object.getTypeArgumentsAsTypes()) == null) {
            return;
        }
        Object typeArguments2 = object;
        Iterator iterator2 = typeArguments2.iterator();
        while (iterator2.hasNext()) {
            KtTypeReference it;
            KtTypeReference typeArgument = (KtTypeReference)iterator2.next();
            if (typeArgument == null) continue;
            boolean bl2 = false;
            AnnotationChecker.checkTypeReference$default(this, it, trace, false, true, false, 20, null);
        }
    }

    static /* synthetic */ void checkTypeReference$default(AnnotationChecker annotationChecker, KtTypeReference ktTypeReference, BindingTrace bindingTrace, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        annotationChecker.checkTypeReference(ktTypeReference, bindingTrace, bl, bl2, bl3);
    }

    private final List<AnnotationUseSiteTarget> getImplicitUseSiteTargetList(KtAnnotated $this$getImplicitUseSiteTargetList) {
        KtAnnotated ktAnnotated = $this$getImplicitUseSiteTargetList;
        return ktAnnotated instanceof KtParameter ? (((KtParameter)$this$getImplicitUseSiteTargetList).getOwnerFunction() instanceof KtPrimaryConstructor ? UseSiteTargetsList.INSTANCE.getT_CONSTRUCTOR_PARAMETER() : CollectionsKt.emptyList()) : (ktAnnotated instanceof KtProperty ? (!((KtProperty)$this$getImplicitUseSiteTargetList).isLocal() ? UseSiteTargetsList.INSTANCE.getT_PROPERTY() : CollectionsKt.emptyList()) : (ktAnnotated instanceof KtPropertyAccessor ? (((KtPropertyAccessor)$this$getImplicitUseSiteTargetList).isGetter() ? CollectionsKt.listOf((Object)((Object)AnnotationUseSiteTarget.PROPERTY_GETTER)) : CollectionsKt.listOf((Object)((Object)AnnotationUseSiteTarget.PROPERTY_SETTER))) : CollectionsKt.emptyList()));
    }

    private final AnnotationUseSiteTarget getDefaultUseSiteTarget(KtAnnotated $this$getDefaultUseSiteTarget, AnnotationDescriptor descriptor2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.getImplicitUseSiteTargetList($this$getDefaultUseSiteTarget);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationUseSiteTarget it = (AnnotationUseSiteTarget)((Object)element$iv);
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)Companion.applicableTargetSet(descriptor2), (Object)((Object)KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)it)))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void checkEntries(List<? extends KtAnnotationEntry> entries, AnnotationTargetList actualTargets, BindingTrace trace, KtAnnotated annotated) {
        if (entries.isEmpty()) {
            return;
        }
        entryTypesWithAnnotations = new HashMap<K, V>();
        for (KtAnnotationEntry entry : entries) {
            block14: {
                this.checkAnnotationEntry(entry, actualTargets, trace);
                if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry) == null) continue;
                if (descriptor instanceof LazyAnnotationDescriptor) {
                    ((LazyAnnotationDescriptor)descriptor).forceResolveAllContents();
                }
                contextReceiversSupported = this.languageVersionSettings.supportsFeature(LanguageFeature.ContextReceivers);
                if (Intrinsics.areEqual((Object)descriptor.getFqName(), (Object)new FqName("kotlin.ContextFunctionTypeParams")) && !contextReceiversSupported) {
                    trace.report(Errors.UNSUPPORTED_FEATURE.on(entry, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)LanguageFeature.ContextReceivers, (Object)this.languageVersionSettings)));
                }
                if (DescriptorUtilsKt.getAnnotationClass(descriptor) == null) continue;
                v0 /* !! */  = entry.getUseSiteTarget();
                if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getAnnotationUseSiteTarget()) == null) {
                    v0 /* !! */  = this.getDefaultUseSiteTarget(annotated, descriptor);
                }
                useSiteTarget /* !! */  = v0 /* !! */ ;
                var13_14 = entryTypesWithAnnotations;
                key$iv = descriptor.getType();
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    $i$a$-getOrPut-AnnotationChecker$checkEntries$existingTargetsForAnnotation$1 = false;
                    answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    v1 /* !! */  = answer$iv;
                } else {
                    v1 /* !! */  = value$iv;
                }
                if ((existingTargetsForAnnotation = (List)v1 /* !! */ ).contains(useSiteTarget /* !! */ )) ** GOTO lbl-1000
                $this$any$iv = existingTargetsForAnnotation;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (AnnotationUseSiteTarget)element$iv;
                        $i$a$-any-AnnotationChecker$checkEntries$duplicateAnnotation$1 = false;
                        if (!(it == null != (useSiteTarget /* !! */  == null))) continue;
                        v2 = true;
                        break block14;
                    }
                    v2 = false;
                }
            }
            if (v2) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = duplicateAnnotation = false;
            }
            if (duplicateAnnotation && !this.isRepeatableAnnotation(classDescriptor)) {
                trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)entry)));
            }
            existingTargetsForAnnotation.add(useSiteTarget /* !! */ );
        }
        for (AdditionalAnnotationChecker checker : this.additionalCheckers) {
            checker.checkEntries(entries, actualTargets.getDefaultTargets(), trace, annotated, this.languageVersionSettings);
        }
    }

    static /* synthetic */ void checkEntries$default(AnnotationChecker annotationChecker, List list2, AnnotationTargetList annotationTargetList, BindingTrace bindingTrace, KtAnnotated ktAnnotated, int n, Object object) {
        if ((n & 8) != 0) {
            ktAnnotated = null;
        }
        annotationChecker.checkEntries(list2, annotationTargetList, bindingTrace, ktAnnotated);
    }

    private final void checkAnnotationEntry(KtAnnotationEntry entry, AnnotationTargetList actualTargets, BindingTrace trace) {
        AnnotationUseSiteTarget useSiteTarget;
        Set applicableTargets = AnnotationChecker.Companion.applicableTargetSet(entry, trace);
        KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = entry.getUseSiteTarget();
        AnnotationUseSiteTarget annotationUseSiteTarget = useSiteTarget = ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null;
        if (AnnotationChecker.checkAnnotationEntry$check(applicableTargets, useSiteTarget, actualTargets.getDefaultTargets()) || AnnotationChecker.checkAnnotationEntry$check(applicableTargets, useSiteTarget, actualTargets.getCanBeSubstituted()) || AnnotationChecker.checkAnnotationEntry$checkWithUseSiteTargets(useSiteTarget, actualTargets, applicableTargets)) {
            AnnotationChecker.checkAnnotationEntry$checkUselessFunctionLiteralAnnotation(applicableTargets, entry, trace);
            return;
        }
        if (useSiteTarget != null) {
            PsiElement psiElement = entry;
            Object object = (KotlinTarget)((Object)CollectionsKt.firstOrNull(actualTargets.getDefaultTargets()));
            if (object == null || (object = object.getDescription()) == null) {
                object = "unidentified target";
            }
            trace.report(Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET.on((KtAnnotationEntry)psiElement, (String)object, useSiteTarget.getRenderName()));
        } else {
            PsiElement psiElement = entry;
            Object object = (KotlinTarget)((Object)CollectionsKt.firstOrNull(actualTargets.getDefaultTargets()));
            if (object == null || (object = object.getDescription()) == null) {
                object = "unidentified target";
            }
            trace.report(Errors.WRONG_ANNOTATION_TARGET.on((KtAnnotationEntry)psiElement, (String)object));
        }
    }

    private final boolean isRepeatableAnnotation(ClassDescriptor descriptor2) {
        return DescriptorUtilsKt.isAnnotatedWithKotlinRepeatable(descriptor2) || this.platformAnnotationFeaturesSupport.isRepeatableAnnotationClass(descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ClassDescriptor> checkPropertyUseSiteTargetAnnotations$getDescriptors(List<? extends KtAnnotationEntry> $this$checkPropertyUseSiteTargetAnnotations_u24getDescriptors, BindingTrace $trace) {
        List list2;
        List<? extends KtAnnotationEntry> list3 = $this$checkPropertyUseSiteTargetAnnotations_u24getDescriptors;
        if (list3 != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list3;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ClassDescriptor classDescriptor;
                AnnotationDescriptor annotationDescriptor;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
                boolean bl2 = false;
                AnnotationDescriptor annotationDescriptor2 = annotationDescriptor = (AnnotationDescriptor)$trace.get(BindingContext.ANNOTATION, it);
                if (annotationDescriptor2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)annotationDescriptor2, (String)"get(BindingContext.ANNOTATION, it)");
                    classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
                } else {
                    classDescriptor = null;
                }
                if (classDescriptor == null) continue;
                ClassDescriptor it$iv$iv = classDescriptor;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final boolean checkAnnotationEntry$check(Set<? extends KotlinTarget> applicableTargets, AnnotationUseSiteTarget useSiteTarget, List<? extends KotlinTarget> targets) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && (useSiteTarget == null || KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget) == it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void checkAnnotationEntry$checkUselessFunctionLiteralAnnotation(Set<? extends KotlinTarget> applicableTargets, KtAnnotationEntry $entry, BindingTrace $trace) {
        KotlinRetention retention;
        if (!applicableTargets.contains((Object)KotlinTarget.FUNCTION)) {
            return;
        }
        PsiElement psiElement = $entry.getParent();
        KtAnnotatedExpression ktAnnotatedExpression = psiElement instanceof KtAnnotatedExpression ? (KtAnnotatedExpression)psiElement : null;
        if (ktAnnotatedExpression == null) {
            return;
        }
        KtAnnotatedExpression annotatedExpression = ktAnnotatedExpression;
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)$trace.get(BindingContext.ANNOTATION, $entry);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor descriptor2 = annotationDescriptor;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(descriptor2);
        KotlinRetention kotlinRetention = retention = classDescriptor != null ? DescriptorUtilsKt.getAnnotationRetention(classDescriptor) : null;
        if (retention == KotlinRetention.SOURCE) {
            return;
        }
        KtExpression ktExpression = annotatedExpression.getBaseExpression();
        KtLambdaExpression ktLambdaExpression = ktExpression instanceof KtLambdaExpression ? (KtLambdaExpression)ktExpression : null;
        if (ktLambdaExpression == null) {
            return;
        }
        KtLambdaExpression functionLiteralExpression = ktLambdaExpression;
        if (InlineUtil.isInlinedArgument(functionLiteralExpression.getFunctionLiteral(), $trace.getBindingContext(), false)) {
            $trace.report(Errors.NON_SOURCE_ANNOTATION_ON_INLINED_LAMBDA_EXPRESSION.on((KtAnnotationEntry)((PsiElement)$entry)));
        }
    }

    private static final boolean checkAnnotationEntry$checkWithUseSiteTargets(AnnotationUseSiteTarget useSiteTarget, AnnotationTargetList $actualTargets, Set<? extends KotlinTarget> applicableTargets) {
        boolean bl;
        block4: {
            if (useSiteTarget == null) {
                return false;
            }
            KotlinTarget useSiteMapping = KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget);
            Iterable $this$any$iv = $actualTargets.getOnlyWithUseSiteTarget();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && it == useSiteMapping)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final Set<KotlinTarget> applicableTargetSet(@NotNull AnnotationDescriptor descriptor2) {
        return Companion.applicableTargetSet(descriptor2);
    }

    static {
        Name name = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"allowedTargets\")");
        TARGET_ALLOWED_TARGETS = name;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ$\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u000bJ\u0016\u0010\u001d\u001a\u00020\u001e*\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion;", "", "()V", "TARGET_ALLOWED_TARGETS", "Lorg/jetbrains/kotlin/name/Name;", "applicableTargetSet", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "applicableTargetSetFromTargetAnnotationOrNull", "getActualTargetList", "Lorg/jetbrains/kotlin/resolve/AnnotationTargetList;", "Lorg/jetbrains/kotlin/resolve/TargetList;", "annotated", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDeclarationSiteActualTargetList", "", "loadAnnotationTargets", "targetEntryDescriptor", "hasBackingField", "", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<KotlinTarget> applicableTargetSet(KtAnnotationEntry entry, BindingTrace trace) {
            Object object;
            block6: {
                block5: {
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
                    if (annotationDescriptor == null) {
                        return KotlinTarget.Companion.getDEFAULT_TARGET_SET();
                    }
                    AnnotationDescriptor descriptor2 = annotationDescriptor;
                    if (KotlinTypeKt.isError(descriptor2.getType())) {
                        return KotlinTarget.Companion.getALL_TARGET_SET();
                    }
                    object = DescriptorUtilsKt.getAnnotationClass(descriptor2);
                    if (object == null) break block5;
                    ClassDescriptor p0 = object;
                    boolean bl = false;
                    Set<KotlinTarget> set = this.applicableTargetSetFromTargetAnnotationOrNull(p0);
                    object = set;
                    if (set != null) break block6;
                }
                object = KotlinTarget.Companion.getDEFAULT_TARGET_SET();
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public final Set<KotlinTarget> applicableTargetSet(@NotNull AnnotationDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(descriptor2);
            if (classDescriptor == null) {
                return SetsKt.emptySet();
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            return this.applicableTargetSet(classDescriptor2);
        }

        @NotNull
        public final Set<KotlinTarget> applicableTargetSet(@NotNull ClassDescriptor classDescriptor) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
                    AnnotationDescriptor targetEntryDescriptor = classDescriptor.getAnnotations().findAnnotation(StandardNames.FqNames.target);
                    object = targetEntryDescriptor;
                    if (object == null) break block2;
                    AnnotationDescriptor it = object;
                    boolean bl = false;
                    Set<KotlinTarget> set = Companion.loadAnnotationTargets(it);
                    object = set;
                    if (set != null) break block3;
                }
                object = KotlinTarget.Companion.getDEFAULT_TARGET_SET();
            }
            return object;
        }

        @Nullable
        public final Set<KotlinTarget> applicableTargetSetFromTargetAnnotationOrNull(@NotNull ClassDescriptor classDescriptor) {
            Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
            AnnotationDescriptor annotationDescriptor = classDescriptor.getAnnotations().findAnnotation(StandardNames.FqNames.target);
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor targetEntryDescriptor = annotationDescriptor;
            return this.loadAnnotationTargets(targetEntryDescriptor);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Set<KotlinTarget> loadAnnotationTargets(@NotNull AnnotationDescriptor targetEntryDescriptor) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)targetEntryDescriptor, (String)"targetEntryDescriptor");
            ConstantValue<?> constantValue = targetEntryDescriptor.getAllValueArguments().get(TARGET_ALLOWED_TARGETS);
            ArrayValue arrayValue = constantValue instanceof ArrayValue ? (ArrayValue)constantValue : null;
            if (arrayValue == null) {
                return null;
            }
            ArrayValue valueArgument = arrayValue;
            Iterable $this$filterIsInstance$iv = (Iterable)valueArgument.getValue();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof EnumValue)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KotlinTarget it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                EnumValue it = (EnumValue)element$iv$iv;
                boolean bl2 = false;
                String string2 = it.getEnumEntryName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.enumEntryName.asString()");
                if (KotlinTarget.Companion.valueOrNull(string2) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        @NotNull
        public final List<KotlinTarget> getDeclarationSiteActualTargetList(@NotNull KtElement annotated, @Nullable ClassDescriptor descriptor2, @NotNull BindingContext context2) {
            Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return this.getActualTargetList(annotated, descriptor2, context2).getDefaultTargets();
        }

        private final boolean hasBackingField(DeclarationDescriptor $this$hasBackingField, BindingContext context2) {
            Object object;
            block3: {
                block2: {
                    object = $this$hasBackingField instanceof PropertyDescriptor ? (PropertyDescriptor)$this$hasBackingField : null;
                    if (object == null) break block2;
                    PropertyDescriptor it = object;
                    boolean bl = false;
                    Boolean bl2 = (Boolean)context2.get(BindingContext.BACKING_FIELD_REQUIRED, it);
                    object = bl2;
                    if (bl2 != null) break block3;
                }
                object = false;
            }
            return (Boolean)object;
        }

        @NotNull
        public final AnnotationTargetList getActualTargetList(@NotNull KtElement annotated, @Nullable DeclarationDescriptor descriptor2, @NotNull BindingContext context2) {
            AnnotationTargetList annotationTargetList;
            Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            KtElement ktElement = annotated;
            if (ktElement instanceof KtClassOrObject) {
                ClassDescriptor classDescriptor = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
                if (classDescriptor != null) {
                    ClassDescriptor it = classDescriptor;
                    boolean bl = false;
                    ClassKind classKind = it.getKind();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)classKind), (String)"it.kind");
                    annotationTargetList = new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(classKind, it.isInner(), it.isCompanionObject(), DescriptorUtils.isLocal(it)), null, null, 6, null);
                } else {
                    annotationTargetList = AnnotationTargetLists.INSTANCE.getT_CLASSIFIER();
                }
            } else if (ktElement instanceof KtDestructuringDeclarationEntry) {
                annotationTargetList = AnnotationTargetLists.INSTANCE.getT_LOCAL_VARIABLE();
            } else if (ktElement instanceof KtProperty) {
                annotationTargetList = ((KtProperty)annotated).isLocal() ? AnnotationTargetLists.INSTANCE.getT_LOCAL_VARIABLE() : (((KtProperty)annotated).isMember() ? AnnotationTargetLists.INSTANCE.T_MEMBER_PROPERTY(this.hasBackingField(descriptor2, context2), ((KtProperty)annotated).hasDelegate()) : AnnotationTargetLists.INSTANCE.T_TOP_LEVEL_PROPERTY(this.hasBackingField(descriptor2, context2), ((KtProperty)annotated).hasDelegate()));
            } else if (ktElement instanceof KtParameter) {
                KtDestructuringDeclaration destructuringDeclaration = ((KtParameter)annotated).getDestructuringDeclaration();
                annotationTargetList = destructuringDeclaration != null ? AnnotationTargetLists.INSTANCE.getT_DESTRUCTURING_DECLARATION() : (((KtParameter)annotated).hasValOrVar() ? AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITH_VAL() : AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITHOUT_VAL());
            } else {
                annotationTargetList = ktElement instanceof KtConstructor ? AnnotationTargetLists.INSTANCE.getT_CONSTRUCTOR() : (ktElement instanceof KtFunction ? (ExpressionTypingUtils.isFunctionExpression(descriptor2) ? AnnotationTargetLists.INSTANCE.getT_FUNCTION_EXPRESSION() : (((KtFunction)annotated).isLocal() ? AnnotationTargetLists.INSTANCE.getT_LOCAL_FUNCTION() : (((KtFunction)annotated).getParent() instanceof KtClassOrObject || ((KtFunction)annotated).getParent() instanceof KtClassBody ? AnnotationTargetLists.INSTANCE.getT_MEMBER_FUNCTION() : AnnotationTargetLists.INSTANCE.getT_TOP_LEVEL_FUNCTION()))) : (ktElement instanceof KtTypeAlias ? AnnotationTargetLists.INSTANCE.getT_TYPEALIAS() : (ktElement instanceof KtPropertyAccessor ? (((KtPropertyAccessor)annotated).isGetter() ? AnnotationTargetLists.INSTANCE.getT_PROPERTY_GETTER() : AnnotationTargetLists.INSTANCE.getT_PROPERTY_SETTER()) : (ktElement instanceof KtTypeReference ? AnnotationTargetLists.INSTANCE.getT_TYPE_REFERENCE() : (ktElement instanceof KtFile ? AnnotationTargetLists.INSTANCE.getT_FILE() : (ktElement instanceof KtTypeParameter ? AnnotationTargetLists.INSTANCE.getT_TYPE_PARAMETER() : (ktElement instanceof KtTypeProjection ? (((KtTypeProjection)annotated).getProjectionKind() == KtProjectionKind.STAR ? AnnotationTargetLists.INSTANCE.getT_STAR_PROJECTION() : AnnotationTargetLists.INSTANCE.getT_TYPE_PROJECTION()) : (ktElement instanceof KtAnonymousInitializer ? AnnotationTargetLists.INSTANCE.getT_INITIALIZER() : (ktElement instanceof KtDestructuringDeclaration ? AnnotationTargetLists.INSTANCE.getT_DESTRUCTURING_DECLARATION() : (ktElement instanceof KtLambdaExpression ? AnnotationTargetLists.INSTANCE.getT_FUNCTION_LITERAL() : (ktElement instanceof KtObjectLiteralExpression ? AnnotationTargetLists.INSTANCE.getT_OBJECT_LITERAL() : (ktElement instanceof KtExpression ? AnnotationTargetLists.INSTANCE.getT_EXPRESSION() : AnnotationTargetLists.INSTANCE.getEMPTY()))))))))))));
            }
            return annotationTargetList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

