/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"getUnboxedType", "Lorg/jetbrains/org/objectweb/asm/Type;", "boxedType", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "isInlineClassValue", "", "unboxedTypeOfInlineClass", "backend"})
public final class BoxedBasicValueKt {
    @NotNull
    public static final Type getUnboxedType(@NotNull Type boxedType, @NotNull GenerationState state) {
        Intrinsics.checkNotNullParameter((Object)boxedType, (String)"boxedType");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Type primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType);
        if (primitiveType != null) {
            return primitiveType;
        }
        if (Intrinsics.areEqual((Object)boxedType, (Object)AsmTypes.K_CLASS_TYPE)) {
            Type type2 = AsmTypes.JAVA_CLASS_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"JAVA_CLASS_TYPE");
            return type2;
        }
        Type type3 = BoxedBasicValueKt.unboxedTypeOfInlineClass(boxedType, state);
        if (type3 != null) {
            Type type4;
            Type it = type4 = type3;
            boolean bl = false;
            return it;
        }
        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Expected primitive type wrapper or KClass or inline class wrapper, got: ", (Object)boxedType));
    }

    @Nullable
    public static final Type unboxedTypeOfInlineClass(@NotNull Type boxedType, @NotNull GenerationState state) {
        ClassDescriptor classDescriptor;
        ClassDescriptor classDescriptor2;
        Intrinsics.checkNotNullParameter((Object)boxedType, (String)"boxedType");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ClassDescriptor classDescriptor3 = (ClassDescriptor)CollectionsKt.singleOrNull(state.getJvmBackendClassResolver().resolveToClassDescriptors(boxedType));
        if (classDescriptor3 == null) {
            classDescriptor2 = null;
        } else {
            ClassDescriptor classDescriptor4;
            ClassDescriptor it = classDescriptor4 = classDescriptor3;
            boolean bl = false;
            classDescriptor2 = classDescriptor = InlineClassesUtilsKt.isInlineClass(it) ? classDescriptor4 : null;
        }
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        return (Type)state.getMapInlineClass().invoke(descriptor2);
    }

    private static final boolean isInlineClassValue(Type boxedType) {
        return !AsmUtil.isBoxedPrimitiveType(boxedType) && !Intrinsics.areEqual((Object)boxedType, (Object)AsmTypes.K_CLASS_TYPE);
    }

    public static final /* synthetic */ boolean access$isInlineClassValue(Type boxedType) {
        return BoxedBasicValueKt.isInlineClassValue(boxedType);
    }
}

