/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.JsAnnotations;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0004*\u00020\u0007\u001a\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\t*\u00020\n\u001a\f\u0010\f\u001a\u0004\u0018\u00010\t*\u00020\n\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\t*\u00020\n\u001a\n\u0010\u0011\u001a\u00020\t*\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0003*\u00020\n\u001a\n\u0010\u0013\u001a\u00020\u0003*\u00020\n\u001a\n\u0010\u0014\u001a\u00020\u0003*\u00020\n\u001a\n\u0010\u0015\u001a\u00020\u0003*\u00020\n\u001a\n\u0010\u0016\u001a\u00020\u0003*\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\u00a8\u0006\u0017"}, d2={"associatedObjectKeyAnnotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "isAssociatedObjectAnnotatedAnnotation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "associatedObject", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "getJsFunAnnotation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "getJsModule", "getJsName", "getJsNameOrKotlinName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getJsQualifier", "getSingleConstStringArgument", "isJsExport", "isJsNativeGetter", "isJsNativeInvoke", "isJsNativeSetter", "isJsNonModule", "backend.js"})
public final class AnnotationUtilsKt {
    @NotNull
    private static final FqName associatedObjectKeyAnnotationFqName = new FqName("kotlin.reflect.AssociatedObjectKey");

    @NotNull
    public static final String getSingleConstStringArgument(@NotNull IrConstructorCall $this$getSingleConstStringArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$getSingleConstStringArgument, (String)"<this>");
        IrExpression irExpression = $this$getSingleConstStringArgument.getValueArgument(0);
        if (irExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<kotlin.String>");
        }
        return (String)((IrConst)irExpression).getValue();
    }

    @Nullable
    public static final String getJsModule(@NotNull IrAnnotationContainer $this$getJsModule) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsModule, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsModule, JsAnnotations.INSTANCE.getJsModuleFqn());
        return irConstructorCall == null ? null : AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall);
    }

    public static final boolean isJsNonModule(@NotNull IrAnnotationContainer $this$isJsNonModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsNonModule, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsNonModule, JsAnnotations.INSTANCE.getJsNonModuleFqn());
    }

    @Nullable
    public static final String getJsQualifier(@NotNull IrAnnotationContainer $this$getJsQualifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsQualifier, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsQualifier, JsAnnotations.INSTANCE.getJsQualifierFqn());
        return irConstructorCall == null ? null : AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall);
    }

    @Nullable
    public static final String getJsName(@NotNull IrAnnotationContainer $this$getJsName) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsName, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsName, JsAnnotations.INSTANCE.getJsNameFqn());
        return irConstructorCall == null ? null : AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall);
    }

    @Nullable
    public static final String getJsFunAnnotation(@NotNull IrAnnotationContainer $this$getJsFunAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsFunAnnotation, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsFunAnnotation, JsAnnotations.INSTANCE.getJsFunFqn());
        return irConstructorCall == null ? null : AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall);
    }

    public static final boolean isJsExport(@NotNull IrAnnotationContainer $this$isJsExport) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsExport, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsExport, JsAnnotations.INSTANCE.getJsExportFqn());
    }

    public static final boolean isJsNativeGetter(@NotNull IrAnnotationContainer $this$isJsNativeGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsNativeGetter, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsNativeGetter, JsAnnotations.INSTANCE.getJsNativeGetter());
    }

    public static final boolean isJsNativeSetter(@NotNull IrAnnotationContainer $this$isJsNativeSetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsNativeSetter, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsNativeSetter, JsAnnotations.INSTANCE.getJsNativeSetter());
    }

    public static final boolean isJsNativeInvoke(@NotNull IrAnnotationContainer $this$isJsNativeInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsNativeInvoke, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsNativeInvoke, JsAnnotations.INSTANCE.getJsNativeInvoke());
    }

    @NotNull
    public static final Name getJsNameOrKotlinName(@NotNull IrDeclarationWithName $this$getJsNameOrKotlinName) {
        Name name;
        Intrinsics.checkNotNullParameter((Object)$this$getJsNameOrKotlinName, (String)"<this>");
        String jsName = AnnotationUtilsKt.getJsName($this$getJsNameOrKotlinName);
        if (jsName == null) {
            name = $this$getJsNameOrKotlinName.getName();
        } else {
            Name name2 = Name.identifier(jsName);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(jsName)");
            name = name2;
        }
        return name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAssociatedObjectAnnotatedAnnotation(@NotNull IrClass $this$isAssociatedObjectAnnotatedAnnotation) {
        IrConstructorCall it;
        Intrinsics.checkNotNullParameter((Object)$this$isAssociatedObjectAnnotatedAnnotation, (String)"<this>");
        if (!IrUtilsKt.isAnnotationClass($this$isAssociatedObjectAnnotatedAnnotation)) return false;
        Iterable $this$any$iv = $this$isAssociatedObjectAnnotatedAnnotation.getAnnotations();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (IrConstructorCall)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)it.getSymbol().getOwner())), (Object)associatedObjectKeyAnnotationFqName));
        return true;
    }

    @Nullable
    public static final IrClass associatedObject(@NotNull IrConstructorCall $this$associatedObject) {
        IrClassSymbol irClassSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$associatedObject, (String)"<this>");
        if (!AnnotationUtilsKt.isAssociatedObjectAnnotatedAnnotation(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)$this$associatedObject.getSymbol().getOwner()))) {
            return null;
        }
        IrExpression irExpression = $this$associatedObject.getValueArgument(0);
        IrClassReference irClassReference = irExpression instanceof IrClassReference ? (IrClassReference)irExpression : null;
        IrClassifierSymbol irClassifierSymbol = irClassReference == null ? null : irClassReference.getSymbol();
        IrClassSymbol irClassSymbol2 = irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (irClassSymbol == null) {
            return null;
        }
        IrClass klass = (IrClass)irClassSymbol.getOwner();
        return IrUtilsKt.isObject(klass) ? klass : null;
    }
}

