/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.collectors.CheckerRunningDiagnosticCollectorVisitor;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH$R&\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "createComponents", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lkotlin/jvm/functions/Function1;)V", "getCreateComponents", "()Lkotlin/jvm/functions/Function1;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "collectDiagnostics", "", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "reporter", "createVisitor", "Lorg/jetbrains/kotlin/fir/analysis/collectors/CheckerRunningDiagnosticCollectorVisitor;", "components", "Companion", "checkers"})
public abstract class AbstractDiagnosticCollector
implements SessionHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final Function1<DiagnosticReporter, List<AbstractDiagnosticCollectorComponent>> createComponents;
    @NotNull
    public static final String SUPPRESS_ALL_INFOS = "infos";
    @NotNull
    public static final String SUPPRESS_ALL_WARNINGS = "warnings";
    @NotNull
    public static final String SUPPRESS_ALL_ERRORS = "errors";

    public AbstractDiagnosticCollector(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull Function1<? super DiagnosticReporter, ? extends List<? extends AbstractDiagnosticCollectorComponent>> createComponents) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter(createComponents, (String)"createComponents");
        this.session = session2;
        this.scopeSession = scopeSession;
        this.createComponents = createComponents;
    }

    public /* synthetic */ AbstractDiagnosticCollector(FirSession firSession, ScopeSession scopeSession, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scopeSession = new ScopeSession();
        }
        this(firSession, scopeSession, (Function1<? super DiagnosticReporter, ? extends List<? extends AbstractDiagnosticCollectorComponent>>)function1);
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    protected final Function1<DiagnosticReporter, List<AbstractDiagnosticCollectorComponent>> getCreateComponents() {
        return this.createComponents;
    }

    public final void collectDiagnostics(@NotNull FirDeclaration firDeclaration, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)firDeclaration, (String)"firDeclaration");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        List components2 = (List)this.createComponents.invoke((Object)reporter);
        CheckerRunningDiagnosticCollectorVisitor visitor2 = this.createVisitor(components2);
        firDeclaration.accept(visitor2, null);
    }

    @NotNull
    protected abstract CheckerRunningDiagnosticCollectorVisitor createVisitor(@NotNull List<? extends AbstractDiagnosticCollectorComponent> var1);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector$Companion;", "", "()V", "SUPPRESS_ALL_ERRORS", "", "SUPPRESS_ALL_INFOS", "SUPPRESS_ALL_WARNINGS", "getDiagnosticsSuppressedForContainer", "", "annotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<String> getDiagnosticsSuppressedForContainer(@NotNull FirAnnotationContainer annotationContainer) {
            void $this$flatMapTo$iv$iv;
            ConeClassLikeType type2;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)annotationContainer, (String)"annotationContainer");
            Iterable $this$filter$iv = annotationContainer.getAnnotations();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                ConeClassLikeType coneClassLikeType;
                FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
                boolean bl2 = false;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef());
                ConeClassLikeType coneClassLikeType2 = coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                if (coneClassLikeType == null) {
                    bl = false;
                } else {
                    type2 = coneClassLikeType;
                    bl = Intrinsics.areEqual((Object)type2.getLookupTag().getClassId(), (Object)StandardClassIds.INSTANCE.getSuppress());
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List annotations2 = (List)destination$iv$iv;
            if (annotations2.isEmpty()) {
                return null;
            }
            Iterable $this$flatMap$iv = annotations2;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$flatMapTo$iv$iv2;
                void $this$flatMap$iv2;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                FirAnnotationCall annotationCall = (FirAnnotationCall)element$iv$iv;
                boolean bl = false;
                Object $this$arguments$iv = annotationCall;
                boolean $i$f$getArguments = false;
                $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$filterIsInstance = false;
                type2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv2 instanceof FirVarargArgumentsExpression)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$flatMap2 = false;
                $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv2;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                    void $this$mapNotNullTo$iv$iv;
                    FirVarargArgumentsExpression varargArgument = (FirVarargArgumentsExpression)element$iv$iv2;
                    boolean bl3 = false;
                    Iterable $this$mapNotNull$iv = varargArgument.getArguments();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        String string2;
                        String string3;
                        Object element$iv$iv$iv;
                        Object element$iv$iv3 = element$iv$iv$iv = iterator2.next();
                        boolean bl4 = false;
                        FirExpression it = (FirExpression)element$iv$iv3;
                        boolean bl5 = false;
                        FirConstExpression firConstExpression = it instanceof FirConstExpression ? (FirConstExpression)it : null;
                        Object var35_36 = firConstExpression == null ? null : firConstExpression.getValue();
                        String string4 = string3 = var35_36 instanceof String ? (String)var35_36 : null;
                        if (string3 == null) continue;
                        String it$iv$iv = string2 = string3;
                        boolean bl6 = false;
                        destination$iv$iv3.add(it$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

