/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.serialization.JvmIdSignatureDescriptor;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.AbstractFirAnalyzerFacade;
import org.jetbrains.kotlin.fir.analysis.collectors.FirDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.SimpleDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterFactory;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.impl.BaseDiagnosticReporter;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import org.jetbrains.kotlin.fir.backend.jvm.Fir2IrJvmSpecialAnnotationSymbolProvider;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmKotlinMangler;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmVisibilityConverter;
import org.jetbrains.kotlin.fir.builder.PsiHandlingMode;
import org.jetbrains.kotlin.fir.builder.RawFirBuilder;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.LightTree2Fir;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessor;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmDescriptorMangler;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorExtensions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120\u0013H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/FirAnalyzerFacade;", "Lorg/jetbrains/kotlin/fir/analysis/AbstractFirAnalyzerFacade;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "originalFiles", "Ljava/io/File;", "useLightTree", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Ljava/util/Collection;Ljava/util/Collection;Z)V", "_scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "collectedDiagnostics", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "firFiles", "getKtFiles", "()Ljava/util/Collection;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getOriginalFiles", "scopeSession", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getUseLightTree", "()Z", "buildRawFir", "", "convertToIr", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrResult;", "extensions", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions;", "runCheckers", "runResolution", "entrypoint"})
public final class FirAnalyzerFacade
extends AbstractFirAnalyzerFacade {
    @NotNull
    private final FirSession session;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Collection<KtFile> ktFiles;
    @NotNull
    private final Collection<File> originalFiles;
    private final boolean useLightTree;
    @Nullable
    private List<? extends FirFile> firFiles;
    @Nullable
    private ScopeSession _scopeSession;
    @Nullable
    private Map<FirFile, ? extends List<? extends FirDiagnostic>> collectedDiagnostics;

    public FirAnalyzerFacade(@NotNull FirSession session2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Collection<? extends KtFile> ktFiles, @NotNull Collection<? extends File> originalFiles, boolean useLightTree) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        Intrinsics.checkNotNullParameter(originalFiles, (String)"originalFiles");
        this.session = session2;
        this.languageVersionSettings = languageVersionSettings;
        this.ktFiles = ktFiles;
        this.originalFiles = originalFiles;
        this.useLightTree = useLightTree;
    }

    public /* synthetic */ FirAnalyzerFacade(FirSession firSession, LanguageVersionSettings languageVersionSettings, Collection collection, Collection collection2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(firSession, languageVersionSettings, collection, collection2, bl);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final Collection<KtFile> getKtFiles() {
        return this.ktFiles;
    }

    @NotNull
    public final Collection<File> getOriginalFiles() {
        return this.originalFiles;
    }

    public final boolean getUseLightTree() {
        return this.useLightTree;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        ScopeSession scopeSession = this._scopeSession;
        Intrinsics.checkNotNull((Object)scopeSession);
        return scopeSession;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRawFir() {
        List list2;
        FirAnalyzerFacade firAnalyzerFacade;
        if (this.firFiles != null) {
            return;
        }
        FirProviderImpl firProvider = (FirProviderImpl)MainSessionComponentsKt.getFirProvider(this.session);
        FirAnalyzerFacade firAnalyzerFacade2 = this;
        if (this.useLightTree) {
            Collection<FirFile> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            LightTree2Fir builder2 = new LightTree2Fir(this.session, firProvider.getKotlinScopeProvider(), false, 4, null);
            Iterable iterable = this.originalFiles;
            FirAnalyzerFacade firAnalyzerFacade3 = firAnalyzerFacade2;
            boolean $i$f$map = false;
            void var5_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirFile firFile;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FirFile firFile2 = firFile = builder2.buildFirFile((File)it);
                boolean bl2 = false;
                firProvider.recordFile(firFile2);
                FirFile firFile3 = firFile;
                collection.add(firFile3);
            }
            collection = (List)destination$iv$iv;
            firAnalyzerFacade = firAnalyzerFacade3;
            list2 = collection;
        } else {
            Collection<FirFile> collection;
            RawFirBuilder builder3 = new RawFirBuilder(this.session, firProvider.getKotlinScopeProvider(), PsiHandlingMode.COMPILER, null, 8, null);
            Iterable $this$map$iv = this.ktFiles;
            FirAnalyzerFacade firAnalyzerFacade4 = firAnalyzerFacade2;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirFile firFile;
                KtFile it = (KtFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FirFile firFile4 = firFile = builder3.buildFirFile(it);
                boolean bl3 = false;
                firProvider.recordFile(firFile4);
                FirFile firFile5 = firFile;
                collection.add(firFile5);
            }
            collection = (List)destination$iv$iv;
            firAnalyzerFacade = firAnalyzerFacade4;
            list2 = collection;
        }
        firAnalyzerFacade.firFiles = list2;
    }

    @Override
    @NotNull
    public List<FirFile> runResolution() {
        if (this.firFiles == null) {
            this.buildRawFir();
        }
        if (this._scopeSession != null) {
            List<FirFile> list2 = this.firFiles;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        FirTotalResolveProcessor resolveProcessor = new FirTotalResolveProcessor(this.session);
        List<? extends FirFile> list3 = this.firFiles;
        Intrinsics.checkNotNull(list3);
        resolveProcessor.process(list3);
        this._scopeSession = resolveProcessor.getScopeSession();
        List<FirFile> list4 = this.firFiles;
        Intrinsics.checkNotNull(list4);
        return list4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<FirFile, List<FirDiagnostic>> runCheckers() {
        Map map;
        if (this._scopeSession == null) {
            this.runResolution();
        }
        if (this.collectedDiagnostics != null) {
            Map<FirFile, List<FirDiagnostic>> map2 = this.collectedDiagnostics;
            Intrinsics.checkNotNull(map2);
            return map2;
        }
        SimpleDiagnosticsCollector collector2 = FirDiagnosticsCollector.INSTANCE.create(this.session, this.getScopeSession());
        Map map3 = map = MapsKt.createMapBuilder();
        FirAnalyzerFacade firAnalyzerFacade = this;
        boolean bl = false;
        List<? extends FirFile> list2 = this.firFiles;
        Intrinsics.checkNotNull(list2);
        for (FirFile firFile : list2) {
            void $this$runCheckers_u24lambda_u2d4;
            BaseDiagnosticReporter reporter = DiagnosticReporterFactory.createReporter$default(DiagnosticReporterFactory.INSTANCE, false, 1, null);
            collector2.collectDiagnostics(firFile, reporter);
            $this$runCheckers_u24lambda_u2d4.put(firFile, reporter.getDiagnostics());
        }
        Unit unit2 = Unit.INSTANCE;
        firAnalyzerFacade.collectedDiagnostics = MapsKt.build((Map)map);
        Map<FirFile, List<FirDiagnostic>> map4 = this.collectedDiagnostics;
        Intrinsics.checkNotNull(map4);
        return map4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Fir2IrResult convertToIr(@NotNull GeneratorExtensions extensions) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        FirSession it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        if (this._scopeSession == null) {
            this.runResolution();
        }
        JvmIdSignatureDescriptor signaturer = new JvmIdSignatureDescriptor(new JvmDescriptorMangler(null));
        Iterable iterable = FirModuleDataKt.getModuleData(this.session).getDependsOnDependencies();
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FirModuleData firModuleData = (FirModuleData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirSession firSession = ((FirModuleData)((Object)it)).getSession();
            collection.add(firSession);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirSession)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == FirSession.Kind.Source)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FirSession)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ((FirProviderImpl)MainSessionComponentsKt.getFirProvider(it)).getAllFirFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List commonFirFiles = (List)destination$iv$iv;
        ScopeSession scopeSession = this._scopeSession;
        Intrinsics.checkNotNull((Object)scopeSession);
        List<? extends FirFile> list2 = this.firFiles;
        Intrinsics.checkNotNull(list2);
        return Fir2IrConverter.Companion.createModuleFragment(this.session, scopeSession, CollectionsKt.plus((Collection)list2, (Iterable)commonFirFiles), this.languageVersionSettings, signaturer, extensions, new FirJvmKotlinMangler(this.session), IrFactoryImpl.INSTANCE, FirJvmVisibilityConverter.INSTANCE, new Fir2IrJvmSpecialAnnotationSymbolProvider());
    }
}

