/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTableKt;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureClashTracker;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;)V", "clashTracker", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureClashTracker;", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureClashTracker;)V", "publicIdSignatureComputer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "getPublicIdSignatureComputer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "table", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getTable", "()Ljava/util/Map;", "computeSignatureByDeclaration", "declaration", "compatibleMode", "", "isExportedDeclaration", "loadKnownBuiltins", "", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "ir.serialization.common"})
public abstract class GlobalDeclarationTable {
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    @NotNull
    private final IdSignatureClashTracker clashTracker;
    @NotNull
    private final PublicIdSignatureComputer publicIdSignatureComputer;
    @NotNull
    private final Map<IrDeclaration, IdSignature> table;

    public GlobalDeclarationTable(@NotNull KotlinMangler.IrMangler mangler, @NotNull IdSignatureClashTracker clashTracker) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        Intrinsics.checkNotNullParameter((Object)clashTracker, (String)"clashTracker");
        this.mangler = mangler;
        this.clashTracker = clashTracker;
        this.publicIdSignatureComputer = new PublicIdSignatureComputer(this.mangler);
        this.table = new LinkedHashMap();
    }

    @NotNull
    public final PublicIdSignatureComputer getPublicIdSignatureComputer() {
        return this.publicIdSignatureComputer;
    }

    @NotNull
    protected final Map<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    public GlobalDeclarationTable(@NotNull KotlinMangler.IrMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this(mangler, IdSignatureClashTracker.Companion.getDEFAULT_TRACKER());
    }

    protected final void loadKnownBuiltins(@NotNull IrBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Iterable $this$forEach$iv = DeclarationTableKt.getKnownBuiltins(builtIns);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdSignature idSignature;
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            IrSymbol symbol2 = it.getSymbol();
            Map<IrDeclaration, IdSignature> map = this.getTable();
            IdSignature idSignature2 = symbol2.getSignature();
            Intrinsics.checkNotNull((Object)idSignature2);
            IdSignature id = idSignature = idSignature2;
            boolean bl2 = false;
            this.clashTracker.commit(it, id);
            map.put(it, idSignature);
        }
    }

    @NotNull
    public IdSignature computeSignatureByDeclaration(@NotNull IrDeclaration declaration2, boolean compatibleMode) {
        IdSignature idSignature;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Map<IrDeclaration, IdSignature> $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        IdSignature value$iv = $this$getOrPut$iv.get(declaration2);
        if (value$iv == null) {
            IdSignature idSignature2;
            boolean bl = false;
            IdSignature it = idSignature2 = this.getPublicIdSignatureComputer().composePublicIdSignature(declaration2, compatibleMode);
            boolean bl2 = false;
            this.clashTracker.commit(declaration2, it);
            IdSignature answer$iv = idSignature2;
            $this$getOrPut$iv.put(declaration2, answer$iv);
            idSignature = answer$iv;
        } else {
            idSignature = value$iv;
        }
        return idSignature;
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration2, boolean compatibleMode) {
        KotlinMangler.IrMangler irMangler;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KotlinMangler.IrMangler $this$isExportedDeclaration_u24lambda_u2d4 = irMangler = this.mangler;
        boolean bl = false;
        return $this$isExportedDeclaration_u24lambda_u2d4.isExported(declaration2, compatibleMode);
    }
}

