/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.CustomInstruction;
import org.jetbrains.kotlin.ir.interpreter.DefaultCallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionsUnfolderKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterAssertionError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterTimeOutError;
import org.jetbrains.kotlin.ir.interpreter.proxy.CommonProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KClassState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB!\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010!\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'J\u0010\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u0007H\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020 2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020 2\u0006\u00104\u001a\u000205H\u0002J\u0014\u00106\u001a\u00020 2\n\u0010%\u001a\u0006\u0012\u0002\b\u000307H\u0002J\u0010\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020 2\u0006\u0010<\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020 2\u0006\u0010<\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020 2\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020 2\u0006\u0010%\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020 2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020 2\u0006\u0010%\u001a\u00020TH\u0002J\u0010\u0010U\u001a\u00020 2\u0006\u0010%\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020 2\u0006\u0010%\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020 2\u0006\u0010%\u001a\u00020ZH\u0002J\u0010\u0010[\u001a\u00020 2\u0006\u0010\\\u001a\u00020]H\u0002J\u0010\u0010^\u001a\u00020 2\u0006\u0010%\u001a\u00020_H\u0002J\u0010\u0010`\u001a\u00020 2\u0006\u0010%\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u00020 2\u0006\u0010%\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020 2\u0006\u0010%\u001a\u00020eH\u0002J\u0010\u0010f\u001a\u00020 2\u0006\u0010\"\u001a\u00020gH\u0002J\u0010\u0010h\u001a\u00020 2\u0006\u0010%\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u00020 2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010m\u001a\u00020 2\u0006\u0010%\u001a\u00020nH\u0002J\u0010\u0010o\u001a\u00020 2\u0006\u0010A\u001a\u00020pH\u0002J0\u0010q\u001a\u00020\u001e2\u0006\u00101\u001a\u0002022\u0019\u0010r\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00010s\u00a2\u0006\u0002\btH\u0000\u00a2\u0006\u0002\buJ\f\u0010v\u001a\u00020 *\u00020wH\u0002J\f\u0010x\u001a\u00020 *\u00020yH\u0002R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006z"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Ljava/util/Map;)V", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;Ljava/util/Map;)V", "getBodyMap$ir_interpreter", "()Ljava/util/Map;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getCallStack", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "commandCount", "", "getEnvironment$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getUnitState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "incrementAndCheckCommands", "", "interpret", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "interpretBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "interpretBody", "body", "interpretBranch", "branch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "interpretCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "interpretClassReference", "classReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "interpretConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "interpretConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "interpretConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interpretDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "interpretDoWhile", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "interpretEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "interpretEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interpretField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "interpretFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "interpretFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "interpretFunctionReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "interpretGetClass", "Lorg/jetbrains/kotlin/ir/expressions/IrGetClass;", "interpretGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "interpretGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interpretGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interpretPropertyReference", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "interpretReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "interpretSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "interpretStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "interpretThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "interpretTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "interpretTypeOperatorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "interpretValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "interpretVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "interpretWhile", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "withNewCallStack", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withNewCallStack$ir_interpreter", "handle", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "tryResetFunctionBody", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.interpreter"})
public final class IrInterpreter {
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;
    @NotNull
    private final CallInterceptor callInterceptor;
    private int commandCount;

    public IrInterpreter(@NotNull IrInterpreterEnvironment environment, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(bodyMap, (String)"bodyMap");
        this.environment = environment;
        this.bodyMap = bodyMap;
        this.callInterceptor = new DefaultCallInterceptor(this);
    }

    @NotNull
    public final IrInterpreterEnvironment getEnvironment$ir_interpreter() {
        return this.environment;
    }

    @NotNull
    public final Map<IdSignature, IrBody> getBodyMap$ir_interpreter() {
        return this.bodyMap;
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.environment.getIrBuiltIns();
    }

    private final CallStack getCallStack() {
        return this.environment.getCallStack$ir_interpreter();
    }

    public IrInterpreter(@NotNull IrBuiltIns irBuiltIns, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter(bodyMap, (String)"bodyMap");
        this(new IrInterpreterEnvironment(irBuiltIns, null, 2, null), bodyMap);
    }

    public /* synthetic */ IrInterpreter(IrBuiltIns irBuiltIns, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(irBuiltIns, (Map<IdSignature, ? extends IrBody>)map);
    }

    public IrInterpreter(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        this(new IrInterpreterEnvironment(irModule), (Map<IdSignature, ? extends IrBody>)MapsKt.emptyMap());
    }

    private final void incrementAndCheckCommands() {
        IrInterpreter irInterpreter = this;
        int n = irInterpreter.commandCount;
        irInterpreter.commandCount = n + 1;
        if (this.commandCount >= this.environment.getConfiguration().getMaxCommands()) {
            ExceptionUtilsKt.handleUserException(new InterpreterTimeOutError(), this.environment);
        }
    }

    private final State getUnitState() {
        Complex complex = this.environment.getMapOfObjects$ir_interpreter().get(this.getIrBuiltIns().getUnitClass());
        Intrinsics.checkNotNull((Object)complex);
        return complex;
    }

    private final void handle(Instruction $this$handle) {
        Instruction instruction = $this$handle;
        if (instruction instanceof CompoundInstruction) {
            InstructionsUnfolderKt.unfoldInstruction($this$handle.getElement(), this.environment);
        } else if (instruction instanceof SimpleInstruction) {
            Unit unit2;
            this.interpret(((SimpleInstruction)$this$handle).getElement());
            Unit it = unit2 = Unit.INSTANCE;
            boolean bl = false;
            this.incrementAndCheckCommands();
        } else if (instruction instanceof CustomInstruction) {
            ((CustomInstruction)$this$handle).getEvaluate().invoke();
        }
    }

    @NotNull
    public final IrExpression interpret(@NotNull IrExpression expression2, @Nullable IrFile file2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.commandCount = 0;
        this.getCallStack().newFrame(expression2, file2);
        this.getCallStack().pushInstruction(new CompoundInstruction(expression2));
        while (!this.getCallStack().hasNoInstructions()) {
            this.handle(this.getCallStack().popInstruction());
        }
        IrExpression $this$interpret_u24lambda_u2d1 = irExpression = IrTreeBuildUtilsKt.toIrExpression(this.getCallStack().popState(), expression2);
        boolean bl = false;
        this.getCallStack().dropFrame();
        return irExpression;
    }

    public static /* synthetic */ IrExpression interpret$default(IrInterpreter irInterpreter, IrExpression irExpression, IrFile irFile, int n, Object object) {
        if ((n & 2) != 0) {
            irFile = null;
        }
        return irInterpreter.interpret(irExpression, irFile);
    }

    @NotNull
    public final State withNewCallStack$ir_interpreter(@NotNull IrCall call2, @NotNull Function1<? super IrInterpreter, ? extends Object> init2) {
        State state;
        IrInterpreter irInterpreter;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        IrInterpreter $this$withNewCallStack_u24lambda_u2d3 = irInterpreter = new IrInterpreter(this.environment.copyWithNewCallStack(), this.bodyMap);
        boolean bl = false;
        $this$withNewCallStack_u24lambda_u2d3.getCallStack().newFrame((IrFunction)call2.getSymbol().getOwner());
        init2.invoke((Object)$this$withNewCallStack_u24lambda_u2d3);
        while (!$this$withNewCallStack_u24lambda_u2d3.getCallStack().hasNoInstructions()) {
            $this$withNewCallStack_u24lambda_u2d3.handle($this$withNewCallStack_u24lambda_u2d3.getCallStack().popInstruction());
        }
        State $this$withNewCallStack_u24lambda_u2d3_u24lambda_u2d2 = state = $this$withNewCallStack_u24lambda_u2d3.getCallStack().popState();
        boolean bl2 = false;
        $this$withNewCallStack_u24lambda_u2d3.getCallStack().dropFrame();
        return state;
    }

    private final void interpret(IrElement element) {
        IrElement irElement = element;
        if (irElement instanceof IrSimpleFunction) {
            this.interpretFunction((IrSimpleFunction)element);
        } else if (irElement instanceof IrConstructor) {
            this.interpretConstructor((IrConstructor)element);
        } else if (irElement instanceof IrCall) {
            this.interpretCall((IrCall)element);
        } else if (irElement instanceof IrConstructorCall) {
            this.interpretConstructorCall((IrFunctionAccessExpression)element);
        } else if (irElement instanceof IrEnumConstructorCall) {
            this.interpretEnumConstructorCall((IrEnumConstructorCall)element);
        } else if (irElement instanceof IrDelegatingConstructorCall) {
            this.interpretDelegatingConstructorCall((IrDelegatingConstructorCall)element);
        } else if (irElement instanceof IrValueParameter) {
            this.interpretValueParameter((IrValueParameter)element);
        } else if (irElement instanceof IrField) {
            this.interpretField((IrField)element);
        } else if (irElement instanceof IrBody) {
            this.interpretBody((IrBody)element);
        } else if (irElement instanceof IrBlock) {
            this.interpretBlock((IrBlock)element);
        } else if (irElement instanceof IrReturn) {
            this.interpretReturn((IrReturn)element);
        } else if (irElement instanceof IrSetField) {
            this.interpretSetField((IrSetField)element);
        } else if (irElement instanceof IrGetField) {
            this.interpretGetField((IrGetField)element);
        } else if (irElement instanceof IrGetObjectValue) {
            this.interpretGetObjectValue((IrGetObjectValue)element);
        } else if (irElement instanceof IrGetEnumValue) {
            this.interpretGetEnumValue((IrGetEnumValue)element);
        } else if (irElement instanceof IrEnumEntry) {
            this.interpretEnumEntry((IrEnumEntry)element);
        } else if (irElement instanceof IrConst) {
            this.interpretConst((IrConst)element);
        } else if (irElement instanceof IrVariable) {
            this.getCallStack().storeState((IrSymbol)((IrVariable)element).getSymbol(), this.getCallStack().popState());
        } else if (irElement instanceof IrSetValue) {
            this.getCallStack().rewriteState(((IrSetValue)element).getSymbol(), this.getCallStack().popState());
        } else if (irElement instanceof IrTypeOperatorCall) {
            this.interpretTypeOperatorCall((IrTypeOperatorCall)element);
        } else if (irElement instanceof IrBranch) {
            this.interpretBranch((IrBranch)element);
        } else if (irElement instanceof IrWhileLoop) {
            this.interpretWhile((IrWhileLoop)element);
        } else if (irElement instanceof IrDoWhileLoop) {
            this.interpretDoWhile((IrDoWhileLoop)element);
        } else if (irElement instanceof IrWhen) {
            this.getCallStack().dropSubFrame();
        } else if (irElement instanceof IrVararg) {
            this.interpretVararg((IrVararg)element);
        } else if (irElement instanceof IrTry) {
            this.interpretTry((IrTry)element);
        } else if (irElement instanceof IrThrow) {
            this.interpretThrow((IrThrow)element);
        } else if (irElement instanceof IrStringConcatenation) {
            this.interpretStringConcatenation((IrStringConcatenation)element);
        } else if (irElement instanceof IrFunctionExpression) {
            this.interpretFunctionExpression((IrFunctionExpression)element);
        } else if (irElement instanceof IrFunctionReference) {
            this.interpretFunctionReference((IrFunctionReference)element);
        } else if (irElement instanceof IrPropertyReference) {
            this.interpretPropertyReference((IrPropertyReference)element);
        } else if (irElement instanceof IrClassReference) {
            this.interpretClassReference((IrClassReference)element);
        } else if (irElement instanceof IrGetClass) {
            this.interpretGetClass((IrGetClass)element);
        } else {
            throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)(element.getClass() + " not supported for interpretation")));
        }
    }

    private final void tryResetFunctionBody(IrFunction $this$tryResetFunctionBody) {
        IdSignature idSignature = $this$tryResetFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return;
        }
        IdSignature signature2 = idSignature;
        if (this.bodyMap.get(signature2) != null) {
            $this$tryResetFunctionBody.setBody(null);
        }
    }

    private final void interpretFunction(IrSimpleFunction function2) {
        this.tryResetFunctionBody(function2);
        if (UtilsKt.checkCast(function2, this.environment)) {
            this.getCallStack().dropFrameAndCopyResult();
        }
    }

    private final void interpretValueParameter(IrValueParameter valueParameter2) {
        IrFunction irFunction2 = (IrFunction)valueParameter2.getParent();
        State state = this.getCallStack().popState();
        State state2 = StateKt.checkNullability(state, valueParameter2.getType(), this.environment, (Function0<? extends Throwable>)((Function0)new Function0<Throwable>(irFunction2, valueParameter2){
            final /* synthetic */ IrFunction $irFunction;
            final /* synthetic */ IrValueParameter $valueParameter;
            {
                this.$irFunction = $irFunction;
                this.$valueParameter = $valueParameter;
                super(0);
            }

            @NotNull
            public final Throwable invoke() {
                if (IrInterpreter.access$interpretValueParameter$isReceiver(this.$irFunction, this.$valueParameter)) {
                    return new NullPointerException();
                }
                String method = UtilsKt.getCapitalizedFileName(this.$irFunction) + '.' + UtilsKt.getFqName(this.$irFunction);
                Name parameter = this.$valueParameter.getName();
                return new IllegalArgumentException("Parameter specified as non-null is null: method " + method + ", parameter " + parameter);
            }
        }));
        if (state2 == null) {
            return;
        }
        this.getCallStack().pushState(state);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretCall(IrCall call2) {
        Object it;
        IrValueParameterSymbol irValueParameterSymbol2;
        Object[] dispatchReceiver;
        Object[] objectArray;
        IrValueParameterSymbol it2;
        State state;
        Object item$iv$iv;
        IrValueParameterSymbol $this$mapTo$iv$iv;
        IrSimpleFunction owner = (IrSimpleFunction)call2.getSymbol().getOwner();
        Iterable $this$map$iv = owner.getValueParameters();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            item$iv$iv = object.next();
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            State state2 = this.getCallStack().popState();
            collection.add(state2);
        }
        List valueArguments = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        IrValueParameterSymbol $i$f$map22 = UtilsKt.getExtensionReceiver(owner);
        if ($i$f$map22 == null) {
            state = null;
        } else {
            it2 = $this$mapTo$iv$iv = $i$f$map22;
            boolean bl = false;
            state = this.getCallStack().popState();
        }
        State extensionReceiver = state;
        $this$mapTo$iv$iv = UtilsKt.getDispatchReceiver(owner);
        if ($this$mapTo$iv$iv == null) {
            objectArray = null;
        } else {
            IrValueParameterSymbol it3 = it2 = $this$mapTo$iv$iv;
            boolean irValueParameterSymbol2 = false;
            objectArray = this.getCallStack().popState();
        }
        Object[] it3 = dispatchReceiver = objectArray;
        it2 = it3 == null ? null : it3.getIrFunctionByIrCall(call2);
        IrValueParameterSymbol irFunction2 = it2 == null ? call2.getSymbol().getOwner() : it2;
        it3 = new State[]{IrInterpreter.interpretCall$getThisOrSuperReceiver((State)dispatchReceiver, (IrFunction)((Object)irFunction2)), extensionReceiver};
        List args = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])it3), (Iterable)valueArguments);
        Map<IrTypeParameterSymbol, KTypeState> reifiedTypeArguments = UtilsKt.loadReifiedTypeArguments(this.environment, call2);
        this.getCallStack().newFrame((IrFunction)((Object)irFunction2));
        this.getCallStack().pushInstruction(new SimpleInstruction((IrElement)((Object)irFunction2)));
        if (dispatchReceiver instanceof StateWithClosure) {
            this.getCallStack().loadUpValues((StateWithClosure)dispatchReceiver);
        }
        if (extensionReceiver instanceof StateWithClosure) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)extensionReceiver));
        }
        if (AdditionalIrUtilsKt.isLocal((IrDeclaration)((Object)irFunction2))) {
            this.getCallStack().copyUpValuesFromPreviousFrame();
        }
        if ((irValueParameterSymbol2 = UtilsKt.getDispatchReceiver((IrFunction)((Object)irFunction2))) != null) {
            it = item$iv$iv = irValueParameterSymbol2;
            boolean bl = false;
            CallStack callStack = this.getCallStack();
            IrSymbol irSymbol2 = (IrSymbol)it;
            Intrinsics.checkNotNull((Object)dispatchReceiver);
            callStack.storeState(irSymbol2, (State)dispatchReceiver);
        }
        irValueParameterSymbol2 = UtilsKt.getExtensionReceiver((IrFunction)((Object)irFunction2));
        if (irValueParameterSymbol2 != null) {
            State state3;
            it = item$iv$iv = irValueParameterSymbol2;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it, (state3 = extensionReceiver) == null ? this.getCallStack().loadState((IrSymbol)it) : state3);
        }
        Iterable $this$forEachIndexed$iv = ((IrFunction)((Object)irFunction2)).getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int i = n;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)param.getSymbol(), (State)valueArguments.get(i));
        }
        this.getCallStack().storeState((IrSymbol)((IrFunction)((Object)irFunction2)).getSymbol(), new KTypeState(call2.getType(), (IrClass)this.environment.getKTypeClass$ir_interpreter().getOwner()));
        Map<IrTypeParameterSymbol, KTypeState> $this$forEach$iv = reifiedTypeArguments;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IrTypeParameterSymbol, KTypeState>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IrTypeParameterSymbol, KTypeState> element$iv;
            Map.Entry<IrTypeParameterSymbol, KTypeState> it4 = element$iv = iterator2.next();
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it4.getKey(), it4.getValue());
        }
        if (dispatchReceiver instanceof Complex && ((object = IrUtilsKt.getParentClassOrNull((IrDeclaration)((Object)irFunction2))) == null ? false : ((IrClass)object).isInner())) {
            Complex.DefaultImpls.loadOuterClassesInto$default((Complex)dispatchReceiver, this.getCallStack(), null, 2, null);
        }
        this.callInterceptor.interceptCall(call2, (IrFunction)((Object)irFunction2), args, (Function0<Unit>)((Function0)new Function0<Unit>(this, (IrFunction)((Object)irFunction2)){
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrFunction $irFunction;
            {
                this.this$0 = $receiver;
                this.$irFunction = $irFunction;
                super(0);
            }

            public final void invoke() {
                IrInterpreter.access$getCallStack(this.this$0).pushInstruction(new CompoundInstruction(this.$irFunction));
            }
        }));
    }

    private final void interpretField(IrField field2) {
        IrClass irClass2 = IrUtilsKt.getParentAsClass(field2);
        IrValueParameter irValueParameter = irClass2.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameterSymbol receiver = irValueParameter.getSymbol();
        State receiverState = this.getCallStack().loadState(receiver);
        IrPropertySymbol irPropertySymbol = field2.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        receiverState.setField(irPropertySymbol, this.getCallStack().popState());
    }

    private final void interpretBody(IrBody body2) {
        if (this.getCallStack().peekState() == null) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretBlock(IrBlock block) {
        this.getCallStack().dropSubFrame();
        if (this.getCallStack().peekState() == null) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretConstructor(IrConstructor constructor2) {
        CallStack callStack = this.getCallStack();
        CallStack callStack2 = this.getCallStack();
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(constructor2).getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        callStack.pushState(callStack2.loadState(irValueParameter.getSymbol()));
        this.getCallStack().dropFrameAndCopyResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretConstructorCall(IrFunctionAccessExpression constructorCall) {
        IrValueSymbol irValueSymbol;
        IrStatement irStatement;
        IrStatement irStatement2;
        State state;
        IrValueParameterSymbol $i$f$mapTo22;
        State objectState;
        Object $this$interpretConstructorCall_u24lambda_u2d12;
        State state2;
        IrValueParameter $this$mapTo$iv$iv;
        IrFunction constructor2 = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
        Iterable $this$map$iv = constructor2.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv = iterator2.next();
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            State state3 = this.getCallStack().popState();
            collection.add(state3);
        }
        List valueArguments = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        IrClass irClass2 = IrUtilsKt.getParentAsClass(constructor2);
        $this$mapTo$iv$iv = constructor2.getDispatchReceiverParameter();
        IrValueParameterSymbol receiverSymbol = $this$mapTo$iv$iv == null ? null : $this$mapTo$iv$iv.getSymbol();
        destination$iv$iv = constructorCall;
        if (!(destination$iv$iv instanceof IrConstructorCall)) {
            state2 = this.getCallStack().loadState(UtilsKt.getThisReceiver(constructorCall));
        } else {
            StateWithClosure $i$f$mapTo22 = UtilsKt.isSubclassOfThrowable(irClass2) ? new ExceptionState(irClass2, this.getCallStack().getStackTrace()) : new Common(irClass2);
            $this$interpretConstructorCall_u24lambda_u2d12 = $i$f$mapTo22;
            boolean bl = false;
            if (IrUtilsKt.isObject(irClass2)) {
                this.getEnvironment$ir_interpreter().getMapOfObjects$ir_interpreter().put(irClass2.getSymbol(), (Complex)$this$interpretConstructorCall_u24lambda_u2d12);
            }
            state2 = objectState = (State)((Object)$i$f$mapTo22);
        }
        if (AdditionalIrUtilsKt.isLocal(irClass2)) {
            this.getCallStack().storeUpValues((StateWithClosure)((Object)objectState));
        }
        if (($i$f$mapTo22 = receiverSymbol) == null) {
            state = null;
        } else {
            Object it = $this$interpretConstructorCall_u24lambda_u2d12 = $i$f$mapTo22;
            boolean bl = false;
            state = this.getCallStack().popState();
        }
        State outerClass2 = state;
        IrType returnType2 = UtilsKt.getTypeIfReified(constructorCall.getType(), this.getCallStack());
        this.getCallStack().newFrame(constructor2);
        this.getCallStack().pushInstruction(new SimpleInstruction(constructor2));
        if (AdditionalIrUtilsKt.isLocal(irClass2)) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)objectState));
        }
        this.getCallStack().storeState((IrSymbol)UtilsKt.getThisReceiver(constructorCall), objectState);
        Iterable $this$forEachIndexed$iv = constructor2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int i = n;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)param.getSymbol(), (State)valueArguments.get(i));
        }
        this.getCallStack().storeState((IrSymbol)constructor2.getSymbol(), new KTypeState(returnType2, (IrClass)this.environment.getKTypeClass$ir_interpreter().getOwner()));
        Object object = constructor2.getBody();
        if (object == null) {
            irStatement2 = null;
        } else {
            List<IrStatement> bl = IrUtilsKt.getStatements((IrBody)object);
            irStatement2 = irStatement = (IrStatement)bl.get(0);
        }
        if (irStatement == null) {
            irValueSymbol = null;
        } else if (irStatement instanceof IrTypeOperatorCall) {
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)((IrTypeOperatorCall)irStatement).getArgument());
        } else if (irStatement instanceof IrFunctionAccessExpression) {
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irStatement);
        } else if (irStatement instanceof IrBlock) {
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)CollectionsKt.last(((IrBlock)irStatement).getStatements()));
        } else {
            throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)(irStatement.getClass() + " is not supported as first statement in constructor call")));
        }
        IrValueSymbol superReceiver = irValueSymbol;
        irStatement = superReceiver;
        if (irStatement != null) {
            object = irStatement;
            IrElement it = object;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)((Object)it), objectState);
        }
        if (outerClass2 != null) {
            IrType irType;
            IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(irClass2).getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            Pair outerClassSymbolToState = TuplesKt.to((Object)irValueParameter.getSymbol(), (Object)outerClass2);
            ((Complex)objectState).setOuterClass((Pair<? extends IrSymbol, ? extends State>)outerClassSymbolToState);
            object = superReceiver;
            if (object == null) {
                irType = null;
            } else {
                IrValueDeclaration irValueDeclaration = object.getOwner();
                irType = irValueDeclaration.getType();
            }
            if (!Intrinsics.areEqual((Object)irType, (Object)((IrValueParameter)receiverSymbol.getOwner()).getType())) {
                this.getCallStack().storeState((IrSymbol)receiverSymbol, outerClass2);
                ((Complex)objectState).loadOuterClassesInto(this.getCallStack(), UtilsKt.getThisReceiver(constructorCall));
            }
        }
        this.callInterceptor.interceptConstructor(constructorCall, valueArguments, (Function0<Unit>)((Function0)new Function0<Unit>(this, constructor2){
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrFunction $constructor;
            {
                this.this$0 = $receiver;
                this.$constructor = $constructor;
                super(0);
            }

            public final void invoke() {
                IrInterpreter.access$getCallStack(this.this$0).pushInstruction(new CompoundInstruction(this.$constructor));
            }
        }));
    }

    private final void interpretDelegatingConstructorCall(IrDelegatingConstructorCall constructorCall) {
        if (Intrinsics.areEqual((Object)((IrConstructor)constructorCall.getSymbol().getOwner()).getParent(), this.getIrBuiltIns().getAnyClass().getOwner())) {
            return;
        }
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretEnumConstructorCall(IrEnumConstructorCall constructorCall) {
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretConst(IrConst<?> expression2) {
        IrType signedType = IrInterpreter.interpretConst$getSignedType(this, expression2.getType());
        if (signedType != null) {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClassSymbol unsignedClass = irClassSymbol;
            IrConstructor constructor2 = (IrConstructor)((IrConstructorSymbol)SequencesKt.single(IrUtilsKt.getConstructors(unsignedClass))).getOwner();
            IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor2.getReturnType(), constructor2.getSymbol(), null, 4, null);
            constructorCall.putValueArgument(0, IrTreeBuildUtilsKt.toIrConst$default(expression2.getValue(), signedType, 0, 0, 6, null));
            this.getCallStack().pushInstruction(new CompoundInstruction(constructorCall));
            return;
        }
        this.getCallStack().pushState(UtilsKt.toPrimitive(expression2));
    }

    private final void interpretReturn(IrReturn expression2) {
        this.getCallStack().returnFromFrameWithResult(expression2);
    }

    private final void interpretWhile(IrWhileLoop loop2) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result2) {
            this.getCallStack().newSubFrame(loop2);
            this.getCallStack().pushInstruction(new SimpleInstruction(loop2));
            this.getCallStack().pushInstruction(new CompoundInstruction(loop2.getCondition()));
            this.getCallStack().pushInstruction(new CompoundInstruction(loop2.getBody()));
        }
    }

    private final void interpretDoWhile(IrDoWhileLoop loop2) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result2) {
            this.getCallStack().newSubFrame(loop2);
            this.getCallStack().pushInstruction(new SimpleInstruction(loop2));
            this.getCallStack().pushInstruction(new CompoundInstruction(loop2.getCondition()));
            this.getCallStack().pushInstruction(new CompoundInstruction(loop2.getBody()));
        }
    }

    private final void interpretBranch(IrBranch branch) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        if (result2) {
            this.getCallStack().dropSubFrame();
            this.getCallStack().pushInstruction(new CompoundInstruction(branch.getResult()));
        }
    }

    private final void interpretSetField(IrSetField expression2) {
        State state;
        IrExpression irExpression = expression2.getReceiver();
        if (irExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDeclarationReference");
        }
        IrSymbol receiver = ((IrDeclarationReference)irExpression).getSymbol();
        IrPropertySymbol irPropertySymbol = ((IrField)expression2.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        IrPropertySymbol propertySymbol = irPropertySymbol;
        State $this$interpretSetField_u24lambda_u2d16 = state = this.getCallStack().loadState(receiver);
        boolean bl = false;
        $this$interpretSetField_u24lambda_u2d16.setField(propertySymbol, this.getCallStack().popState());
    }

    private final void interpretGetField(IrGetField expression2) {
        Object object;
        Object initializerExpression;
        IrExpression irExpression = expression2.getReceiver();
        IrDeclarationReference irDeclarationReference = irExpression instanceof IrDeclarationReference ? (IrDeclarationReference)irExpression : null;
        IrSymbol receiver = irDeclarationReference == null ? null : irDeclarationReference.getSymbol();
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        if (Intrinsics.areEqual((Object)field2.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && field2.isStatic()) {
            IrExpressionBody irExpressionBody = field2.getInitializer();
            Object object2 = initializerExpression = irExpressionBody == null ? null : irExpressionBody.getExpression();
            if (initializerExpression instanceof IrConst) {
                this.getCallStack().pushInstruction(new SimpleInstruction((IrElement)initializerExpression));
            } else {
                this.callInterceptor.interceptJavaStaticField(expression2);
            }
        } else if (Intrinsics.areEqual((Object)field2.getOrigin(), (Object)IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE) && ((initializerExpression = field2.getCorrespondingPropertySymbol()) == null ? false : ((IrProperty)(object = (IrProperty)initializerExpression.getOwner())).isConst())) {
            this.getCallStack().pushInstruction(new CompoundInstruction((initializerExpression = field2.getInitializer()) == null ? null : ((IrExpressionBody)initializerExpression).getExpression()));
        } else if (UtilsKt.accessesTopLevelOrObjectField(expression2)) {
            IrExpressionBody irExpressionBody;
            IrExpressionBody irExpressionBody2;
            IrDeclarationBase irDeclarationBase;
            object = field2.getCorrespondingPropertySymbol();
            IrProperty propertyOwner = object == null ? null : (IrProperty)object.getOwner();
            IrProperty irProperty2 = propertyOwner;
            boolean isConst = (irProperty2 == null ? false : irProperty2.isConst()) || ((irProperty2 = propertyOwner) == null ? null : ((irDeclarationBase = irProperty2.getBackingField()) == null ? null : ((irExpressionBody2 = irDeclarationBase.getInitializer()) == null ? null : irExpressionBody2.getExpression()))) instanceof IrConst || ((irProperty2 = propertyOwner) == null ? false : ((irDeclarationBase = IrUtilsKt.getParentClassOrNull(irProperty2)) == null ? false : UtilsKt.hasAnnotation(irDeclarationBase, UtilsKt.getCompileTimeAnnotation())));
            boolean $i$f$verify = false;
            if (!isConst) {
                boolean bl = false;
                String string2 = "Cannot interpret get method on top level non const properties";
                String string3 = string2.toString();
                throw new InterpreterAssertionError(string3);
            }
            this.getCallStack().pushInstruction(new CompoundInstruction((irExpressionBody = field2.getInitializer()) == null ? null : irExpressionBody.getExpression()));
        } else {
            CallStack callStack = this.getCallStack();
            IrSymbol irSymbol2 = receiver;
            Intrinsics.checkNotNull((Object)irSymbol2);
            State state = callStack.loadState(irSymbol2);
            IrPropertySymbol irPropertySymbol = field2.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull((Object)irPropertySymbol);
            State result2 = state.getField(irPropertySymbol);
            CallStack callStack2 = this.getCallStack();
            State state2 = result2;
            Intrinsics.checkNotNull((Object)state2);
            callStack2.pushState(state2);
        }
    }

    private final void interpretGetObjectValue(IrGetObjectValue expression2) {
        this.callInterceptor.interceptGetObjectValue(expression2, (Function0<Unit>)((Function0)new Function0<Unit>(expression2, this){
            final /* synthetic */ IrGetObjectValue $expression;
            final /* synthetic */ IrInterpreter this$0;
            {
                this.$expression = $expression;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean buildObject;
                IrClass objectClass = (IrClass)this.$expression.getSymbol().getOwner();
                boolean bl = buildObject = UtilsKt.hasAnnotation(objectClass, UtilsKt.getCompileTimeAnnotation()) || this.this$0.getEnvironment$ir_interpreter().getConfiguration().getCreateNonCompileTimeObjects();
                if (SequencesKt.none(IrUtilsKt.getConstructors(objectClass)) || !buildObject) {
                    Common state = new Common(objectClass);
                    Map<IrSymbol, Complex> map = this.this$0.getEnvironment$ir_interpreter().getMapOfObjects$ir_interpreter();
                    IrClassSymbol irClassSymbol = objectClass.getSymbol();
                    map.put(irClassSymbol, state);
                    IrInterpreter.access$getCallStack(this.this$0).pushState(state);
                    return;
                }
                IrConstructor constructor2 = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors(objectClass));
                IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor2.getReturnType(), constructor2.getSymbol(), null, 4, null);
                IrInterpreter.access$getCallStack(this.this$0).pushInstruction(new CompoundInstruction(constructorCall));
            }
        }));
    }

    private final void interpretGetEnumValue(IrGetEnumValue expression2) {
        CallStack callStack = this.getCallStack();
        Complex complex = this.environment.getMapOfEnums$ir_interpreter().get(expression2.getSymbol());
        Intrinsics.checkNotNull((Object)complex);
        callStack.pushState(complex);
    }

    private final void interpretEnumEntry(IrEnumEntry enumEntry) {
        this.callInterceptor.interceptEnumEntry(enumEntry, (Function0<Unit>)((Function0)new Function0<Unit>(enumEntry, this){
            final /* synthetic */ IrEnumEntry $enumEntry;
            final /* synthetic */ IrInterpreter this$0;
            {
                this.$enumEntry = $enumEntry;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                IrEnumConstructorCall irEnumConstructorCall;
                Object[] $this$filterIsInstanceTo$iv$iv;
                IrEnumConstructorCall $this$filterIsInstanceTo$iv$iv2;
                IrClass enumClass2 = IrUtilsKt.getParentAsClass((IrDeclaration)this.$enumEntry.getSymbol().getOwner());
                Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
                boolean $i$f$filterIsInstance232 = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                Map<IrSymbol, Complex> map = $this$filterIsInstanceTo$iv$iv2.iterator();
                while (map.hasNext()) {
                    T element$iv$iv = map.next();
                    if (!(element$iv$iv instanceof IrEnumEntry)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List enumEntries = (List)destination$iv$iv;
                IrExpressionBody $i$f$filterIsInstance232 = this.$enumEntry.getInitializerExpression();
                if ($i$f$filterIsInstance232 == null) {
                    throw new InterpreterError("Initializer at enum entry " + UtilsKt.getFqName(this.$enumEntry) + " is null");
                }
                IrExpression enumInitializer = $i$f$filterIsInstance232.getExpression();
                IrEnumConstructorCall irEnumConstructorCall2 = $this$filterIsInstanceTo$iv$iv2 = enumInitializer instanceof IrEnumConstructorCall ? (IrEnumConstructorCall)enumInitializer : null;
                if ($this$filterIsInstanceTo$iv$iv2 == null) {
                    Iterable $this$filterIsInstance$iv2 = ((IrBlock)enumInitializer).getStatements();
                    boolean $i$f$filterIsInstance = false;
                    map = $this$filterIsInstance$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo2 = false;
                    for (T t : $this$filterIsInstanceTo$iv$iv) {
                        if (!(t instanceof IrEnumConstructorCall)) continue;
                        destination$iv$iv2.add(t);
                    }
                    irEnumConstructorCall = (IrEnumConstructorCall)CollectionsKt.single((List)((List)destination$iv$iv2));
                } else {
                    irEnumConstructorCall = $this$filterIsInstanceTo$iv$iv2;
                }
                IrEnumConstructorCall enumConstructorCall = irEnumConstructorCall;
                IrEnumConstructorCall enumSuperCall = UtilsKt.getSuperEnumCall(enumConstructorCall);
                Function0 cleanEnumSuperCall2 = (Function0)new Function0<Unit>(enumSuperCall, this.this$0){
                    final /* synthetic */ IrEnumConstructorCall $enumSuperCall;
                    final /* synthetic */ IrInterpreter this$0;
                    {
                        this.$enumSuperCall = $enumSuperCall;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        IrEnumConstructorCall irEnumConstructorCall;
                        IrEnumConstructorCall $this$invoke_u24lambda_u2d1 = irEnumConstructorCall = this.$enumSuperCall;
                        boolean bl = false;
                        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)$this$invoke_u24lambda_u2d1.getValueArgumentsCount());
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator2 = $this$forEach$iv.iterator();
                        while (iterator2.hasNext()) {
                            int element$iv;
                            int it = element$iv = ((IntIterator)iterator2).nextInt();
                            boolean bl2 = false;
                            $this$invoke_u24lambda_u2d1.putValueArgument(it, null);
                        }
                        IrInterpreter.access$getCallStack(this.this$0).popState();
                        IrInterpreter.access$getCallStack(this.this$0).dropSubFrame();
                    }
                };
                Collection $i$f$filterIsInstance = enumEntries;
                if (!$i$f$filterIsInstance.isEmpty()) {
                    $this$filterIsInstanceTo$iv$iv = new IrConst[]{IrTreeBuildUtilsKt.toIrConst$default(this.$enumEntry.getName().asString(), this.this$0.getIrBuiltIns().getStringType(), 0, 0, 6, null), IrTreeBuildUtilsKt.toIrConst$default(enumEntries.indexOf(this.$enumEntry), this.this$0.getIrBuiltIns().getIntType(), 0, 0, 6, null)};
                    List valueArguments = CollectionsKt.listOf((Object[])$this$filterIsInstanceTo$iv$iv);
                    Iterable $this$forEachIndexed$iv = valueArguments;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T t : $this$forEachIndexed$iv) {
                        void irConst;
                        int n = index$iv;
                        index$iv = n + 1;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        IrConst irConst2 = (IrConst)t;
                        int index2 = n;
                        boolean bl = false;
                        enumSuperCall.putValueArgument(index2, (IrExpression)irConst);
                    }
                }
                Common enumClassObject = new Common((IrClass)((map = this.$enumEntry.getCorrespondingClass()) == null ? enumClass2 : map));
                map = this.this$0.getEnvironment$ir_interpreter().getMapOfEnums$ir_interpreter();
                IrEnumEntrySymbol irEnumEntrySymbol = this.$enumEntry.getSymbol();
                map.put(irEnumEntrySymbol, enumClassObject);
                IrInterpreter.access$getCallStack(this.this$0).newSubFrame(this.$enumEntry);
                IrInterpreter.access$getCallStack(this.this$0).pushInstruction(new CustomInstruction((Function0<Unit>)cleanEnumSuperCall2));
                IrInterpreter.access$getCallStack(this.this$0).pushInstruction(new CompoundInstruction(enumInitializer));
                IrInterpreter.access$getCallStack(this.this$0).storeState((IrSymbol)UtilsKt.getThisReceiver(enumConstructorCall), enumClassObject);
            }
        }));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void interpretTypeOperatorCall(IrTypeOperatorCall expression2) {
        IrTypeParameter irTypeParameter2;
        IrClassifierSymbol typeClassifier = IrTypesKt.getClassifierOrFail(expression2.getTypeOperand());
        IrSymbolOwner irSymbolOwner = typeClassifier.getOwner();
        IrTypeParameter irTypeParameter3 = irTypeParameter2 = irSymbolOwner instanceof IrTypeParameter ? (IrTypeParameter)irSymbolOwner : null;
        boolean isReified = irTypeParameter2 == null ? false : irTypeParameter2.isReified();
        boolean isErased = typeClassifier.getOwner() instanceof IrTypeParameter && !isReified;
        IrType typeOperand = UtilsKt.getTypeIfReified(expression2.getTypeOperand(), this.getCallStack());
        State state = this.getCallStack().popState();
        IrTypeOperator irTypeOperator = expression2.getOperator();
        int n = WhenMappings.$EnumSwitchMapping$1[irTypeOperator.ordinal()];
        switch (n) {
            case 1: {
                return;
            }
            case 2: 
            case 3: {
                if (StateKt.isNull(state) && !IrTypeUtilsKt.isNullable(typeOperand)) {
                    ExceptionUtilsKt.handleUserException(new NullPointerException(), this.environment);
                    return;
                }
                if (!isErased && !StateKt.isSubtypeOf(state, typeOperand)) {
                    String castedClassName = UtilsKt.getFqName(state.getIrClass());
                    ExceptionUtilsKt.handleUserException(new ClassCastException(castedClassName + " cannot be cast to " + RenderIrElementKt.render(typeOperand)), this.environment);
                    return;
                }
                this.getCallStack().pushState(state);
                return;
            }
            case 4: {
                if (!isErased && !StateKt.isSubtypeOf(state, typeOperand)) {
                    this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(null, this.getIrBuiltIns().getNothingNType()));
                    return;
                }
                this.getCallStack().pushState(state);
                return;
            }
            case 5: {
                boolean isInstance = isErased || StateKt.isSubtypeOf(state, typeOperand);
                this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(isInstance, this.getIrBuiltIns().getBooleanType()));
                return;
            }
            case 6: {
                boolean isInstance = isErased || StateKt.isSubtypeOf(state, typeOperand);
                this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(!isInstance, this.getIrBuiltIns().getBooleanType()));
                return;
            }
            case 7: {
                if (StateKt.isNull(state) && !IrTypeUtilsKt.isNullable(typeOperand)) {
                    ExceptionUtilsKt.handleUserException(new NullPointerException(), this.environment);
                    return;
                }
                this.getCallStack().pushState(state);
                return;
            }
            case 8: {
                State state2;
                if (StateKt.isNull(state)) {
                    state2 = state;
                } else if (state instanceof KFunctionState) {
                    State state3 = state;
                    KFunctionState $this$interpretTypeOperatorCall_u24lambda_u2d18 = (KFunctionState)state3;
                    boolean bl = false;
                    $this$interpretTypeOperatorCall_u24lambda_u2d18.setFunInterface(typeOperand);
                    state2 = state3;
                } else {
                    DeepCopyTypeRemapper typeRemapper$iv;
                    Object element$iv;
                    IrFunction it;
                    void $this$first$iv;
                    Iterator $this$filterIsInstanceTo$iv$iv;
                    IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(typeOperand);
                    Intrinsics.checkNotNull((Object)irClassSymbol);
                    IrClass samClass = (IrClass)irClassSymbol.getOwner();
                    IrFunction samFunction = UtilsKt.getSingleAbstractMethod(samClass);
                    Iterable $this$filterIsInstance$iv = state.getIrClass().getDeclarations();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv = iterator2.next();
                        if (!(element$iv$iv instanceof IrFunction)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$first = false;
                    $this$filterIsInstanceTo$iv$iv = $this$first$iv.iterator();
                    do {
                        if (!$this$filterIsInstanceTo$iv$iv.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        element$iv = $this$filterIsInstanceTo$iv$iv.next();
                        it = (IrFunction)element$iv;
                        boolean bl = false;
                    } while (!(Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.INVOKE) && it.getValueParameters().size() == samFunction.getValueParameters().size()));
                    IrFunction invokeFunction = (IrFunction)element$iv;
                    IrClass functionClass = IrUtilsKt.getParentAsClass(UtilsKt.getLastOverridden(invokeFunction));
                    IrValueParameter irValueParameter = invokeFunction.getDispatchReceiverParameter();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    Pair dispatchReceiver = TuplesKt.to((Object)irValueParameter.getSymbol(), (Object)state);
                    IrElement $this$deepCopyWithSymbols_u24default$iv = invokeFunction;
                    boolean $i$f$deepCopyWithSymbols = false;
                    DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
                    IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols_u24default$iv, symbolRemapper$iv);
                    DeepCopyTypeRemapper deepCopyTypeRemapper = typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
                    DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv;
                    IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
                    TypeRemapper typeRemapper = deepCopyTypeRemapper;
                    SymbolRemapper p0 = deepCopySymbolRemapper;
                    DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols(p0, typeRemapper);
                    IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(irElement.transform(deepCopyIrTreeWithSymbols, null), samClass);
                    if (irElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                    }
                    Object object = (Pair[])((IrFunction)irElement2);
                    IrFunction $this$interpretTypeOperatorCall_u24lambda_u2d20 = (IrFunction)object;
                    boolean bl = false;
                    $this$interpretTypeOperatorCall_u24lambda_u2d20.setDispatchReceiverParameter(null);
                    IrFunction newInvoke = (IrFunction)object;
                    object = new Pair[]{dispatchReceiver};
                    Object $this$interpretTypeOperatorCall_u24lambda_u2d21 = object = new KFunctionState(newInvoke, functionClass, this.environment, MapsKt.mutableMapOf((Pair[])object));
                    boolean bl2 = false;
                    ((KFunctionState)$this$interpretTypeOperatorCall_u24lambda_u2d21).setFunInterface(typeOperand);
                    state2 = (State)object;
                }
                State newState = state2;
                this.getCallStack().pushState(newState);
                return;
            }
        }
        ExceptionUtilsKt.stop((Function0<? extends Object>)((Function0)new Function0<Object>(expression2){
            final /* synthetic */ IrTypeOperatorCall $expression;
            {
                this.$expression = $expression;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Type operator " + (Object)((Object)this.$expression.getOperator()) + " is not supported for interpretation";
            }
        }));
        throw null;
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretVararg(IrVararg expression2) {
        State state;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = expression2.getElements();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrVarargElement it = (IrVarargElement)element$iv$iv;
            boolean bl = false;
            State result2 = this.getCallStack().popState();
            Iterable list$iv$iv = result2 instanceof Wrapper ? CollectionsKt.listOf((Object)((Wrapper)result2).getValue()) : (result2 instanceof Primitive ? (IrTypePredicatesKt.isArray(expression2.getVarargElementType()) || UtilsKt.isPrimitiveArray(expression2.getVarargElementType()) ? CollectionsKt.listOf((Object)result2) : IrInterpreter.interpretVararg$arrayToList(((Primitive)result2).getValue())) : (result2 instanceof Common ? (UtilsKt.isUnsignedArray(IrUtilsKt.getDefaultType(result2.getIrClass())) ? IrInterpreter.interpretVararg$arrayToList(((Primitive)CollectionsKt.single((Iterable)result2.getFields().values())).getValue()) : CollectionsKt.listOf((Object)CommonProxy.Companion.asProxy$ir_interpreter$default(CommonProxy.Companion, (Common)result2, this.callInterceptor, null, 2, null))) : CollectionsKt.listOf((Object)result2)));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List args = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        if (UtilsKt.isUnsignedArray(expression2.getType())) {
            void $this$mapTo$iv$iv;
            Object element$iv2;
            Object object;
            IrClass owner;
            block6: {
                void $this$first$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
                Intrinsics.checkNotNull((Object)irClassSymbol);
                owner = (IrClass)irClassSymbol.getOwner();
                Iterable $this$filterIsInstance$iv = owner.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                object = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    Object element$iv$iv = bl.next();
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    IrProperty it = (IrProperty)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"storage")) continue;
                    break block6;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrProperty storageProperty = (IrProperty)element$iv2;
            Iterable $this$map$iv = args;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                void var16_24 = it;
                void var18_26 = var16_24 instanceof Proxy ? ((Primitive)CollectionsKt.single((Iterable)((Proxy)it).getState().getFields().values())).getValue() : it;
                collection.add(var18_26);
            }
            List primitiveArray = (List)destination$iv$iv3;
            IrField irField = storageProperty.getBackingField();
            Intrinsics.checkNotNull((Object)irField);
            Primitive<?> unsignedArray = UtilsKt.toPrimitiveStateArray(primitiveArray, irField.getType());
            Object $this$interpretVararg_u24lambda_u2d25 = object = new Common(owner);
            boolean bl = false;
            ((Common)$this$interpretVararg_u24lambda_u2d25).setField(storageProperty.getSymbol(), unsignedArray);
            state = (State)object;
        } else {
            state = UtilsKt.toPrimitiveStateArray(args, expression2.getType());
        }
        State array2 = state;
        this.getCallStack().pushState(array2);
    }

    private final void interpretTry(IrTry element) {
        IrExpression irExpression;
        State possibleException = this.getCallStack().peekState();
        this.getCallStack().dropSubFrame();
        if (possibleException instanceof ExceptionState) {
            Function0 checkUnhandledException2 = (Function0)new Function0<Unit>(this, possibleException){
                final /* synthetic */ IrInterpreter this$0;
                final /* synthetic */ State $possibleException;
                {
                    this.this$0 = $receiver;
                    this.$possibleException = $possibleException;
                    super(0);
                }

                public final void invoke() {
                    IrInterpreter.access$getCallStack(this.this$0).pushState(this.$possibleException);
                    IrInterpreter.access$getCallStack(this.this$0).dropFramesUntilTryCatch();
                }
            };
            this.getCallStack().pushInstruction(new CustomInstruction((Function0<Unit>)checkUnhandledException2));
        }
        if ((irExpression = element.getFinallyExpression()) != null) {
            InstructionsUnfolderKt.handleAndDropResult$default(irExpression, this.getCallStack(), false, 2, null);
        }
    }

    private final void interpretThrow(IrThrow expression2) {
        this.getCallStack().dropFramesUntilTryCatch();
    }

    private final void interpretStringConcatenation(IrStringConcatenation expression2) {
        List result2 = new ArrayList();
        int n = expression2.getArguments().size();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int it = n3 = n2++;
            boolean bl = false;
            State state = this.getCallStack().popState();
            ((Collection)result2).add(state instanceof Primitive ? String.valueOf(((Primitive)state).getValue()) : (state instanceof Wrapper ? ((Wrapper)state).getValue().toString() : state.toString()));
        }
        this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)result2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), expression2.getType()));
    }

    private final void interpretFunctionExpression(IrFunctionExpression expression2) {
        IrFunction irFunction2 = expression2.getFunction();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        KFunctionState function2 = new KFunctionState(irFunction2, (IrClass)irClassSymbol.getOwner(), this.environment, null, 8, null);
        if (AdditionalIrUtilsKt.isLocal(expression2.getFunction())) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretFunctionReference(IrFunctionReference reference) {
        Pair pair;
        Pair pair2;
        IrFunctionReference irFunctionReference;
        IrInterpreterEnvironment irInterpreterEnvironment;
        Pair pair3;
        Object object;
        State state;
        IrExpression irExpression;
        State state2;
        IrFunction irFunction2 = ((IrFunctionSymbol)reference.getSymbol()).getOwner();
        IrExpression irExpression2 = reference.getDispatchReceiver();
        if (irExpression2 == null) {
            state2 = null;
        } else {
            IrExpression it = irExpression = irExpression2;
            boolean bl = false;
            state2 = this.getCallStack().popState();
        }
        State dispatchReceiver = state2;
        irExpression = reference.getExtensionReceiver();
        if (irExpression == null) {
            state = null;
        } else {
            object = irExpression;
            IrExpression it = object;
            boolean bl = false;
            state = this.getCallStack().popState();
        }
        State extensionReceiver = state;
        IrFunctionReference irFunctionReference2 = reference;
        IrInterpreterEnvironment irInterpreterEnvironment2 = this.environment;
        object = dispatchReceiver;
        if (object == null) {
            pair3 = null;
        } else {
            void it;
            Object object2;
            Object bl = object2 = object;
            irInterpreterEnvironment = irInterpreterEnvironment2;
            irFunctionReference = irFunctionReference2;
            boolean bl2 = false;
            IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getDispatchReceiver(irFunction2);
            Intrinsics.checkNotNull((Object)irValueParameterSymbol);
            pair2 = new Pair((Object)irValueParameterSymbol, (Object)it);
            irFunctionReference2 = irFunctionReference;
            irInterpreterEnvironment2 = irInterpreterEnvironment;
            pair3 = pair2;
        }
        object = extensionReceiver;
        if (object == null) {
            pair = null;
        } else {
            Object object3;
            Object it = object3 = object;
            pair2 = pair3;
            irInterpreterEnvironment = irInterpreterEnvironment2;
            irFunctionReference = irFunctionReference2;
            boolean bl = false;
            IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getExtensionReceiver(irFunction2);
            Intrinsics.checkNotNull((Object)irValueParameterSymbol);
            Pair pair4 = new Pair((Object)irValueParameterSymbol, it);
            irFunctionReference2 = irFunctionReference;
            irInterpreterEnvironment2 = irInterpreterEnvironment;
            pair3 = pair2;
            pair = pair4;
        }
        Pair pair5 = pair;
        Pair pair6 = pair3;
        IrInterpreterEnvironment irInterpreterEnvironment3 = irInterpreterEnvironment2;
        IrFunctionReference irFunctionReference3 = irFunctionReference2;
        KFunctionState function2 = new KFunctionState(irFunctionReference3, irInterpreterEnvironment3, (Pair<? extends IrSymbol, ? extends State>)pair6, pair5);
        if (AdditionalIrUtilsKt.isLocal(irFunction2)) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    private final void interpretPropertyReference(IrPropertyReference propertyReference) {
        IrSimpleFunction irSimpleFunction;
        State state;
        IrExpression irExpression;
        Object object = propertyReference.getDispatchReceiver();
        IrExpression irExpression2 = irExpression = object == null ? propertyReference.getExtensionReceiver() : object;
        if (irExpression == null) {
            state = null;
        } else {
            object = irExpression;
            IrExpression it = object;
            boolean bl = false;
            state = this.getCallStack().popState();
        }
        State receiver = state;
        KPropertyState propertyState = new KPropertyState(propertyReference, receiver);
        object = propertyReference.getGetter();
        if (object != null) {
            irSimpleFunction = (IrSimpleFunction)object.getOwner();
            List<IrTypeParameter> list2 = irSimpleFunction.getTypeParameters();
            IrInterpreter.interpretPropertyReference$addToFields(list2, propertyReference, this, propertyState);
        }
        object = propertyReference.getSetter();
        if (object != null) {
            irSimpleFunction = (IrSimpleFunction)object.getOwner();
            List<IrTypeParameter> list3 = irSimpleFunction.getTypeParameters();
            IrInterpreter.interpretPropertyReference$addToFields(list3, propertyReference, this, propertyState);
        }
        this.getCallStack().pushState(propertyState);
    }

    private final void interpretClassReference(IrClassReference classReference) {
        IrClassifierSymbol irClassifierSymbol = classReference.getSymbol();
        if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            KTypeState kTypeState = (KTypeState)this.getCallStack().loadState(classReference.getSymbol());
            CallStack callStack = this.getCallStack();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kTypeState.getIrType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClass irClass2 = (IrClass)irClassSymbol.getOwner();
            IrClassSymbol irClassSymbol2 = IrTypesKt.getClassOrNull(classReference.getType());
            Intrinsics.checkNotNull((Object)irClassSymbol2);
            callStack.pushState(new KClassState(irClass2, (IrClass)irClassSymbol2.getOwner()));
        } else {
            this.getCallStack().pushState(new KClassState(classReference));
        }
    }

    private final void interpretGetClass(IrGetClass expression2) {
        IrClass irClass2 = this.getCallStack().popState().getIrClass();
        CallStack callStack = this.getCallStack();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        callStack.pushState(new KClassState(irClass2, (IrClass)irClassSymbol.getOwner()));
    }

    private static final boolean interpretValueParameter$isReceiver(IrFunction irFunction2, IrValueParameter $valueParameter) {
        return Intrinsics.areEqual((Object)irFunction2.getDispatchReceiverParameter(), (Object)$valueParameter) || Intrinsics.areEqual((Object)irFunction2.getExtensionReceiverParameter(), (Object)$valueParameter);
    }

    private static final State interpretCall$getThisOrSuperReceiver(State $this$interpretCall_u24getThisOrSuperReceiver, IrFunction irFunction2) {
        if (!($this$interpretCall_u24getThisOrSuperReceiver instanceof Common) || ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass() == null || !(irFunction2.getParent() instanceof IrClass)) {
            return $this$interpretCall_u24getThisOrSuperReceiver;
        }
        Wrapper wrapper = ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass();
        Intrinsics.checkNotNull((Object)wrapper);
        if (IrUtilsKt.isSubclassOf(wrapper.getIrClass(), IrUtilsKt.getParentAsClass(irFunction2))) {
            return ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass();
        }
        return $this$interpretCall_u24getThisOrSuperReceiver;
    }

    private static final IrType interpretConst$getSignedType(IrInterpreter this$0, IrType unsignedType) {
        IrType irType;
        UnsignedType unsignedType2 = IrTypePredicatesKt.getUnsignedType(unsignedType);
        int n = unsignedType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[unsignedType2.ordinal()];
        switch (n) {
            case 1: {
                irType = this$0.getIrBuiltIns().getByteType();
                break;
            }
            case 2: {
                irType = this$0.getIrBuiltIns().getShortType();
                break;
            }
            case 3: {
                irType = this$0.getIrBuiltIns().getIntType();
                break;
            }
            case 4: {
                irType = this$0.getIrBuiltIns().getLongType();
                break;
            }
            default: {
                irType = null;
            }
        }
        return irType;
    }

    private static final List<Object> interpretVararg$arrayToList(Object value2) {
        Object object = value2;
        return CollectionsKt.reversed((Iterable)(object instanceof byte[] ? ArraysKt.toList((byte[])((byte[])value2)) : (object instanceof char[] ? ArraysKt.toList((char[])((char[])value2)) : (object instanceof short[] ? ArraysKt.toList((short[])((short[])value2)) : (object instanceof int[] ? ArraysKt.toList((int[])((int[])value2)) : (object instanceof long[] ? ArraysKt.toList((long[])((long[])value2)) : (object instanceof float[] ? ArraysKt.toList((float[])((float[])value2)) : (object instanceof double[] ? ArraysKt.toList((double[])((double[])value2)) : (object instanceof boolean[] ? ArraysKt.toList((boolean[])((boolean[])value2)) : (object instanceof Object[] ? ArraysKt.toList((Object[])((Object[])value2)) : CollectionsKt.listOf((Object)value2)))))))))));
    }

    private static final void interpretPropertyReference$addToFields(List<? extends IrTypeParameter> $this$interpretPropertyReference_u24addToFields, IrPropertyReference $propertyReference, IrInterpreter this$0, KPropertyState propertyState) {
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)$propertyReference.getTypeArgumentsCount());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index2 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            IrType irType = $propertyReference.getTypeArgument(index2);
            Intrinsics.checkNotNull((Object)irType);
            KTypeState kTypeState = new KTypeState(irType, (IrClass)this$0.getEnvironment$ir_interpreter().getKTypeClass$ir_interpreter().getOwner());
            propertyState.setField($this$interpretPropertyReference_u24addToFields.get(index2).getSymbol(), kTypeState);
        }
    }

    public static final /* synthetic */ boolean access$interpretValueParameter$isReceiver(IrFunction irFunction2, IrValueParameter $valueParameter) {
        return IrInterpreter.interpretValueParameter$isReceiver(irFunction2, $valueParameter);
    }

    public static final /* synthetic */ CallStack access$getCallStack(IrInterpreter $this) {
        return $this.getCallStack();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UnsignedType.values().length];
            nArray[UnsignedType.UBYTE.ordinal()] = 1;
            nArray[UnsignedType.USHORT.ordinal()] = 2;
            nArray[UnsignedType.UINT.ordinal()] = 3;
            nArray[UnsignedType.ULONG.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrTypeOperator.values().length];
            nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 1;
            nArray[IrTypeOperator.CAST.ordinal()] = 2;
            nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 3;
            nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 4;
            nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 5;
            nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 6;
            nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 7;
            nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 8;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

