/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;Lorg/jetbrains/kotlin/ir/interpreter/state/State;)V", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)V", "getState", "()Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "setState", "(Lorg/jetbrains/kotlin/ir/interpreter/state/State;)V", "getSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ir.interpreter"})
public final class Variable {
    @NotNull
    private final IrSymbol symbol;
    public State state;

    public Variable(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        this.symbol = symbol2;
    }

    @NotNull
    public final IrSymbol getSymbol() {
        return this.symbol;
    }

    @NotNull
    public final State getState() {
        State state = this.state;
        if (state != null) {
            return state;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        return null;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"<set-?>");
        this.state = state;
    }

    public Variable(@NotNull IrSymbol symbol2, @NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this(symbol2);
        this.setState(state);
    }

    @NotNull
    public String toString() {
        IrSymbolOwner irSymbolOwner = this.symbol.getOwner();
        IrDeclarationWithName irDeclarationWithName = irSymbolOwner instanceof IrDeclarationWithName ? (IrDeclarationWithName)irSymbolOwner : null;
        return "Variable(symbol=" + (irDeclarationWithName == null ? null : irDeclarationWithName.getName()) + ", state=" + this.getState() + ')';
    }

    @NotNull
    public final IrSymbol component1() {
        return this.symbol;
    }

    @NotNull
    public final Variable copy(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return new Variable(symbol2);
    }

    public static /* synthetic */ Variable copy$default(Variable variable2, IrSymbol irSymbol2, int n, Object object) {
        if ((n & 1) != 0) {
            irSymbol2 = variable2.symbol;
        }
        return variable2.copy(irSymbol2);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Variable)) {
            return false;
        }
        Variable variable2 = (Variable)other;
        return Intrinsics.areEqual((Object)this.symbol, (Object)variable2.symbol);
    }
}

