/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH$J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J<\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0011H\u0002J.\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0011J\f\u0010\u001a\u001a\u00020\u0011*\u00020\u0011H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Lorg/jetbrains/kotlin/ir/util/TypeTranslator;)V", "extractAnnotationOffsets", "Lkotlin/Pair;", "", "annotationDescriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "generateAnnotationConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "realType", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateConstantOrAnnotationValueAsExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "endOffset", "constantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "varargElementType", "generateConstantValueAsExpression", "getArrayElementType", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.tree"})
public abstract class ConstantValueGenerator {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    @NotNull
    private final TypeTranslator typeTranslator;

    public ConstantValueGenerator(@NotNull ModuleDescriptor moduleDescriptor, @NotNull ReferenceSymbolTable symbolTable, @NotNull TypeTranslator typeTranslator2) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)typeTranslator2, (String)"typeTranslator");
        this.moduleDescriptor = moduleDescriptor;
        this.symbolTable = symbolTable;
        this.typeTranslator = typeTranslator2;
    }

    @NotNull
    protected abstract Pair<Integer, Integer> extractAnnotationOffsets(@NotNull AnnotationDescriptor var1);

    private final IrType toIrType(KotlinType $this$toIrType) {
        return this.typeTranslator.translateType($this$toIrType);
    }

    @NotNull
    public final IrExpression generateConstantValueAsExpression(int startOffset, int endOffset, @NotNull ConstantValue<?> constantValue, @Nullable KotlinType varargElementType) {
        Intrinsics.checkNotNullParameter(constantValue, (String)"constantValue");
        IrExpression irExpression = this.generateConstantOrAnnotationValueAsExpression(startOffset, endOffset, constantValue, null, varargElementType);
        Intrinsics.checkNotNull((Object)irExpression);
        return irExpression;
    }

    public static /* synthetic */ IrExpression generateConstantValueAsExpression$default(ConstantValueGenerator constantValueGenerator, int n, int n2, ConstantValue constantValue, KotlinType kotlinType, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateConstantValueAsExpression");
        }
        if ((n3 & 8) != 0) {
            kotlinType = null;
        }
        return constantValueGenerator.generateConstantValueAsExpression(n, n2, constantValue, kotlinType);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateConstantOrAnnotationValueAsExpression(int startOffset, int endOffset, ConstantValue<?> constantValue, KotlinType realType, KotlinType varargElementType) {
        IrExpression irExpression;
        KotlinType constantValueType = constantValue.getType(this.moduleDescriptor);
        KotlinType kotlinType = realType;
        KotlinType constantKtType = kotlinType == null ? constantValueType : kotlinType;
        IrType constantType = this.toIrType(constantKtType);
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof StringValue) {
            irExpression = IrConstImpl.Companion.string(startOffset, endOffset, constantType, (String)((StringValue)constantValue).getValue());
        } else if (constantValue2 instanceof IntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((IntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof UIntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((UIntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof NullValue) {
            irExpression = IrConstImpl.Companion.constNull(startOffset, endOffset, constantType);
        } else if (constantValue2 instanceof BooleanValue) {
            irExpression = IrConstImpl.Companion.boolean(startOffset, endOffset, constantType, (Boolean)((BooleanValue)constantValue).getValue());
        } else if (constantValue2 instanceof LongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((LongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof ULongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((ULongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof DoubleValue) {
            irExpression = IrConstImpl.Companion.double(startOffset, endOffset, constantType, ((Number)((DoubleValue)constantValue).getValue()).doubleValue());
        } else if (constantValue2 instanceof FloatValue) {
            irExpression = IrConstImpl.Companion.float(startOffset, endOffset, constantType, ((Number)((FloatValue)constantValue).getValue()).floatValue());
        } else if (constantValue2 instanceof CharValue) {
            irExpression = IrConstImpl.Companion.char(startOffset, endOffset, constantType, ((Character)((CharValue)constantValue).getValue()).charValue());
        } else if (constantValue2 instanceof ByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((ByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof UByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((UByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof ShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((ShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof UShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((UShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof ArrayValue) {
            List list2;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object = varargElementType;
            KotlinType arrayElementType = object == null ? this.getArrayElementType(constantValueType) : object;
            object = (Iterable)((ArrayValue)constantValue).getValue();
            IrType irType = this.toIrType(arrayElementType);
            IrType irType2 = constantType;
            int n = endOffset;
            int n2 = startOffset;
            boolean $i$f$mapNotNull = false;
            void var13_24 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrExpression irExpression2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ConstantValue it = (ConstantValue)element$iv$iv;
                boolean bl2 = false;
                if (ConstantValueGenerator.generateConstantOrAnnotationValueAsExpression$default(this, startOffset, endOffset, it, arrayElementType, null, 16, null) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                IrExpression it$iv$iv = irExpression2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = list2 = (List)destination$iv$iv;
            IrType irType3 = irType;
            IrType irType4 = irType2;
            int n3 = n;
            int n4 = n2;
            irExpression = new IrVarargImpl(n4, n3, irType4, irType3, list3);
        } else if (constantValue2 instanceof EnumValue) {
            ClassifierDescriptor $this$mapNotNull$iv = constantValueType.getMemberScope().getContributedClassifier(((EnumValue)constantValue).getEnumEntryName(), NoLookupLocation.FROM_BACKEND);
            if ($this$mapNotNull$iv == null) {
                throw new AssertionError((Object)("No such enum entry " + ((EnumValue)constantValue).getEnumEntryName() + " in " + constantType));
            }
            ClassifierDescriptor enumEntryDescriptor = $this$mapNotNull$iv;
            if (!(enumEntryDescriptor instanceof ClassDescriptor)) {
                throw new AssertionError((Object)("Enum entry " + enumEntryDescriptor + " should be a ClassDescriptor"));
            }
            if (!DescriptorUtils.isEnumEntry(enumEntryDescriptor)) {
                return null;
            }
            irExpression = new IrGetEnumValueImpl(startOffset, endOffset, constantType, this.symbolTable.referenceEnumEntry((ClassDescriptor)enumEntryDescriptor));
        } else if (constantValue2 instanceof AnnotationValue) {
            irExpression = this.generateAnnotationConstructorCall((AnnotationDescriptor)((AnnotationValue)constantValue).getValue(), constantKtType);
        } else if (constantValue2 instanceof KClassValue) {
            IrClassReferenceImpl irClassReferenceImpl;
            KotlinType classifierKtType = ((KClassValue)constantValue).getArgumentType(this.moduleDescriptor);
            if (KotlinTypeKt.isError(classifierKtType)) {
                irClassReferenceImpl = null;
            } else {
                ClassifierDescriptor classifierDescriptor;
                ClassifierDescriptor classifierDescriptor2 = classifierKtType.getConstructor().getDeclarationDescriptor();
                if (classifierDescriptor2 == null) {
                    throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected KClassValue: ", (Object)classifierKtType));
                }
                ClassifierDescriptor classifierDescriptor3 = classifierDescriptor = classifierDescriptor2;
                irClassReferenceImpl = new IrClassReferenceImpl(startOffset, endOffset, this.toIrType(constantValue.getType(this.moduleDescriptor)), IrUtilsKt.referenceClassifier(this.symbolTable, classifierDescriptor3), this.toIrType(classifierKtType));
            }
            irExpression = irClassReferenceImpl;
        } else if (constantValue2 instanceof ErrorValue) {
            irExpression = null;
        } else {
            String string2 = "Unexpected constant value: " + constantValue.getClass().getSimpleName() + ' ' + constantValue;
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        return irExpression;
    }

    static /* synthetic */ IrExpression generateConstantOrAnnotationValueAsExpression$default(ConstantValueGenerator constantValueGenerator, int n, int n2, ConstantValue constantValue, KotlinType kotlinType, KotlinType kotlinType2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateConstantOrAnnotationValueAsExpression");
        }
        if ((n3 & 0x10) != 0) {
            kotlinType2 = null;
        }
        return constantValueGenerator.generateConstantOrAnnotationValueAsExpression(n, n2, constantValue, kotlinType, kotlinType2);
    }

    @Nullable
    public final IrConstructorCall generateAnnotationConstructorCall(@NotNull AnnotationDescriptor annotationDescriptor, @Nullable KotlinType realType) {
        ConstantValue<?> constantValue;
        Pair<Integer, Integer> pair;
        Object object;
        Intrinsics.checkNotNullParameter((Object)annotationDescriptor, (String)"annotationDescriptor");
        KotlinType kotlinType = realType;
        KotlinType annotationType = kotlinType == null ? annotationDescriptor.getType() : kotlinType;
        ClassifierDescriptor annotationClassDescriptor = annotationType.getConstructor().getDeclarationDescriptor();
        if (!(annotationClassDescriptor instanceof ClassDescriptor)) {
            return null;
        }
        if (annotationClassDescriptor instanceof NotFoundClasses.MockClassDescriptor) {
            return null;
        }
        boolean bl = DescriptorUtils.isAnnotationClass(annotationClassDescriptor);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)"Annotation class expected: ", (Object)annotationClassDescriptor);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Pair<Integer, Integer> pair2 = ((ClassDescriptor)annotationClassDescriptor).getUnsubstitutedPrimaryConstructor();
        if (pair2 == null) {
            Collection<ClassConstructorDescriptor> collection = ((ClassDescriptor)annotationClassDescriptor).getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"annotationClassDescriptor.constructors");
            ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (classConstructorDescriptor == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"No constructor for annotation class ", (Object)annotationClassDescriptor));
            }
            object = classConstructorDescriptor;
        } else {
            object = pair2;
        }
        Pair<Integer, Integer> primaryConstructorDescriptor = pair = object;
        IrConstructorSymbol primaryConstructorSymbol = this.symbolTable.referenceConstructor((ClassConstructorDescriptor)primaryConstructorDescriptor);
        pair2 = this.extractAnnotationOffsets(annotationDescriptor);
        int startOffset = ((Number)pair2.component1()).intValue();
        int endOffset = ((Number)pair2.component2()).intValue();
        IrType irType = this.toIrType(annotationType);
        int n = primaryConstructorDescriptor.getValueParameters().size();
        int n2 = ((ClassDescriptor)annotationClassDescriptor).getDeclaredTypeParameters().size();
        IrConstructorCallImpl irCall = new IrConstructorCallImpl(startOffset, endOffset, irType, primaryConstructorSymbol, n2, 0, n, null, 128, null);
        TypeSubstitutor substitutor2 = TypeConstructorSubstitution.Companion.create(annotationType).buildSubstitutor();
        ClassConstructorDescriptor classConstructorDescriptor = primaryConstructorDescriptor.substitute(substitutor2);
        if (classConstructorDescriptor == null) {
            String string3 = "Cannot substitute constructor";
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        ClassConstructorDescriptor substitutedConstructor = classConstructorDescriptor;
        List<TypeProjection> typeArguments2 = annotationType.getArguments();
        int n3 = typeArguments2.size() == ((ClassDescriptor)annotationClassDescriptor).getDeclaredTypeParameters().size() ? 1 : 0;
        int n4 = 0;
        boolean bl5 = false;
        if (_Assertions.ENABLED && n3 == 0) {
            boolean bl6 = false;
            String string4 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        n3 = 0;
        n4 = typeArguments2.size() + -1;
        if (n3 <= n4) {
            do {
                int i = n3++;
                TypeProjection typeArgument = typeArguments2.get(i);
                constantValue = typeArgument.getType();
                Intrinsics.checkNotNullExpressionValue((Object)constantValue, (String)"typeArgument.type");
                irCall.putTypeArgument(i, this.toIrType((KotlinType)((Object)constantValue)));
            } while (n3 <= n4);
        }
        for (ValueParameterDescriptor valueParameter2 : substitutedConstructor.getValueParameters()) {
            ConstantValue<?> argumentValue;
            IrExpression irArgument;
            int argumentIndex = valueParameter2.getIndex();
            constantValue = annotationDescriptor.getAllValueArguments().get(valueParameter2.getName());
            if (constantValue == null || (irArgument = this.generateConstantOrAnnotationValueAsExpression(-1, -1, argumentValue = constantValue, valueParameter2.getType(), valueParameter2.getVarargElementType())) == null) continue;
            irCall.putValueArgument(argumentIndex, irArgument);
        }
        return irCall;
    }

    public static /* synthetic */ IrConstructorCall generateAnnotationConstructorCall$default(ConstantValueGenerator constantValueGenerator, AnnotationDescriptor annotationDescriptor, KotlinType kotlinType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateAnnotationConstructorCall");
        }
        if ((n & 2) != 0) {
            kotlinType = null;
        }
        return constantValueGenerator.generateAnnotationConstructorCall(annotationDescriptor, kotlinType);
    }

    private final KotlinType getArrayElementType(KotlinType $this$getArrayElementType) {
        KotlinType kotlinType = TypeUtilsKt.getBuiltIns($this$getArrayElementType).getArrayElementType($this$getArrayElementType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"builtIns.getArrayElementType(this)");
        return kotlinType;
    }
}

