/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeCheckerContext;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.AbstractTypeCheckerContext;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001aJ\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0001*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a6\u0010\u001c\u001a\u0004\u0018\u00010\u0001*\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001c\u0010\u001f\u001a\u00020\u0010*\u00020\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\"H\u0002\u001a$\u0010#\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010%\u001a\u00020\u0001*\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015\u001a8\u0010&\u001a\u0004\u0018\u00010\u0001*\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a6\u0010'\u001a\u00020\n*\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001aN\u0010(\u001a\u00020\n*\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u001aP\u0010+\u001a\u00020\n*\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010,\u001a\u00020-2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u001aN\u0010.\u001a\u00020\n*\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010/\u001a\u00020\u0010\u001aN\u00100\u001a\u00020\n*\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010/\u001a\u00020\u0010\u001aN\u00101\u001a\u00020\n*\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u0002022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010/\u001a\u00020\u0010\u001a\n\u00103\u001a\u00020\u0001*\u00020\u0001\u00a8\u00064"}, d2={"argumentTypeWithSuspendConversion", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "expectedType", "argumentType", "captureFromTypeParameterUpperBoundIfNeeded", "checkApplicabilityForArgumentType", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/SimpleConstraintSystemConstraintPosition;", "isReceiver", "", "isDispatch", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "captureTypeFromExpressionOrNull", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "getExpectedTypeForSAMConversion", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getExpectedTypeWithSAMConversion", "argument", "candidateExpectedType", "hasSupertypeWithGivenClassId", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeCheckerContext;", "isFunctional", "expectedFunctionType", "prepareCapturedType", "prepareExpectedType", "resolveArgument", "resolveArgumentExpression", "expectedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resolveBlockArgument", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolvePlainArgumentType", "useNullableArgumentType", "resolvePlainExpressionArgument", "resolveSubCallArgument", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "varargElementType", "resolve"})
public final class ArgumentsKt {
    public static final void resolveArgumentExpression(@NotNull Candidate $this$resolveArgumentExpression, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument2, @Nullable ConeKotlinType expectedType2, @Nullable FirTypeRef expectedTypeRef, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveArgumentExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirExpression firExpression2 = argument2;
        if ((((firExpression2 instanceof FirFunctionCall ? true : firExpression2 instanceof FirWhenExpression) ? true : firExpression2 instanceof FirTryExpression) ? true : firExpression2 instanceof FirCheckNotNullCall) ? true : firExpression2 instanceof FirElvisExpression) {
            ArgumentsKt.resolveSubCallArgument$default($this$resolveArgumentExpression, csBuilder, (FirResolvable)((Object)argument2), expectedType2, sink, context2, isReceiver, isDispatch, false, 128, null);
        } else if (firExpression2 instanceof FirSafeCallExpression) {
            FirQualifiedAccess nestedQualifier = ((FirSafeCallExpression)argument2).getRegularQualifiedAccess();
            if (nestedQualifier instanceof FirExpression) {
                ArgumentsKt.resolveSubCallArgument($this$resolveArgumentExpression, csBuilder, nestedQualifier, expectedType2, sink, context2, isReceiver, isDispatch, true);
            } else {
                ConeKotlinType coneKotlinType;
                ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getUnit(), new ConeTypeProjection[0], false, null, 4, null), (coneKotlinType = expectedType2) == null ? null : coneKotlinType.getType(), SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, sink, context2);
            }
        } else if (firExpression2 instanceof FirCallableReferenceAccess) {
            if (((FirCallableReferenceAccess)argument2).getCalleeReference() instanceof FirResolvedNamedReference) {
                ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument2, expectedType2, sink, context2, isReceiver, isDispatch, false, 128, null);
            } else {
                PostponedArgumentsKt.preprocessCallableReference($this$resolveArgumentExpression, (FirCallableReferenceAccess)argument2, expectedType2, context2);
            }
        } else if (firExpression2 instanceof FirAnonymousFunction) {
            PostponedArgumentsKt.preprocessLambdaArgument$default($this$resolveArgumentExpression, csBuilder, (FirAnonymousFunction)argument2, expectedType2, expectedTypeRef, context2, false, null, 96, null);
        } else if (firExpression2 instanceof FirWrappedArgumentExpression) {
            ArgumentsKt.resolveArgumentExpression($this$resolveArgumentExpression, csBuilder, ((FirWrappedArgumentExpression)argument2).getExpression(), expectedType2, expectedTypeRef, sink, context2, isReceiver, isDispatch);
        } else if (firExpression2 instanceof FirBlock) {
            ArgumentsKt.resolveBlockArgument($this$resolveArgumentExpression, csBuilder, (FirBlock)argument2, expectedType2, expectedTypeRef, sink, context2, isReceiver, isDispatch);
        } else {
            ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument2, expectedType2, sink, context2, isReceiver, isDispatch, false, 128, null);
        }
    }

    private static final void resolveBlockArgument(Candidate $this$resolveBlockArgument, ConstraintSystemBuilder csBuilder, FirBlock block, ConeKotlinType expectedType2, FirTypeRef expectedTypeRef, CheckerSink sink, ResolutionContext context2, boolean isReceiver, boolean isDispatch) {
        List<FirExpression> returnArguments = UtilsKt.returnExpressions(block);
        if (returnArguments.isEmpty()) {
            ConeKotlinType coneKotlinType;
            FirTypeRef $this$coneType$iv = block.getTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                coneKotlinType2 = null;
            }
            if ((coneKotlinType = coneKotlinType2) == null) {
                String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            ConeKotlinType coneKotlinType3 = expectedType2;
            ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, coneKotlinType, coneKotlinType3 == null ? null : coneKotlinType3.getType(), SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, sink, context2);
            return;
        }
        for (FirExpression argument2 : returnArguments) {
            ArgumentsKt.resolveArgumentExpression($this$resolveBlockArgument, csBuilder, argument2, expectedType2, expectedTypeRef, sink, context2, isReceiver, isDispatch);
        }
    }

    public static final void resolveSubCallArgument(@NotNull Candidate $this$resolveSubCallArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirResolvable argument2, @Nullable ConeKotlinType expectedType2, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveSubCallArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Candidate candidate2 = CandidateFactoryKt.candidate(argument2);
        if (candidate2 == null) {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveSubCallArgument, csBuilder, (FirExpression)((Object)argument2), expectedType2, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
            return;
        }
        Candidate candidate3 = candidate2;
        FirBasedSymbol $this$firUnsafe$iv = candidate3.getSymbol();
        boolean $i$f$firUnsafe = false;
        Object fir$iv = $this$firUnsafe$iv.getFir();
        boolean bl = fir$iv instanceof FirTypedDeclaration;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirTypedDeclaration.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType$default((FirElement)fir$iv, null, 1, null);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ConeKotlinType type2 = context2.getReturnTypeCalculator().tryCalculateReturnType((FirTypedDeclaration)((FirElement)fir$iv)).getType();
        ConeKotlinType argumentType = candidate3.getSubstitutor().substituteOrSelf(type2);
        ArgumentsKt.resolvePlainArgumentType($this$resolveSubCallArgument, csBuilder, argumentType, expectedType2, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
    }

    public static /* synthetic */ void resolveSubCallArgument$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirResolvable firResolvable, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolveSubCallArgument(candidate2, constraintSystemBuilder, firResolvable, coneKotlinType, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    public static final void resolvePlainExpressionArgument(@NotNull Candidate $this$resolvePlainExpressionArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument2, @Nullable ConeKotlinType expectedType2, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$resolvePlainExpressionArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (expectedType2 == null) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = argument2.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) == null) {
            return;
        }
        ConeKotlinType argumentType = coneKotlinType;
        ArgumentsKt.resolvePlainArgumentType($this$resolvePlainExpressionArgument, csBuilder, argumentType, expectedType2, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
    }

    public static /* synthetic */ void resolvePlainExpressionArgument$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirExpression firExpression2, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolvePlainExpressionArgument(candidate2, constraintSystemBuilder, firExpression2, coneKotlinType, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    public static final void resolvePlainArgumentType(@NotNull Candidate $this$resolvePlainArgumentType, @NotNull ConstraintSystemBuilder csBuilder, @NotNull ConeKotlinType argumentType, @Nullable ConeKotlinType expectedType2, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$resolvePlainArgumentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SimpleConstraintSystemConstraintPosition position = SimpleConstraintSystemConstraintPosition.INSTANCE;
        FirSession session2 = context2.getSession();
        ConeKotlinType capturedType = ArgumentsKt.prepareCapturedType($this$resolvePlainArgumentType, argumentType, context2);
        ConeKotlinType argumentTypeForApplicabilityCheck = null;
        ConeKotlinType coneKotlinType2 = argumentTypeForApplicabilityCheck = useNullableArgumentType ? TypeUtilsKt.withNullability$default(capturedType, ConeNullability.NULLABLE, SessionUtilsKt.getTypeContext(session2), null, 4, null) : capturedType;
        if (expectedType2 != null && (coneKotlinType = ArgumentsKt.argumentTypeWithSuspendConversion(session2, context2.getBodyResolveComponents().getScopeSession(), expectedType2, argumentTypeForApplicabilityCheck)) != null) {
            ConeKotlinType coneKotlinType3 = coneKotlinType;
            boolean bl = false;
            boolean bl2 = false;
            ConeKotlinType it = coneKotlinType3;
            boolean bl3 = false;
            argumentTypeForApplicabilityCheck = it;
            $this$resolvePlainArgumentType.getSubstitutor().substituteOrSelf(argumentTypeForApplicabilityCheck);
            $this$resolvePlainArgumentType.setUsesSuspendConversion(true);
        }
        ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, argumentTypeForApplicabilityCheck, expectedType2, position, isReceiver, isDispatch, sink, context2);
    }

    public static /* synthetic */ void resolvePlainArgumentType$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, ConeKotlinType coneKotlinType, ConeKotlinType coneKotlinType2, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolvePlainArgumentType(candidate2, constraintSystemBuilder, coneKotlinType, coneKotlinType2, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType argumentTypeWithSuspendConversion(FirSession session2, ScopeSession scopeSession, ConeKotlinType expectedType2, ConeKotlinType argumentType) {
        ConeLookupTagBasedType coneLookupTagBasedType;
        if (!InferenceUtilsKt.isSuspendFunctionType(expectedType2, session2)) {
            return null;
        }
        ConeClassLikeType expectedFunctionalType = InferenceUtilsKt.suspendFunctionTypeToFunctionType(expectedType2, session2);
        ConeKotlinType argumentTypeWithInvoke = InferenceUtilsKt.findSubtypeOfNonSuspendFunctionalType(argumentType, session2, expectedFunctionalType);
        ConeKotlinType coneKotlinType = argumentTypeWithInvoke;
        if (coneKotlinType == null) {
            coneLookupTagBasedType = null;
        } else {
            FirFunctionSymbol<?> firFunctionSymbol = InferenceUtilsKt.findContributedInvokeSymbol(coneKotlinType, session2, scopeSession, expectedFunctionalType, false);
            if (firFunctionSymbol == null) {
                coneLookupTagBasedType = null;
            } else {
                void $this$mapTo$iv$iv;
                FirFunctionSymbol<?> firFunctionSymbol2 = firFunctionSymbol;
                boolean bl = false;
                boolean bl2 = false;
                FirFunctionSymbol<?> invokeSymbol2 = firFunctionSymbol2;
                boolean bl3 = false;
                Iterable $this$map$iv = ((FirFunction)invokeSymbol2.getFir()).getValueParameters();
                boolean $i$f$map = false;
                Object object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Object object2 = $this$mapTo$iv$iv.iterator();
                while (object2.hasNext()) {
                    ConeKotlinType coneKotlinType2;
                    void it;
                    Object item$iv$iv = object2.next();
                    FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    FirTypeRef $this$coneType$iv = it.getReturnTypeRef();
                    boolean $i$f$getConeType = false;
                    FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
                    boolean $i$f$coneTypeSafe = false;
                    boolean bl5 = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
                    ConeKotlinType coneKotlinType3 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                    if (!(coneKotlinType3 instanceof ConeKotlinType)) {
                        coneKotlinType3 = null;
                    }
                    if ((coneKotlinType2 = coneKotlinType3) == null) {
                        String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                        boolean bl6 = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    ConeKotlinType coneKotlinType4 = coneKotlinType2;
                    collection.add(coneKotlinType4);
                }
                List list2 = (List)destination$iv$iv;
                FirTypeRef $this$coneType$iv = ((FirFunction)invokeSymbol2.getFir()).getReturnTypeRef();
                boolean $i$f$getConeType = false;
                FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeSafe = false;
                boolean bl7 = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
                ConeKotlinType coneKotlinType5 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                if (!(coneKotlinType5 instanceof ConeKotlinType)) {
                    coneKotlinType5 = null;
                }
                if ((object2 = coneKotlinType5) == null) {
                    object = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                    boolean bl8 = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                coneLookupTagBasedType = ResolveUtilsKt.createFunctionalType(list2, null, (ConeKotlinType)object2, true, InferenceUtilsKt.isKFunctionType(argumentType, session2));
            }
        }
        return coneLookupTagBasedType;
    }

    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull Candidate $this$prepareCapturedType, @NotNull ConeKotlinType argumentType, @NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareCapturedType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ConeKotlinType coneKotlinType = ArgumentsKt.captureTypeFromExpressionOrNull($this$prepareCapturedType, argumentType, context2);
        return coneKotlinType == null ? argumentType : coneKotlinType;
    }

    private static final ConeKotlinType captureTypeFromExpressionOrNull(Candidate $this$captureTypeFromExpressionOrNull, ConeKotlinType argumentType, ResolutionContext context2) {
        if (argumentType instanceof ConeFlexibleType) {
            return ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, ((ConeFlexibleType)argumentType).getLowerBound(), context2);
        }
        if (!(argumentType instanceof ConeClassLikeType)) {
            return null;
        }
        Object object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)argumentType, context2.getSession(), null, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        ConeTypeProjection[] it = object;
        boolean bl3 = false;
        if (it != argumentType) {
            return ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, (ConeKotlinType)it, context2);
        }
        object = argumentType.getTypeArguments();
        bl = false;
        if (((ConeTypeProjection[])object).length == 0) {
            return null;
        }
        object = context2.getInferenceComponents().getCtx().captureFromArguments((SimpleTypeMarker)((Object)argumentType), CaptureStatus.FROM_EXPRESSION);
        return object instanceof ConeKotlinType ? (ConeKotlinType)object : null;
    }

    private static final void checkApplicabilityForArgumentType(ConstraintSystemBuilder csBuilder, ConeKotlinType argumentType, ConeKotlinType expectedType2, SimpleConstraintSystemConstraintPosition position, boolean isReceiver, boolean isDispatch, CheckerSink sink, ResolutionContext context2) {
        if (expectedType2 == null) {
            return;
        }
        if (isReceiver && isDispatch) {
            if (!ConeTypeUtilsKt.isNullable(expectedType2) && ConeTypeUtilsKt.isMarkedNullable(argumentType)) {
                sink.reportDiagnostic(InapplicableWrongReceiver.INSTANCE);
            }
            return;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType2, position)) {
            if (!isReceiver) {
                csBuilder.addSubtypeConstraint(argumentType, expectedType2, position);
                return;
            }
            ConeKotlinType nullableExpectedType = TypeUtilsKt.withNullability$default(expectedType2, ConeNullability.NULLABLE, SessionUtilsKt.getTypeContext(context2.getSession()), null, 4, null);
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportDiagnostic(InapplicableWrongReceiver.INSTANCE);
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType2, position);
                sink.reportDiagnostic(InapplicableWrongReceiver.INSTANCE);
            }
        }
    }

    public static final void resolveArgument(@NotNull Candidate $this$resolveArgument, @NotNull FirExpression argument2, @Nullable FirValueParameter parameter, boolean isReceiver, @NotNull CheckerSink sink, @NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirExpression $this$resultType$iv = argument2;
        boolean $i$f$getResultType = false;
        PhaseUtilsKt.ensureResolvedTypeDeclaration($this$resultType$iv.getTypeRef(), context2.getSession());
        ConeKotlinType expectedType2 = ArgumentsKt.prepareExpectedType($this$resolveArgument, context2.getSession(), context2.getBodyResolveComponents().getScopeSession(), argument2, parameter, context2);
        FirValueParameter firValueParameter = parameter;
        ArgumentsKt.resolveArgumentExpression($this$resolveArgument, $this$resolveArgument.getSystem().getBuilder(), argument2, expectedType2, firValueParameter == null ? null : firValueParameter.getReturnTypeRef(), sink, context2, isReceiver, false);
    }

    private static final ConeKotlinType prepareExpectedType(Candidate $this$prepareExpectedType, FirSession session2, ScopeSession scopeSession, FirExpression argument2, FirValueParameter parameter, ResolutionContext context2) {
        if (parameter == null) {
            return null;
        }
        ConeKotlinType basicExpectedType = ArgumentsKt.getExpectedTypeForSAMConversion(argument2, parameter);
        ConeKotlinType coneKotlinType = ArgumentsKt.getExpectedTypeWithSAMConversion($this$prepareExpectedType, session2, scopeSession, argument2, basicExpectedType, context2);
        ConeKotlinType expectedType2 = coneKotlinType == null ? basicExpectedType : coneKotlinType;
        return $this$prepareExpectedType.getSubstitutor().substituteOrSelf(expectedType2);
    }

    private static final ConeKotlinType getExpectedTypeWithSAMConversion(Candidate $this$getExpectedTypeWithSAMConversion, FirSession session2, ScopeSession scopeSession, FirExpression argument2, ConeKotlinType candidateExpectedType, ResolutionContext context2) {
        ConeKotlinType coneKotlinType;
        FirFunction firFunction;
        if (InferenceUtilsKt.isBuiltinFunctionalType(candidateExpectedType, session2)) {
            return null;
        }
        Object obj = $this$getExpectedTypeWithSAMConversion.getSymbol().getFir();
        FirFunction firFunction2 = firFunction = obj instanceof FirFunction ? (FirFunction)obj : null;
        if (firFunction == null) {
            return null;
        }
        FirFunction firFunction3 = firFunction;
        if (!context2.getBodyResolveComponents().getSamResolver().shouldRunSamConversionForFunction(firFunction3)) {
            return null;
        }
        ConeKotlinType expectedFunctionType = context2.getBodyResolveComponents().getSamResolver().getFunctionTypeForPossibleSamType(candidateExpectedType);
        boolean condition$iv = ArgumentsKt.isFunctional(argument2, session2, scopeSession, expectedFunctionType);
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            ConeKotlinType coneKotlinType2 = expectedFunctionType;
            boolean bl2 = false;
            boolean bl3 = false;
            ConeKotlinType $this$getExpectedTypeWithSAMConversion_u24lambda_u2d5_u24lambda_u2d4 = coneKotlinType2;
            boolean bl4 = false;
            $this$getExpectedTypeWithSAMConversion.setUsesSAM(true);
            coneKotlinType = coneKotlinType2;
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFunctional(@NotNull FirExpression $this$isFunctional, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, @Nullable ConeKotlinType expectedFunctionType) {
        boolean bl;
        Object object;
        FirExpression firExpression2;
        FirWrappedArgumentExpression firWrappedArgumentExpression;
        Intrinsics.checkNotNullParameter((Object)$this$isFunctional, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        FirWrappedArgumentExpression firWrappedArgumentExpression2 = firWrappedArgumentExpression = $this$isFunctional instanceof FirWrappedArgumentExpression ? (FirWrappedArgumentExpression)$this$isFunctional : null;
        FirExpression firExpression3 = firWrappedArgumentExpression == null ? $this$isFunctional : (firExpression2 = (object = firWrappedArgumentExpression.getExpression()) == null ? $this$isFunctional : object);
        if (firExpression2 instanceof FirAnonymousFunction) {
            return true;
        }
        boolean bl2 = firExpression2 instanceof FirCallableReferenceAccess;
        if (bl2) {
            return true;
        }
        Object $this$coneTypeSafe$iv = $this$isFunctional.getTypeRef();
        boolean $i$f$coneTypeSafe22 = false;
        boolean bl3 = false;
        Object object2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = object2 == null ? null : ((FirResolvedTypeRef)object2).getType();
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            return false;
        }
        object = coneKotlinType;
        if (object == null) {
            return false;
        }
        Object coneType = object;
        if (InferenceUtilsKt.isBuiltinFunctionalType((ConeKotlinType)coneType, session2)) {
            return true;
        }
        FirFunctionSymbol<?> $i$f$coneTypeSafe22 = expectedFunctionType;
        $this$coneTypeSafe$iv = $i$f$coneTypeSafe22 == null ? null : ConeTypesKt.lowerBoundIfFlexible((ConeKotlinType)((Object)$i$f$coneTypeSafe22));
        if (!($this$coneTypeSafe$iv instanceof ConeClassLikeType)) return false;
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)$this$coneTypeSafe$iv;
        ConeClassLikeType classLikeExpectedFunctionType = coneClassLikeType;
        if (classLikeExpectedFunctionType == null) return false;
        if (coneType instanceof ConeIntegerLiteralType) {
            return false;
        }
        $i$f$coneTypeSafe22 = InferenceUtilsKt.findContributedInvokeSymbol((ConeKotlinType)coneType, session2, scopeSession, classLikeExpectedFunctionType, false);
        if ($i$f$coneTypeSafe22 == null) {
            return false;
        }
        FirFunctionSymbol<?> invokeSymbol2 = $i$f$coneTypeSafe22;
        object2 = InferenceUtilsKt.returnType(classLikeExpectedFunctionType, session2);
        Intrinsics.checkNotNull((Object)object2);
        ConeKotlinType expectedReturnType = ConeTypesKt.lowerBoundIfFlexible((ConeKotlinType)object2);
        if (!(expectedReturnType instanceof ConeTypeParameterType)) {
            ConeKotlinType coneKotlinType2;
            AbstractTypeCheckerContext abstractTypeCheckerContext = InferenceComponentsKt.getInferenceComponents(session2).getCtx();
            FirTypeRef $this$coneType$iv = ((FirFunction)invokeSymbol2.getFir()).getReturnTypeRef();
            boolean $i$f$getConeType = false;
            Object $this$coneTypeSafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeSafe = false;
            boolean bl4 = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType3 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType3 instanceof ConeKotlinType)) {
                coneKotlinType3 = null;
            }
            if ((coneKotlinType2 = coneKotlinType3) == null) {
                $this$coneTypeSafe$iv$iv = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException($this$coneTypeSafe$iv$iv.toString());
            }
            if (!AbstractTypeChecker.INSTANCE.isSubtypeOf(abstractTypeCheckerContext, (KotlinTypeMarker)coneKotlinType2, (KotlinTypeMarker)expectedReturnType, false)) return false;
        }
        boolean bl6 = true;
        boolean returnTypeCompatible = bl6;
        if (!returnTypeCompatible) {
            return false;
        }
        if (((FirFunction)invokeSymbol2.getFir()).getValueParameters().size() != classLikeExpectedFunctionType.getTypeArguments().length - 1) {
            return false;
        }
        List parameterPairs = CollectionsKt.zip((Iterable)((FirFunction)invokeSymbol2.getFir()).getValueParameters(), (Iterable)InferenceUtilsKt.valueParameterTypesIncludingReceiver(classLikeExpectedFunctionType, session2));
        Iterable $this$all$iv = parameterPairs;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            Pair $dstr$invokeParameter$expectedParameter = (Pair)element$iv;
            boolean bl7 = false;
            FirValueParameter invokeParameter = (FirValueParameter)$dstr$invokeParameter$expectedParameter.component1();
            ConeKotlinType expectedParameter = (ConeKotlinType)$dstr$invokeParameter$expectedParameter.component2();
            Intrinsics.checkNotNull((Object)expectedParameter);
            ConeKotlinType expectedParameterType = ConeTypesKt.lowerBoundIfFlexible(expectedParameter);
            if (!(expectedParameterType instanceof ConeTypeParameterType)) {
                ConeKotlinType coneKotlinType4;
                AbstractTypeCheckerContext abstractTypeCheckerContext = InferenceComponentsKt.getInferenceComponents(session2).getCtx();
                FirTypeRef $this$coneType$iv = invokeParameter.getReturnTypeRef();
                boolean $i$f$getConeType = false;
                FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeSafe = false;
                boolean bl8 = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
                ConeKotlinType coneKotlinType5 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                if (!(coneKotlinType5 instanceof ConeKotlinType)) {
                    coneKotlinType5 = null;
                }
                if ((coneKotlinType4 = coneKotlinType5) == null) {
                    String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                    boolean bl9 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                if (!AbstractTypeChecker.INSTANCE.isSubtypeOf(abstractTypeCheckerContext, (KotlinTypeMarker)coneKotlinType4, (KotlinTypeMarker)expectedParameterType, false)) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    public static final ConeKotlinType getExpectedTypeForSAMConversion(@NotNull FirExpression $this$getExpectedTypeForSAMConversion, @NotNull FirValueParameter parameter) {
        ConeKotlinType coneKotlinType;
        FirTypeRef $this$coneType$iv;
        boolean shouldUnwrapVarargType;
        Intrinsics.checkNotNullParameter((Object)$this$getExpectedTypeForSAMConversion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        FirExpression firExpression2 = $this$getExpectedTypeForSAMConversion;
        boolean bl = firExpression2 instanceof FirSpreadArgumentExpression ? !((FirSpreadArgumentExpression)$this$getExpectedTypeForSAMConversion).isSpread() : (shouldUnwrapVarargType = firExpression2 instanceof FirNamedArgumentExpression ? ((FirNamedArgumentExpression)$this$getExpectedTypeForSAMConversion).getExpression() instanceof FirConstExpression : true);
        if (parameter.isVararg() && shouldUnwrapVarargType) {
            ConeKotlinType coneKotlinType2;
            $this$coneType$iv = parameter.getReturnTypeRef();
            boolean $i$f$getConeType = false;
            Object $this$coneTypeSafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeSafe = false;
            boolean bl2 = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType3 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType3 instanceof ConeKotlinType)) {
                coneKotlinType3 = null;
            }
            if ((coneKotlinType2 = coneKotlinType3) == null) {
                $this$coneTypeSafe$iv$iv = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                $i$f$coneTypeSafe = false;
                throw (Throwable)new IllegalStateException($this$coneTypeSafe$iv$iv.toString());
            }
            coneKotlinType = ArgumentsKt.varargElementType(coneKotlinType2);
        } else {
            ConeKotlinType coneKotlinType4;
            $this$coneType$iv = parameter.getReturnTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeSafe = false;
            boolean bl3 = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType5 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType5 instanceof ConeKotlinType)) {
                coneKotlinType5 = null;
            }
            if ((coneKotlinType4 = coneKotlinType5) == null) {
                String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            coneKotlinType = coneKotlinType4;
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType varargElementType(@NotNull ConeKotlinType $this$varargElementType) {
        Intrinsics.checkNotNullParameter((Object)$this$varargElementType, (String)"<this>");
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$varargElementType);
        return coneKotlinType == null ? $this$varargElementType : coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeKotlinType captureFromTypeParameterUpperBoundIfNeeded(@NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType2, @NotNull FirSession session2) {
        Object v2;
        ConeTypeCheckerContext context2;
        block9: {
            void $this$singleOrNull$iv;
            void $this$mapTo$iv$iv;
            ConeTypeParameterType coneTypeParameterType;
            Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
            Intrinsics.checkNotNullParameter((Object)expectedType2, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypesKt.upperBoundIfFlexible(expectedType2));
            if (classId == null) {
                return argumentType;
            }
            ClassId expectedTypeClassId = classId;
            ConeKotlinType coneKotlinType = ConeTypesKt.lowerBoundIfFlexible(argumentType);
            ConeTypeParameterType coneTypeParameterType2 = coneTypeParameterType = coneKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneKotlinType : null;
            if (coneTypeParameterType == null) {
                return argumentType;
            }
            ConeTypeParameterType simplifiedArgumentType = coneTypeParameterType;
            FirTypeParameter typeParameter = (FirTypeParameter)simplifiedArgumentType.getLookupTag().getTypeParameterSymbol().getFir();
            context2 = SessionUtilsKt.getTypeCheckerContext(session2);
            Iterable $this$map$iv = typeParameter.getBounds();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ConeKotlinType coneKotlinType2;
                void it;
                FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void $this$coneType$iv = it;
                boolean $i$f$getConeType = false;
                void $this$coneTypeSafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeSafe = false;
                boolean bl2 = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
                ConeKotlinType coneKotlinType3 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                if (!(coneKotlinType3 instanceof ConeKotlinType)) {
                    coneKotlinType3 = null;
                }
                if ((coneKotlinType2 = coneKotlinType3) == null) {
                    String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default((FirElement)$this$coneType$iv, null, 1, null);
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                ConeKotlinType coneKotlinType4 = coneKotlinType2;
                collection.add(coneKotlinType4);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                if (!ArgumentsKt.hasSupertypeWithGivenClassId(it, expectedTypeClassId, context2)) continue;
                if (found$iv) {
                    v2 = null;
                    break block9;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        ConeKotlinType coneKotlinType = v2;
        if (coneKotlinType == null) {
            return argumentType;
        }
        ConeKotlinType chosenSupertype = coneKotlinType;
        ConeKotlinType coneKotlinType5 = (ConeKotlinType)context2.captureFromExpression(chosenSupertype);
        if (coneKotlinType5 == null) {
            return argumentType;
        }
        ConeKotlinType capturedType = coneKotlinType5;
        return argumentType instanceof ConeDefinitelyNotNullType ? ((coneKotlinType5 = TypeUtilsKt.create(ConeDefinitelyNotNullType.Companion, capturedType)) == null ? capturedType : coneKotlinType5) : capturedType;
    }

    private static final boolean hasSupertypeWithGivenClassId(ConeKotlinType $this$hasSupertypeWithGivenClassId, ClassId classId, ConeTypeCheckerContext context2) {
        boolean bl = false;
        boolean bl2 = false;
        ConeTypeCheckerContext $this$hasSupertypeWithGivenClassId_u24lambda_u2d9 = context2;
        boolean bl3 = false;
        return $this$hasSupertypeWithGivenClassId_u24lambda_u2d9.anySuperTypeConstructor($this$hasSupertypeWithGivenClassId, (Function1<? super TypeConstructorMarker, Boolean>)((Function1)new Function1<TypeConstructorMarker, Boolean>(classId){
            final /* synthetic */ ClassId $classId;
            {
                this.$classId = $classId;
                super(1);
            }

            public final boolean invoke(@NotNull TypeConstructorMarker it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof ConeClassLikeLookupTag && Intrinsics.areEqual((Object)((ConeClassLikeLookupTag)it).getClassId(), (Object)this.$classId);
            }
        }));
    }
}

