/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.controlFlow;

import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.psi.JavaCodeFragment;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssertStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiBlockStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiBreakStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassObjectAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiConstantEvaluationHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiContinueStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDoWhileStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEmptyStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionListStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiForStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIfStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiInstanceOfExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLabeledStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiLoopStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPatternVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPostfixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecordComponent;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceListElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabelStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabelStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabeledRuleStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSynchronizedStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiThisExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiThrowStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTryStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeTestPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhileStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiYieldStatement;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.AnalysisCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.AnalysisCanceledSoftException;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.BranchingInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.CallInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlow;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowFactory;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowImpl;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowPolicy;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowSubRange;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowUtil;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.EmptyInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.GoToInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ReadVariableInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ReturnInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ThrowToInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.WriteVariableInstruction;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaPsiRecordUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;

class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance(ControlFlowAnalyzer.class);
    private final PsiElement myCodeFragment;
    private final ControlFlowPolicy myPolicy;
    private ControlFlowImpl myCurrentFlow;
    private final Stack<PsiParameter> myCatchParameters;
    private final Stack<PsiElement> myCatchBlocks;
    private final Stack<FinallyBlockSubroutine> myFinallyBlocks;
    private final Stack<PsiElement> myUnhandledExceptionCatchBlocks;
    private final StatementStack myStartStatementStack;
    private final StatementStack myEndStatementStack;
    private final Stack<BranchingInstruction.Role> myStartJumpRoles;
    private final Stack<BranchingInstruction.Role> myEndJumpRoles;
    private final boolean myEnabledShortCircuit;
    private final boolean myEvaluateConstantIfCondition;
    private final boolean myAssignmentTargetsAreElements;
    private final Stack<TIntArrayList> intArrayPool;
    private final Map<PsiElement, TIntArrayList> offsetsAddElementStart;
    private final Map<PsiElement, TIntArrayList> offsetsAddElementEnd;
    private final ControlFlowFactory myControlFlowFactory;
    private final Map<PsiElement, ControlFlowSubRange> mySubRanges;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final Map<PsiField, PsiParameter> myImplicitCompactConstructorAssignments;
    private final Map<PsiElement, List<PsiElement>> finallyBlockToUnhandledExceptions;

    ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition) {
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(0);
        }
        if (policy == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(1);
        }
        this(codeFragment, policy, enabledShortCircuit, evaluateConstantIfCondition, false);
    }

    private ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition, boolean assignmentTargetsAreElements) {
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(2);
        }
        if (policy == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(3);
        }
        this.myCatchParameters = new Stack();
        this.myCatchBlocks = new Stack();
        this.myFinallyBlocks = new Stack();
        this.myUnhandledExceptionCatchBlocks = new Stack();
        this.myStartStatementStack = new StatementStack();
        this.myEndStatementStack = new StatementStack();
        this.myStartJumpRoles = new Stack();
        this.myEndJumpRoles = new Stack();
        this.intArrayPool = new Stack();
        this.offsetsAddElementStart = new THashMap();
        this.offsetsAddElementEnd = new THashMap();
        this.mySubRanges = new THashMap();
        this.finallyBlockToUnhandledExceptions = new HashMap<PsiElement, List<PsiElement>>();
        this.myCodeFragment = codeFragment;
        this.myPolicy = policy;
        this.myEnabledShortCircuit = enabledShortCircuit;
        this.myEvaluateConstantIfCondition = evaluateConstantIfCondition;
        this.myAssignmentTargetsAreElements = assignmentTargetsAreElements;
        Project project = codeFragment.getProject();
        this.myControlFlowFactory = ControlFlowFactory.getInstance(project);
        this.myConstantEvaluationHelper = JavaPsiFacade.getInstance(project).getConstantEvaluationHelper();
        this.myImplicitCompactConstructorAssignments = this.getImplicitCompactConstructorAssignmentsMap();
    }

    private Map<PsiField, PsiParameter> getImplicitCompactConstructorAssignmentsMap() {
        PsiMethod ctor = ObjectUtils.tryCast(this.myCodeFragment.getParent(), PsiMethod.class);
        if (ctor == null || !JavaPsiRecordUtil.isCompactConstructor(ctor)) {
            return Collections.emptyMap();
        }
        PsiClass containingClass = ctor.getContainingClass();
        if (containingClass == null) {
            return Collections.emptyMap();
        }
        PsiParameter[] parameters2 = ctor.getParameterList().getParameters();
        PsiRecordComponent[] components2 = containingClass.getRecordComponents();
        HashMap<PsiField, PsiParameter> map = new HashMap<PsiField, PsiParameter>();
        for (int i = 0; i < Math.min(components2.length, parameters2.length); ++i) {
            PsiRecordComponent component = components2[i];
            PsiField field = JavaPsiRecordUtil.getFieldForComponent(component);
            PsiParameter parameter = parameters2[i];
            map.put(field, parameter);
        }
        return map;
    }

    @NotNull
    ControlFlow buildControlFlow() throws AnalysisCanceledException {
        this.myStartJumpRoles.push(BranchingInstruction.Role.END);
        this.myEndJumpRoles.push(BranchingInstruction.Role.END);
        this.myCurrentFlow = new ControlFlowImpl();
        this.myStartStatementStack.pushStatement(this.myCodeFragment, false);
        this.myEndStatementStack.pushStatement(this.myCodeFragment, false);
        try {
            this.myCodeFragment.accept(this);
            this.cleanup();
        }
        catch (AnalysisCanceledSoftException e) {
            throw new AnalysisCanceledException(e.getErrorElement());
        }
        ControlFlowImpl controlFlowImpl = this.myCurrentFlow;
        if (controlFlowImpl == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(4);
        }
        return controlFlowImpl;
    }

    private void generateCompactConstructorAssignments() {
        this.myImplicitCompactConstructorAssignments.values().stream().filter(this.myPolicy::isParameterAccepted).forEach(this::generateReadInstruction);
    }

    @NotNull
    private TIntArrayList getEmptyIntArray() {
        if (this.intArrayPool.isEmpty()) {
            return new TIntArrayList(1);
        }
        TIntArrayList list2 = this.intArrayPool.pop();
        list2.clear();
        TIntArrayList tIntArrayList = list2;
        if (tIntArrayList == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(5);
        }
        return tIntArrayList;
    }

    private void poolIntArray(@NotNull TIntArrayList list2) {
        if (list2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(6);
        }
        this.intArrayPool.add(list2);
    }

    private void addElementOffsetLater(@NotNull PsiElement element, boolean atStart) {
        Map<PsiElement, TIntArrayList> offsetsAddElement;
        TIntArrayList offsets;
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(7);
        }
        if ((offsets = (offsetsAddElement = atStart ? this.offsetsAddElementStart : this.offsetsAddElementEnd).get(element)) == null) {
            offsets = this.getEmptyIntArray();
            offsetsAddElement.put(element, offsets);
        }
        int offset2 = this.myCurrentFlow.getSize() - 1;
        offsets.add(offset2);
        if (this.myCurrentFlow.getEndOffset(element) != -1) {
            this.patchInstructionOffsets(element);
        }
    }

    private void patchInstructionOffsets(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(8);
        }
        this.patchInstructionOffsets(this.offsetsAddElementStart.get(element), this.myCurrentFlow.getStartOffset(element));
        this.offsetsAddElementStart.put(element, null);
        this.patchInstructionOffsets(this.offsetsAddElementEnd.get(element), this.myCurrentFlow.getEndOffset(element));
        this.offsetsAddElementEnd.put(element, null);
    }

    private void patchInstructionOffsets(@Nullable TIntArrayList offsets, int add2) {
        if (offsets == null) {
            return;
        }
        for (int i = 0; i < offsets.size(); ++i) {
            int offset2 = offsets.get(i);
            BranchingInstruction instruction = (BranchingInstruction)this.myCurrentFlow.getInstructions().get(offset2);
            instruction.offset += add2;
            LOG.assertTrue(instruction.offset >= 0);
        }
        this.poolIntArray(offsets);
    }

    private void cleanup() {
        for (TIntArrayList tIntArrayList : this.offsetsAddElementStart.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (TIntArrayList tIntArrayList : this.offsetsAddElementEnd.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (Map.Entry entry : this.mySubRanges.entrySet()) {
            ProgressManager.checkCanceled();
            ControlFlowSubRange subRange = (ControlFlowSubRange)entry.getValue();
            PsiElement element = (PsiElement)entry.getKey();
            this.myControlFlowFactory.registerSubRange(element, subRange, this.myEvaluateConstantIfCondition, this.myEnabledShortCircuit, this.myPolicy);
        }
    }

    private void startElement(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(9);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressManager.checkCanceled();
            if (!(child instanceof PsiErrorElement) || Comparing.strEqual(((PsiErrorElement)child).getErrorDescription(), JavaPsiBundle.message("expected.semicolon", new Object[0]))) continue;
            throw new AnalysisCanceledSoftException(element);
        }
        ProgressManager.checkCanceled();
        this.myCurrentFlow.startElement(element);
        this.generateUncheckedExceptionJumpsIfNeeded(element, true);
    }

    private void generateUncheckedExceptionJumpsIfNeeded(@NotNull PsiElement element, boolean atStart) {
        boolean isGeneratingCodeBlock;
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(10);
        }
        boolean isGeneratingStatement = element instanceof PsiStatement && !(element instanceof PsiSwitchLabelStatement);
        boolean bl = isGeneratingCodeBlock = element instanceof PsiCodeBlock && !(element.getParent() instanceof PsiSwitchStatement);
        if (isGeneratingStatement || isGeneratingCodeBlock) {
            this.generateUncheckedExceptionJumps(element, atStart);
        }
    }

    private void finishElement(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(11);
        }
        this.generateUncheckedExceptionJumpsIfNeeded(element, false);
        this.myCurrentFlow.finishElement(element);
        this.patchInstructionOffsets(element);
    }

    private void generateUncheckedExceptionJumps(@NotNull PsiElement element, boolean atStart) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(12);
        }
        if (atStart && element instanceof PsiStatement && element.getParent() instanceof PsiCodeBlock && element.getPrevSibling() != null) {
            return;
        }
        for (int i = this.myUnhandledExceptionCatchBlocks.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiElement block = (PsiElement)this.myUnhandledExceptionCatchBlocks.get(i);
            if (block == null) {
                if (this.myFinallyBlocks.isEmpty()) continue;
                break;
            }
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-1);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, block)) continue;
            this.addElementOffsetLater(block, true);
        }
        if (!this.myFinallyBlocks.isEmpty()) {
            PsiElement finallyBlock = this.myFinallyBlocks.peek().getElement();
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-2);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (!this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, finallyBlock)) {
                this.addElementOffsetLater(finallyBlock, true);
            }
        }
    }

    private void generateCheckedExceptionJumps(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(13);
        }
        this.generateExceptionJumps(element, ExceptionUtil.collectUnhandledExceptions(element, element.getParent()));
    }

    private void generateExceptionJumps(@NotNull PsiElement element, Collection<? extends PsiClassType> unhandledExceptions) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(14);
        }
        for (PsiClassType psiClassType : unhandledExceptions) {
            ProgressManager.checkCanceled();
            this.generateThrow(psiClassType, element);
        }
    }

    private void generateThrow(@NotNull PsiClassType unhandledException, @NotNull PsiElement throwingElement) {
        if (unhandledException == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(15);
        }
        if (throwingElement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(16);
        }
        List<PsiElement> catchBlocks = this.findThrowToBlocks(unhandledException);
        for (PsiElement block : catchBlocks) {
            ProgressManager.checkCanceled();
            ConditionalThrowToInstruction instruction = new ConditionalThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.patchCheckedThrowInstructionIfInsideFinally(instruction, throwingElement, block)) continue;
            if (block == null) {
                this.addElementOffsetLater(this.myCodeFragment, false);
                continue;
            }
            --instruction.offset;
            this.addElementOffsetLater(block, true);
        }
    }

    private boolean patchCheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, @NotNull PsiElement throwingElement, PsiElement elementToJumpTo) {
        PsiElement finallyBlock;
        if (instruction == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(17);
        }
        if (throwingElement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(18);
        }
        if ((finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo)) == null) {
            return false;
        }
        List unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.computeIfAbsent(finallyBlock, k -> new ArrayList());
        int index2 = unhandledExceptionCatchBlocks.indexOf(elementToJumpTo);
        if (index2 == -1) {
            index2 = unhandledExceptionCatchBlocks.size();
            unhandledExceptionCatchBlocks.add(elementToJumpTo);
        }
        instruction.offset = 3 + index2;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    private boolean patchUncheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, @NotNull PsiElement throwingElement, @NotNull PsiElement elementToJumpTo) {
        PsiElement finallyBlock;
        if (instruction == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(19);
        }
        if (throwingElement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(20);
        }
        if (elementToJumpTo == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(21);
        }
        if ((finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo)) == null) {
            return false;
        }
        instruction.offset = 2;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    @Override
    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiElement[] children2;
        this.startElement(codeFragment);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiElement child : children2 = codeFragment.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept(this);
        }
        this.finishElement(codeFragment);
        this.registerSubRange(codeFragment, prevOffset);
    }

    private void registerSubRange(@NotNull PsiElement codeFragment, int startOffset) {
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(22);
        }
        ControlFlowSubRange flow = new ControlFlowSubRange(this.myCurrentFlow, startOffset, this.myCurrentFlow.getSize());
        this.mySubRanges.put(codeFragment, flow);
    }

    @Override
    public void visitCodeBlock(PsiCodeBlock block) {
        PsiStatement[] statements2;
        this.startElement(block);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiStatement statement2 : statements2 = block.getStatements()) {
            ProgressManager.checkCanceled();
            statement2.accept(this);
        }
        int nextOffset = this.myCurrentFlow.getSize();
        if (!(block.getParent() instanceof PsiSwitchStatement) && prevOffset == nextOffset) {
            this.emitEmptyInstruction();
        }
        if (block == this.myCodeFragment) {
            this.generateCompactConstructorAssignments();
        }
        this.finishElement(block);
        if (prevOffset != 0) {
            this.registerSubRange(block, prevOffset);
        }
    }

    private void emitEmptyInstruction() {
        this.myCurrentFlow.addInstruction(EmptyInstruction.INSTANCE);
    }

    @Override
    public void visitFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(23);
        }
        this.visitChildren(file2);
    }

    @Override
    public void visitBlockStatement(PsiBlockStatement statement2) {
        this.startElement(statement2);
        PsiCodeBlock codeBlock = statement2.getCodeBlock();
        codeBlock.accept(this);
        this.finishElement(statement2);
    }

    @Override
    public void visitBreakStatement(PsiBreakStatement statement2) {
        this.generateYieldInstructions(statement2, null, statement2.findExitedStatement());
    }

    @Override
    public void visitYieldStatement(PsiYieldStatement statement2) {
        this.generateYieldInstructions(statement2, statement2.getExpression(), statement2.findEnclosingExpression());
    }

    private void generateYieldInstructions(PsiStatement statement2, PsiExpression valueExpression, PsiElement exitedStatement) {
        this.startElement(statement2);
        this.generateExpressionInstructions(valueExpression);
        if (exitedStatement != null) {
            GoToInstruction instruction;
            int finallyStartOffset;
            this.callFinallyBlocksOnExit(exitedStatement);
            PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(statement2, exitedStatement);
            int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, callInstruction);
            } else {
                instruction = new GoToInstruction(0, BranchingInstruction.Role.END, PsiTreeUtil.isAncestor(exitedStatement, this.myCodeFragment, true));
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(exitedStatement, false);
        }
        this.finishElement(statement2);
    }

    private void callFinallyBlocksOnExit(PsiElement exitedStatement) {
        FinallyBlockSubroutine finallyBlockSubroutine;
        PsiElement finallyBlock;
        PsiElement enclosingTryStatement;
        ListIterator it = this.myFinallyBlocks.listIterator(this.myFinallyBlocks.size());
        while (it.hasPrevious() && (enclosingTryStatement = (finallyBlock = (finallyBlockSubroutine = (FinallyBlockSubroutine)it.previous()).getElement()).getParent()) != null && PsiTreeUtil.isAncestor(exitedStatement, enclosingTryStatement, false)) {
            CallInstruction instruction = new CallInstruction(0, 0);
            finallyBlockSubroutine.addCall(instruction);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(finallyBlock, true);
        }
    }

    private PsiElement findEnclosingFinallyBlockElement(@NotNull PsiElement sourceElement, @Nullable PsiElement jumpElement) {
        if (sourceElement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(24);
        }
        for (PsiElement element = sourceElement; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiCodeBlock) || !(element.getParent() instanceof PsiTryStatement) || ((PsiTryStatement)element.getParent()).getFinallyBlock() != element) continue;
            if (this.myCurrentFlow.getStartOffset(element.getParent()) == -1) {
                return null;
            }
            if (jumpElement != null && PsiTreeUtil.isAncestor(element, jumpElement, false)) continue;
            return element;
        }
        return null;
    }

    @Override
    public void visitContinueStatement(PsiContinueStatement statement2) {
        this.startElement(statement2);
        PsiStatement continuedStatement = statement2.findContinuedStatement();
        if (continuedStatement != null) {
            GoToInstruction instruction;
            int finallyStartOffset;
            PsiElement body2 = null;
            if (continuedStatement instanceof PsiLoopStatement) {
                body2 = ((PsiLoopStatement)continuedStatement).getBody();
            }
            if (body2 == null) {
                body2 = this.myCodeFragment;
            }
            this.callFinallyBlocksOnExit(continuedStatement);
            PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(statement2, continuedStatement);
            int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, callInstruction);
            } else {
                instruction = new GoToInstruction(0, BranchingInstruction.Role.END, PsiTreeUtil.isAncestor(body2, this.myCodeFragment, true));
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(body2, false);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
        PsiElement[] elements;
        this.startElement(statement2);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement element : elements = statement2.getDeclaredElements()) {
            ProgressManager.checkCanceled();
            if (element instanceof PsiClass) {
                element.accept(this);
                continue;
            }
            if (!(element instanceof PsiVariable)) continue;
            this.processVariable((PsiVariable)element);
        }
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement(statement2);
    }

    private void processVariable(@NotNull PsiVariable element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(25);
        }
        PsiExpression initializer2 = element.getInitializer();
        this.generateExpressionInstructions(initializer2);
        if (element instanceof PsiLocalVariable && initializer2 != null || element instanceof PsiField) {
            if (element instanceof PsiLocalVariable && !this.myPolicy.isLocalVariableAccepted((PsiLocalVariable)element)) {
                return;
            }
            if (this.myAssignmentTargetsAreElements) {
                this.startElement(element);
            }
            this.generateWriteInstruction(element);
            if (this.myAssignmentTargetsAreElements) {
                this.finishElement(element);
            }
        }
    }

    @Override
    public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
        PsiExpression condition;
        this.startElement(statement2);
        PsiStatement body2 = statement2.getBody();
        this.myStartStatementStack.pushStatement(body2 == null ? statement2 : body2, true);
        this.myEndStatementStack.pushStatement(statement2, false);
        if (body2 != null) {
            body2.accept(this);
        }
        if ((condition = statement2.getCondition()) != null) {
            condition.accept(this);
        }
        int offset2 = this.myCurrentFlow.getStartOffset(statement2);
        Object loopCondition = this.myConstantEvaluationHelper.computeConstantExpression(statement2.getCondition());
        if (loopCondition instanceof Boolean) {
            if (((Boolean)loopCondition).booleanValue()) {
                this.myCurrentFlow.addInstruction(new GoToInstruction(offset2));
            } else {
                this.emitEmptyInstruction();
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(offset2, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement2);
    }

    @Override
    public void visitEmptyStatement(PsiEmptyStatement statement2) {
        this.startElement(statement2);
        this.emitEmptyInstruction();
        this.finishElement(statement2);
    }

    @Override
    public void visitExpressionStatement(PsiExpressionStatement statement2) {
        this.startElement(statement2);
        PsiExpression expression2 = statement2.getExpression();
        expression2.accept(this);
        for (PsiParameter catchParameter : this.myCatchParameters) {
            ProgressManager.checkCanceled();
            PsiType type2 = catchParameter.getType();
            List<PsiType> types2 = type2 instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type2).getDisjunctions() : Collections.singletonList(type2);
            for (PsiType subType : types2) {
                if (!(subType instanceof PsiClassType)) continue;
                this.generateThrow((PsiClassType)subType, statement2);
            }
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitExpressionListStatement(PsiExpressionListStatement statement2) {
        PsiExpression[] expressions;
        this.startElement(statement2);
        for (PsiExpression expr : expressions = statement2.getExpressionList().getExpressions()) {
            ProgressManager.checkCanceled();
            expr.accept(this);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitField(PsiField field) {
        PsiExpression initializer2 = field.getInitializer();
        if (initializer2 != null) {
            this.startElement(field);
            initializer2.accept(this);
            this.finishElement(field);
        }
    }

    @Override
    public void visitForStatement(PsiForStatement statement2) {
        PsiStatement update;
        Object loopCondition;
        PsiExpression condition;
        this.startElement(statement2);
        PsiStatement body2 = statement2.getBody();
        this.myStartStatementStack.pushStatement(body2 == null ? statement2 : body2, false);
        this.myEndStatementStack.pushStatement(statement2, false);
        PsiStatement initialization = statement2.getInitialization();
        if (initialization != null) {
            initialization.accept(this);
        }
        if ((condition = statement2.getCondition()) != null) {
            condition.accept(this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression(condition)) instanceof Boolean || condition == null) {
            boolean value2;
            boolean bl = value2 = condition == null || (Boolean)loopCondition != false;
            if (value2) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater(statement2, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(statement2, false);
        }
        if (body2 != null) {
            body2.accept(this);
        }
        if ((update = statement2.getUpdate()) != null) {
            update.accept(this);
        }
        int offset2 = initialization != null ? this.myCurrentFlow.getEndOffset(initialization) : this.myCurrentFlow.getStartOffset(statement2);
        GoToInstruction instruction = new GoToInstruction(offset2);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement2);
    }

    @Override
    public void visitForeachStatement(PsiForeachStatement statement2) {
        this.startElement(statement2);
        PsiStatement body2 = statement2.getBody();
        this.myStartStatementStack.pushStatement(body2 == null ? statement2 : body2, false);
        this.myEndStatementStack.pushStatement(statement2, false);
        PsiExpression iteratedValue = statement2.getIteratedValue();
        if (iteratedValue != null) {
            iteratedValue.accept(this);
        }
        int gotoTarget = this.myCurrentFlow.getSize();
        ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getIteratedValue());
        this.myCurrentFlow.addInstruction(instruction);
        this.addElementOffsetLater(statement2, false);
        PsiParameter iterationParameter = statement2.getIterationParameter();
        if (this.myPolicy.isParameterAccepted(iterationParameter)) {
            this.generateWriteInstruction(iterationParameter);
        }
        if (body2 != null) {
            body2.accept(this);
        }
        GoToInstruction gotoInstruction = new GoToInstruction(gotoTarget);
        this.myCurrentFlow.addInstruction(gotoInstruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement2);
    }

    @Override
    public void visitIfStatement(PsiIfStatement statement2) {
        this.startElement(statement2);
        PsiStatement elseBranch = statement2.getElseBranch();
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpression conditionExpression = statement2.getCondition();
        this.generateConditionalStatementInstructions(statement2, conditionExpression, thenBranch, elseBranch);
        this.finishElement(statement2);
    }

    private void generateConditionalStatementInstructions(@NotNull PsiElement statement2, @Nullable PsiExpression conditionExpression, PsiElement thenBranch, PsiElement elseBranch) {
        Object value2;
        if (statement2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(26);
        }
        if (thenBranch == null) {
            this.myStartStatementStack.pushStatement(statement2, false);
        } else {
            this.myStartStatementStack.pushStatement(thenBranch, true);
        }
        if (elseBranch == null) {
            this.myEndStatementStack.pushStatement(statement2, false);
        } else {
            this.myEndStatementStack.pushStatement(elseBranch, true);
        }
        this.myEndJumpRoles.push(elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE);
        this.myStartJumpRoles.push(thenBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.THEN);
        if (conditionExpression != null) {
            conditionExpression.accept(this);
        }
        boolean thenReachable = true;
        boolean generateConditionalJump = true;
        if (this.myEvaluateConstantIfCondition && (value2 = this.myConstantEvaluationHelper.computeConstantExpression(conditionExpression)) instanceof Boolean) {
            thenReachable = (Boolean)value2;
            generateConditionalJump = false;
            this.myCurrentFlow.setConstantConditionOccurred(true);
        }
        if (generateConditionalJump || !thenReachable) {
            BranchingInstruction.Role role = elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE;
            BranchingInstruction instruction = generateConditionalJump ? new ConditionalGoToInstruction(0, role, conditionExpression) : new GoToInstruction(0, role);
            this.myCurrentFlow.addInstruction(instruction);
            if (elseBranch == null) {
                this.addElementOffsetLater(statement2, false);
            } else {
                this.addElementOffsetLater(elseBranch, true);
            }
        }
        if (thenBranch != null) {
            thenBranch.accept(this);
        }
        if (elseBranch != null) {
            GoToInstruction instruction = new GoToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(statement2, false);
            elseBranch.accept(this);
        }
        this.myStartJumpRoles.pop();
        this.myEndJumpRoles.pop();
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
    }

    @Override
    public void visitLabeledStatement(PsiLabeledStatement statement2) {
        this.startElement(statement2);
        PsiStatement innerStatement = statement2.getStatement();
        if (innerStatement != null) {
            innerStatement.accept(this);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitReturnStatement(PsiReturnStatement statement2) {
        this.startElement(statement2);
        PsiExpression returnValue = statement2.getReturnValue();
        if (returnValue != null) {
            this.myStartStatementStack.pushStatement(returnValue, false);
            this.myEndStatementStack.pushStatement(returnValue, false);
            returnValue.accept(this);
        }
        this.addReturnInstruction(statement2);
        if (returnValue != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        this.finishElement(statement2);
    }

    private void addReturnInstruction(@NotNull PsiElement statement2) {
        PsiElement finallyBlock;
        int finallyStartOffset;
        if (statement2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(27);
        }
        int n = finallyStartOffset = (finallyBlock = this.findEnclosingFinallyBlockElement(statement2, null)) == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
        if (finallyBlock != null && finallyStartOffset != -1) {
            GoToInstruction instruction = new GoToInstruction(1, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(finallyBlock, false);
        } else {
            GoToInstruction instruction = new GoToInstruction(0, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                this.addElementOffsetLater(this.myCodeFragment, false);
            } else {
                instruction.offset = -4;
                this.addElementOffsetLater(this.myFinallyBlocks.peek().getElement(), true);
            }
        }
    }

    @Override
    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement2) {
        this.startElement(statement2);
        this.generateCaseValueInstructions(statement2.getCaseValues());
        this.finishElement(statement2);
    }

    @Override
    public void visitSwitchLabeledRuleStatement(PsiSwitchLabeledRuleStatement statement2) {
        PsiSwitchBlock switchBlock;
        this.startElement(statement2);
        this.generateCaseValueInstructions(statement2.getCaseValues());
        PsiStatement body2 = statement2.getBody();
        if (body2 != null) {
            body2.accept(this);
        }
        if ((switchBlock = statement2.getEnclosingSwitchBlock()) != null) {
            GoToInstruction instruction = new GoToInstruction(0, BranchingInstruction.Role.END, PsiTreeUtil.isAncestor(switchBlock, this.myCodeFragment, true));
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(switchBlock, false);
        }
        this.finishElement(statement2);
    }

    private void generateCaseValueInstructions(@Nullable PsiExpressionList values) {
        if (values != null) {
            for (PsiExpression caseValue : values.getExpressions()) {
                ProgressManager.checkCanceled();
                this.generateExpressionInstructions(caseValue);
            }
        }
    }

    @Override
    public void visitSwitchStatement(PsiSwitchStatement statement2) {
        this.generateSwitchBlockInstructions(statement2);
    }

    @Override
    public void visitSwitchExpression(PsiSwitchExpression expression2) {
        this.generateSwitchBlockInstructions(expression2);
    }

    public void generateSwitchBlockInstructions(PsiSwitchBlock statement2) {
        PsiCodeBlock body2;
        this.startElement(statement2);
        PsiExpression expr = statement2.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
        if ((body2 = statement2.getBody()) != null) {
            PsiStatement[] statements2 = body2.getStatements();
            PsiSwitchLabelStatementBase defaultLabel = null;
            for (PsiStatement aStatement : statements2) {
                ProgressManager.checkCanceled();
                if (!(aStatement instanceof PsiSwitchLabelStatementBase)) continue;
                if (((PsiSwitchLabelStatementBase)aStatement).isDefaultCase()) {
                    defaultLabel = (PsiSwitchLabelStatementBase)aStatement;
                }
                ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, expr);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater(aStatement, true);
            }
            if (defaultLabel == null) {
                GoToInstruction instruction = new GoToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater(body2, false);
            }
            body2.accept(this);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
        PsiCodeBlock body2;
        this.startElement(statement2);
        PsiExpression lock = statement2.getLockExpression();
        if (lock != null) {
            lock.accept(this);
        }
        if ((body2 = statement2.getBody()) != null) {
            body2.accept(this);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitThrowStatement(PsiThrowStatement statement2) {
        this.startElement(statement2);
        PsiExpression exception = statement2.getException();
        if (exception != null) {
            exception.accept(this);
        }
        List<PsiElement> blocks = this.findThrowToBlocks(statement2);
        this.addThrowInstructions(blocks);
        this.finishElement(statement2);
    }

    private void addThrowInstructions(@NotNull List<? extends PsiElement> blocks) {
        if (blocks == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(28);
        }
        if (blocks.isEmpty() || blocks.get(0) == null) {
            ThrowToInstruction instruction = new ThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                PsiElement element = this.myCodeFragment;
                this.addElementOffsetLater(element, false);
            } else {
                instruction.offset = -2;
                PsiElement element = this.myFinallyBlocks.peek().getElement();
                this.addElementOffsetLater(element, true);
            }
        } else {
            for (int i = 0; i < blocks.size(); ++i) {
                ProgressManager.checkCanceled();
                PsiElement element = blocks.get(i);
                BranchingInstruction instruction = i == blocks.size() - 1 ? new ThrowToInstruction(0) : new ConditionalThrowToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                instruction.offset = -1;
                this.addElementOffsetLater(element, true);
            }
        }
    }

    @NotNull
    private List<PsiElement> findThrowToBlocks(@NotNull PsiThrowStatement statement2) {
        PsiExpression exceptionExpr;
        if (statement2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(29);
        }
        if ((exceptionExpr = statement2.getException()) == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                ControlFlowAnalyzer.$$$reportNull$$$0(30);
            }
            return list2;
        }
        PsiType throwType = exceptionExpr.getType();
        if (!(throwType instanceof PsiClassType)) {
            List<PsiElement> list3 = Collections.emptyList();
            if (list3 == null) {
                ControlFlowAnalyzer.$$$reportNull$$$0(31);
            }
            return list3;
        }
        return this.findThrowToBlocks((PsiClassType)throwType);
    }

    @NotNull
    private List<PsiElement> findThrowToBlocks(@NotNull PsiClassType throwType) {
        if (throwType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(32);
        }
        ArrayList<PsiElement> blocks = new ArrayList<PsiElement>();
        for (int i = this.myCatchParameters.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiParameter parameter = (PsiParameter)this.myCatchParameters.get(i);
            PsiType catchType = parameter.getType();
            if (!ControlFlowUtil.isCaughtExceptionType(throwType, catchType)) continue;
            blocks.add((PsiElement)this.myCatchBlocks.get(i));
        }
        if (blocks.isEmpty()) {
            blocks.add(null);
        }
        ArrayList<PsiElement> arrayList = blocks;
        if (arrayList == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @Override
    public void visitAssertStatement(PsiAssertStatement statement2) {
        Object conditionValue;
        this.startElement(statement2);
        this.myStartStatementStack.pushStatement(statement2, false);
        this.myEndStatementStack.pushStatement(statement2, false);
        ConditionalGoToInstruction passByWhenAssertionsDisabled = new ConditionalGoToInstruction(0, BranchingInstruction.Role.END, null);
        this.myCurrentFlow.addInstruction(passByWhenAssertionsDisabled);
        this.addElementOffsetLater(statement2, false);
        PsiExpression condition = statement2.getAssertCondition();
        boolean generateCondition = true;
        boolean throwReachable = true;
        if (this.myEvaluateConstantIfCondition && (conditionValue = this.myConstantEvaluationHelper.computeConstantExpression(condition)) instanceof Boolean) {
            throwReachable = (Boolean)conditionValue == false;
            generateCondition = false;
            this.emitEmptyInstruction();
        }
        if (generateCondition) {
            if (condition != null) {
                this.myStartStatementStack.pushStatement(statement2, false);
                this.myEndStatementStack.pushStatement(statement2, false);
                this.myEndJumpRoles.push(BranchingInstruction.Role.END);
                this.myStartJumpRoles.push(BranchingInstruction.Role.END);
                condition.accept(this);
                this.myStartJumpRoles.pop();
                this.myEndJumpRoles.pop();
                this.myStartStatementStack.popStatement();
                this.myEndStatementStack.popStatement();
            }
            ConditionalGoToInstruction ifTrue = new ConditionalGoToInstruction(0, BranchingInstruction.Role.END, statement2.getAssertCondition());
            this.myCurrentFlow.addInstruction(ifTrue);
            this.addElementOffsetLater(statement2, false);
        } else if (!throwReachable) {
            this.myCurrentFlow.addInstruction(new GoToInstruction(0, BranchingInstruction.Role.END));
            this.addElementOffsetLater(statement2, false);
        }
        PsiExpression description2 = statement2.getAssertDescription();
        if (description2 != null) {
            description2.accept(this);
        }
        PsiClassType exceptionClass = JavaPsiFacade.getElementFactory(statement2.getProject()).createTypeByFQClassName("java.lang.Throwable", statement2.getResolveScope());
        this.addThrowInstructions(this.findThrowToBlocks(exceptionClass));
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement2);
    }

    @Override
    public void visitTryStatement(PsiTryStatement statement2) {
        int i;
        PsiCodeBlock tryBlock;
        PsiResourceList resourceList;
        this.startElement(statement2);
        PsiCodeBlock[] catchBlocks = statement2.getCatchBlocks();
        PsiParameter[] catchBlockParameters = statement2.getCatchBlockParameters();
        int catchNum = Math.min(catchBlocks.length, catchBlockParameters.length);
        this.myUnhandledExceptionCatchBlocks.push(null);
        block0: for (int i2 = catchNum - 1; i2 >= 0; --i2) {
            ProgressManager.checkCanceled();
            this.myCatchParameters.push(catchBlockParameters[i2]);
            this.myCatchBlocks.push(catchBlocks[i2]);
            PsiType type2 = catchBlockParameters[i2].getType();
            if (type2 instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)type2)) {
                this.myUnhandledExceptionCatchBlocks.push(catchBlocks[i2]);
                continue;
            }
            if (!(type2 instanceof PsiDisjunctionType)) continue;
            PsiType lub = ((PsiDisjunctionType)type2).getLeastUpperBound();
            if (lub instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)lub)) {
                this.myUnhandledExceptionCatchBlocks.push(catchBlocks[i2]);
                continue;
            }
            if (!(lub instanceof PsiIntersectionType)) continue;
            for (PsiType conjunct : ((PsiIntersectionType)lub).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)conjunct)) continue;
                this.myUnhandledExceptionCatchBlocks.push(catchBlocks[i2]);
                continue block0;
            }
        }
        PsiCodeBlock finallyBlock = statement2.getFinallyBlock();
        FinallyBlockSubroutine finallyBlockSubroutine = null;
        if (finallyBlock != null) {
            finallyBlockSubroutine = new FinallyBlockSubroutine(finallyBlock);
            this.myFinallyBlocks.push(finallyBlockSubroutine);
        }
        if ((resourceList = statement2.getResourceList()) != null) {
            this.generateCheckedExceptionJumps(resourceList);
            resourceList.accept(this);
        }
        if ((tryBlock = statement2.getTryBlock()) != null) {
            this.generateCheckedExceptionJumps(tryBlock);
            tryBlock.accept(this);
        }
        while (this.myUnhandledExceptionCatchBlocks.pop() != null) {
        }
        this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
        if (finallyBlock == null) {
            this.addElementOffsetLater(statement2, false);
        } else {
            this.addElementOffsetLater(finallyBlock, true);
        }
        for (i = 0; i < catchNum; ++i) {
            this.myCatchParameters.pop();
            this.myCatchBlocks.pop();
        }
        for (i = catchNum - 1; i >= 0; --i) {
            PsiCodeBlock catchBlock;
            ProgressManager.checkCanceled();
            if (this.myPolicy.isParameterAccepted(catchBlockParameters[i])) {
                this.generateWriteInstruction(catchBlockParameters[i]);
            }
            if ((catchBlock = catchBlocks[i]) != null) {
                catchBlock.accept(this);
            } else {
                LOG.error("Catch body is null (" + i + ") " + statement2.getText());
            }
            this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
            if (finallyBlock == null) {
                this.addElementOffsetLater(statement2, false);
                continue;
            }
            this.addElementOffsetLater(finallyBlock, true);
        }
        if (finallyBlock != null) {
            this.myFinallyBlocks.pop();
        }
        if (finallyBlock != null) {
            CallInstruction normalCompletion = new CallInstruction(0, 0);
            finallyBlockSubroutine.addCall(normalCompletion);
            this.myCurrentFlow.addInstruction(normalCompletion);
            this.addElementOffsetLater(finallyBlock, true);
            this.myCurrentFlow.addInstruction(new GoToInstruction(0));
            this.addElementOffsetLater(statement2, false);
            CallInstruction returnCompletion = new CallInstruction(0, 0);
            finallyBlockSubroutine.addCall(returnCompletion);
            this.myCurrentFlow.addInstruction(returnCompletion);
            this.addElementOffsetLater(finallyBlock, true);
            this.addReturnInstruction(statement2);
            CallInstruction throwExceptionCompletion = new CallInstruction(0, 0);
            finallyBlockSubroutine.addCall(throwExceptionCompletion);
            this.myCurrentFlow.addInstruction(throwExceptionCompletion);
            this.addElementOffsetLater(finallyBlock, true);
            GoToInstruction gotoUncheckedRethrow = new GoToInstruction(0);
            this.myCurrentFlow.addInstruction(gotoUncheckedRethrow);
            this.addElementOffsetLater(finallyBlock, false);
            finallyBlock.accept(this);
            int procStart = this.myCurrentFlow.getStartOffset(finallyBlock);
            int procEnd = this.myCurrentFlow.getEndOffset(finallyBlock);
            for (CallInstruction callInstruction : finallyBlockSubroutine.getCalls()) {
                callInstruction.procBegin = procStart;
                callInstruction.procEnd = procEnd;
            }
            this.myCurrentFlow.addInstruction(new ReturnInstruction(0, normalCompletion));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 3, returnCompletion));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 1, throwExceptionCompletion));
            List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.remove(finallyBlock);
            for (int i3 = 0; unhandledExceptionCatchBlocks != null && i3 < unhandledExceptionCatchBlocks.size(); ++i3) {
                ProgressManager.checkCanceled();
                PsiElement catchBlock = unhandledExceptionCatchBlocks.get(i3);
                ReturnInstruction returnInstruction = new ReturnInstruction(0, throwExceptionCompletion);
                returnInstruction.setRethrowFromFinally();
                this.myCurrentFlow.addInstruction(returnInstruction);
                if (catchBlock == null) {
                    returnInstruction.offset = procStart - 1;
                    continue;
                }
                --returnInstruction.offset;
                this.addElementOffsetLater(catchBlock, true);
            }
            gotoUncheckedRethrow.offset = this.myCurrentFlow.getSize();
            this.generateUncheckedExceptionJumps(statement2, false);
            this.myCurrentFlow.addInstruction(new ThrowToInstruction(0));
            this.addElementOffsetLater(this.myCodeFragment, false);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitResourceList(PsiResourceList resourceList) {
        this.startElement(resourceList);
        for (PsiResourceListElement resource : resourceList) {
            ProgressManager.checkCanceled();
            if (resource instanceof PsiResourceVariable) {
                this.processVariable((PsiVariable)((Object)resource));
                continue;
            }
            if (!(resource instanceof PsiResourceExpression)) continue;
            ((PsiResourceExpression)resource).getExpression().accept(this);
        }
        this.finishElement(resourceList);
    }

    @Override
    public void visitWhileStatement(PsiWhileStatement statement2) {
        Object loopCondition;
        this.startElement(statement2);
        PsiStatement body2 = statement2.getBody();
        if (body2 == null) {
            this.myStartStatementStack.pushStatement(statement2, false);
        } else {
            this.myStartStatementStack.pushStatement(body2, true);
        }
        this.myEndStatementStack.pushStatement(statement2, false);
        PsiExpression condition = statement2.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression(statement2.getCondition())) instanceof Boolean) {
            boolean value2 = (Boolean)loopCondition;
            if (value2) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater(statement2, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(statement2, false);
        }
        if (body2 != null) {
            body2.accept(this);
        }
        int offset2 = this.myCurrentFlow.getStartOffset(statement2);
        GoToInstruction instruction = new GoToInstruction(offset2);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement2);
    }

    @Override
    public void visitExpressionList(PsiExpressionList list2) {
        PsiExpression[] expressions;
        for (PsiExpression expression2 : expressions = list2.getExpressions()) {
            ProgressManager.checkCanceled();
            this.generateExpressionInstructions(expression2);
        }
    }

    private void generateExpressionInstructions(@Nullable PsiExpression expression2) {
        if (expression2 != null) {
            this.myStartStatementStack.pushStatement(expression2, false);
            this.myEndStatementStack.pushStatement(expression2, false);
            expression2.accept(this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
    }

    @Override
    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        this.startElement(expression2);
        expression2.getArrayExpression().accept(this);
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        PsiExpression[] initializers;
        this.startElement(expression2);
        for (PsiExpression initializer2 : initializers = expression2.getInitializers()) {
            ProgressManager.checkCanceled();
            initializer2.accept(this);
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        this.startElement(expression2);
        PsiExpression rExpr = expression2.getRExpression();
        this.myStartStatementStack.pushStatement(rExpr == null ? expression2 : rExpr, false);
        this.myEndStatementStack.pushStatement(rExpr == null ? expression2 : rExpr, false);
        boolean generatedWriteInstruction = false;
        PsiExpression lExpr = PsiUtil.skipParenthesizedExprDown(expression2.getLExpression());
        if (lExpr instanceof PsiReferenceExpression) {
            PsiVariable variable2;
            PsiElement target;
            if (!this.myImplicitCompactConstructorAssignments.isEmpty() && (target = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiField) {
                this.myImplicitCompactConstructorAssignments.remove(target);
            }
            if ((variable2 = this.getUsedVariable((PsiReferenceExpression)lExpr)) != null) {
                PsiExpression qualifier;
                if (this.myAssignmentTargetsAreElements) {
                    this.startElement(lExpr);
                }
                if ((qualifier = ((PsiReferenceExpression)lExpr).getQualifierExpression()) != null) {
                    qualifier.accept(this);
                }
                if (expression2.getOperationTokenType() != JavaTokenType.EQ) {
                    this.generateReadInstruction(variable2);
                }
                if (rExpr != null) {
                    rExpr.accept(this);
                }
                this.generateWriteInstruction(variable2);
                generatedWriteInstruction = true;
                if (this.myAssignmentTargetsAreElements) {
                    this.finishElement(lExpr);
                }
            } else {
                if (rExpr != null) {
                    rExpr.accept(this);
                }
                lExpr.accept(this);
            }
        } else if (lExpr instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)lExpr).getArrayExpression() instanceof PsiReferenceExpression) {
            PsiVariable variable3 = this.getUsedVariable((PsiReferenceExpression)((PsiArrayAccessExpression)lExpr).getArrayExpression());
            if (variable3 != null) {
                this.generateReadInstruction(variable3);
                PsiExpression indexExpression = ((PsiArrayAccessExpression)lExpr).getIndexExpression();
                if (indexExpression != null) {
                    indexExpression.accept(this);
                }
            } else {
                lExpr.accept(this);
            }
            if (rExpr != null) {
                rExpr.accept(this);
            }
        } else if (lExpr != null) {
            lExpr.accept(this);
            if (rExpr != null) {
                rExpr.accept(this);
            }
        }
        if (!generatedWriteInstruction) {
            this.emitEmptyInstruction();
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(expression2);
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        this.startElement(expression2);
        IElementType signTokenType = expression2.getOperationTokenType();
        boolean isAndAnd = signTokenType == JavaTokenType.ANDAND;
        boolean isOrOr = signTokenType == JavaTokenType.OROR;
        PsiExpression[] operands = expression2.getOperands();
        Boolean lValue = isAndAnd;
        PsiExpression lOperand = null;
        Boolean rValue = null;
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression rOperand = operands[i];
            if ((isAndAnd || isOrOr) && this.myEnabledShortCircuit) {
                boolean gotoIsAtStart;
                Object exprValue = this.myConstantEvaluationHelper.computeConstantExpression(rOperand);
                if (exprValue instanceof Boolean) {
                    this.myCurrentFlow.setConstantConditionOccurred(true);
                    rValue = this.shouldCalculateConstantExpression(expression2) ? (Boolean)exprValue : null;
                } else {
                    rValue = null;
                }
                BranchingInstruction.Role role = isAndAnd ? this.myEndJumpRoles.peek() : this.myStartJumpRoles.peek();
                PsiElement gotoElement = isAndAnd ? this.myEndStatementStack.peekElement() : this.myStartStatementStack.peekElement();
                boolean bl = gotoIsAtStart = isAndAnd ? this.myEndStatementStack.peekAtStart() : this.myStartStatementStack.peekAtStart();
                Shortcut shortcut = lValue != null ? (lValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.SKIP_CURRENT_OPERAND) : (rValue != null && rValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.NO_SHORTCUT);
                switch (shortcut) {
                    case NO_SHORTCUT: {
                        this.myCurrentFlow.addInstruction(new ConditionalGoToInstruction(0, role, lOperand));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        break;
                    }
                    case STOP_EXPRESSION: {
                        this.myCurrentFlow.addInstruction(new GoToInstruction(0, role));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        rValue = null;
                        break;
                    }
                }
            }
            this.generateLOperand(rOperand, i == operands.length - 1 ? null : operands[i + 1], signTokenType);
            lOperand = rOperand;
            lValue = rValue;
        }
        this.finishElement(expression2);
    }

    private void generateLOperand(@NotNull PsiExpression lOperand, @Nullable PsiExpression rOperand, @NotNull IElementType signTokenType) {
        if (lOperand == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(34);
        }
        if (signTokenType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(35);
        }
        if (rOperand != null) {
            this.myStartJumpRoles.push(BranchingInstruction.Role.END);
            this.myEndJumpRoles.push(BranchingInstruction.Role.END);
            PsiExpression then = signTokenType == JavaTokenType.OROR ? this.myStartStatementStack.peekElement() : rOperand;
            boolean thenAtStart = signTokenType != JavaTokenType.OROR || this.myStartStatementStack.peekAtStart();
            this.myStartStatementStack.pushStatement(then, thenAtStart);
            PsiExpression elseS = signTokenType == JavaTokenType.ANDAND ? this.myEndStatementStack.peekElement() : rOperand;
            boolean elseAtStart = signTokenType != JavaTokenType.ANDAND || this.myEndStatementStack.peekAtStart();
            this.myEndStatementStack.pushStatement(elseS, elseAtStart);
        }
        lOperand.accept(this);
        if (rOperand != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
            this.myStartJumpRoles.pop();
            this.myEndJumpRoles.pop();
        }
    }

    private static boolean isInsideIfCondition(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(36);
        }
        PsiElement element = expression2;
        while (element instanceof PsiExpression) {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof PsiIfStatement && element == ((PsiIfStatement)parent2).getCondition()) {
                return true;
            }
            element = parent2;
        }
        return false;
    }

    private boolean shouldCalculateConstantExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(37);
        }
        return this.myEvaluateConstantIfCondition || !ControlFlowAnalyzer.isInsideIfCondition(expression2);
    }

    @Override
    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        this.visitChildren(expression2);
    }

    private void visitChildren(@NotNull PsiElement element) {
        PsiElement[] children2;
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(38);
        }
        this.startElement(element);
        for (PsiElement child : children2 = element.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept(this);
        }
        this.finishElement(element);
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        this.startElement(expression2);
        PsiExpression condition = expression2.getCondition();
        PsiExpression thenExpression = expression2.getThenExpression();
        PsiExpression elseExpression = expression2.getElseExpression();
        this.generateConditionalStatementInstructions(expression2, condition, thenExpression, elseExpression);
        this.finishElement(expression2);
    }

    @Override
    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        PsiPatternVariable variable2;
        this.startElement(expression2);
        PsiExpression operand = expression2.getOperand();
        operand.accept(this);
        PsiPattern pattern = expression2.getPattern();
        if (pattern instanceof PsiTypeTestPattern && (variable2 = ((PsiTypeTestPattern)pattern).getPatternVariable()) != null) {
            this.myCurrentFlow.addInstruction(new WriteVariableInstruction(variable2));
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        this.startElement(expression2);
        this.finishElement(expression2);
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        this.startElement(expression2);
        PsiElement body2 = expression2.getBody();
        if (body2 != null) {
            ArrayList array = new ArrayList();
            this.addUsedVariables(array, body2);
            for (PsiVariable var : array) {
                ProgressManager.checkCanceled();
                this.generateReadInstruction(var);
            }
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        PsiExpression qualifierExpression;
        ArrayDeque<PsiMethodCallExpression> calls = new ArrayDeque<PsiMethodCallExpression>();
        do {
            calls.addFirst(expression2);
            this.startElement(expression2);
        } while ((expression2 = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(qualifierExpression = expression2.getMethodExpression().getQualifierExpression()), PsiMethodCallExpression.class)) != null);
        if (qualifierExpression != null) {
            qualifierExpression.accept(this);
        }
        for (PsiMethodCallExpression call2 : calls) {
            PsiExpressionList argumentList2 = call2.getArgumentList();
            argumentList2.accept(this);
            this.emitEmptyInstruction();
            this.generateExceptionJumps(call2, ExceptionUtil.getUnhandledExceptions(call2, call2.getParent()));
            this.finishElement(call2);
        }
    }

    @Override
    public void visitNewExpression(PsiNewExpression expression2) {
        PsiElement[] children2;
        this.startElement(expression2);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement child : children2 = expression2.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept(this);
        }
        this.generateExceptionJumps(expression2, ExceptionUtil.getUnhandledExceptions(expression2, expression2.getParent()));
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.visitChildren(expression2);
    }

    @Override
    public void visitPostfixExpression(PsiPostfixExpression expression2) {
        this.startElement(expression2);
        IElementType op = expression2.getOperationTokenType();
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown(expression2.getOperand());
        if (operand != null) {
            PsiVariable variable2;
            operand.accept(this);
            if ((op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) && operand instanceof PsiReferenceExpression && (variable2 = this.getUsedVariable((PsiReferenceExpression)operand)) != null) {
                this.generateWriteInstruction(variable2);
            }
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        this.startElement(expression2);
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown(expression2.getOperand());
        if (operand != null) {
            PsiVariable variable2;
            IElementType operationSign = expression2.getOperationTokenType();
            if (operationSign == JavaTokenType.EXCL) {
                PsiElement topStartStatement = this.myStartStatementStack.peekElement();
                boolean topAtStart = this.myStartStatementStack.peekAtStart();
                this.myStartStatementStack.pushStatement(this.myEndStatementStack.peekElement(), this.myEndStatementStack.peekAtStart());
                this.myEndStatementStack.pushStatement(topStartStatement, topAtStart);
            }
            operand.accept(this);
            if (operationSign == JavaTokenType.EXCL) {
                this.myStartStatementStack.popStatement();
                this.myEndStatementStack.popStatement();
            }
            if (operand instanceof PsiReferenceExpression && (operationSign == JavaTokenType.PLUSPLUS || operationSign == JavaTokenType.MINUSMINUS) && (variable2 = this.getUsedVariable((PsiReferenceExpression)operand)) != null) {
                this.generateWriteInstruction(variable2);
            }
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiVariable variable2;
        this.startElement(expression2);
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept(this);
        }
        if ((variable2 = this.getUsedVariable(expression2)) != null) {
            this.generateReadInstruction(variable2);
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitSuperExpression(PsiSuperExpression expression2) {
        this.startElement(expression2);
        this.finishElement(expression2);
    }

    @Override
    public void visitThisExpression(PsiThisExpression expression2) {
        this.startElement(expression2);
        this.finishElement(expression2);
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        this.startElement(expression2);
        PsiExpression operand = expression2.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitClass(PsiClass aClass) {
        PsiExpressionList arguments2;
        this.startElement(aClass);
        if (aClass instanceof PsiAnonymousClass && (arguments2 = PsiTreeUtil.getChildOfType(aClass, PsiExpressionList.class)) != null) {
            arguments2.accept(this);
        }
        ArrayList array = new ArrayList();
        this.addUsedVariables(array, aClass);
        for (PsiVariable var : array) {
            ProgressManager.checkCanceled();
            this.generateReadInstruction(var);
        }
        this.finishElement(aClass);
    }

    private void addUsedVariables(@NotNull List<? super PsiVariable> array, @NotNull PsiElement scope2) {
        PsiElement[] children2;
        PsiVariable variable2;
        if (array == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(39);
        }
        if (scope2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(40);
        }
        if (scope2 instanceof PsiReferenceExpression && (variable2 = this.getUsedVariable((PsiReferenceExpression)scope2)) != null && !array.contains(variable2)) {
            array.add(variable2);
        }
        for (PsiElement child : children2 = scope2.getChildren()) {
            ProgressManager.checkCanceled();
            this.addUsedVariables(array, child);
        }
    }

    private void generateReadInstruction(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(41);
        }
        ReadVariableInstruction instruction = new ReadVariableInstruction(variable2);
        this.myCurrentFlow.addInstruction(instruction);
    }

    private void generateWriteInstruction(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(42);
        }
        WriteVariableInstruction instruction = new WriteVariableInstruction(variable2);
        this.myCurrentFlow.addInstruction(instruction);
    }

    @Nullable
    private PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(43);
        }
        if (refExpr.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return this.myPolicy.getUsedVariable(refExpr);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 30: 
            case 31: 
            case 33: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 30: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 4: 
            case 5: 
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowAnalyzer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 25: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unhandledException";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwingElement";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToJumpTo";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOperand";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signTokenType";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowAnalyzer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildControlFlow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyIntArray";
                break;
            }
            case 30: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findThrowToBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 30: 
            case 31: 
            case 33: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "poolIntArray";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addElementOffsetLater";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "patchInstructionOffsets";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateUncheckedExceptionJumpsIfNeeded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "finishElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generateUncheckedExceptionJumps";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateCheckedExceptionJumps";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateExceptionJumps";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generateThrow";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "patchCheckedThrowInstructionIfInsideFinally";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "patchUncheckedThrowInstructionIfInsideFinally";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "registerSubRange";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingFinallyBlockElement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processVariable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "generateConditionalStatementInstructions";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addReturnInstruction";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addThrowInstructions";
                break;
            }
            case 29: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findThrowToBlocks";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "generateLOperand";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isInsideIfCondition";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "shouldCalculateConstantExpression";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitChildren";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addUsedVariables";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "generateReadInstruction";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateWriteInstruction";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getUsedVariable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 30: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FinallyBlockSubroutine {
        private final PsiElement myElement;
        private final List<CallInstruction> myCalls;

        FinallyBlockSubroutine(@NotNull PsiElement element) {
            if (element == null) {
                FinallyBlockSubroutine.$$$reportNull$$$0(0);
            }
            this.myElement = element;
            this.myCalls = new ArrayList<CallInstruction>();
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                FinallyBlockSubroutine.$$$reportNull$$$0(1);
            }
            return psiElement;
        }

        @NotNull
        public List<CallInstruction> getCalls() {
            List<CallInstruction> list2 = this.myCalls;
            if (list2 == null) {
                FinallyBlockSubroutine.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private void addCall(@NotNull CallInstruction callInstruction) {
            if (callInstruction == null) {
                FinallyBlockSubroutine.$$$reportNull$$$0(3);
            }
            this.myCalls.add(callInstruction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowAnalyzer$FinallyBlockSubroutine";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callInstruction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowAnalyzer$FinallyBlockSubroutine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCalls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addCall";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum Shortcut {
        NO_SHORTCUT,
        SKIP_CURRENT_OPERAND,
        STOP_EXPRESSION;

    }

    private static class StatementStack {
        private final Stack<PsiElement> myStatements = new Stack();
        private final TIntArrayList myAtStart = new TIntArrayList();

        private StatementStack() {
        }

        private void popStatement() {
            this.myAtStart.remove(this.myAtStart.size() - 1);
            this.myStatements.pop();
        }

        @NotNull
        private PsiElement peekElement() {
            PsiElement psiElement = this.myStatements.peek();
            if (psiElement == null) {
                StatementStack.$$$reportNull$$$0(0);
            }
            return psiElement;
        }

        private boolean peekAtStart() {
            return this.myAtStart.get(this.myAtStart.size() - 1) == 1;
        }

        private void pushStatement(@NotNull PsiElement statement2, boolean atStart) {
            if (statement2 == null) {
                StatementStack.$$$reportNull$$$0(1);
            }
            this.myStatements.push(statement2);
            this.myAtStart.add(atStart ? 1 : 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowAnalyzer$StatementStack";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "peekElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowAnalyzer$StatementStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "pushStatement";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

