/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u0016\u001a\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00010\rH\u0002\u001a\u000e\u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010,\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001e\u001a\u0010\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u0016H\u0002\u001a\u000e\u00101\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u00102\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0016\u001a\u000e\u00103\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u00104\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0016\u001a\u000e\u00105\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0010\u00106\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u000e\u00107\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0010\u00108\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u000109\u001a\u000e\u0010:\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010;\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010<\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001e\u001a\u000e\u0010=\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010>\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0016\u001a\u000e\u0010?\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0016\u001a\u0016\u0010@\u001a\u0004\u0018\u00010A*\u0002092\u0006\u0010B\u001a\u00020CH\u0002\u001a\u0012\u0010D\u001a\u00020\u0016*\u00020E2\u0006\u0010F\u001a\u00020G\u001a1\u0010H\u001a\u00020\u001c*\u00020\u001e2\u0006\u0010I\u001a\u00020\u00012\u0006\u0010J\u001a\u00020\u00012\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0LH\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006M"}, d2={"CHAR_PROGRESSION_FQN", "", "CHAR_RANGE_FQN", "CLOSED_DOUBLE_RANGE_FQN", "CLOSED_FLOATING_POINT_RANGE_FQN", "CLOSED_FLOAT_RANGE_FQN", "CLOSED_RANGE_FQN", "COMPARABLE_RANGE_FQN", "INT_PROGRESSION_FQN", "INT_RANGE_FQN", "LONG_PROGRESSION_FQN", "LONG_RANGE_FQN", "PRIMITIVE_PROGRESSION_FQNS", "", "PRIMITIVE_RANGE_FQNS", "UINT_PROGRESSION_FQN", "UINT_RANGE_FQN", "ULONG_PROGRESSION_FQN", "ULONG_RANGE_FQN", "UNSIGNED_PROGRESSION_FQNS", "UNSIGNED_RANGE_FQNS", "classFqnString", "Lorg/jetbrains/kotlin/types/KotlinType;", "getClassFqnString", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/lang/String;", "getRangeOrProgressionElementType", "rangeType", "isArrayOrPrimitiveArrayIndices", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isArrayOrPrimitiveArrayWithIndex", "isCharSequenceIndices", "isCharSequenceIterator", "isCharSequenceWithIndex", "isClassTypeWithFqn", "kotlinType", "fqns", "isClosedFloatingPointRangeContains", "isClosedRangeContains", "isCollectionIndices", "isComparableRangeTo", "isIterableWithIndex", "isPrimitiveNumberDownTo", "isPrimitiveNumberRangeExtensionContainsPrimitiveNumber", "isPrimitiveNumberRangeTo", "rangeTo", "isPrimitiveNumberType", "type", "isPrimitiveNumberUntil", "isPrimitiveProgression", "isPrimitiveProgressionReverse", "isPrimitiveRange", "isPrimitiveRangeContains", "isPrimitiveRangeToExtension", "isSequenceWithIndex", "isUnsignedIntegerClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isUnsignedIntegerDownTo", "isUnsignedIntegerRangeContains", "isUnsignedIntegerRangeTo", "isUnsignedIntegerUntil", "isUnsignedProgression", "isUnsignedRange", "findTypeInModuleByTopLevelClassFqName", "Lorg/jetbrains/kotlin/types/SimpleType;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getElementType", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "isTopLevelExtensionOnType", "name", "packageFQN", "receiverTypePredicate", "Lkotlin/Function1;", "backend"})
public final class RangeCodegenUtilKt {
    @NotNull
    public static final String CHAR_RANGE_FQN = "kotlin.ranges.CharRange";
    @NotNull
    public static final String INT_RANGE_FQN = "kotlin.ranges.IntRange";
    @NotNull
    public static final String LONG_RANGE_FQN = "kotlin.ranges.LongRange";
    @NotNull
    private static final Set<String> PRIMITIVE_RANGE_FQNS;
    @NotNull
    public static final String CHAR_PROGRESSION_FQN = "kotlin.ranges.CharProgression";
    @NotNull
    public static final String INT_PROGRESSION_FQN = "kotlin.ranges.IntProgression";
    @NotNull
    public static final String LONG_PROGRESSION_FQN = "kotlin.ranges.LongProgression";
    @NotNull
    private static final Set<String> PRIMITIVE_PROGRESSION_FQNS;
    @NotNull
    public static final String UINT_RANGE_FQN = "kotlin.ranges.UIntRange";
    @NotNull
    public static final String ULONG_RANGE_FQN = "kotlin.ranges.ULongRange";
    @NotNull
    private static final Set<String> UNSIGNED_RANGE_FQNS;
    @NotNull
    public static final String UINT_PROGRESSION_FQN = "kotlin.ranges.UIntProgression";
    @NotNull
    public static final String ULONG_PROGRESSION_FQN = "kotlin.ranges.ULongProgression";
    @NotNull
    private static final Set<String> UNSIGNED_PROGRESSION_FQNS;

    public static final boolean isPrimitiveRange(@NotNull KotlinType rangeType) {
        Intrinsics.checkNotNullParameter((Object)rangeType, (String)"rangeType");
        return RangeCodegenUtilKt.isClassTypeWithFqn(rangeType, PRIMITIVE_RANGE_FQNS);
    }

    public static final boolean isUnsignedRange(@NotNull KotlinType rangeType) {
        Intrinsics.checkNotNullParameter((Object)rangeType, (String)"rangeType");
        return RangeCodegenUtilKt.isClassTypeWithFqn(rangeType, UNSIGNED_RANGE_FQNS);
    }

    public static final boolean isPrimitiveProgression(@NotNull KotlinType rangeType) {
        Intrinsics.checkNotNullParameter((Object)rangeType, (String)"rangeType");
        return RangeCodegenUtilKt.isClassTypeWithFqn(rangeType, PRIMITIVE_PROGRESSION_FQNS);
    }

    public static final boolean isUnsignedProgression(@NotNull KotlinType rangeType) {
        Intrinsics.checkNotNullParameter((Object)rangeType, (String)"rangeType");
        return RangeCodegenUtilKt.isClassTypeWithFqn(rangeType, UNSIGNED_PROGRESSION_FQNS);
    }

    private static final String getClassFqnString(KotlinType $this$classFqnString) {
        ClassDescriptor classDescriptor;
        Object object = $this$classFqnString.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor2 = classDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor declarationDescriptor = classDescriptor;
        object = DescriptorUtils.getFqName(declarationDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFqName(declarationDescriptor)");
        Object fqn = object;
        return ((FqNameUnsafe)fqn).isSafe() ? ((FqNameUnsafe)fqn).asString() : null;
    }

    private static final boolean isClassTypeWithFqn(KotlinType kotlinType, Set<String> fqns) {
        return CollectionsKt.contains((Iterable)fqns, (Object)RangeCodegenUtilKt.getClassFqnString(kotlinType));
    }

    @Nullable
    public static final KotlinType getRangeOrProgressionElementType(@NotNull KotlinType rangeType) {
        KotlinType kotlinType;
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)rangeType, (String)"rangeType");
        Object object = rangeType.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor2 = classDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor rangeClassDescriptor = classDescriptor;
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(rangeClassDescriptor);
        switch (DescriptorUtilsKt.getFqNameSafe(rangeClassDescriptor).asString()) {
            case "kotlin.ranges.CharRange": 
            case "kotlin.ranges.CharProgression": {
                kotlinType = builtIns.getCharType();
                break;
            }
            case "kotlin.ranges.IntProgression": 
            case "kotlin.ranges.IntRange": {
                kotlinType = builtIns.getIntType();
                break;
            }
            case "kotlin.ranges.LongProgression": 
            case "kotlin.ranges.LongRange": {
                kotlinType = builtIns.getLongType();
                break;
            }
            case "kotlin.ranges.ClosedFloatRange": {
                kotlinType = builtIns.getFloatType();
                break;
            }
            case "kotlin.ranges.ClosedDoubleRange": {
                kotlinType = builtIns.getDoubleType();
                break;
            }
            case "kotlin.ranges.ClosedRange": {
                TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull(rangeType.getArguments());
                if (typeProjection == null) {
                    kotlinType = null;
                    break;
                }
                kotlinType = typeProjection.getType();
                break;
            }
            case "kotlin.ranges.ClosedFloatingPointRange": {
                TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull(rangeType.getArguments());
                if (typeProjection == null) {
                    kotlinType = null;
                    break;
                }
                kotlinType = typeProjection.getType();
                break;
            }
            case "kotlin.ranges.ComparableRange": {
                TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull(rangeType.getArguments());
                if (typeProjection == null) {
                    kotlinType = null;
                    break;
                }
                kotlinType = typeProjection.getType();
                break;
            }
            case "kotlin.ranges.UIntProgression": 
            case "kotlin.ranges.UIntRange": {
                kotlinType = RangeCodegenUtilKt.findTypeInModuleByTopLevelClassFqName(rangeClassDescriptor, StandardNames.FqNames.uIntFqName);
                break;
            }
            case "kotlin.ranges.ULongRange": 
            case "kotlin.ranges.ULongProgression": {
                kotlinType = RangeCodegenUtilKt.findTypeInModuleByTopLevelClassFqName(rangeClassDescriptor, StandardNames.FqNames.uLongFqName);
                break;
            }
            default: {
                kotlinType = null;
            }
        }
        return kotlinType;
    }

    private static final SimpleType findTypeInModuleByTopLevelClassFqName(DeclarationDescriptor $this$findTypeInModuleByTopLevelClassFqName, FqName fqName2) {
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule($this$findTypeInModuleByTopLevelClassFqName);
        ClassId classId = ClassId.topLevel(fqName2);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(fqName)");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
        return classDescriptor == null ? null : classDescriptor.getDefaultType();
    }

    @NotNull
    public static final KotlinType getElementType(@NotNull BindingContext $this$getElementType, @NotNull KtForExpression forExpression) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)$this$getElementType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)forExpression, (String)"forExpression");
        Object object = forExpression.getLoopRange();
        Intrinsics.checkNotNull((Object)object);
        KtExpression loopRange = ktExpression = object;
        Object object2 = (ResolvedCall)$this$getElementType.get(BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, loopRange);
        if (object2 == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"No next() function ", (Object)PsiDiagnosticUtils.atLocation(loopRange)));
        }
        Object nextCall = object = object2;
        object2 = ((FunctionDescriptor)nextCall.getResultingDescriptor()).getReturnType();
        Intrinsics.checkNotNull((Object)object2);
        object = object2;
        return object;
    }

    public static final boolean isPrimitiveNumberRangeTo(@NotNull CallableDescriptor rangeTo) {
        Intrinsics.checkNotNullParameter((Object)rangeTo, (String)"rangeTo");
        return Intrinsics.areEqual((Object)"rangeTo", (Object)rangeTo.getName().asString()) && DescriptorAsmUtil.isPrimitiveNumberClassDescriptor(rangeTo.getContainingDeclaration()) || RangeCodegenUtilKt.isPrimitiveRangeToExtension(rangeTo);
    }

    public static final boolean isUnsignedIntegerRangeTo(@NotNull CallableDescriptor rangeTo) {
        Intrinsics.checkNotNullParameter((Object)rangeTo, (String)"rangeTo");
        return Intrinsics.areEqual((Object)"rangeTo", (Object)rangeTo.getName().asString()) && RangeCodegenUtilKt.isUnsignedIntegerClassDescriptor(rangeTo.getContainingDeclaration());
    }

    public static final boolean isUnsignedIntegerClassDescriptor(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 != null && UnsignedTypes.INSTANCE.isUnsignedClass(descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isPrimitiveRangeToExtension(CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "rangeTo";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = KotlinBuiltIns.isPrimitiveType(it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isPrimitiveNumberDownTo(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "downTo";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = DescriptorAsmUtil.isPrimitiveNumberClassDescriptor(it.getConstructor().getDeclarationDescriptor());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isUnsignedIntegerDownTo(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "downTo";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = RangeCodegenUtilKt.isUnsignedIntegerClassDescriptor(it.getConstructor().getDeclarationDescriptor());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isPrimitiveNumberUntil(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "until";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = DescriptorAsmUtil.isPrimitiveNumberClassDescriptor(it.getConstructor().getDeclarationDescriptor());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isUnsignedIntegerUntil(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "until";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = RangeCodegenUtilKt.isUnsignedIntegerClassDescriptor(it.getConstructor().getDeclarationDescriptor());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isArrayOrPrimitiveArrayIndices(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "indices";
        String packageFQN$iv = "kotlin.collections";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = KotlinBuiltIns.isArray(it) || KotlinBuiltIns.isPrimitiveArray(it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isArrayOrPrimitiveArrayWithIndex(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "withIndex";
        String packageFQN$iv = "kotlin.collections";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = KotlinBuiltIns.isArray(it) || KotlinBuiltIns.isPrimitiveArray(it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isCollectionIndices(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "indices";
        String packageFQN$iv = "kotlin.collections";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = KotlinBuiltIns.isCollectionOrNullableCollection(it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isIterableWithIndex(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "withIndex";
        String packageFQN$iv = "kotlin.collections";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = KotlinBuiltIns.isIterableOrNullableIterable(it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isSequenceWithIndex(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "withIndex";
        String packageFQN$iv = "kotlin.sequences";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                ClassifierDescriptor classifierDescriptor;
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                ClassifierDescriptor classifierDescriptor2 = it.getConstructor().getDeclarationDescriptor();
                if (classifierDescriptor2 == null) {
                    return false;
                }
                ClassifierDescriptor typeDescriptor = classifierDescriptor = classifierDescriptor2;
                bl = DescriptorUtilKt.isTopLevelInPackage(typeDescriptor, "Sequence", "kotlin.sequences");
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isCharSequenceIndices(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "indices";
        String packageFQN$iv = "kotlin.text";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = KotlinBuiltIns.isCharSequenceOrNullableCharSequence(it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isCharSequenceWithIndex(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "withIndex";
        String packageFQN$iv = "kotlin.text";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = KotlinBuiltIns.isCharSequenceOrNullableCharSequence(it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isComparableRangeTo(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "rangeTo";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                TypeParameterDescriptor typeParameterDescriptor;
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                Annotated annotated = it.getConstructor().getDeclarationDescriptor();
                TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor = annotated instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)annotated : null;
                if (typeParameterDescriptor == null) {
                    return false;
                }
                TypeParameterDescriptor extensionReceiverTypeDescriptor = typeParameterDescriptor;
                Object object = extensionReceiverTypeDescriptor.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue(object, (String)"extensionReceiverTypeDescriptor.upperBounds");
                annotated = (KotlinType)CollectionsKt.singleOrNull(object);
                if (annotated == null) {
                    return false;
                }
                Annotated upperBoundType = annotated;
                ClassifierDescriptor classifierDescriptor = ((KotlinType)upperBoundType).getConstructor().getDeclarationDescriptor();
                Object object2 = object = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (object == null) {
                    return false;
                }
                Object upperBoundClassDescriptor = object;
                bl = DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)upperBoundClassDescriptor, "Comparable", "kotlin");
            }
        }
        return bl;
    }

    public static final boolean isClosedRangeContains(@NotNull CallableDescriptor descriptor2) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"contains")) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        ClassDescriptor classDescriptor2 = classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClassDescriptor = classDescriptor;
        return DescriptorUtilKt.isTopLevelInPackage(containingClassDescriptor, "ClosedRange", "kotlin.ranges");
    }

    public static final boolean isPrimitiveRangeContains(@NotNull CallableDescriptor descriptor2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"contains")) {
            return false;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
        KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType kotlinType3 = kotlinType;
        KotlinType dispatchReceiverType = kotlinType3;
        return RangeCodegenUtilKt.isPrimitiveRange(dispatchReceiverType);
    }

    public static final boolean isUnsignedIntegerRangeContains(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
        KotlinType dispatchReceiverType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
        ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
        KotlinType extensionReceiverType = receiverParameterDescriptor2 == null ? null : receiverParameterDescriptor2.getType();
        if (dispatchReceiverType != null && extensionReceiverType == null) {
            if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"contains")) {
                return false;
            }
            return RangeCodegenUtilKt.isUnsignedRange(dispatchReceiverType);
        }
        if (extensionReceiverType != null && dispatchReceiverType == null) {
            if (!DescriptorUtilKt.isTopLevelInPackage(descriptor2, "contains", "kotlin.ranges")) {
                return false;
            }
            return RangeCodegenUtilKt.isUnsignedRange(extensionReceiverType);
        }
        return false;
    }

    public static final boolean isPrimitiveNumberRangeExtensionContainsPrimitiveNumber(@NotNull CallableDescriptor descriptor2) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!DescriptorUtilKt.isTopLevelInPackage(descriptor2, "contains", "kotlin.ranges")) {
            return false;
        }
        Annotated annotated = descriptor2.getExtensionReceiverParameter();
        KotlinType kotlinType3 = kotlinType2 = annotated == null ? null : annotated.getType();
        if (kotlinType2 == null) {
            return false;
        }
        KotlinType kotlinType4 = kotlinType2;
        KotlinType extensionReceiverType = kotlinType4;
        if ((kotlinType2 = RangeCodegenUtilKt.getRangeOrProgressionElementType(extensionReceiverType)) == null) {
            return false;
        }
        KotlinType rangeElementType = kotlinType2;
        if (!RangeCodegenUtilKt.isPrimitiveNumberType(rangeElementType)) {
            return false;
        }
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list2);
        KotlinType kotlinType5 = kotlinType = valueParameterDescriptor == null ? null : valueParameterDescriptor.getType();
        if (kotlinType == null) {
            return false;
        }
        annotated = kotlinType;
        Annotated argumentType = annotated;
        return RangeCodegenUtilKt.isPrimitiveNumberType((KotlinType)argumentType);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isPrimitiveProgressionReverse(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "reversed";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl2 = false;
                bl = RangeCodegenUtilKt.isPrimitiveProgression(it);
            }
        }
        return bl;
    }

    private static final boolean isPrimitiveNumberType(KotlinType type2) {
        return KotlinBuiltIns.isByte(type2) || KotlinBuiltIns.isShort(type2) || KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isChar(type2) || KotlinBuiltIns.isLong(type2) || KotlinBuiltIns.isFloat(type2) || KotlinBuiltIns.isDouble(type2);
    }

    public static final boolean isClosedFloatingPointRangeContains(@NotNull CallableDescriptor descriptor2) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"contains")) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        ClassDescriptor classDescriptor2 = classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClassDescriptor = classDescriptor;
        return DescriptorUtilKt.isTopLevelInPackage(containingClassDescriptor, "ClosedFloatingPointRange", "kotlin.ranges");
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isCharSequenceIterator(@NotNull CallableDescriptor descriptor2) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        String string2 = "iterator";
        String packageFQN$iv = "kotlin.text";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                bl = false;
            } else {
                boolean bl2;
                KotlinType kotlinType3;
                KotlinType extensionReceiverType$iv;
                KotlinType it = extensionReceiverType$iv = (kotlinType3 = kotlinType);
                boolean bl3 = false;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                bl = classifierDescriptor == null ? false : (bl2 = DescriptorUtilKt.isTopLevelInPackage(classifierDescriptor, "CharSequence", "kotlin"));
            }
        }
        return bl;
    }

    static {
        Object[] objectArray = new String[]{CHAR_RANGE_FQN, INT_RANGE_FQN, LONG_RANGE_FQN};
        PRIMITIVE_RANGE_FQNS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{CHAR_PROGRESSION_FQN, INT_PROGRESSION_FQN, LONG_PROGRESSION_FQN};
        PRIMITIVE_PROGRESSION_FQNS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{UINT_RANGE_FQN, ULONG_RANGE_FQN};
        UNSIGNED_RANGE_FQNS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{UINT_PROGRESSION_FQN, ULONG_PROGRESSION_FQN};
        UNSIGNED_PROGRESSION_FQNS = SetsKt.setOf((Object[])objectArray);
    }
}

