/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u0006*\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u0006*\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumClassSimpleChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "reportClassInSupertypeForEnum", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reportTypeParametersInEnum", "checkers"})
public final class FirEnumClassSimpleChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirEnumClassSimpleChecker INSTANCE = new FirEnumClassSimpleChecker();

    private FirEnumClassSimpleChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirRegularClass $this$isEnumClass$iv = declaration2;
        boolean $i$f$isEnumClass = false;
        if (!($this$isEnumClass$iv.getClassKind() == ClassKind.ENUM_CLASS)) {
            return;
        }
        Object object = FirHelpersKt.findNonInterfaceSupertype(declaration2, context2);
        if (object != null) {
            FirTypeRef firTypeRef = object;
            boolean bl = false;
            boolean bl2 = false;
            FirTypeRef it = firTypeRef;
            boolean bl3 = false;
            INSTANCE.reportClassInSupertypeForEnum(reporter, it.getSource());
        }
        object = declaration2.getTypeParameters();
        boolean bl = false;
        if (!object.isEmpty()) {
            object = (FirTypeParameterRef)CollectionsKt.firstOrNull(declaration2.getTypeParameters());
            this.reportTypeParametersInEnum(reporter, object == null ? null : object.getSource());
        }
    }

    private final void reportClassInSupertypeForEnum(DiagnosticReporter $this$reportClassInSupertypeForEnum, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportClassInSupertypeForEnum.report((FirDiagnostic)FirErrors.INSTANCE.getCLASS_IN_SUPERTYPE_FOR_ENUM().on(it));
        }
    }

    private final void reportTypeParametersInEnum(DiagnosticReporter $this$reportTypeParametersInEnum, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportTypeParametersInEnum.report((FirDiagnostic)FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_ENUM().on(it));
        }
    }
}

