/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/StringPlusCharFIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/FunctionIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "StringPlusAnyIntrinsic", "js.translator"})
public final class StringPlusCharFIF
implements FunctionIntrinsicFactory {
    @NotNull
    public static final StringPlusCharFIF INSTANCE;

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String string2 = DescriptorUtilsKt.getFqNameUnsafe(descriptor2).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.fqNameUnsafe.asString()");
        String fqName2 = string2;
        if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.String.plus") ^ true && Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.plus") ^ true) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        }
        if (receiverParameterDescriptor == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)receiverParameterDescriptor, (String)"(descriptor.dispatchRece\u2026Parameter ?: return null)");
        KotlinType kotlinType = receiverParameterDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"(descriptor.dispatchRece\u2026eter ?: return null).type");
        KotlinType leftType = kotlinType;
        return KotlinBuiltIns.isStringOrNullableString(leftType) ? new StringPlusAnyIntrinsic(TypeUtils.isNullableType(leftType)) : null;
    }

    private StringPlusCharFIF() {
    }

    static {
        StringPlusCharFIF stringPlusCharFIF;
        INSTANCE = stringPlusCharFIF = new StringPlusCharFIF();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/StringPlusCharFIF$StringPlusAnyIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "leftTypeNullable", "", "(Z)V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "arguments", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    private static final class StringPlusAnyIntrinsic
    extends FunctionIntrinsic {
        private final boolean leftTypeNullable;

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
            JsExpression jsExpression;
            Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
            Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            JsExpression jsExpression2 = callInfo.getDispatchReceiver();
            if (jsExpression2 == null) {
                JsExpression jsExpression3 = callInfo.getExtensionReceiver();
                jsExpression2 = jsExpression3;
                Intrinsics.checkNotNull((Object)jsExpression3);
            }
            JsExpression receiver = jsExpression2;
            BindingContext bindingContext = context2.bindingContext();
            Call call2 = callInfo.getResolvedCall().getCall();
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"callInfo.resolvedCall.call");
            KtExpression ktExpression = call2.getValueArguments().get(0).getArgumentExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            KotlinType kotlinType = bindingContext.getType(ktExpression);
            if (kotlinType == null) {
                ValueParameterDescriptor valueParameterDescriptor = callInfo.getResolvedCall().getResultingDescriptor().getValueParameters().get(0);
                Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"callInfo.resolvedCall.re\u2026riptor.valueParameters[0]");
                kotlinType = valueParameterDescriptor.getType();
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.bindingContext()\u2026r.valueParameters[0].type");
            KotlinType rightType = kotlinType;
            boolean rightTypeNullable = TypeUtils.isNullableType(rightType);
            boolean hasNonNullArg = !this.leftTypeNullable || !rightTypeNullable;
            if (KotlinBuiltIns.isChar(rightType)) {
                jsExpression = JsAstUtils.charToString(arguments2.get(0));
            } else if (KotlinBuiltIns.isStringOrNullableString(rightType) && hasNonNullArg) {
                jsExpression = arguments2.get(0);
            } else {
                boolean bl = false;
                jsExpression = TopLevelFIF.TO_STRING.apply(arguments2.get(0), (List<? extends JsExpression>)CollectionsKt.emptyList(), context2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"when {\n                K\u2026          }\n            }");
            JsExpression rightExpr = jsExpression;
            return new JsBinaryOperation(JsBinaryOperator.ADD, receiver, rightExpr);
        }

        public StringPlusAnyIntrinsic(boolean leftTypeNullable) {
            this.leftTypeNullable = leftTypeNullable;
        }
    }
}

