/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThreadLocalCachedByteArray;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.ByteArraySequence;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.io.CompressedAppendableFile;
import org.jetbrains.kotlin.com.intellij.util.io.DataInputOutputUtil;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.FileAccessorCache;
import org.jetbrains.kotlin.com.intellij.util.io.FileChannelUtil;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentHashMap;
import org.jetbrains.kotlin.com.intellij.util.io.RandomAccessFileWithLengthAndSizeTracking;
import org.jetbrains.kotlin.com.intellij.util.io.UnsyncByteArrayInputStream;

public class PersistentHashMapValueStorage {
    @Nullable
    private RAReader myCompactionModeReader;
    private volatile long mySize;
    private final Path myPath;
    private final CreationTimeOptions myOptions;
    private boolean myCompactionMode;
    private static final int CACHE_PROTECTED_QUEUE_SIZE = 10;
    private static final int CACHE_PROBATIONAL_QUEUE_SIZE = 20;
    private static final long MAX_RETAINED_LIMIT_WHEN_COMPACTING = 0x6400000L;
    static final long SOFT_MAX_RETAINED_LIMIT = 0xA00000L;
    static final int BLOCK_SIZE_TO_WRITE_WHEN_SOFT_MAX_RETAINED_LIMIT_IS_HIT = 1024;
    private static final FileAccessorCache<Path, RandomAccessFileWithLengthAndSizeTracking> ourRandomAccessFileCache = new FileAccessorCache<Path, RandomAccessFileWithLengthAndSizeTracking>(20, 40){

        @Override
        @NotNull
        protected RandomAccessFileWithLengthAndSizeTracking createAccessor(Path path2) throws IOException {
            return new RandomAccessFileWithLengthAndSizeTracking(path2);
        }

        @Override
        protected void disposeAccessor(@NotNull RandomAccessFileWithLengthAndSizeTracking fileAccessor) throws IOException {
            if (fileAccessor == null) {
                1.$$$reportNull$$$0(0);
            }
            fileAccessor.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAccessor", "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMapValueStorage$1", "disposeAccessor"));
        }
    };
    private static final boolean useSingleFileDescriptor = SystemProperties.getBooleanProperty("idea.use.single.file.descriptor.for.persistent.hash.map", true);
    private static final FileAccessorCache<Path, DataOutputStream> ourAppendersCache = new FileAccessorCache<Path, DataOutputStream>(10, 20){

        @Override
        @NotNull
        protected DataOutputStream createAccessor(Path path2) throws IOException {
            OutputStream out = useSingleFileDescriptor ? new OutputStreamOverRandomAccessFileCache(path2) : new FileOutputStream(path2.toFile(), true);
            return new DataOutputStream(new BufferedOutputStream(out));
        }

        @Override
        protected void disposeAccessor(@NotNull DataOutputStream fileAccessor) throws IOException {
            if (fileAccessor == null) {
                2.$$$reportNull$$$0(0);
            }
            if (!useSingleFileDescriptor) {
                IOUtil.syncStream(fileAccessor);
            }
            fileAccessor.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAccessor", "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMapValueStorage$2", "disposeAccessor"));
        }
    };
    private static final FileAccessorCache<Path, RAReader> ourReadersCache = new FileAccessorCache<Path, RAReader>(10, 20){

        @Override
        @NotNull
        protected RAReader createAccessor(Path path2) {
            return useSingleFileDescriptor ? new ReaderOverRandomAccessFileCache(path2) : new FileReader(path2);
        }

        @Override
        protected void disposeAccessor(@NotNull RAReader fileAccessor) {
            if (fileAccessor == null) {
                3.$$$reportNull$$$0(0);
            }
            fileAccessor.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAccessor", "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMapValueStorage$3", "disposeAccessor"));
        }
    };
    private final CompressedAppendableFile myCompressedAppendableFile;
    public static final boolean COMPRESSION_ENABLED = SystemProperties.getBooleanProperty("idea.compression.enabled", true);
    private static final ThreadLocalCachedByteArray myBuffer = new ThreadLocalCachedByteArray();
    private final UnsyncByteArrayInputStream myBufferStreamWrapper;
    private final DataInputStream myBufferDataStreamWrapper;
    private static final int ourBufferLength = 1024;
    private long myChunksRemovalTime;
    private long myChunksReadingTime;
    private int myChunks;
    private long myChunksOriginalBytes;
    private long myChunksBytesAfterRemoval;
    private int myLastReportedChunksCount;
    private static final boolean ourDumpChunkRemovalTime = SystemProperties.getBooleanProperty("idea.phmp.dump.chunk.removal.time", false);

    @NotNull
    CreationTimeOptions getOptions() {
        CreationTimeOptions creationTimeOptions = this.myOptions;
        if (creationTimeOptions == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(0);
        }
        return creationTimeOptions;
    }

    private PersistentHashMapValueStorage(@NotNull Path path2) throws IOException {
        if (path2 == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(1);
        }
        this(path2, CreationTimeOptions.threadLocalOptions());
    }

    private PersistentHashMapValueStorage(@NotNull Path path2, @NotNull CreationTimeOptions options) throws IOException {
        if (path2 == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(2);
        }
        if (options == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(3);
        }
        this.myBufferStreamWrapper = new UnsyncByteArrayInputStream(ArrayUtilRt.EMPTY_BYTE_ARRAY);
        this.myBufferDataStreamWrapper = new DataInputStream(this.myBufferStreamWrapper);
        this.myPath = path2;
        this.myOptions = options;
        CompressedAppendableFile compressedAppendableFile = this.myCompressedAppendableFile = this.myOptions.myDoCompression ? new MyCompressedAppendableFile() : null;
        this.mySize = this.myCompressedAppendableFile == null ? (Files.exists(this.myPath, new LinkOption[0]) ? Files.size(this.myPath) : 0L) : this.myCompressedAppendableFile.length();
    }

    public long appendBytes(ByteArraySequence data, long prevChunkAddress) throws IOException {
        return this.appendBytes(data.getBytes(), data.getOffset(), data.getLength(), prevChunkAddress);
    }

    public long appendBytes(byte[] data, int offset2, int dataLength, long prevChunkAddress) throws IOException {
        if (this.mySize == 0L) {
            long currentLength;
            byte[] bytes = "Header Record For PersistentHashMapValueStorage".getBytes(StandardCharsets.UTF_8);
            this.doAppendBytes(bytes, 0, bytes.length, 0L);
            FileAccessorCache.Handle<DataOutputStream> streamCacheValue = ourAppendersCache.getIfCached(this.myPath);
            if (streamCacheValue != null) {
                try {
                    IOUtil.syncStream(streamCacheValue.get());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    streamCacheValue.release();
                }
            }
            long l = currentLength = Files.exists(this.myPath, new LinkOption[0]) ? Files.size(this.myPath) : 0L;
            if (currentLength > this.mySize) {
                Logger.getInstance(this.getClass().getName()).info("Avoided PSHM corruption due to write failure:" + this.myPath);
                this.mySize = currentLength;
            }
        }
        return this.doAppendBytes(data, offset2, dataLength, prevChunkAddress);
    }

    void checkAppendsAllowed(int previouslyAccumulatedChunkSize) {
        if (previouslyAccumulatedChunkSize != 0 && this.myOptions.myHasNoChunks) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doAppendBytes(byte[] data, int offset2, int dataLength, long prevChunkAddress) throws IOException {
        if (!this.allowedToCompactChunks()) {
            throw new AssertionError();
        }
        if (prevChunkAddress != 0L && this.myOptions.myHasNoChunks) {
            throw new AssertionError();
        }
        long result2 = this.mySize;
        FileAccessorCache.Handle<DataOutputStream> appender = this.myCompressedAppendableFile != null ? null : ourAppendersCache.get(this.myPath);
        try {
            if (this.myCompressedAppendableFile != null) {
                BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream(15);
                DataOutputStream testStream = new DataOutputStream(stream);
                this.saveHeader(dataLength, prevChunkAddress, result2, testStream);
                this.myCompressedAppendableFile.append(stream.getInternalBuffer(), stream.size());
                this.myCompressedAppendableFile.append(data, offset2, dataLength);
                this.mySize += (long)(stream.size() + dataLength);
            } else {
                DataOutputStream dataOutputStream = appender.get();
                dataOutputStream.resetWrittenBytesCount();
                this.saveHeader(dataLength, prevChunkAddress, result2, dataOutputStream);
                dataOutputStream.write(data, offset2, dataLength);
                this.mySize += (long)dataOutputStream.resetWrittenBytesCount();
            }
        }
        finally {
            if (appender != null) {
                appender.release();
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private void saveHeader(int dataLength, long prevChunkAddress, long result2, @NotNull DataOutputStream dataOutputStream) throws IOException {
        void dataOutputStream2;
        if (dataOutputStream == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(4);
        }
        DataInputOutputUtil.writeINT((DataOutput)dataOutputStream2, dataLength);
        if (!this.myOptions.myHasNoChunks) {
            if (result2 < prevChunkAddress) {
                throw new IOException("writePrevChunkAddress:" + result2 + "," + prevChunkAddress + "," + this.myPath);
            }
            long diff = result2 - prevChunkAddress;
            DataInputOutputUtil.writeLONG((DataOutput)dataOutputStream2, prevChunkAddress == 0L ? 0L : diff);
        }
    }

    private long compactValuesWithoutChunks(@NotNull List<? extends PersistentHashMap.CompactionRecordInfo> infos2, @NotNull PersistentHashMapValueStorage storage2) throws IOException {
        if (infos2 == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(5);
        }
        if (storage2 == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(6);
        }
        infos2.sort((info, info2) -> Comparing.compare(info.valueAddress, info2.valueAddress));
        int fileBufferLength = 262144;
        byte[] buffer = new byte[262144];
        int fragments2 = 0;
        int newFragments = 0;
        byte[] outputBuffer = new byte[4096];
        long readStartOffset = -1L;
        int bytesRead = -1;
        for (PersistentHashMap.CompactionRecordInfo compactionRecordInfo : infos2) {
            int newBytesFitInBuffer;
            int bytesFitInBuffer;
            int recordStartInBuffer = (int)(compactionRecordInfo.valueAddress - readStartOffset);
            if (recordStartInBuffer + 5 > 262144 || readStartOffset == -1L) {
                readStartOffset = compactionRecordInfo.valueAddress;
                long remainingBytes = readStartOffset != -1L ? this.mySize - readStartOffset : this.mySize;
                bytesRead = remainingBytes < 262144L ? (int)remainingBytes : 262144;
                this.myCompactionModeReader.get(readStartOffset, buffer, 0, bytesRead);
                recordStartInBuffer = (int)(compactionRecordInfo.valueAddress - readStartOffset);
            }
            this.myBufferStreamWrapper.init(buffer, recordStartInBuffer, buffer.length);
            int available = this.myBufferStreamWrapper.available();
            int chunkSize = DataInputOutputUtil.readINT(this.myBufferDataStreamWrapper);
            long prevChunkAddress = this.readPrevChunkAddress(compactionRecordInfo.valueAddress);
            assert (prevChunkAddress == 0L);
            int dataOffset = available - this.myBufferStreamWrapper.available() + recordStartInBuffer;
            if (chunkSize >= outputBuffer.length) {
                outputBuffer = new byte[(chunkSize / 4096 + 1) * 4096];
            }
            System.arraycopy(buffer, dataOffset, outputBuffer, 0, bytesFitInBuffer);
            for (bytesFitInBuffer = Math.min(chunkSize, 262144 - dataOffset); bytesFitInBuffer != chunkSize; bytesFitInBuffer += newBytesFitInBuffer) {
                long remainingBytes = this.mySize - (readStartOffset += (long)bytesRead);
                bytesRead = remainingBytes < 262144L ? (int)remainingBytes : 262144;
                this.myCompactionModeReader.get(readStartOffset, buffer, 0, bytesRead);
                newBytesFitInBuffer = Math.min(chunkSize - bytesFitInBuffer, 262144);
                System.arraycopy(buffer, 0, outputBuffer, bytesFitInBuffer, newBytesFitInBuffer);
            }
            compactionRecordInfo.newValueAddress = storage2.appendBytes(outputBuffer, 0, chunkSize, 0L);
            ++fragments2;
            ++newFragments;
        }
        return (long)fragments2 | (long)newFragments << 32;
    }

    long compactValues(@NotNull List<? extends PersistentHashMap.CompactionRecordInfo> infos2, @NotNull PersistentHashMapValueStorage storage2) throws IOException {
        long lastReadOffset;
        if (infos2 == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(7);
        }
        if (storage2 == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(8);
        }
        if (this.myOptions.myHasNoChunks) {
            return this.compactValuesWithoutChunks(infos2, storage2);
        }
        PriorityQueue<? extends PersistentHashMap.CompactionRecordInfo> records = new PriorityQueue<PersistentHashMap.CompactionRecordInfo>(infos2.size(), (info, info2) -> Comparing.compare(info2.valueAddress, info.valueAddress));
        records.addAll(infos2);
        int fileBufferLength = 262144;
        int maxRecordHeader = 15;
        byte[] buffer = new byte[262159];
        byte[] reusedAccumulatedChunksBuffer = new byte[]{};
        long lastConsumedOffset = lastReadOffset = this.mySize;
        long allRecordsStart = 0L;
        int fragments2 = 0;
        int newFragments = 0;
        int allRecordsLength = 0;
        byte[] stuffFromPreviousRecord = null;
        int bytesRead = (int)(this.mySize - this.mySize / 262144L * 262144L);
        long retained = 0L;
        while (lastReadOffset != 0L) {
            long readStartOffset = lastReadOffset - (long)bytesRead;
            this.myCompactionModeReader.get(readStartOffset, buffer, 0, bytesRead);
            while (!records.isEmpty()) {
                PersistentHashMap.CompactionRecordInfo info3 = (PersistentHashMap.CompactionRecordInfo)records.peek();
                if (info3.valueAddress >= readStartOffset) {
                    byte[] accumulatedChunksBuffer;
                    if (info3.valueAddress >= lastReadOffset) {
                        throw new IOException("Value storage is corrupted: value file size:" + this.mySize + ", readStartOffset:" + readStartOffset + ", record address:" + info3.valueAddress + "; file: " + this.myPath);
                    }
                    int recordStartInBuffer = (int)(info3.valueAddress - readStartOffset);
                    this.myBufferStreamWrapper.init(buffer, recordStartInBuffer, buffer.length);
                    if (stuffFromPreviousRecord != null && 262144 - recordStartInBuffer < 15) {
                        if (allRecordsStart != 0L) {
                            this.myCompactionModeReader.get(allRecordsStart, buffer, bytesRead, 15);
                        } else {
                            int maxAdditionalBytes = Math.min(stuffFromPreviousRecord.length, 15);
                            for (int i = 0; i < maxAdditionalBytes; ++i) {
                                buffer[bytesRead + i] = stuffFromPreviousRecord[i];
                            }
                        }
                    }
                    int available = this.myBufferStreamWrapper.available();
                    int chunkSize = DataInputOutputUtil.readINT(this.myBufferDataStreamWrapper);
                    long prevChunkAddress = this.readPrevChunkAddress(info3.valueAddress);
                    int dataOffset = available - this.myBufferStreamWrapper.available();
                    if (info3.value != null) {
                        int defragmentedChunkSize = info3.value.length + chunkSize;
                        if (prevChunkAddress == 0L) {
                            if (defragmentedChunkSize >= reusedAccumulatedChunksBuffer.length) {
                                reusedAccumulatedChunksBuffer = new byte[defragmentedChunkSize];
                            }
                            accumulatedChunksBuffer = reusedAccumulatedChunksBuffer;
                        } else {
                            accumulatedChunksBuffer = new byte[defragmentedChunkSize];
                            retained += (long)defragmentedChunkSize;
                        }
                        System.arraycopy(info3.value, 0, accumulatedChunksBuffer, chunkSize, info3.value.length);
                    } else if (prevChunkAddress == 0L) {
                        if (chunkSize >= reusedAccumulatedChunksBuffer.length) {
                            reusedAccumulatedChunksBuffer = new byte[chunkSize];
                        }
                        accumulatedChunksBuffer = reusedAccumulatedChunksBuffer;
                    } else {
                        accumulatedChunksBuffer = new byte[chunkSize];
                        retained += (long)chunkSize;
                    }
                    int chunkSizeOutOfBuffer = Math.min(chunkSize, Math.max((int)(info3.valueAddress + (long)dataOffset + (long)chunkSize - lastReadOffset), 0));
                    if (chunkSizeOutOfBuffer > 0) {
                        if (allRecordsStart != 0L) {
                            this.myCompactionModeReader.get(allRecordsStart, accumulatedChunksBuffer, chunkSize - chunkSizeOutOfBuffer, chunkSizeOutOfBuffer);
                        } else {
                            int offsetInStuffFromPreviousRecord = Math.max((int)(info3.valueAddress + (long)dataOffset - lastReadOffset), 0);
                            System.arraycopy(stuffFromPreviousRecord, offsetInStuffFromPreviousRecord, accumulatedChunksBuffer, chunkSize - chunkSizeOutOfBuffer, chunkSizeOutOfBuffer);
                        }
                    }
                    stuffFromPreviousRecord = null;
                    allRecordsLength = 0;
                    allRecordsStart = 0;
                    lastConsumedOffset = info3.valueAddress;
                    PersistentHashMapValueStorage.checkPreconditions(accumulatedChunksBuffer, chunkSize, 0);
                    System.arraycopy(buffer, recordStartInBuffer + dataOffset, accumulatedChunksBuffer, 0, chunkSize - chunkSizeOutOfBuffer);
                    ++fragments2;
                    records.remove(info3);
                    if (info3.value != null) {
                        chunkSize += info3.value.length;
                        retained -= (long)info3.value.length;
                        info3.value = null;
                    }
                    if (prevChunkAddress == 0L) {
                        info3.newValueAddress = storage2.appendBytes(accumulatedChunksBuffer, 0, chunkSize, info3.newValueAddress);
                        ++newFragments;
                        continue;
                    }
                    if (retained > 0xA00000L && accumulatedChunksBuffer.length > 1024 || retained > 0x6400000L) {
                        newFragments += this.saveAccumulatedDataOnDiskPreservingWriteOrder(storage2, info3, prevChunkAddress, accumulatedChunksBuffer, chunkSize);
                        retained -= (long)accumulatedChunksBuffer.length;
                        continue;
                    }
                    info3.value = accumulatedChunksBuffer;
                    info3.valueAddress = prevChunkAddress;
                    records.add(info3);
                    continue;
                }
                if (stuffFromPreviousRecord == null) {
                    stuffFromPreviousRecord = new byte[(int)(lastConsumedOffset - readStartOffset)];
                    System.arraycopy(buffer, 0, stuffFromPreviousRecord, 0, stuffFromPreviousRecord.length);
                    break;
                }
                allRecordsStart = readStartOffset;
                allRecordsLength += buffer.length;
                break;
            }
            lastReadOffset -= (long)bytesRead;
            bytesRead = 262144;
        }
        return (long)fragments2 | (long)newFragments << 32;
    }

    private int saveAccumulatedDataOnDiskPreservingWriteOrder(PersistentHashMapValueStorage storage2, PersistentHashMap.CompactionRecordInfo info, long prevChunkAddress, byte[] accumulatedChunksData, int accumulatedChunkDataLength) throws IOException {
        ReadResult result2 = this.readBytes(prevChunkAddress);
        info.newValueAddress = storage2.appendBytes(result2.buffer, 0, result2.buffer.length, info.newValueAddress);
        info.newValueAddress = storage2.appendBytes(accumulatedChunksData, 0, accumulatedChunkDataLength, info.newValueAddress);
        info.value = null;
        info.valueAddress = 0L;
        return 2;
    }

    public ReadResult readBytes(long tailChunkAddress) throws IOException {
        PersistentHashMapValueStorage.forceAppender(this.myPath);
        this.checkCancellation();
        long startedTime = ourDumpChunkRemovalTime ? System.nanoTime() : 0L;
        RAReader reader = this.myCompactionModeReader;
        FileAccessorCache.Handle<RAReader> readerHandle = null;
        if (reader == null) {
            readerHandle = this.myCompressedAppendableFile != null ? null : ourReadersCache.get(this.myPath);
            reader = this.myCompressedAppendableFile != null ? null : readerHandle.get();
        }
        int chunkCount = 0;
        byte[] result2 = null;
        try {
            long chunk = tailChunkAddress;
            while (chunk != 0L) {
                if (chunk < 0L || chunk > this.mySize) {
                    throw new PersistentEnumeratorBase.CorruptedException(this.myPath);
                }
                byte[] buffer = myBuffer.getBuffer(1024);
                int len = (int)Math.min(1024L, this.mySize - chunk);
                if (this.myCompressedAppendableFile != null) {
                    DataInputStream stream = this.myCompressedAppendableFile.getStream(chunk);
                    stream.readFully(buffer, 0, len);
                    stream.close();
                } else {
                    reader.get(chunk, buffer, 0, len);
                }
                this.myBufferStreamWrapper.init(buffer, 0, len);
                int chunkSize = DataInputOutputUtil.readINT(this.myBufferDataStreamWrapper);
                if (chunkSize < 0) {
                    throw new IOException("Value storage corrupted: negative chunk size: " + chunkSize);
                }
                long prevChunkAddress = this.readPrevChunkAddress(chunk);
                int headerOffset = len - this.myBufferStreamWrapper.available();
                byte[] b = new byte[(result2 != null ? result2.length : 0) + chunkSize];
                if (result2 != null) {
                    System.arraycopy(result2, 0, b, b.length - result2.length, result2.length);
                }
                result2 = b;
                PersistentHashMapValueStorage.checkPreconditions(result2, chunkSize, 0);
                if (chunkSize < 1024 - headerOffset) {
                    System.arraycopy(buffer, headerOffset, result2, 0, chunkSize);
                } else if (this.myCompressedAppendableFile != null) {
                    DataInputStream stream = this.myCompressedAppendableFile.getStream(chunk + (long)headerOffset);
                    stream.readFully(result2, 0, chunkSize);
                    stream.close();
                } else {
                    reader.get(chunk + (long)headerOffset, result2, 0, chunkSize);
                }
                if (prevChunkAddress >= chunk) {
                    throw new PersistentEnumeratorBase.CorruptedException(this.myPath);
                }
                chunk = prevChunkAddress;
                ++chunkCount;
                if (prevChunkAddress != 0L) {
                    this.checkCancellation();
                    assert (!this.myOptions.myHasNoChunks);
                }
                if ((long)result2.length <= this.mySize || this.myCompressedAppendableFile != null) continue;
                throw new PersistentEnumeratorBase.CorruptedException(this.myPath);
            }
        }
        catch (OutOfMemoryError error) {
            throw new PersistentEnumeratorBase.CorruptedException(this.myPath);
        }
        finally {
            if (readerHandle != null) {
                readerHandle.release();
            }
        }
        if (chunkCount > 1) {
            this.checkCancellation();
            this.myChunksReadingTime += (ourDumpChunkRemovalTime ? System.nanoTime() : 0L) - startedTime;
            this.myChunks += chunkCount;
            this.myChunksOriginalBytes += (long)result2.length;
        }
        return new ReadResult(result2, chunkCount);
    }

    private boolean allowedToCompactChunks() {
        return !this.myCompactionMode && !this.myOptions.myReadOnly;
    }

    boolean performChunksCompaction(int chunksCount, int chunksBytesSize) {
        return chunksCount > 1 && this.allowedToCompactChunks();
    }

    long compactChunks(PersistentHashMap.ValueDataAppender appender, ReadResult result2) throws IOException {
        long newValueOffset;
        long startedTime;
        this.checkCancellation();
        long l = startedTime = ourDumpChunkRemovalTime ? System.nanoTime() : 0L;
        if (this.myOptions.myCompactChunksWithValueDeserialization) {
            BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream(result2.buffer.length);
            DataOutputStream testStream = new DataOutputStream(stream);
            appender.append(testStream);
            newValueOffset = this.appendBytes(stream.toByteArraySequence(), 0L);
            this.myChunksBytesAfterRemoval += (long)stream.size();
        } else {
            newValueOffset = this.appendBytes(new ByteArraySequence(result2.buffer), 0L);
            this.myChunksBytesAfterRemoval += (long)result2.buffer.length;
        }
        if (ourDumpChunkRemovalTime) {
            this.myChunksRemovalTime += System.nanoTime() - startedTime;
            if (this.myChunks - this.myLastReportedChunksCount > 1000) {
                this.myLastReportedChunksCount = this.myChunks;
                System.out.println(this.myChunks + " chunks were read " + this.myChunksReadingTime / 1000000L + "ms, bytes: " + this.myChunksOriginalBytes + (this.myChunksOriginalBytes != this.myChunksBytesAfterRemoval ? "->" + this.myChunksBytesAfterRemoval : "") + " compaction:" + this.myChunksRemovalTime / 1000000L + "ms in " + this.myPath);
            }
        }
        return newValueOffset;
    }

    private void checkCancellation() {
        if (this.myOptions.myExceptionalIOCancellationCallback != null) {
            this.myOptions.myExceptionalIOCancellationCallback.checkCancellation();
        }
    }

    private long readPrevChunkAddress(long chunk) throws IOException {
        if (this.myOptions.myHasNoChunks) {
            return 0L;
        }
        long prevOffsetDiff = DataInputOutputUtil.readLONG(this.myBufferDataStreamWrapper);
        if (prevOffsetDiff >= chunk) {
            throw new IOException("readPrevChunkAddress:" + chunk + "," + prevOffsetDiff + "," + this.mySize + "," + this.myPath);
        }
        return prevOffsetDiff != 0L ? chunk - prevOffsetDiff : 0L;
    }

    public long getSize() {
        return this.mySize;
    }

    private static void checkPreconditions(byte[] result2, int chunkSize, int off) throws IOException {
        if (chunkSize < 0) {
            throw new IOException("Value storage corrupted: negative chunk size");
        }
        if (off < 0) {
            throw new IOException("Value storage corrupted: negative offset");
        }
        if (chunkSize > result2.length - off) {
            throw new IOException("Value storage corrupted");
        }
    }

    public void force() {
        if (this.myOptions.myReadOnly) {
            return;
        }
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.force();
        }
        if (this.mySize < 0L) assert (false);
        PersistentHashMapValueStorage.forceAppender(this.myPath);
    }

    private static void forceAppender(Path path2) {
        FileAccessorCache.Handle<DataOutputStream> cached2 = ourAppendersCache.getIfCached(path2);
        if (cached2 != null) {
            try {
                cached2.get().flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                cached2.release();
            }
        }
    }

    public void dispose() {
        try {
            if (this.myCompressedAppendableFile != null) {
                this.myCompressedAppendableFile.dispose();
            }
        }
        finally {
            if (this.mySize < 0L) assert (false);
            ourReadersCache.remove(this.myPath);
            ourAppendersCache.remove(this.myPath);
            ourRandomAccessFileCache.remove(this.myPath);
            if (this.myCompactionModeReader != null) {
                this.myCompactionModeReader.dispose();
                this.myCompactionModeReader = null;
            }
        }
    }

    void switchToCompactionMode() {
        ourReadersCache.remove(this.myPath);
        ourRandomAccessFileCache.remove(this.myPath);
        this.myCompactionModeReader = this.myCompressedAppendableFile != null ? new RAReader(){

            @Override
            public void get(long addr, byte[] dst, int off, int len) throws IOException {
                DataInputStream stream = PersistentHashMapValueStorage.this.myCompressedAppendableFile.getStream(addr);
                stream.readFully(dst, off, len);
                stream.close();
            }

            @Override
            public void dispose() {
            }
        } : new FileReader(this.myPath);
        this.myCompactionMode = true;
    }

    public static PersistentHashMapValueStorage create(Path path2, boolean readOnly) throws IOException {
        if (readOnly) {
            CreationTimeOptions.READONLY.set(Boolean.TRUE);
        }
        try {
            PersistentHashMapValueStorage persistentHashMapValueStorage = new PersistentHashMapValueStorage(path2);
            return persistentHashMapValueStorage;
        }
        finally {
            if (readOnly) {
                CreationTimeOptions.READONLY.set(null);
            }
        }
    }

    public static PersistentHashMapValueStorage create(@NotNull Path path2, @NotNull CreationTimeOptions options) throws IOException {
        if (path2 == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(9);
        }
        if (options == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(10);
        }
        return new PersistentHashMapValueStorage(path2, options);
    }

    public boolean isReadOnly() {
        return this.myOptions.myReadOnly;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMapValueStorage";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataOutputStream";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMapValueStorage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveHeader";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compactValuesWithoutChunks";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compactValues";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCompressedAppendableFile
    extends CompressedAppendableFile {
        MyCompressedAppendableFile() throws IOException {
            super(PersistentHashMapValueStorage.this.myPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected InputStream getChunkInputStream(Path appendFile, long offset2, int pageSize) throws IOException {
            PersistentHashMapValueStorage.forceAppender(PersistentHashMapValueStorage.this.myPath);
            FileAccessorCache.Handle fileAccessor = ourReadersCache.get(PersistentHashMapValueStorage.this.myPath);
            byte[] bytes = new byte[pageSize];
            ((RAReader)fileAccessor.get()).get(offset2, bytes, 0, pageSize);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            if (byteArrayInputStream2 == null) {
                MyCompressedAppendableFile.$$$reportNull$$$0(0);
            }
            return byteArrayInputStream2;
            finally {
                fileAccessor.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void saveChunk(BufferExposingByteArrayOutputStream compressedChunk, long endOfFileOffset) throws IOException {
            FileAccessorCache.Handle streamCacheValue = ourAppendersCache.get(PersistentHashMapValueStorage.this.myPath);
            try {
                ((DataOutputStream)streamCacheValue.get()).write(compressedChunk.getInternalBuffer(), 0, compressedChunk.size());
            }
            finally {
                streamCacheValue.release();
            }
            streamCacheValue = ourAppendersCache.get(PersistentHashMapValueStorage.this.myPath.resolveSibling(PersistentHashMapValueStorage.this.myPath.getFileName() + ".s"));
            try {
                DataInputOutputUtil.writeINT((DataOutput)streamCacheValue.get(), compressedChunk.size());
            }
            finally {
                streamCacheValue.release();
            }
        }

        @Override
        @NotNull
        protected Path getChunksFile() {
            Path path2 = PersistentHashMapValueStorage.this.myPath;
            if (path2 == null) {
                MyCompressedAppendableFile.$$$reportNull$$$0(1);
            }
            return path2;
        }

        @Override
        protected Path getChunkLengthFile() {
            return PersistentHashMapValueStorage.this.myPath.resolveSibling(PersistentHashMapValueStorage.this.myPath.getFileName() + ".s");
        }

        @Override
        public synchronized void force() {
            super.force();
            PersistentHashMapValueStorage.forceAppender(PersistentHashMapValueStorage.this.myPath.resolveSibling(PersistentHashMapValueStorage.this.myPath.getFileName() + ".s"));
        }

        @Override
        public synchronized void dispose() {
            super.dispose();
            ourAppendersCache.remove(PersistentHashMapValueStorage.this.myPath.resolveSibling(PersistentHashMapValueStorage.this.myPath.getFileName() + ".s"));
            ourRandomAccessFileCache.remove(PersistentHashMapValueStorage.this.myPath.resolveSibling(PersistentHashMapValueStorage.this.myPath.getFileName() + ".s"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMapValueStorage$MyCompressedAppendableFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunkInputStream";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunksFile";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class OutputStreamOverRandomAccessFileCache
    extends OutputStream {
        private final Path myPath;

        OutputStreamOverRandomAccessFileCache(Path path2) {
            this.myPath = path2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte @NotNull [] b, int off, int len) throws IOException {
            if (b == null) {
                OutputStreamOverRandomAccessFileCache.$$$reportNull$$$0(0);
            }
            FileAccessorCache.Handle fileAccessor = ourRandomAccessFileCache.get(this.myPath);
            RandomAccessFileWithLengthAndSizeTracking file2 = (RandomAccessFileWithLengthAndSizeTracking)fileAccessor.get();
            try {
                file2.seek(file2.length());
                file2.write(b, off, len);
            }
            finally {
                fileAccessor.release();
            }
        }

        @Override
        public void write(int b) throws IOException {
            byte[] r = new byte[]{(byte)(b & 0xFF)};
            this.write(r);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMapValueStorage$OutputStreamOverRandomAccessFileCache", "write"));
        }
    }

    private static class FileReader
    implements RAReader {
        private final FileChannel myFile;

        private FileReader(Path file2) {
            try {
                this.myFile = FileChannelUtil.unInterruptible(FileChannel.open(file2, StandardOpenOption.READ));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void get(long addr, byte[] dst, int off, int len) throws IOException {
            this.myFile.position(addr);
            this.myFile.read(ByteBuffer.wrap(dst, off, len));
        }

        @Override
        public void dispose() {
            try {
                this.myFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ReaderOverRandomAccessFileCache
    implements RAReader {
        private final Path myPath;

        private ReaderOverRandomAccessFileCache(@NotNull Path path2) {
            if (path2 == null) {
                ReaderOverRandomAccessFileCache.$$$reportNull$$$0(0);
            }
            this.myPath = path2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void get(long addr, byte[] dst, int off, int len) throws IOException {
            FileAccessorCache.Handle fileAccessor = ourRandomAccessFileCache.get(this.myPath);
            try {
                RandomAccessFileWithLengthAndSizeTracking file2 = (RandomAccessFileWithLengthAndSizeTracking)fileAccessor.get();
                file2.seek(addr);
                file2.read(dst, off, len);
            }
            finally {
                fileAccessor.release();
            }
        }

        @Override
        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMapValueStorage$ReaderOverRandomAccessFileCache", "<init>"));
        }
    }

    private static interface RAReader {
        public void get(long var1, byte[] var3, int var4, int var5) throws IOException;

        public void dispose();
    }

    static class ReadResult {
        final byte[] buffer;
        final int chunksCount;

        ReadResult(byte[] buffer, int chunksCount) {
            this.buffer = buffer;
            this.chunksCount = chunksCount;
        }
    }

    public static interface ExceptionalIOCancellationCallback {
        public void checkCancellation();
    }

    public static class CreationTimeOptions {
        public static final ThreadLocal<ExceptionalIOCancellationCallback> EXCEPTIONAL_IO_CANCELLATION = new ThreadLocal();
        public static final ThreadLocal<Boolean> READONLY = new ThreadLocal();
        public static final ThreadLocal<Boolean> COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION = new ThreadLocal();
        public static final ThreadLocal<Boolean> HAS_NO_CHUNKS = new ThreadLocal();
        static final ThreadLocal<Boolean> DO_COMPRESSION = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return COMPRESSION_ENABLED;
            }
        };
        private final ExceptionalIOCancellationCallback myExceptionalIOCancellationCallback;
        private final boolean myReadOnly;
        private final boolean myCompactChunksWithValueDeserialization;
        private final boolean myHasNoChunks;
        private final boolean myDoCompression;

        private CreationTimeOptions(ExceptionalIOCancellationCallback callback, boolean readOnly, boolean compactChunksWithValueDeserialization, boolean hasNoChunks, boolean doCompression) {
            this.myExceptionalIOCancellationCallback = callback;
            this.myReadOnly = readOnly;
            this.myCompactChunksWithValueDeserialization = compactChunksWithValueDeserialization;
            this.myHasNoChunks = hasNoChunks;
            this.myDoCompression = doCompression;
        }

        int getVersion() {
            return (this.myHasNoChunks ? 10 : 0) * 31 + (this.myDoCompression ? 19 : 0);
        }

        boolean isReadOnly() {
            return this.myReadOnly;
        }

        @NotNull
        CreationTimeOptions setReadOnly() {
            return new CreationTimeOptions(this.myExceptionalIOCancellationCallback, true, this.myCompactChunksWithValueDeserialization, this.myHasNoChunks, this.myDoCompression);
        }

        @NotNull
        static CreationTimeOptions threadLocalOptions() {
            return new CreationTimeOptions(EXCEPTIONAL_IO_CANCELLATION.get(), READONLY.get() == Boolean.TRUE, COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.get() == Boolean.TRUE, HAS_NO_CHUNKS.get() == Boolean.TRUE, DO_COMPRESSION.get() == Boolean.TRUE);
        }
    }
}

