/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.types.expressions.AssignedVariablesSearcher;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\r\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u0013*\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u001a.\u0010\u0016\u001a\u00020\u0013*\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a8\u0006\u001a"}, d2={"hasNoWritersInClosures", "", "variableContainingDeclaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "writers", "", "Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher$Writer;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isAccessedBeforeAllClosureWriters", "accessElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isAccessedInsideClosure", "isAccessedInsideClosureAfterAllWriters", "hasDefaultGetter", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isInvisibleFromOtherModules", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "propertyKind", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "usageModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "variableKind", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
public final class DataFlowValueKindUtilsKt {
    @NotNull
    public static final DataFlowValue.Kind propertyKind(@NotNull PropertyDescriptor $this$propertyKind, @Nullable ModuleDescriptor usageModule) {
        Intrinsics.checkNotNullParameter((Object)$this$propertyKind, (String)"$this$propertyKind");
        if ($this$propertyKind.isVar()) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        if (ModalityKt.isOverridable($this$propertyKind)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!DataFlowValueKindUtilsKt.hasDefaultGetter($this$propertyKind)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!DataFlowValueKindUtilsKt.isInvisibleFromOtherModules($this$propertyKind)) {
            ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($this$propertyKind);
            Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"DescriptorUtils.getContainingModule(this)");
            ModuleDescriptor declarationModule = moduleDescriptor;
            if (usageModule == null || Intrinsics.areEqual((Object)usageModule, (Object)declarationModule) ^ true) {
                return DataFlowValue.Kind.ALIEN_PUBLIC_PROPERTY;
            }
        }
        return DataFlowValue.Kind.STABLE_VALUE;
    }

    @NotNull
    public static final DataFlowValue.Kind variableKind(@NotNull VariableDescriptor $this$variableKind, @Nullable ModuleDescriptor usageModule, @NotNull BindingContext bindingContext, @NotNull KtElement accessElement, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$variableKind, (String)"$this$variableKind");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)accessElement, (String)"accessElement");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if ($this$variableKind instanceof PropertyDescriptor) {
            return DataFlowValueKindUtilsKt.propertyKind((PropertyDescriptor)$this$variableKind, usageModule);
        }
        if ($this$variableKind instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)$this$variableKind).isDelegated()) {
            return languageVersionSettings.supportsFeature(LanguageFeature.ProhibitSmartcastsOnLocalDelegatedProperty) ? DataFlowValue.Kind.PROPERTY_WITH_GETTER : DataFlowValue.Kind.LEGACY_STABLE_LOCAL_DELEGATED_PROPERTY;
        }
        if (!($this$variableKind instanceof LocalVariableDescriptor) && !($this$variableKind instanceof ParameterDescriptor)) {
            return DataFlowValue.Kind.OTHER;
        }
        if (!$this$variableKind.isVar()) {
            return DataFlowValue.Kind.STABLE_VALUE;
        }
        if ($this$variableKind instanceof SyntheticFieldDescriptor) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        PreliminaryDeclarationVisitor preliminaryDeclarationVisitor = PreliminaryDeclarationVisitor.Companion.getVisitorByVariable($this$variableKind, bindingContext);
        if (preliminaryDeclarationVisitor == null) {
            return DataFlowValue.Kind.CAPTURED_VARIABLE;
        }
        PreliminaryDeclarationVisitor preliminaryVisitor = preliminaryDeclarationVisitor;
        Set<AssignedVariablesSearcher.Writer> writers = preliminaryVisitor.writers($this$variableKind);
        if (writers.isEmpty()) {
            return DataFlowValue.Kind.STABLE_VARIABLE;
        }
        DeclarationDescriptor declarationDescriptor = $this$variableKind.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"this.containingDeclaration");
        DeclarationDescriptor variableContainingDeclaration = declarationDescriptor;
        if (DataFlowValueKindUtilsKt.isAccessedInsideClosure(variableContainingDeclaration, bindingContext, accessElement)) {
            return preliminaryVisitor.getLanguageVersionSettings().supportsFeature(LanguageFeature.CapturedInClosureSmartCasts) && DataFlowValueKindUtilsKt.hasNoWritersInClosures(variableContainingDeclaration, writers, bindingContext) && DataFlowValueKindUtilsKt.isAccessedInsideClosureAfterAllWriters(writers, accessElement) ? DataFlowValue.Kind.STABLE_VARIABLE : DataFlowValue.Kind.CAPTURED_VARIABLE;
        }
        return DataFlowValueKindUtilsKt.isAccessedBeforeAllClosureWriters(variableContainingDeclaration, writers, bindingContext, accessElement) ? DataFlowValue.Kind.STABLE_VARIABLE : DataFlowValue.Kind.CAPTURED_VARIABLE;
    }

    public static final boolean hasNoWritersInClosures(@NotNull DeclarationDescriptor variableContainingDeclaration, @NotNull Set<AssignedVariablesSearcher.Writer> writers, @NotNull BindingContext bindingContext) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)variableContainingDeclaration, (String)"variableContainingDeclaration");
            Intrinsics.checkNotNullParameter(writers, (String)"writers");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Iterable $this$none$iv = writers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    DeclarationDescriptor writerDescriptor;
                    DeclarationDescriptor declarationDescriptor;
                    AssignedVariablesSearcher.Writer $dstr$_u24__u24$writerDeclaration = (AssignedVariablesSearcher.Writer)element$iv;
                    boolean bl2 = false;
                    KtDeclaration writerDeclaration = $dstr$_u24__u24$writerDeclaration.component2();
                    if (writerDeclaration != null) {
                        KtDeclaration ktDeclaration;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        KtDeclaration it = ktDeclaration;
                        boolean bl5 = false;
                        declarationDescriptor = ControlFlowInformationProvider.Companion.getDeclarationDescriptorIncludingConstructors(bindingContext, it);
                    } else {
                        declarationDescriptor = writerDescriptor = null;
                    }
                    boolean bl6 = writerDeclaration != null && Intrinsics.areEqual((Object)variableContainingDeclaration, writerDescriptor) ^ true;
                    if (!bl6) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isAccessedInsideClosureAfterAllWriters(Set<AssignedVariablesSearcher.Writer> writers, KtElement accessElement) {
        boolean bl;
        block4: {
            KtDeclaration ktDeclaration = ControlFlowInformationProvider.Companion.getElementParentDeclaration(accessElement);
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration parent2 = ktDeclaration;
            Iterable $this$none$iv = writers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    AssignedVariablesSearcher.Writer $dstr$assignment = (AssignedVariablesSearcher.Writer)element$iv;
                    boolean bl2 = false;
                    KtBinaryExpression assignment = $dstr$assignment.component1();
                    if (!(!PsiUtilsKt.before(assignment, parent2))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isAccessedBeforeAllClosureWriters(DeclarationDescriptor variableContainingDeclaration, Set<AssignedVariablesSearcher.Writer> writers, BindingContext bindingContext, KtElement accessElement) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = writers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtDeclaration ktDeclaration;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AssignedVariablesSearcher.Writer it = (AssignedVariablesSearcher.Writer)element$iv$iv;
            boolean bl2 = false;
            if (it.getDeclaration() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            KtDeclaration it$iv$iv = ktDeclaration;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDeclaration writerDeclaration = (KtDeclaration)element$iv;
            boolean bl = false;
            DeclarationDescriptor writerDescriptor = ControlFlowInformationProvider.Companion.getDeclarationDescriptorIncludingConstructors(bindingContext, writerDeclaration);
            if (!(Intrinsics.areEqual((Object)variableContainingDeclaration, (Object)writerDescriptor) ^ true) || PsiUtilsKt.before(accessElement, writerDeclaration)) continue;
            return false;
        }
        return true;
    }

    private static final boolean isInvisibleFromOtherModules(DeclarationDescriptorWithVisibility $this$isInvisibleFromOtherModules) {
        if (Visibilities.INVISIBLE_FROM_OTHER_MODULES.contains($this$isInvisibleFromOtherModules.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = $this$isInvisibleFromOtherModules.getContainingDeclaration();
        return containingDeclaration instanceof DeclarationDescriptorWithVisibility && DataFlowValueKindUtilsKt.isInvisibleFromOtherModules((DeclarationDescriptorWithVisibility)containingDeclaration);
    }

    private static final boolean hasDefaultGetter(PropertyDescriptor $this$hasDefaultGetter) {
        PropertyGetterDescriptor getter2 = $this$hasDefaultGetter.getGetter();
        return getter2 == null || getter2.isDefault();
    }

    private static final boolean isAccessedInsideClosure(DeclarationDescriptor variableContainingDeclaration, BindingContext bindingContext, KtElement accessElement) {
        KtDeclaration parent2 = ControlFlowInformationProvider.Companion.getElementParentDeclaration(accessElement);
        return parent2 != null ? Intrinsics.areEqual((Object)ControlFlowInformationProvider.Companion.getDeclarationDescriptorIncludingConstructors(bindingContext, parent2), (Object)variableContainingDeclaration) ^ true : false;
    }
}

