/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCodeKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.SwitchOptimizer;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020#2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020%2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020'2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020)2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020+2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010/\u001a\u00020\u00022\u0006\u0010 \u001a\u0002002\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00101\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u0002022\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u0002042\u0006\u0010\t\u001a\u00020\u0003H\u0016J(\u00105\u001a\u00020\u0002*\u00020\u001d2\u0006\u0010\t\u001a\u00020\u00032\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\u000207H\u0002\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "()V", "visitBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "context", "visitBlockBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsEmpty;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrSetVariable;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "maybeOptimizeIntoSwitch", "transformer", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "backend.js"})
public final class IrElementToJsStatementTransformer
implements BaseIrElementToJsNodeTransformer<JsStatement, JsGenerationContext> {
    @Override
    @NotNull
    public JsEmpty visitFunction(@NotNull IrFunction declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JsEmpty jsEmpty = JsEmpty.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        JsEmpty it = jsEmpty;
        boolean bl3 = false;
        boolean bl4 = Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)JsIrBackendContext.Companion.getCallableClosureOrigin());
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl6 = false;
            String string2 = "The only possible Function Declaration is one composed in Callable Reference Lowering";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return jsEmpty;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitBlockBody(@NotNull IrBlockBody body2, @NotNull JsGenerationContext context2) {
        Collection<JsStatement> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable $this$map$iv = body2.getStatements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStatement jsStatement = (JsStatement)it.accept(this, context2);
            collection.add(jsStatement);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsBlock(list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsBlock visitBlock(@NotNull IrBlock expression2, @NotNull JsGenerationContext context2) {
        Collection<JsStatement> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable $this$map$iv = expression2.getStatements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStatement jsStatement = (JsStatement)it.accept(this, context2);
            collection.add(jsStatement);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsBlock(list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext context2) {
        Collection<JsStatement> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable $this$map$iv = expression2.getStatements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStatement jsStatement = (JsStatement)it.accept(this, context2);
            collection.add(jsStatement);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsBlock(list2);
    }

    @Override
    @NotNull
    public JsStatement visitExpression(@NotNull IrExpression expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new JsExpressionStatement((JsExpression)expression2.accept(new IrElementToJsExpressionTransformer(), context2));
    }

    @Override
    @NotNull
    public JsStatement visitBreak(@NotNull IrBreak jump, @NotNull JsGenerationContext context2) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName jsName = context2.getNameForLoop(jump.getLoop());
        if (jsName != null) {
            JsNameRef jsNameRef2;
            JsName jsName2 = jsName;
            boolean bl = false;
            boolean bl2 = false;
            JsName it = jsName2;
            boolean bl3 = false;
            jsNameRef = jsNameRef2 = new JsNameRef(it);
        } else {
            jsNameRef = null;
        }
        JsNameRef jsNameRef3 = jsNameRef;
        return new JsBreak(jsNameRef3);
    }

    @Override
    @NotNull
    public JsStatement visitContinue(@NotNull IrContinue jump, @NotNull JsGenerationContext context2) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName jsName = context2.getNameForLoop(jump.getLoop());
        if (jsName != null) {
            JsNameRef jsNameRef2;
            JsName jsName2 = jsName;
            boolean bl = false;
            boolean bl2 = false;
            JsName it = jsName2;
            boolean bl3 = false;
            jsNameRef = jsNameRef2 = new JsNameRef(it);
        } else {
            jsNameRef = null;
        }
        JsNameRef jsNameRef3 = jsNameRef;
        return new JsContinue(jsNameRef3);
    }

    private final JsStatement maybeOptimizeIntoSwitch(IrExpression $this$maybeOptimizeIntoSwitch, JsGenerationContext context2, Function1<? super JsExpression, ? extends JsStatement> transformer2) {
        if ($this$maybeOptimizeIntoSwitch instanceof IrWhen) {
            Function1 stmtTransformer2 = (Function1)new Function1<JsStatement, JsStatement>(transformer2){
                final /* synthetic */ Function1 $transformer;

                @NotNull
                public final JsStatement invoke(@NotNull JsStatement stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    JsExpression jsExpression = ((JsExpressionStatement)stmt).getExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"(stmt as JsExpressionStatement).expression");
                    return (JsStatement)this.$transformer.invoke((Object)jsExpression);
                }
                {
                    this.$transformer = function1;
                    super(1);
                }
            };
            JsStatement jsStatement = new SwitchOptimizer(context2, (Function1<? super JsStatement, ? extends JsStatement>)stmtTransformer2).tryOptimize((IrWhen)$this$maybeOptimizeIntoSwitch);
            if (jsStatement != null) {
                JsStatement jsStatement2 = jsStatement;
                boolean bl = false;
                boolean bl2 = false;
                JsStatement it = jsStatement2;
                boolean bl3 = false;
                return it;
            }
        }
        return (JsStatement)transformer2.invoke($this$maybeOptimizeIntoSwitch.accept(new IrElementToJsExpressionTransformer(), context2));
    }

    @Override
    @NotNull
    public JsStatement visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName fieldName = context2.getNameForField((IrField)expression2.getSymbol().getOwner());
        IrElementToJsExpressionTransformer expressionTransformer = new IrElementToJsExpressionTransformer();
        IrExpression irExpression = expression2.getReceiver();
        JsNameRef dest = new JsNameRef(fieldName, irExpression != null ? (JsExpression)irExpression.accept(expressionTransformer, context2) : null);
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, (Function1<? super JsExpression, ? extends JsStatement>)((Function1)new Function1<JsExpression, JsStatement>(dest){
            final /* synthetic */ JsNameRef $dest;

            @NotNull
            public final JsStatement invoke(@NotNull JsExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JsStatement jsStatement = JsAstUtilsKt.jsAssignment(this.$dest, it).makeStmt();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"jsAssignment(dest, it).makeStmt()");
                return jsStatement;
            }
            {
                this.$dest = jsNameRef;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public JsStatement visitSetVariable(@NotNull IrSetVariable expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsNameRef ref = new JsNameRef(context2.getNameForValueDeclaration((IrValueDeclaration)expression2.getSymbol().getOwner()));
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, (Function1<? super JsExpression, ? extends JsStatement>)((Function1)new Function1<JsExpression, JsStatement>(ref){
            final /* synthetic */ JsNameRef $ref;

            @NotNull
            public final JsStatement invoke(@NotNull JsExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JsStatement jsStatement = new JsBinaryOperation(JsBinaryOperator.ASG, this.$ref, it).makeStmt();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"JsBinaryOperation(JsBina\u2026.ASG, ref, it).makeStmt()");
                return jsStatement;
            }
            {
                this.$ref = jsNameRef;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public JsStatement visitReturn(@NotNull IrReturn expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, (Function1<? super JsExpression, ? extends JsStatement>)((Function1)visitReturn.1.INSTANCE));
    }

    @Override
    @NotNull
    public JsStatement visitThrow(@NotNull IrThrow expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, (Function1<? super JsExpression, ? extends JsStatement>)((Function1)visitThrow.1.INSTANCE));
    }

    @Override
    @NotNull
    public JsStatement visitVariable(@NotNull IrVariable declaration2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName varName = context2.getNameForValueDeclaration(declaration2);
        IrExpression value2 = declaration2.getInitializer();
        if (value2 instanceof IrWhen) {
            JsNameRef jsNameRef = varName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"varName.makeRef()");
            JsNameRef varRef = jsNameRef;
            Function1 transformer2 = (Function1)new Function1<JsStatement, JsStatement>(varRef){
                final /* synthetic */ JsNameRef $varRef;

                @NotNull
                public final JsStatement invoke(@NotNull JsStatement stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    JsExpression jsExpression = ((JsExpressionStatement)stmt).getExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"(stmt as JsExpressionStatement).expression");
                    JsExpression expr = jsExpression;
                    return new JsBinaryOperation(JsBinaryOperator.ASG, this.$varRef, expr).makeStmt();
                }
                {
                    this.$varRef = jsNameRef;
                    super(1);
                }
            };
            JsStatement jsStatement = new SwitchOptimizer(context2, (Function1<? super JsStatement, ? extends JsStatement>)transformer2).tryOptimize((IrWhen)value2);
            if (jsStatement != null) {
                JsStatement jsStatement2 = jsStatement;
                boolean bl = false;
                boolean bl2 = false;
                JsStatement it = jsStatement2;
                boolean bl3 = false;
                return new JsBlock(new JsVars(new JsVars.JsVar(varName)), it);
            }
        }
        return JsAstUtilsKt.jsVar(varName, value2, context2);
    }

    @Override
    @NotNull
    public JsStatement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (IrTypePredicatesKt.isAny(IrUtilsKt.getConstructedClassType((IrConstructor)expression2.getSymbol().getOwner()))) {
            return JsEmpty.INSTANCE;
        }
        JsStatement jsStatement = ((JsExpression)expression2.accept(new IrElementToJsExpressionTransformer(), context2)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"expression.accept(IrElem\u2026er(), context).makeStmt()");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.checkIfJsCode(expression2.getSymbol())) {
            JsStatement jsStatement;
            IrExpression irExpression = expression2.getValueArgument(0);
            if (irExpression == null) {
                String string2 = "JsCode is expected";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            List<JsStatement> statements2 = JsCodeKt.translateJsCodeIntoStatementList(irExpression);
            switch (statements2.size()) {
                case 0: {
                    jsStatement = JsEmpty.INSTANCE;
                    break;
                }
                case 1: {
                    jsStatement = (JsStatement)CollectionsKt.single(statements2);
                    break;
                }
                default: {
                    jsStatement = new JsBlock(statements2);
                }
            }
            return jsStatement;
        }
        JsStatement jsStatement = JsAstUtilsKt.translateCall(expression2, data, new IrElementToJsExpressionTransformer()).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"translateCall(expression\u2026Transformer()).makeStmt()");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return JsEmpty.INSTANCE;
    }

    @Override
    @NotNull
    public JsStatement visitTry(@NotNull IrTry aTry, @NotNull JsGenerationContext context2) {
        JsCatch jsCatch;
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsBlock jsTryBlock = JsAstUtilsKt.asBlock((JsStatement)aTry.getTryResult().accept(this, context2));
        IrCatch irCatch = (IrCatch)CollectionsKt.singleOrNull(aTry.getCatches());
        if (irCatch != null) {
            IrCatch irCatch2 = irCatch;
            boolean bl = false;
            boolean bl2 = false;
            IrCatch it = irCatch2;
            boolean bl3 = false;
            JsName name = context2.getNameForValueDeclaration(it.getCatchParameter());
            JsStatement jsCatchBlock = (JsStatement)it.getResult().accept(this, context2);
            jsCatch = new JsCatch(JsGenerationContextKt.getEmptyScope(), name.getIdent(), jsCatchBlock);
        } else {
            jsCatch = null;
        }
        JsCatch jsCatch2 = jsCatch;
        Object object = aTry.getFinallyExpression();
        JsBlock jsFinallyBlock = object != null && (object = (JsStatement)object.accept(this, context2)) != null ? JsAstUtilsKt.asBlock((JsStatement)object) : null;
        return new JsTry(jsTryBlock, jsCatch2, jsFinallyBlock);
    }

    @Override
    @NotNull
    public JsStatement visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context2) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsStatement jsStatement2 = new SwitchOptimizer(context2).tryOptimize(expression2);
        if (jsStatement2 == null) {
            jsStatement2 = jsStatement = (JsStatement)JsAstUtilsKt.toJsNode$default(expression2, this, context2, visitWhen.1.INSTANCE, null, 8, null);
        }
        if (jsStatement2 == null) {
            jsStatement = JsEmpty.INSTANCE;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull JsGenerationContext context2) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName label = context2.getNameForLoop(loop2);
        IrExpression irExpression = loop2.getBody();
        JsWhile loopStatement = new JsWhile((JsExpression)loop2.getCondition().accept(new IrElementToJsExpressionTransformer(), context2), irExpression != null ? (JsStatement)irExpression.accept(this, context2) : null);
        JsName jsName = label;
        if (jsName != null) {
            JsName jsName2 = jsName;
            boolean bl = false;
            boolean bl2 = false;
            JsName it = jsName2;
            boolean bl3 = false;
            jsStatement = new JsLabel(it, loopStatement);
        } else {
            jsStatement = loopStatement;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull JsGenerationContext context2) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName label = context2.getNameForLoop(loop2);
        IrExpression irExpression = loop2.getBody();
        JsDoWhile loopStatement = new JsDoWhile((JsExpression)loop2.getCondition().accept(new IrElementToJsExpressionTransformer(), context2), irExpression != null ? (JsStatement)irExpression.accept(this, context2) : null);
        JsName jsName = label;
        if (jsName != null) {
            JsName jsName2 = jsName;
            boolean bl = false;
            boolean bl2 = false;
            JsName it = jsName2;
            boolean bl3 = false;
            jsStatement = new JsLabel(it, loopStatement);
        } else {
            jsStatement = loopStatement;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitElement(@NotNull IrElement element, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    @NotNull
    public JsStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitBody(@NotNull IrBody body2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    @NotNull
    public JsStatement visitBranch(@NotNull IrBranch branch, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsStatement visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public JsStatement visitCallableReference(@NotNull IrCallableReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitCatch(@NotNull IrCatch aCatch, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)aCatch, (String)"aCatch");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public JsStatement visitClass(@NotNull IrClass declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitClassReference(@NotNull IrClassReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    @NotNull
    public <T> JsStatement visitConst(@NotNull IrConst<T> expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitConstructor(@NotNull IrConstructor declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitDeclaration(@NotNull IrDeclaration declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitElseBranch(@NotNull IrElseBranch branch, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsStatement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    @NotNull
    public JsStatement visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitField(@NotNull IrField declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitFile(@NotNull IrFile declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitGetClass(@NotNull IrGetClass expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitLoop(@NotNull IrLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public JsStatement visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitProperty(@NotNull IrProperty declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitScript(@NotNull IrScript declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitScript(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)spread, (String)"spread");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public JsStatement visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    @NotNull
    public JsStatement visitTypeAlias(@NotNull IrTypeAlias declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsStatement visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitVararg(this, expression2, data);
    }
}

