/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.io.Bits;
import org.jetbrains.kotlin.com.intellij.util.io.IOStatistics;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.io.InlineKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.IntToIntBtree;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.kotlin.com.intellij.util.io.ResizeableMappedFile;

public class PersistentBTreeEnumerator<Data>
extends PersistentEnumeratorBase<Data> {
    private static final int BTREE_PAGE_SIZE = SystemProperties.getIntProperty("idea.btree.page.size", 32768);
    private int myLogicalFileLength;
    private int myDataPageStart;
    private int myFirstPageStart;
    private int myDataPageOffset;
    private int myDuplicatedValuesPageStart;
    private int myDuplicatedValuesPageOffset;
    private int myValuesCount;
    private int myCollisions;
    private int myExistingKeysEnumerated;
    private IntToIntBtree myBTree;
    private final boolean myInlineKeysNoMapping;
    private boolean myExternalKeysNoMapping;
    private static final int VERSION;
    private final int[] myResultBuf;

    public PersistentBTreeEnumerator(@NotNull File file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext) throws IOException {
        if (file2 == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(2);
        }
        if (dataDescriptor == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(3);
        }
        this(file2, dataDescriptor, initialSize, lockContext, 0);
    }

    public PersistentBTreeEnumerator(@NotNull File file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int version) throws IOException {
        if (file2 == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(4);
        }
        if (dataDescriptor == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(5);
        }
        super(file2, new ResizeableMappedFile(file2, initialSize, lockContext, 0x100000, true, IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER), dataDescriptor, initialSize, new PersistentEnumeratorBase.Version(VERSION + version), new RecordBufferHandler(), false);
        this.myResultBuf = new int[1];
        this.myInlineKeysNoMapping = this.myDataDescriptor instanceof InlineKeyDescriptor && !PersistentBTreeEnumerator.wantKeyMapping();
        boolean bl = this.myExternalKeysNoMapping = !(this.myDataDescriptor instanceof InlineKeyDescriptor) && !PersistentBTreeEnumerator.wantKeyMapping();
        if (this.myBTree == null) {
            try {
                this.lockStorage();
                this.storeVars(false);
                this.initBtree(false);
                this.storeBTreeVars(false);
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable e) {
                LOG.info(e);
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new PersistentEnumeratorBase.CorruptedException(file2);
            }
            finally {
                this.unlockStorage();
            }
        }
    }

    @NotNull
    private static File indexFile(@NotNull File file2) {
        if (file2 == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(6);
        }
        return new File(file2.getPath() + "_i");
    }

    private static boolean wantKeyMapping() {
        return false;
    }

    private void initBtree(boolean initial) throws IOException {
        this.myBTree = new IntToIntBtree(BTREE_PAGE_SIZE, PersistentBTreeEnumerator.indexFile(this.myFile), this.myStorage.getPagedFileStorage().getStorageLockContext(), initial);
    }

    private void storeVars(boolean toDisk) {
        this.myLogicalFileLength = this.store(20, this.myLogicalFileLength, toDisk);
        this.myDataPageStart = this.store(24, this.myDataPageStart, toDisk);
        this.myDataPageOffset = this.store(28, this.myDataPageOffset, toDisk);
        this.myFirstPageStart = this.store(32, this.myFirstPageStart, toDisk);
        this.myDuplicatedValuesPageStart = this.store(36, this.myDuplicatedValuesPageStart, toDisk);
        this.myDuplicatedValuesPageOffset = this.store(40, this.myDuplicatedValuesPageOffset, toDisk);
        this.myValuesCount = this.store(44, this.myValuesCount, toDisk);
        this.myCollisions = this.store(48, this.myCollisions, toDisk);
        this.myExistingKeysEnumerated = this.store(52, this.myExistingKeysEnumerated, toDisk);
        this.storeBTreeVars(toDisk);
    }

    private void storeBTreeVars(boolean toDisk) {
        IntToIntBtree tree = this.myBTree;
        if (tree != null) {
            int BTREE_DATA_START = 56;
            tree.persistVars(new IntToIntBtree.BtreeDataStorage(){

                @Override
                public int persistInt(int offset2, int value2, boolean toDisk) {
                    return PersistentBTreeEnumerator.this.store(56 + offset2, value2, toDisk);
                }
            }, toDisk);
        }
    }

    private int store(int offset2, int value2, boolean toDisk) {
        assert (offset2 + 4 < 128);
        if (toDisk) {
            if (this.myFirstPageStart == -1 || this.myStorage.getInt(offset2) != value2) {
                this.myStorage.putInt(offset2, value2);
            }
        } else {
            value2 = this.myStorage.getInt(offset2);
        }
        return value2;
    }

    @Override
    protected void setupEmptyFile() throws IOException {
        this.myLogicalFileLength = 128;
        this.myDataPageStart = -1;
        this.myFirstPageStart = -1;
        this.myDuplicatedValuesPageStart = -1;
        this.initBtree(true);
        this.storeVars(true);
    }

    @Override
    protected void doClose() throws IOException {
        try {
            super.doClose();
        }
        finally {
            IntToIntBtree tree = this.myBTree;
            if (tree != null) {
                tree.doClose();
            }
        }
    }

    private int allocPage() {
        int pageStart = this.myLogicalFileLength;
        this.myLogicalFileLength += 4096 - pageStart % 4096;
        return pageStart;
    }

    @Override
    public boolean processAllDataObject(final @NotNull Processor<? super Data> processor2, final @Nullable PersistentEnumeratorBase.DataFilter filter2) throws IOException {
        if (processor2 == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(7);
        }
        if (this.myInlineKeysNoMapping) {
            return this.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                @Override
                public boolean process(int record2) {
                    if (filter2 == null || filter2.accept(record2)) {
                        Object data = ((InlineKeyDescriptor)PersistentBTreeEnumerator.this.myDataDescriptor).fromInt(this.getCurrentKey());
                        return processor2.process(data);
                    }
                    return true;
                }
            });
        }
        return super.processAllDataObject(processor2, filter2);
    }

    @Override
    public boolean traverseAllRecords(final @NotNull PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        if (p == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(8);
        }
        try {
            this.lockStorage();
            boolean bl = this.myBTree.processMappings(new IntToIntBtree.KeyValueProcessor(){

                @Override
                public boolean process(int key, int value2) throws IOException {
                    p.setCurrentKey(key);
                    if (value2 > 0 || PersistentBTreeEnumerator.this.myInlineKeysNoMapping) {
                        return p.process(value2);
                    }
                    int rec = -value2;
                    while (rec != 0) {
                        int id = PersistentBTreeEnumerator.this.myStorage.getInt(rec);
                        if (!p.process(id)) {
                            return false;
                        }
                        rec = PersistentBTreeEnumerator.this.myStorage.getInt(rec + 4);
                    }
                    return true;
                }
            });
            return bl;
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException corruptedException = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            corruptedException.initCause(e);
            throw corruptedException;
        }
        finally {
            this.unlockStorage();
        }
    }

    protected int addrToIndex(int addr) {
        assert (this.myExternalKeysNoMapping);
        return addr + 1;
    }

    @Override
    protected int indexToAddr(int idx) {
        if (this.myExternalKeysNoMapping) {
            IntToIntBtree.myAssert(idx > 0);
            return idx - 1;
        }
        int anInt = this.myStorage.getInt(idx);
        return anInt;
    }

    @Override
    protected int setupValueId(int hashCode, int dataOff) {
        if (this.myExternalKeysNoMapping) {
            return this.addrToIndex(dataOff);
        }
        PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase> recordHandler = this.getRecordHandler();
        byte[] buf = recordHandler.getRecordBuffer(this);
        int pos = recordHandler.recordWriteOffset(this, buf);
        this.myStorage.ensureSize(pos + buf.length);
        if (!this.myInlineKeysNoMapping) {
            this.myStorage.putInt(pos, dataOff);
        }
        return pos;
    }

    @Override
    public void setRecordHandler(@NotNull PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase> recordHandler) {
        if (recordHandler == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(9);
        }
        this.myExternalKeysNoMapping = false;
        super.setRecordHandler(recordHandler);
    }

    @Override
    public Data getValue(int keyId, int processingKey) throws IOException {
        if (this.myInlineKeysNoMapping) {
            return (Data)((InlineKeyDescriptor)this.myDataDescriptor).fromInt(processingKey);
        }
        return super.getValue(keyId, processingKey);
    }

    long getNonNegativeValue(Data key) throws IOException {
        assert (this.myInlineKeysNoMapping);
        try {
            this.lockStorage();
            boolean hasMapping = this.myBTree.get(((InlineKeyDescriptor)this.myDataDescriptor).toInt(key), this.myResultBuf);
            if (!hasMapping) {
                long l = 0L;
                return l;
            }
            long l = this.keyIdToNonNegativeOffset(this.myResultBuf[0]);
            return l;
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException exception = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.unlockStorage();
        }
    }

    long keyIdToNonNegativeOffset(int value2) {
        if (value2 >= 0) {
            return value2;
        }
        return this.myStorage.getLong(-value2);
    }

    void putNonNegativeValue(Data key, long value2) throws IOException {
        assert (value2 >= 0L);
        assert (this.myInlineKeysNoMapping);
        try {
            this.lockStorage();
            int intKey = ((InlineKeyDescriptor)this.myDataDescriptor).toInt(key);
            this.markDirty(true);
            if (value2 < Integer.MAX_VALUE) {
                this.myBTree.put(intKey, (int)value2);
            } else {
                boolean hasMapping = this.myBTree.get(intKey, this.myResultBuf);
                if (hasMapping && this.myResultBuf[0] < 0) {
                    this.myStorage.putLong(-this.myResultBuf[0], value2);
                    return;
                }
                int pos = this.nextLongValueRecord();
                this.myStorage.putLong(pos, value2);
                this.myBTree.put(intKey, -pos);
            }
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException exception = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.unlockStorage();
        }
    }

    private int nextLongValueRecord() {
        assert (this.myInlineKeysNoMapping);
        if (this.myDuplicatedValuesPageStart == -1 || this.myDuplicatedValuesPageOffset == 4096) {
            int existingOffset;
            this.myDuplicatedValuesPageStart = this.allocPage();
            this.myDuplicatedValuesPageOffset = existingOffset = this.myDuplicatedValuesPageStart % 4096;
            this.myDuplicatedValuesPageStart -= existingOffset;
        }
        int duplicatedValueOff = this.myDuplicatedValuesPageOffset;
        this.myDuplicatedValuesPageOffset += 8;
        return this.myDuplicatedValuesPageStart + duplicatedValueOff;
    }

    @Override
    protected synchronized int enumerateImpl(Data value2, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        try {
            int n;
            this.lockStorage();
            int valueHC = this.myDataDescriptor.getHashCode(value2);
            boolean hasMapping = this.myBTree.get(valueHC, this.myResultBuf);
            if (!hasMapping && onlyCheckForExisting) {
                int n2 = 0;
                return n2;
            }
            int indexNodeValueAddress = hasMapping ? this.myResultBuf[0] : 0;
            int collisionAddress = 0;
            boolean hasExistingData = false;
            if (!this.myInlineKeysNoMapping) {
                int address;
                if (indexNodeValueAddress > 0) {
                    if (this.isKeyAtIndex(value2, indexNodeValueAddress)) {
                        if (!saveNewValue) {
                            ++this.myExistingKeysEnumerated;
                            int n3 = indexNodeValueAddress;
                            return n3;
                        }
                        hasExistingData = true;
                    }
                    collisionAddress = indexNodeValueAddress;
                } else if (indexNodeValueAddress < 0) {
                    collisionAddress = -indexNodeValueAddress;
                    while (true) {
                        if (this.isKeyAtIndex(value2, address = this.myStorage.getInt(collisionAddress))) {
                            if (!saveNewValue) {
                                n = address;
                                return n;
                            }
                            hasExistingData = true;
                            break;
                        }
                        int newCollisionAddress = this.myStorage.getInt(collisionAddress + 4);
                        if (newCollisionAddress == 0) break;
                        collisionAddress = newCollisionAddress;
                    }
                }
                if (onlyCheckForExisting) {
                    address = 0;
                    return address;
                }
            } else if (hasMapping) {
                if (!saveNewValue) {
                    int address = indexNodeValueAddress;
                    return address;
                }
                hasExistingData = true;
            }
            int newValueId = this.writeData(value2, valueHC);
            ++this.myValuesCount;
            if (IOStatistics.DEBUG && (this.myValuesCount & 0xFFFF) == 0) {
                IOStatistics.dump("Index " + this.myFile + ", values " + this.myValuesCount + ", existing keys enumerated:" + this.myExistingKeysEnumerated + ", storage size:" + this.myStorage.length());
                this.myBTree.dumpStatistics();
            }
            if (collisionAddress != 0) {
                if (hasExistingData) {
                    if (indexNodeValueAddress > 0) {
                        this.myBTree.put(valueHC, newValueId);
                    } else {
                        this.myStorage.putInt(collisionAddress, newValueId);
                    }
                } else {
                    int duplicatedValueOff;
                    if (indexNodeValueAddress > 0) {
                        duplicatedValueOff = this.nextDuplicatedValueRecord();
                        this.myBTree.put(valueHC, -duplicatedValueOff);
                        this.myStorage.putInt(duplicatedValueOff, indexNodeValueAddress);
                        collisionAddress = duplicatedValueOff;
                        ++this.myCollisions;
                    }
                    ++this.myCollisions;
                    duplicatedValueOff = this.nextDuplicatedValueRecord();
                    this.myStorage.putInt(collisionAddress + 4, duplicatedValueOff);
                    this.myStorage.putInt(duplicatedValueOff, newValueId);
                    this.myStorage.putInt(duplicatedValueOff + 4, 0);
                }
            } else {
                this.myBTree.put(valueHC, newValueId);
            }
            n = newValueId;
            return n;
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException exception = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.unlockStorage();
        }
    }

    @Override
    boolean canReEnumerate() {
        return true;
    }

    @Override
    public Data valueOf(int idx) throws IOException {
        assert (!this.myInlineKeysNoMapping) : "No valueOf for inline keys with no mapping option";
        return super.valueOf(idx);
    }

    private int nextDuplicatedValueRecord() {
        assert (!this.myInlineKeysNoMapping);
        if (this.myDuplicatedValuesPageStart == -1 || this.myDuplicatedValuesPageOffset == 4096) {
            int existingOffset;
            this.myDuplicatedValuesPageStart = this.allocPage();
            this.myDuplicatedValuesPageOffset = existingOffset = this.myDuplicatedValuesPageStart % 4096;
            this.myDuplicatedValuesPageStart -= existingOffset;
        }
        int duplicatedValueOff = this.myDuplicatedValuesPageOffset;
        this.myDuplicatedValuesPageOffset += 8;
        return this.myDuplicatedValuesPageStart + duplicatedValueOff;
    }

    @Override
    protected void doFlush() throws IOException {
        this.myBTree.doFlush();
        this.storeVars(true);
        super.doFlush();
    }

    static {
        assert (0x100000 % BTREE_PAGE_SIZE == 0) : "Page size should be divisor of 1048576";
        VERSION = 8 + IntToIntBtree.version() + BTREE_PAGE_SIZE + 4096 + 128;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHandler";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentBTreeEnumerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllDataObject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseAllRecords";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setRecordHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RecordBufferHandler
    extends PersistentEnumeratorBase.RecordBufferHandler<PersistentBTreeEnumerator> {
        private byte[] myBuffer;

        private RecordBufferHandler() {
        }

        @Override
        int recordWriteOffset(@NotNull PersistentBTreeEnumerator enumerator, @NotNull byte[] buf) {
            PersistentBTreeEnumerator persistentBTreeEnumerator;
            if (enumerator == null) {
                RecordBufferHandler.$$$reportNull$$$0(0);
            }
            if (buf == null) {
                RecordBufferHandler.$$$reportNull$$$0(1);
            }
            if (enumerator.myFirstPageStart == -1) {
                enumerator.myFirstPageStart = (enumerator.myDataPageStart = enumerator.allocPage());
                int existingOffset = enumerator.myDataPageStart % 4096;
                enumerator.myDataPageOffset = existingOffset;
                persistentBTreeEnumerator = enumerator;
                persistentBTreeEnumerator.myDataPageStart = persistentBTreeEnumerator.myDataPageStart - existingOffset;
            }
            if (enumerator.myDataPageOffset + buf.length + 4 > 4096) {
                assert (enumerator.myDataPageOffset + 4 <= 4096);
                int prevDataPageStart = enumerator.myDataPageStart + 4096 - 4;
                enumerator.myDataPageStart = enumerator.allocPage();
                enumerator.myStorage.putInt(prevDataPageStart, enumerator.myDataPageStart);
                enumerator.myDataPageOffset = 0;
            }
            int recordWriteOffset = enumerator.myDataPageOffset;
            assert (recordWriteOffset + buf.length + 4 <= 4096);
            persistentBTreeEnumerator = enumerator;
            persistentBTreeEnumerator.myDataPageOffset = persistentBTreeEnumerator.myDataPageOffset + buf.length;
            return recordWriteOffset + enumerator.myDataPageStart;
        }

        @Override
        @NotNull
        byte[] getRecordBuffer(@NotNull PersistentBTreeEnumerator enumerator) {
            if (enumerator == null) {
                RecordBufferHandler.$$$reportNull$$$0(2);
            }
            if (this.myBuffer == null) {
                byte[] byArray = this.myBuffer = enumerator.myInlineKeysNoMapping ? ArrayUtilRt.EMPTY_BYTE_ARRAY : new byte[4];
            }
            if (this.myBuffer == null) {
                RecordBufferHandler.$$$reportNull$$$0(3);
            }
            return this.myBuffer;
        }

        @Override
        void setupRecord(@NotNull PersistentBTreeEnumerator enumerator, int hashCode, int dataOffset, byte[] buf) {
            if (enumerator == null) {
                RecordBufferHandler.$$$reportNull$$$0(4);
            }
            if (!enumerator.myInlineKeysNoMapping) {
                Bits.putInt(buf, 0, dataOffset);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumerator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buf";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentBTreeEnumerator$RecordBufferHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentBTreeEnumerator$RecordBufferHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecordBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "recordWriteOffset";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRecordBuffer";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setupRecord";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

