/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.SortingException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.graph.CachingSemiGraph;
import org.jetbrains.kotlin.com.intellij.util.graph.DFSTBuilder;
import org.jetbrains.kotlin.com.intellij.util.graph.GraphGenerator;
import org.jetbrains.kotlin.com.intellij.util.graph.InboundSemiGraph;

public class LoadingOrder {
    public static final LoadingOrder ANY = new LoadingOrder();
    public static final LoadingOrder FIRST = new LoadingOrder("first");
    public static final LoadingOrder LAST = new LoadingOrder("last");
    @NonNls
    private final String myName;
    private final boolean myFirst;
    private final boolean myLast;
    private final Set<String> myBefore;
    private final Set<String> myAfter;

    private LoadingOrder() {
        this.myBefore = new LinkedHashSet<String>(2);
        this.myAfter = new LinkedHashSet<String>(2);
        this.myName = "ANY";
        this.myFirst = false;
        this.myLast = false;
    }

    private LoadingOrder(@NonNls @NotNull String text2) {
        if (text2 == null) {
            LoadingOrder.$$$reportNull$$$0(0);
        }
        this.myBefore = new LinkedHashSet<String>(2);
        this.myAfter = new LinkedHashSet<String>(2);
        this.myName = text2;
        boolean last = false;
        boolean first = false;
        for (String string2 : StringUtil.split(text2, ",")) {
            String trimmed = string2.trim();
            if (trimmed.equalsIgnoreCase("first")) {
                first = true;
                continue;
            }
            if (trimmed.equalsIgnoreCase("last")) {
                last = true;
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "before ")) {
                this.myBefore.add(trimmed.substring("before ".length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "before:")) {
                this.myBefore.add(trimmed.substring("before:".length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "after ")) {
                this.myAfter.add(trimmed.substring("after ".length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "after:")) {
                this.myAfter.add(trimmed.substring("after:".length()).trim());
                continue;
            }
            throw new AssertionError((Object)("Invalid specification: " + trimmed + "; should be one of FIRST, LAST, BEFORE <id> or AFTER <id>"));
        }
        this.myFirst = first;
        this.myLast = last;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadingOrder)) {
            return false;
        }
        LoadingOrder that = (LoadingOrder)o;
        if (this.myFirst != that.myFirst) {
            return false;
        }
        if (this.myLast != that.myLast) {
            return false;
        }
        if (!this.myAfter.equals(that.myAfter)) {
            return false;
        }
        return this.myBefore.equals(that.myBefore);
    }

    public int hashCode() {
        int result2 = this.myFirst ? 1 : 0;
        result2 = 31 * result2 + (this.myLast ? 1 : 0);
        result2 = 31 * result2 + this.myBefore.hashCode();
        result2 = 31 * result2 + this.myAfter.hashCode();
        return result2;
    }

    public static void sort(final @NotNull List<? extends Orderable> orderable) {
        if (orderable == null) {
            LoadingOrder.$$$reportNull$$$0(2);
        }
        if (orderable.size() < 2) {
            return;
        }
        final LinkedHashMap<String, Orderable> map2 = new LinkedHashMap<String, Orderable>();
        final LinkedHashMap<Orderable, LoadingOrder> cachedMap = new LinkedHashMap<Orderable, LoadingOrder>();
        final LinkedHashSet<Orderable> first = new LinkedHashSet<Orderable>(1);
        final LinkedHashSet<Orderable> hasBefore = new LinkedHashSet<Orderable>(orderable.size());
        for (Orderable orderable2 : orderable) {
            LoadingOrder order2;
            String id = orderable2.getOrderId();
            if (StringUtil.isNotEmpty(id)) {
                map2.put(id, orderable2);
            }
            if ((order2 = orderable2.getOrder()) == ANY) continue;
            cachedMap.put(orderable2, order2);
            if (order2.myFirst) {
                first.add(orderable2);
            }
            if (order2.myBefore.isEmpty()) continue;
            hasBefore.add(orderable2);
        }
        if (cachedMap.isEmpty()) {
            return;
        }
        InboundSemiGraph<Orderable> graph2 = new InboundSemiGraph<Orderable>(){

            @Override
            @NotNull
            public Collection<Orderable> getNodes() {
                ArrayList<Orderable> list2 = new ArrayList<Orderable>(orderable);
                Collections.reverse(list2);
                ArrayList<Orderable> arrayList = list2;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            @Override
            @NotNull
            public Iterator<Orderable> getIn(Orderable n) {
                LoadingOrder hisOrder;
                LoadingOrder order2 = cachedMap.getOrDefault(n, ANY);
                LinkedHashSet<Orderable> predecessors = new LinkedHashSet<Orderable>();
                for (String id : order2.myAfter) {
                    Orderable o = (Orderable)map2.get(id);
                    if (o == null) continue;
                    predecessors.add(o);
                }
                String id = n.getOrderId();
                if (StringUtil.isNotEmpty(id)) {
                    for (Orderable o : hasBefore) {
                        hisOrder = cachedMap.getOrDefault(o, ANY);
                        if (!hisOrder.myBefore.contains(id)) continue;
                        predecessors.add(o);
                    }
                }
                if (order2.myLast) {
                    for (Orderable o : orderable) {
                        hisOrder = cachedMap.getOrDefault(o, ANY);
                        if (hisOrder.myLast) continue;
                        predecessors.add(o);
                    }
                }
                if (!order2.myFirst) {
                    predecessors.addAll(first);
                }
                Iterator<Orderable> iterator2 = predecessors.iterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/LoadingOrder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        DFSTBuilder<Orderable> dFSTBuilder = new DFSTBuilder<Orderable>(GraphGenerator.generate(CachingSemiGraph.cache(graph2)));
        if (!dFSTBuilder.isAcyclic()) {
            Couple<Orderable> p = dFSTBuilder.getCircularDependency();
            throw new SortingException("Could not satisfy sorting requirements", (Orderable)p.first, (Orderable)p.second);
        }
        orderable.sort(dFSTBuilder.comparator());
    }

    @NotNull
    public static LoadingOrder readOrder(@Nullable String orderAttr) {
        if (orderAttr == null) {
            LoadingOrder loadingOrder = ANY;
            if (loadingOrder == null) {
                LoadingOrder.$$$reportNull$$$0(3);
            }
            return loadingOrder;
        }
        if (orderAttr.equals("first")) {
            LoadingOrder loadingOrder = FIRST;
            if (loadingOrder == null) {
                LoadingOrder.$$$reportNull$$$0(4);
            }
            return loadingOrder;
        }
        if (orderAttr.equals("last")) {
            LoadingOrder loadingOrder = LAST;
            if (loadingOrder == null) {
                LoadingOrder.$$$reportNull$$$0(5);
            }
            return loadingOrder;
        }
        return new LoadingOrder(orderAttr);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/LoadingOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/LoadingOrder";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Orderable {
        @Nullable
        public String getOrderId();

        public LoadingOrder getOrder();
    }
}

