/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower.inlineclasses;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbi;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbiKt;
import org.jetbrains.kotlin.codegen.state.InlineClassManglingUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0015J\f\u0010\u0016\u001a\u00020\r*\u00020\tH\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/inlineclasses/InlineClassAbi;", "", "()V", "propertyName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getPropertyName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/name/Name;", "getUnderlyingType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "hashSuffix", "", "irFunction", "mangledNameFor", "mangleReturnTypes", "", "returnHashSuffix", "unboxType", "type", "unboxType$backend_jvm", "eraseToString", "UNMANGLED_FUNCTION_REFERENCE", "backend.jvm"})
public final class InlineClassAbi {
    public static final InlineClassAbi INSTANCE;

    @Nullable
    public final IrType unboxType$backend_jvm(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Object object = IrTypesKt.getClassOrNull(type2);
        if (object == null || (object = (IrClass)object.getOwner()) == null) {
            return null;
        }
        Object klass = object;
        if (!klass.isInline()) {
            return null;
        }
        IrType underlyingType = InlineClassAbiKt.unboxInlineClass(this.getUnderlyingType((IrClass)klass));
        if (!IrTypeUtilsKt.isNullable(type2)) {
            return underlyingType;
        }
        if (IrTypeUtilsKt.isNullable(underlyingType) || IrTypePredicatesKt.isPrimitiveType(underlyingType)) {
            return null;
        }
        return IrTypesKt.makeNullable(underlyingType);
    }

    @NotNull
    public final IrType getUnderlyingType(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        boolean bl = irClass2.isInline();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(irClass2);
        Intrinsics.checkNotNull((Object)irConstructor);
        return irConstructor.getValueParameters().get(0).getType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Name mangledNameFor(@NotNull IrFunction irFunction, boolean mangleReturnTypes) {
        String string2;
        String string3;
        boolean bl;
        block15: {
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            if (irFunction instanceof IrConstructor) {
                boolean bl2 = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)irFunction).isInline();
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-InlineClassAbi$mangledNameFor$22 = false;
                    String $i$a$-assert-InlineClassAbi$mangledNameFor$22 = "Should not mangle names of non-inline class constructors: " + RenderIrElementKt.render(irFunction);
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-InlineClassAbi$mangledNameFor$22));
                }
                Name name = Name.identifier("constructor-impl");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"constructor-impl\")");
                return name;
            }
            Iterable $this$any$iv = InlineClassAbiKt.getFullValueParameterList(irFunction);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl4 = false;
                    if (!InlineClassAbiKt.getRequiresMangling(it.getType())) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            string3 = this.hashSuffix(irFunction);
        } else if (mangleReturnTypes && InlineClassAbiKt.getHasMangledReturnType(irFunction)) {
            string3 = this.returnHashSuffix(irFunction);
        } else {
            IrDeclarationParent irDeclarationParent = irFunction.getParent();
            if (!(irDeclarationParent instanceof IrClass)) {
                irDeclarationParent = null;
            }
            IrClass irClass2 = (IrClass)irDeclarationParent;
            if (irClass2 == null) return irFunction.getName();
            if (!irClass2.isInline()) return irFunction.getName();
            string3 = "impl";
        }
        String suffix = string3;
        if (AdditionalIrUtilsKt.isGetter(irFunction)) {
            string2 = JvmAbi.getterName(this.getPropertyName(irFunction).asString());
        } else if (AdditionalIrUtilsKt.isSetter(irFunction)) {
            string2 = JvmAbi.setterName(this.getPropertyName(irFunction).asString());
        } else {
            if (irFunction.getName().isSpecial()) {
                String string4 = "Unhandled special name in mangledNameFor: " + irFunction.getName();
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            string2 = irFunction.getName().asString();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when {\n            irFun\u2026name.asString()\n        }");
        String base = string2;
        Name name = Name.identifier(base + '-' + suffix);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"$base-$suffix\")");
        return name;
    }

    private final Name getPropertyName(IrFunction $this$propertyName) {
        IrFunction irFunction = $this$propertyName;
        if (irFunction == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        }
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)irFunction).getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        return ((IrProperty)irPropertySymbol.getOwner()).getName();
    }

    @NotNull
    public final String returnHashSuffix(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        return InlineClassManglingUtilsKt.md5base64(':' + this.eraseToString(irFunction.getReturnType()));
    }

    private final String hashSuffix(IrFunction irFunction) {
        return InlineClassManglingUtilsKt.md5base64(CollectionsKt.joinToString$default((Iterable)InlineClassAbiKt.getFullValueParameterList(irFunction), null, null, null, (int)0, null, (Function1)hashSuffix.1.INSTANCE, (int)31, null));
    }

    private final String eraseToString(IrType $this$eraseToString) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder2;
        boolean bl5 = false;
        $this$buildString.append('L');
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.getErasedUpperBound($this$eraseToString));
        Intrinsics.checkNotNull((Object)fqName2);
        $this$buildString.append(fqName2);
        if (IrTypeUtilsKt.isNullable($this$eraseToString)) {
            $this$buildString.append('?');
        }
        $this$buildString.append(';');
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private InlineClassAbi() {
    }

    static {
        InlineClassAbi inlineClassAbi;
        INSTANCE = inlineClassAbi = new InlineClassAbi();
    }

    public static final /* synthetic */ String access$eraseToString(InlineClassAbi $this, IrType $this$access_u24eraseToString) {
        return $this.eraseToString($this$access_u24eraseToString);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/inlineclasses/InlineClassAbi$UNMANGLED_FUNCTION_REFERENCE;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "()V", "backend.jvm"})
    public static final class UNMANGLED_FUNCTION_REFERENCE
    extends IrStatementOriginImpl {
        public static final UNMANGLED_FUNCTION_REFERENCE INSTANCE;

        private UNMANGLED_FUNCTION_REFERENCE() {
            super("UNMANGLED_FUNCTION_REFERENCE");
        }

        static {
            UNMANGLED_FUNCTION_REFERENCE uNMANGLED_FUNCTION_REFERENCE;
            INSTANCE = uNMANGLED_FUNCTION_REFERENCE = new UNMANGLED_FUNCTION_REFERENCE();
        }
    }
}

