/*
 * Decompiled with CFR 0.152.
 */
package javaslang.control;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javaslang.Value;
import javaslang.collection.Iterator;

public interface Option<T>
extends Serializable,
Value<T> {
    public static final long serialVersionUID = 1L;

    public static <T> Option<T> some(T value2) {
        return new Some(value2);
    }

    public static <T> Option<T> none() {
        None none2 = None.INSTANCE;
        return none2;
    }

    @Override
    public boolean isEmpty();

    default public boolean isDefined() {
        return !this.isEmpty();
    }

    @Override
    default public boolean isSingleValued() {
        return true;
    }

    @Override
    public T get();

    default public T getOrElse(T other) {
        return this.isEmpty() ? other : this.get();
    }

    default public <X extends Throwable> T getOrElseThrow(Supplier<X> exceptionSupplier) throws X {
        Objects.requireNonNull(exceptionSupplier, "exceptionSupplier is null");
        if (this.isEmpty()) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.get();
    }

    default public <U> Option<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? Option.none() : Option.some(mapper.apply(this.get()));
    }

    @Override
    default public Iterator<T> iterator() {
        return this.isEmpty() ? Iterator.empty() : Iterator.of(this.get());
    }

    @Override
    public String toString();

    public static final class None<T>
    implements Serializable,
    Option<T> {
        private static final long serialVersionUID = 1L;
        private static final None<?> INSTANCE = new None();

        private None() {
        }

        @Override
        public T get() {
            throw new NoSuchElementException("No value present");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return 1;
        }

        @Override
        public String stringPrefix() {
            return "None";
        }

        @Override
        public String toString() {
            return this.stringPrefix();
        }
    }

    public static final class Some<T>
    implements Serializable,
    Option<T> {
        private static final long serialVersionUID = 1L;
        private static final Some<Void> NOTHING = new Some<Object>(null);
        private final T value;

        private Some(T value2) {
            this.value = value2;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Some && Objects.equals(this.value, ((Some)obj).value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String stringPrefix() {
            return "Some";
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "(" + this.value + ")";
        }
    }
}

