/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmConstantsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/DefaultCheckerInTailrec;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class DefaultCheckerInTailrec
implements DeclarationChecker {
    public static final DefaultCheckerInTailrec INSTANCE;

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(declaration instanceof KtNamedFunction && descriptor instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor).isTailrec())) {
            return;
        }
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperComputationOrderOfTailrecDefaultParameters)) {
            return;
        }
        v0 = ((FunctionDescriptor)descriptor).getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(v0, (String)"descriptor.valueParameters");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var7_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ValueParameterDescriptor)element$iv$iv;
            $i$a$-filter-DefaultCheckerInTailrec$check$defaultValues$1 = false;
            if (!it.declaresDefaultValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ValueParameterDescriptor)element$iv$iv;
            $i$a$-filter-DefaultCheckerInTailrec$check$defaultValues$2 = false;
            v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            parameterDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(v1);
            if (!(parameterDeclaration instanceof KtParameter) || ((KtParameter)parameterDeclaration).getDefaultValue() == null) ** GOTO lbl52
            var16_15 = false;
            var17_16 = false;
            it = var15_14;
            $i$a$-let-DefaultCheckerInTailrec$check$defaultValues$2$1 = false;
            v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            v3 = context.getTrace().getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"context.trace.bindingContext");
            if (JvmConstantsKt.getCompileTimeConstant(v2, v3, false, context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineConstVals)) != null) {
                var21_20 = false;
                var22_21 = false;
                const = var20_19;
                $i$a$-let-DefaultCheckerInTailrec$check$defaultValues$2$1$1 = false;
                type = const.getType(DescriptorUtilsKt.getModule(descriptor));
                v4 = !KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(type) && !KotlinBuiltIns.isStringOrNullableString(type);
            } else {
                (Void)null;
lbl52:
                // 2 sources

                v4 = true;
            }
            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        defaultValues = (List)destination$iv$iv;
        if (defaultValues.size() > 1) {
            context.getTrace().report(ErrorsJvm.TAILREC_WITH_DEFAULTS.on((KtNamedFunction)declaration));
        }
    }

    private DefaultCheckerInTailrec() {
    }

    static {
        DefaultCheckerInTailrec defaultCheckerInTailrec;
        INSTANCE = defaultCheckerInTailrec = new DefaultCheckerInTailrec();
    }
}

