/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.ClassExtension;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.ElementManipulator;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;

public class ElementManipulators
extends ClassExtension<ElementManipulator> {
    @NonNls
    public static final String EP_NAME = "org.jetbrains.kotlin.com.intellij.lang.elementManipulator";
    public static final ElementManipulators INSTANCE = new ElementManipulators();
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.ElementManipulators");

    private ElementManipulators() {
        super(EP_NAME);
    }

    public static <T extends PsiElement> ElementManipulator<T> getManipulator(@NotNull T element) {
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(0);
        }
        return (ElementManipulator)INSTANCE.forClass(element.getClass());
    }

    public static int getOffsetInElement(@NotNull PsiElement element) {
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(1);
        }
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getNotNullManipulator(element);
        return ElementManipulators.getManipulatorRange(manipulator, element).getStartOffset();
    }

    @NotNull
    public static <T extends PsiElement> ElementManipulator<T> getNotNullManipulator(@NotNull T element) {
        ElementManipulator<T> manipulator;
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((manipulator = ElementManipulators.getManipulator(element)) != null, element.getClass().getName());
        ElementManipulator<T> elementManipulator = manipulator;
        if (elementManipulator == null) {
            ElementManipulators.$$$reportNull$$$0(3);
        }
        return elementManipulator;
    }

    @NotNull
    public static TextRange getValueTextRange(@NotNull PsiElement element) {
        ElementManipulator<PsiElement> manipulator;
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(4);
        }
        TextRange textRange = (manipulator = ElementManipulators.getManipulator(element)) == null ? TextRange.from(0, element.getTextLength()) : ElementManipulators.getManipulatorRange(manipulator, element);
        if (textRange == null) {
            ElementManipulators.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @NotNull
    public static String getValueText(@NotNull PsiElement element) {
        TextRange valueTextRange;
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(6);
        }
        if ((valueTextRange = ElementManipulators.getValueTextRange(element)).isEmpty()) {
            if ("" == null) {
                ElementManipulators.$$$reportNull$$$0(7);
            }
            return "";
        }
        String text2 = element.getText();
        if (valueTextRange.getEndOffset() > text2.length()) {
            LOG.error("Wrong range for " + element + " text: " + text2 + " range " + valueTextRange);
        }
        String string2 = valueTextRange.substring(text2);
        if (string2 == null) {
            ElementManipulators.$$$reportNull$$$0(8);
        }
        return string2;
    }

    public static <T extends PsiElement> T handleContentChange(@NotNull T element, String text2) {
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(9);
        }
        ElementManipulator<T> manipulator = ElementManipulators.getNotNullManipulator(element);
        return manipulator.handleContentChange(element, text2);
    }

    @NotNull
    private static TextRange getManipulatorRange(@NotNull ElementManipulator<? super PsiElement> manipulator, @NotNull PsiElement element) {
        if (manipulator == null) {
            ElementManipulators.$$$reportNull$$$0(10);
        }
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(11);
        }
        TextRange rangeInElement = manipulator.getRangeInElement(element);
        TextRange elementRange = TextRange.from(0, element.getTextLength());
        if (!elementRange.contains(rangeInElement)) {
            LOG.error("Element range: " + elementRange + ";\nmanipulator range: " + rangeInElement + ";\nelement: " + element.getClass() + ";\nmanipulator: " + manipulator.getClass() + ".");
        }
        TextRange textRange = rangeInElement;
        if (textRange == null) {
            ElementManipulators.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullManipulator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTextRange";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getManipulatorRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManipulator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullManipulator";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValueTextRange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValueText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getManipulatorRange";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

